(* ::Package:: *)

(* ::Title:: *)
(*Integrands involving exponentials of inverse hyperbolic cotangents*)


(* ::Section::Closed:: *)
(*Integrands of the form x^m E^(n ArcCoth[a x])*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m E^(n ArcCoth[a x])*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{E^ArcCoth[a*x]*x^3, x, 8, (2*Sqrt[1 - 1/(a^2*x^2)]*x)/(3*a^3) + (3*Sqrt[1 - 1/(a^2*x^2)]*x^2)/(8*a^2) + (Sqrt[1 - 1/(a^2*x^2)]*x^3)/(3*a) + (1/4)*Sqrt[1 - 1/(a^2*x^2)]*x^4 + (3*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(8*a^4)}
{E^ArcCoth[a*x]*x^2, x, 7, (2*Sqrt[1 - 1/(a^2*x^2)]*x)/(3*a^2) + (Sqrt[1 - 1/(a^2*x^2)]*x^2)/(2*a) + (1/3)*Sqrt[1 - 1/(a^2*x^2)]*x^3 + ArcTanh[Sqrt[1 - 1/(a^2*x^2)]]/(2*a^3)}
{E^ArcCoth[a*x]*x^1, x, 6, (Sqrt[1 - 1/(a^2*x^2)]*x)/a + (1/2)*Sqrt[1 - 1/(a^2*x^2)]*x^2 + ArcTanh[Sqrt[1 - 1/(a^2*x^2)]]/(2*a^2)}
{E^ArcCoth[a*x], x, 5, Sqrt[1 - 1/(a^2*x^2)]*x + ArcTanh[Sqrt[1 - 1/(a^2*x^2)]]/a}
{E^ArcCoth[a*x]/x^1, x, 6, -ArcCsc[a*x] + ArcTanh[Sqrt[1 - 1/(a^2*x^2)]]}
{E^ArcCoth[a*x]/x^2, x, 3, a*Sqrt[1 - 1/(a^2*x^2)] - a*ArcCsc[a*x]}
{E^ArcCoth[a*x]/x^3, x, 3, (1/2)*a*Sqrt[1 - 1/(a^2*x^2)]*(2*a + 1/x) - (1/2)*a^2*ArcCsc[a*x]}
{E^ArcCoth[a*x]/x^4, x, 7, a^3*Sqrt[1 - 1/(a^2*x^2)] - (1/3)*a^3*(1 - 1/(a^2*x^2))^(3/2) + (a^2*Sqrt[1 - 1/(a^2*x^2)])/(2*x) - (1/2)*a^3*ArcCsc[a*x]}
{E^ArcCoth[a*x]/x^5, x, 5, (1/24)*a^3*Sqrt[1 - 1/(a^2*x^2)]*(16*a + 9/x) + (a*Sqrt[1 - 1/(a^2*x^2)])/(4*x^3) + (a^2*Sqrt[1 - 1/(a^2*x^2)])/(3*x^2) - (3/8)*a^4*ArcCsc[a*x]}


{E^(2*ArcCoth[a*x])*x^3, x, 4, (2*x)/a^3 + x^2/a^2 + (2*x^3)/(3*a) + x^4/4 + (2*Log[1 - a*x])/a^4}
{E^(2*ArcCoth[a*x])*x^2, x, 4, (2*x)/a^2 + x^2/a + x^3/3 + (2*Log[1 - a*x])/a^3}
{E^(2*ArcCoth[a*x])*x^1, x, 4, (2*x)/a + x^2/2 + (2*Log[1 - a*x])/a^2}
{E^(2*ArcCoth[a*x]), x, 4, x + (2*Log[1 - a*x])/a}
{E^(2*ArcCoth[a*x])/x^1, x, 4, -Log[x] + 2*Log[1 - a*x]}
{E^(2*ArcCoth[a*x])/x^2, x, 4, x^(-1) - 2*a*Log[x] + 2*a*Log[1 - a*x]}
{E^(2*ArcCoth[a*x])/x^3, x, 4, 1/(2*x^2) + (2*a)/x - 2*a^2*Log[x] + 2*a^2*Log[1 - a*x]}
{E^(2*ArcCoth[a*x])/x^4, x, 4, 1/(3*x^3) + a/x^2 + (2*a^2)/x - 2*a^3*Log[x] + 2*a^3*Log[1 - a*x]}


{E^(3*ArcCoth[a*x])*x^2, x, 14, -((4*Sqrt[1 - 1/(a^2*x^2)])/(a^2*(a - 1/x))) + (14*Sqrt[1 - 1/(a^2*x^2)]*x)/(3*a^2) + (3*Sqrt[1 - 1/(a^2*x^2)]*x^2)/(2*a) + (1/3)*Sqrt[1 - 1/(a^2*x^2)]*x^3 + (11*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(2*a^3)}
{E^(3*ArcCoth[a*x])*x^1, x, 12, -((4*Sqrt[1 - 1/(a^2*x^2)])/(a*(a - 1/x))) + (3*Sqrt[1 - 1/(a^2*x^2)]*x)/a + (1/2)*Sqrt[1 - 1/(a^2*x^2)]*x^2 + (9*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(2*a^2)}
{E^(3*ArcCoth[a*x]), x, 8, -((4*Sqrt[1 - 1/(a^2*x^2)])/(a - 1/x)) + Sqrt[1 - 1/(a^2*x^2)]*x + (3*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/a}
{E^(3*ArcCoth[a*x])/x^1, x, 8, -((4*a*Sqrt[1 - 1/(a^2*x^2)])/(a - 1/x)) + ArcCsc[a*x] + ArcTanh[Sqrt[1 - 1/(a^2*x^2)]]}
{E^(3*ArcCoth[a*x])/x^2, x, 5, -3*a*Sqrt[1 - 1/(a^2*x^2)] - (2*(a + 1/x)^2)/(a*Sqrt[1 - 1/(a^2*x^2)]) + 3*a*ArcCsc[a*x]}
{E^(3*ArcCoth[a*x])/x^3, x, 9, (-(9/2))*a^2*Sqrt[1 - 1/(a^2*x^2)] - (a^5*(1 - 1/(a^2*x^2))^(5/2))/(a - 1/x)^3 - (3*a^3*(1 - 1/(a^2*x^2))^(3/2))/(2*(a - 1/x)) + (9/2)*a^2*ArcCsc[a*x]}
{E^(3*ArcCoth[a*x])/x^4, x, 10, -((a + 1/x)^3/Sqrt[1 - 1/(a^2*x^2)]) - (1/3)*a*Sqrt[1 - 1/(a^2*x^2)]*(3*a + 1/x)^2 - (1/6)*a^2*Sqrt[1 - 1/(a^2*x^2)]*(28*a + 3/x) + (11/2)*a^3*ArcCsc[a*x]}


{E^(4*ArcCoth[a*x])*x^3, x, 4, (12*x)/a^3 + (4*x^2)/a^2 + (4*x^3)/(3*a) + x^4/4 + 4/(a^4*(1 - a*x)) + (16*Log[1 - a*x])/a^4}
{E^(4*ArcCoth[a*x])*x^2, x, 4, (8*x)/a^2 + (2*x^2)/a + x^3/3 + 4/(a^3*(1 - a*x)) + (12*Log[1 - a*x])/a^3}
{E^(4*ArcCoth[a*x])*x^1, x, 4, (4*x)/a + x^2/2 + 4/(a^2*(1 - a*x)) + (8*Log[1 - a*x])/a^2}
{E^(4*ArcCoth[a*x]), x, 4, x + 4/(a*(1 - a*x)) + (4*Log[1 - a*x])/a}
{E^(4*ArcCoth[a*x])/x^1, x, 4, 4/(1 - a*x) + Log[x]}
{E^(4*ArcCoth[a*x])/x^2, x, 4, -x^(-1) + (4*a)/(1 - a*x) + 4*a*Log[x] - 4*a*Log[1 - a*x]}
{E^(4*ArcCoth[a*x])/x^3, x, 4, -1/(2*x^2) - (4*a)/x + (4*a^2)/(1 - a*x) + 8*a^2*Log[x] - 8*a^2*Log[1 - a*x]}
{E^(4*ArcCoth[a*x])/x^4, x, 4, -1/(3*x^3) - (2*a)/x^2 - (8*a^2)/x + (4*a^3)/(1 - a*x) + 12*a^3*Log[x] - 12*a^3*Log[1 - a*x]}


(* ::Subsubsection::Closed:: *)
(*n<0*)


{x^3/E^ArcCoth[a*x], x, 8, -((2*Sqrt[1 - 1/(a^2*x^2)]*x)/(3*a^3)) + (3*Sqrt[1 - 1/(a^2*x^2)]*x^2)/(8*a^2) - (Sqrt[1 - 1/(a^2*x^2)]*x^3)/(3*a) + (1/4)*Sqrt[1 - 1/(a^2*x^2)]*x^4 + (3*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(8*a^4)}
{x^2/E^ArcCoth[a*x], x, 7, (2*Sqrt[1 - 1/(a^2*x^2)]*x)/(3*a^2) - (Sqrt[1 - 1/(a^2*x^2)]*x^2)/(2*a) + (1/3)*Sqrt[1 - 1/(a^2*x^2)]*x^3 - ArcTanh[Sqrt[1 - 1/(a^2*x^2)]]/(2*a^3)}
{x^1/E^ArcCoth[a*x], x, 6, -((Sqrt[1 - 1/(a^2*x^2)]*x)/a) + (1/2)*Sqrt[1 - 1/(a^2*x^2)]*x^2 + ArcTanh[Sqrt[1 - 1/(a^2*x^2)]]/(2*a^2)}
{E^(-ArcCoth[a*x]), x, 5, Sqrt[1 - 1/(a^2*x^2)]*x - ArcTanh[Sqrt[1 - 1/(a^2*x^2)]]/a}
{1/(E^ArcCoth[a*x]*x^1), x, 6, ArcCsc[a*x] + ArcTanh[Sqrt[1 - 1/(a^2*x^2)]]}
{1/(E^ArcCoth[a*x]*x^2), x, 3, (-a)*Sqrt[1 - 1/(a^2*x^2)] - a*ArcCsc[a*x]}
{1/(E^ArcCoth[a*x]*x^3), x, 3, (1/2)*a*Sqrt[1 - 1/(a^2*x^2)]*(2*a - 1/x) + (1/2)*a^2*ArcCsc[a*x]}
{1/(E^ArcCoth[a*x]*x^4), x, 7, (-a^3)*Sqrt[1 - 1/(a^2*x^2)] + (1/3)*a^3*(1 - 1/(a^2*x^2))^(3/2) + (a^2*Sqrt[1 - 1/(a^2*x^2)])/(2*x) - (1/2)*a^3*ArcCsc[a*x]}
{1/(E^ArcCoth[a*x]*x^5), x, 5, (1/24)*a^3*Sqrt[1 - 1/(a^2*x^2)]*(16*a - 9/x) - (a*Sqrt[1 - 1/(a^2*x^2)])/(4*x^3) + (a^2*Sqrt[1 - 1/(a^2*x^2)])/(3*x^2) + (3/8)*a^4*ArcCsc[a*x]}


{x^3/E^(2*ArcCoth[a*x]), x, 4, (-2*x)/a^3 + x^2/a^2 - (2*x^3)/(3*a) + x^4/4 + (2*Log[1 + a*x])/a^4}
{x^2/E^(2*ArcCoth[a*x]), x, 4, (2*x)/a^2 - x^2/a + x^3/3 - (2*Log[1 + a*x])/a^3}
{x^1/E^(2*ArcCoth[a*x]), x, 4, (-2*x)/a + x^2/2 + (2*Log[1 + a*x])/a^2}
{E^(-2*ArcCoth[a*x]), x, 4, x - (2*Log[1 + a*x])/a}
{1/(E^(2*ArcCoth[a*x])*x^1), x, 4, -Log[x] + 2*Log[1 + a*x]}
{1/(E^(2*ArcCoth[a*x])*x^2), x, 4, x^(-1) + 2*a*Log[x] - 2*a*Log[1 + a*x]}
{1/(E^(2*ArcCoth[a*x])*x^3), x, 4, 1/(2*x^2) - (2*a)/x - 2*a^2*Log[x] + 2*a^2*Log[1 + a*x]}
{1/(E^(2*ArcCoth[a*x])*x^4), x, 4, 1/(3*x^3) - a/x^2 + (2*a^2)/x + 2*a^3*Log[x] - 2*a^3*Log[1 + a*x]}


{x^3/E^(3*ArcCoth[a*x]), x, 19, -((4*Sqrt[1 - 1/(a^2*x^2)])/(a^3*(a + 1/x))) - (6*Sqrt[1 - 1/(a^2*x^2)]*x)/a^3 + (19*Sqrt[1 - 1/(a^2*x^2)]*x^2)/(8*a^2) - (Sqrt[1 - 1/(a^2*x^2)]*x^3)/a + (1/4)*Sqrt[1 - 1/(a^2*x^2)]*x^4 + (51*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(8*a^4)}
{x^2/E^(3*ArcCoth[a*x]), x, 14, (4*Sqrt[1 - 1/(a^2*x^2)])/(a^2*(a + 1/x)) + (14*Sqrt[1 - 1/(a^2*x^2)]*x)/(3*a^2) - (3*Sqrt[1 - 1/(a^2*x^2)]*x^2)/(2*a) + (1/3)*Sqrt[1 - 1/(a^2*x^2)]*x^3 - (11*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(2*a^3)}
{x^1/E^(3*ArcCoth[a*x]), x, 12, -((4*Sqrt[1 - 1/(a^2*x^2)])/(a*(a + 1/x))) - (3*Sqrt[1 - 1/(a^2*x^2)]*x)/a + (1/2)*Sqrt[1 - 1/(a^2*x^2)]*x^2 + (9*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(2*a^2)}
{E^(-3*ArcCoth[a*x]), x, 8, (4*Sqrt[1 - 1/(a^2*x^2)])/(a + 1/x) + Sqrt[1 - 1/(a^2*x^2)]*x - (3*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/a}
{1/(E^(3*ArcCoth[a*x])*x^1), x, 8, -((4*a*Sqrt[1 - 1/(a^2*x^2)])/(a + 1/x)) - ArcCsc[a*x] + ArcTanh[Sqrt[1 - 1/(a^2*x^2)]]}
{1/(E^(3*ArcCoth[a*x])*x^2), x, 5, 3*a*Sqrt[1 - 1/(a^2*x^2)] + (2*(a - 1/x)^2)/(a*Sqrt[1 - 1/(a^2*x^2)]) + 3*a*ArcCsc[a*x]}
{1/(E^(3*ArcCoth[a*x])*x^3), x, 9, (-(9/2))*a^2*Sqrt[1 - 1/(a^2*x^2)] - (a^5*(1 - 1/(a^2*x^2))^(5/2))/(a + 1/x)^3 - (3*a^3*(1 - 1/(a^2*x^2))^(3/2))/(2*(a + 1/x)) - (9/2)*a^2*ArcCsc[a*x]}
{1/(E^(3*ArcCoth[a*x])*x^4), x, 10, (1/6)*a^2*Sqrt[1 - 1/(a^2*x^2)]*(28*a - 3/x) + (a - 1/x)^3/Sqrt[1 - 1/(a^2*x^2)] + (1/3)*a*Sqrt[1 - 1/(a^2*x^2)]*(3*a - 1/x)^2 + (11/2)*a^3*ArcCsc[a*x]}
{1/(E^(3*ArcCoth[a*x])*x^5), x, 14, (-(27/4))*a^4*Sqrt[1 - 1/(a^2*x^2)] - (9/8)*a^3*Sqrt[1 - 1/(a^2*x^2)]*(2*a - 3/x) - (a*(a - 1/x)^3)/Sqrt[1 - 1/(a^2*x^2)] + (a*Sqrt[1 - 1/(a^2*x^2)])/(4*x^3) - (a^2*Sqrt[1 - 1/(a^2*x^2)])/x^2 - (51/8)*a^4*ArcCsc[a*x]}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m E^(n/2 ArcCoth[a x])*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{E^(ArcCoth[a*x]/2)*x^4, x, 11, (611*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x)/(1920*a^4) + (269*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x^2)/(960*a^3) + (11*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x^3)/(48*a^2) + (9*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x^4)/(40*a) + (1/5)*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x^5 + (31*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(128*a^5) + (31*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(128*a^5)}
{E^(ArcCoth[a*x]/2)*x^3, x, 10, (83*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x)/(192*a^3) + (29*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x^2)/(96*a^2) + (7*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x^3)/(24*a) + (1/4)*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x^4 + (11*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(64*a^4) + (11*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(64*a^4)}
{E^(ArcCoth[a*x]/2)*x^2, x, 9, (11*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x)/(24*a^2) + (5*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x^2)/(12*a) + (1/3)*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x^3 + (3*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(8*a^3) + (3*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(8*a^3)}
{E^(ArcCoth[a*x]/2)*x, x, 7, ((1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x)/(4*a) + (1/2)*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(5/4)*x^2 + ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)]/(4*a^2) + ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)]/(4*a^2)}
{E^(ArcCoth[a*x]/2), x, 6, (1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x + ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)]/a + ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)]/a}
{E^(ArcCoth[a*x]/2)/x, x, 17, (-Sqrt[2])*ArcTan[1 - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)] + Sqrt[2]*ArcTan[1 + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)] + 2*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)] + 2*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)] + Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)]/Sqrt[2] - Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)]/Sqrt[2]}
{E^(ArcCoth[a*x]/2)/x^2, x, 13, a*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4) - (a*ArcTan[1 - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/Sqrt[2] + (a*ArcTan[1 + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/Sqrt[2] + (a*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(2*Sqrt[2]) - (a*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(2*Sqrt[2])}
{E^(ArcCoth[a*x]/2)/x^3, x, 14, (a^2*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4))/4 + (a^2*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(5/4))/2 - (a^2*ArcTan[1 - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(4*Sqrt[2]) + (a^2*ArcTan[1 + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(4*Sqrt[2]) + (a^2*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(8*Sqrt[2]) - (a^2*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(8*Sqrt[2])}
{E^(ArcCoth[a*x]/2)/x^4, x, 15, (3*a^3*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4))/8 + (a^3*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(5/4))/12 + (a^2*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(5/4))/(3*x) - (3*a^3*ArcTan[1 - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(8*Sqrt[2]) + (3*a^3*ArcTan[1 + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(8*Sqrt[2]) + (3*a^3*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(16*Sqrt[2]) - (3*a^3*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(16*Sqrt[2])}


{E^((3*ArcCoth[a*x])/2)*x^4, x, 11, (557*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x)/(640*a^4) + (157*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x^2)/(320*a^3) + (5*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x^3)/(16*a^2) + (11*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x^4)/(40*a) + (1/5)*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x^5 - (237*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(128*a^5) + (237*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(128*a^5)}
{E^((3*ArcCoth[a*x])/2)*x^3, x, 10, (63*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x)/(64*a^3) + (15*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x^2)/(32*a^2) + (3*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x^3)/(8*a) + (1/4)*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x^4 - (123*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(64*a^4) + (123*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(64*a^4)}
{E^((3*ArcCoth[a*x])/2)*x^2, x, 9, (23*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x)/(24*a^2) + (7*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x^2)/(12*a) + (1/3)*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x^3 - (17*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(8*a^3) + (17*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(8*a^3)}
{E^((3*ArcCoth[a*x])/2)*x, x, 7, (3*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x)/(4*a) + (1/2)*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(7/4)*x^2 - (9*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(4*a^2) + (9*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(4*a^2)}
{E^((3*ArcCoth[a*x])/2), x, 6, (1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x - (3*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/a + (3*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/a}
{E^((3*ArcCoth[a*x])/2)/x, x, 17, (-Sqrt[2])*ArcTan[1 - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)] + Sqrt[2]*ArcTan[1 + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)] - 2*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)] + 2*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)] - Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)]/Sqrt[2] + Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)]/Sqrt[2]}
{E^((3*ArcCoth[a*x])/2)/x^2, x, 13, a*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4) - (3*a*ArcTan[1 - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/Sqrt[2] + (3*a*ArcTan[1 + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/Sqrt[2] - (3*a*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(2*Sqrt[2]) + (3*a*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(2*Sqrt[2])}
{E^((3*ArcCoth[a*x])/2)/x^3, x, 14, (3*a^2*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4))/4 + (a^2*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(7/4))/2 - (9*a^2*ArcTan[1 - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(4*Sqrt[2]) + (9*a^2*ArcTan[1 + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(4*Sqrt[2]) - (9*a^2*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(8*Sqrt[2]) + (9*a^2*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(8*Sqrt[2])}
{E^((3*ArcCoth[a*x])/2)/x^4, x, 15, (17*a^3*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4))/24 + (a^3*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(7/4))/4 + (a^2*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(7/4))/(3*x) - (17*a^3*ArcTan[1 - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(8*Sqrt[2]) + (17*a^3*ArcTan[1 + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(8*Sqrt[2]) - (17*a^3*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(16*Sqrt[2]) + (17*a^3*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(16*Sqrt[2])}


{E^((5*ArcCoth[a*x])/2)*x^4, x, 12, -((26111*(1 + 1/(a*x))^(1/4))/(1920*a^5*(1 - 1/(a*x))^(1/4))) + (5533*(1 + 1/(a*x))^(1/4)*x)/(1920*a^4*(1 - 1/(a*x))^(1/4)) + (1189*(1 + 1/(a*x))^(1/4)*x^2)/(960*a^3*(1 - 1/(a*x))^(1/4)) + (181*(1 + 1/(a*x))^(1/4)*x^3)/(240*a^2*(1 - 1/(a*x))^(1/4)) + (21*(1 + 1/(a*x))^(1/4)*x^4)/(40*a*(1 - 1/(a*x))^(1/4)) + ((1 + 1/(a*x))^(1/4)*x^5)/(5*(1 - 1/(a*x))^(1/4)) + (1003*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(128*a^5) + (1003*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(128*a^5)}
{E^((5*ArcCoth[a*x])/2)*x^3, x, 11, -((2467*(1 + 1/(a*x))^(1/4))/(192*a^4*(1 - 1/(a*x))^(1/4))) + (521*(1 + 1/(a*x))^(1/4)*x)/(192*a^3*(1 - 1/(a*x))^(1/4)) + (113*(1 + 1/(a*x))^(1/4)*x^2)/(96*a^2*(1 - 1/(a*x))^(1/4)) + (17*(1 + 1/(a*x))^(1/4)*x^3)/(24*a*(1 - 1/(a*x))^(1/4)) + ((1 + 1/(a*x))^(1/4)*x^4)/(4*(1 - 1/(a*x))^(1/4)) + (475*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(64*a^4) + (475*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(64*a^4)}
{E^((5*ArcCoth[a*x])/2)*x^2, x, 10, -((287*(1 + 1/(a*x))^(1/4))/(24*a^3*(1 - 1/(a*x))^(1/4))) + (61*(1 + 1/(a*x))^(1/4)*x)/(24*a^2*(1 - 1/(a*x))^(1/4)) + (13*(1 + 1/(a*x))^(1/4)*x^2)/(12*a*(1 - 1/(a*x))^(1/4)) + ((1 + 1/(a*x))^(1/4)*x^3)/(3*(1 - 1/(a*x))^(1/4)) + (55*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(8*a^3) + (55*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(8*a^3)}
{E^((5*ArcCoth[a*x])/2)*x, x, 8, -((25*(1 + 1/(a*x))^(1/4))/(2*a^2*(1 - 1/(a*x))^(1/4))) + (5*(1 + 1/(a*x))^(5/4)*x)/(4*a*(1 - 1/(a*x))^(1/4)) + ((1 + 1/(a*x))^(9/4)*x^2)/(2*(1 - 1/(a*x))^(1/4)) + (25*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(4*a^2) + (25*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(4*a^2)}
{E^((5*ArcCoth[a*x])/2), x, 7, -((10*(1 + 1/(a*x))^(1/4))/(a*(1 - 1/(a*x))^(1/4))) + ((1 + 1/(a*x))^(5/4)*x)/(1 - 1/(a*x))^(1/4) + (5*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/a + (5*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/a}
{E^((5*ArcCoth[a*x])/2)/x, x, 19, -((8*(1 + 1/(a*x))^(1/4))/(1 - 1/(a*x))^(1/4)) + Sqrt[2]*ArcTan[1 - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)] - Sqrt[2]*ArcTan[1 + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)] + 2*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)] + 2*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)] - Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)]/Sqrt[2] + Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)]/Sqrt[2]}
{E^((5*ArcCoth[a*x])/2)/x^2, x, 14, -5*a*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4) - (4*a*(1 + 1/(a*x))^(5/4))/(1 - 1/(a*x))^(1/4) + (5*a*ArcTan[1 - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/Sqrt[2] - (5*a*ArcTan[1 + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/Sqrt[2] - (5*a*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(2*Sqrt[2]) + (5*a*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(2*Sqrt[2])}
{E^((5*ArcCoth[a*x])/2)/x^3, x, 15, (-25*a^2*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4))/4 - (5*a^2*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(5/4))/2 - (2*a^2*(1 + 1/(a*x))^(9/4))/(1 - 1/(a*x))^(1/4) + (25*a^2*ArcTan[1 - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(4*Sqrt[2]) - (25*a^2*ArcTan[1 + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(4*Sqrt[2]) - (25*a^2*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(8*Sqrt[2]) + (25*a^2*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(8*Sqrt[2])}
{E^((5*ArcCoth[a*x])/2)/x^4, x, 16, (-55*a^3*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4))/8 - (11*a^3*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(5/4))/4 - (2*a^3*(1 + 1/(a*x))^(9/4))/(1 - 1/(a*x))^(1/4) - (a^3*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(9/4))/3 + (55*a^3*ArcTan[1 - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(8*Sqrt[2]) - (55*a^3*ArcTan[1 + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(8*Sqrt[2]) - (55*a^3*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(16*Sqrt[2]) + (55*a^3*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(16*Sqrt[2])}


(* ::Subsubsection::Closed:: *)
(*n<0*)


{x^4/E^(ArcCoth[a*x]/2), x, 11, (611*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x)/(1920*a^4) - (269*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x^2)/(960*a^3) + (11*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x^3)/(48*a^2) - (9*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x^4)/(40*a) + (1/5)*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x^5 + (31*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(128*a^5) - (31*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(128*a^5)}
{x^3/E^(ArcCoth[a*x]/2), x, 10, -((83*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x)/(192*a^3)) + (29*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x^2)/(96*a^2) - (7*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x^3)/(24*a) + (1/4)*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x^4 - (11*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(64*a^4) + (11*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(64*a^4)}
{x^2/E^(ArcCoth[a*x]/2), x, 9, (11*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x)/(24*a^2) - (5*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x^2)/(12*a) + (1/3)*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x^3 + (3*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(8*a^3) - (3*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(8*a^3)}
{x/E^(ArcCoth[a*x]/2), x, 7, -(((1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x)/(4*a)) + (1/2)*(1 - 1/(a*x))^(5/4)*(1 + 1/(a*x))^(3/4)*x^2 - ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)]/(4*a^2) + ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)]/(4*a^2)}
{E^(-ArcCoth[a*x]/2), x, 6, (1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)*x + ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)]/a - ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)]/a}
{1/(E^(ArcCoth[a*x]/2)*x), x, 17, Sqrt[2]*ArcTan[1 - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)] - Sqrt[2]*ArcTan[1 + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)] - 2*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)] + 2*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)] + Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)]/Sqrt[2] - Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)]/Sqrt[2]}
{1/(E^(ArcCoth[a*x]/2)*x^2), x, 13, -(a*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4)) - (a*ArcTan[1 - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/Sqrt[2] + (a*ArcTan[1 + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/Sqrt[2] - (a*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(2*Sqrt[2]) + (a*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(2*Sqrt[2])}
{1/(E^(ArcCoth[a*x]/2)*x^3), x, 14, (a^2*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4))/4 + (a^2*(1 - 1/(a*x))^(5/4)*(1 + 1/(a*x))^(3/4))/2 + (a^2*ArcTan[1 - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(4*Sqrt[2]) - (a^2*ArcTan[1 + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(4*Sqrt[2]) + (a^2*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(8*Sqrt[2]) - (a^2*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(8*Sqrt[2])}
{1/(E^(ArcCoth[a*x]/2)*x^4), x, 15, (-3*a^3*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4))/8 - (a^3*(1 - 1/(a*x))^(5/4)*(1 + 1/(a*x))^(3/4))/12 + (a^2*(1 - 1/(a*x))^(5/4)*(1 + 1/(a*x))^(3/4))/(3*x) - (3*a^3*ArcTan[1 - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(8*Sqrt[2]) + (3*a^3*ArcTan[1 + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(8*Sqrt[2]) - (3*a^3*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(16*Sqrt[2]) + (3*a^3*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(16*Sqrt[2])}


{x^4/E^((3*ArcCoth[a*x])/2), x, 11, (557*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x)/(640*a^4) - (157*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x^2)/(320*a^3) + (5*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x^3)/(16*a^2) - (11*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x^4)/(40*a) + (1/5)*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x^5 - (237*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(128*a^5) - (237*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(128*a^5)}
{x^3/E^((3*ArcCoth[a*x])/2), x, 10, -((63*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x)/(64*a^3)) + (15*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x^2)/(32*a^2) - (3*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x^3)/(8*a) + (1/4)*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x^4 + (123*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(64*a^4) + (123*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(64*a^4)}
{x^2/E^((3*ArcCoth[a*x])/2), x, 9, (23*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x)/(24*a^2) - (7*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x^2)/(12*a) + (1/3)*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x^3 - (17*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(8*a^3) - (17*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(8*a^3)}
{x/E^((3*ArcCoth[a*x])/2), x, 7, -((3*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x)/(4*a)) + (1/2)*(1 - 1/(a*x))^(7/4)*(1 + 1/(a*x))^(1/4)*x^2 + (9*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(4*a^2) + (9*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(4*a^2)}
{E^((-3*ArcCoth[a*x])/2), x, 6, (1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)*x - (3*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/a - (3*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/a}
{1/(E^((3*ArcCoth[a*x])/2)*x), x, 17, Sqrt[2]*ArcTan[1 - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)] - Sqrt[2]*ArcTan[1 + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)] + 2*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)] + 2*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)] - Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)]/Sqrt[2] + Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)]/Sqrt[2]}
{1/(E^((3*ArcCoth[a*x])/2)*x^2), x, 13, -(a*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4)) - (3*a*ArcTan[1 - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/Sqrt[2] + (3*a*ArcTan[1 + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/Sqrt[2] + (3*a*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(2*Sqrt[2]) - (3*a*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(2*Sqrt[2])}
{1/(E^((3*ArcCoth[a*x])/2)*x^3), x, 14, (3*a^2*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4))/4 + (a^2*(1 - 1/(a*x))^(7/4)*(1 + 1/(a*x))^(1/4))/2 + (9*a^2*ArcTan[1 - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(4*Sqrt[2]) - (9*a^2*ArcTan[1 + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(4*Sqrt[2]) - (9*a^2*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(8*Sqrt[2]) + (9*a^2*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(8*Sqrt[2])}
{1/(E^((3*ArcCoth[a*x])/2)*x^4), x, 15, (-17*a^3*(1 - 1/(a*x))^(3/4)*(1 + 1/(a*x))^(1/4))/24 - (a^3*(1 - 1/(a*x))^(7/4)*(1 + 1/(a*x))^(1/4))/4 + (a^2*(1 - 1/(a*x))^(7/4)*(1 + 1/(a*x))^(1/4))/(3*x) - (17*a^3*ArcTan[1 - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(8*Sqrt[2]) + (17*a^3*ArcTan[1 + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(8*Sqrt[2]) + (17*a^3*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(16*Sqrt[2]) - (17*a^3*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(16*Sqrt[2])}


{x^4/E^((5*ArcCoth[a*x])/2), x, 12, (26111*(1 - 1/(a*x))^(1/4))/(1920*a^5*(1 + 1/(a*x))^(1/4)) + (5533*(1 - 1/(a*x))^(1/4)*x)/(1920*a^4*(1 + 1/(a*x))^(1/4)) - (1189*(1 - 1/(a*x))^(1/4)*x^2)/(960*a^3*(1 + 1/(a*x))^(1/4)) + (181*(1 - 1/(a*x))^(1/4)*x^3)/(240*a^2*(1 + 1/(a*x))^(1/4)) - (21*(1 - 1/(a*x))^(1/4)*x^4)/(40*a*(1 + 1/(a*x))^(1/4)) + ((1 - 1/(a*x))^(1/4)*x^5)/(5*(1 + 1/(a*x))^(1/4)) + (1003*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(128*a^5) - (1003*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(128*a^5)}
{x^3/E^((5*ArcCoth[a*x])/2), x, 11, -((2467*(1 - 1/(a*x))^(1/4))/(192*a^4*(1 + 1/(a*x))^(1/4))) - (521*(1 - 1/(a*x))^(1/4)*x)/(192*a^3*(1 + 1/(a*x))^(1/4)) + (113*(1 - 1/(a*x))^(1/4)*x^2)/(96*a^2*(1 + 1/(a*x))^(1/4)) - (17*(1 - 1/(a*x))^(1/4)*x^3)/(24*a*(1 + 1/(a*x))^(1/4)) + ((1 - 1/(a*x))^(1/4)*x^4)/(4*(1 + 1/(a*x))^(1/4)) - (475*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(64*a^4) + (475*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(64*a^4)}
{x^2/E^((5*ArcCoth[a*x])/2), x, 10, (287*(1 - 1/(a*x))^(1/4))/(24*a^3*(1 + 1/(a*x))^(1/4)) + (61*(1 - 1/(a*x))^(1/4)*x)/(24*a^2*(1 + 1/(a*x))^(1/4)) - (13*(1 - 1/(a*x))^(1/4)*x^2)/(12*a*(1 + 1/(a*x))^(1/4)) + ((1 - 1/(a*x))^(1/4)*x^3)/(3*(1 + 1/(a*x))^(1/4)) + (55*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(8*a^3) - (55*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(8*a^3)}
{x/E^((5*ArcCoth[a*x])/2), x, 8, -((25*(1 - 1/(a*x))^(1/4))/(2*a^2*(1 + 1/(a*x))^(1/4))) - (5*(1 - 1/(a*x))^(5/4)*x)/(4*a*(1 + 1/(a*x))^(1/4)) + ((1 - 1/(a*x))^(9/4)*x^2)/(2*(1 + 1/(a*x))^(1/4)) - (25*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(4*a^2) + (25*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(4*a^2)}
{E^((-5*ArcCoth[a*x])/2), x, 7, (10*(1 - 1/(a*x))^(1/4))/(a*(1 + 1/(a*x))^(1/4)) + ((1 - 1/(a*x))^(5/4)*x)/(1 + 1/(a*x))^(1/4) + (5*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/a - (5*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/a}
{1/(E^((5*ArcCoth[a*x])/2)*x), x, 19, -((8*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)) - Sqrt[2]*ArcTan[1 - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)] + Sqrt[2]*ArcTan[1 + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)] - 2*ArcTan[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)] + 2*ArcTanh[(1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)] - Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)]/Sqrt[2] + Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)]/Sqrt[2]}
{1/(E^((5*ArcCoth[a*x])/2)*x^2), x, 14, (4*a*(1 - 1/(a*x))^(5/4))/(1 + 1/(a*x))^(1/4) + 5*a*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4) + (5*a*ArcTan[1 - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/Sqrt[2] - (5*a*ArcTan[1 + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/Sqrt[2] + (5*a*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(2*Sqrt[2]) - (5*a*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(2*Sqrt[2])}
{1/(E^((5*ArcCoth[a*x])/2)*x^3), x, 15, (-2*a^2*(1 - 1/(a*x))^(9/4))/(1 + 1/(a*x))^(1/4) - (25*a^2*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4))/4 - (5*a^2*(1 - 1/(a*x))^(5/4)*(1 + 1/(a*x))^(3/4))/2 - (25*a^2*ArcTan[1 - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(4*Sqrt[2]) + (25*a^2*ArcTan[1 + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(4*Sqrt[2]) - (25*a^2*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(8*Sqrt[2]) + (25*a^2*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(8*Sqrt[2])}
{1/(E^((5*ArcCoth[a*x])/2)*x^4), x, 16, (2*a^3*(1 - 1/(a*x))^(9/4))/(1 + 1/(a*x))^(1/4) + (55*a^3*(1 - 1/(a*x))^(1/4)*(1 + 1/(a*x))^(3/4))/8 + (11*a^3*(1 - 1/(a*x))^(5/4)*(1 + 1/(a*x))^(3/4))/4 + (a^3*(1 - 1/(a*x))^(9/4)*(1 + 1/(a*x))^(3/4))/3 + (55*a^3*ArcTan[1 - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(8*Sqrt[2]) - (55*a^3*ArcTan[1 + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(8*Sqrt[2]) + (55*a^3*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] - (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(16*Sqrt[2]) - (55*a^3*Log[1 + Sqrt[1 - 1/(a*x)]/Sqrt[1 + 1/(a*x)] + (Sqrt[2]*(1 - 1/(a*x))^(1/4))/(1 + 1/(a*x))^(1/4)])/(16*Sqrt[2])}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m E^(n/3 ArcCoth[a x])*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{E^(ArcCoth[x]/3)*x^2, x, 16, (11/27)*(1 + 1/x)^(1/6)*((-1 + x)/x)^(5/6)*x + (7/18)*(1 + 1/x)^(1/6)*((-1 + x)/x)^(5/6)*x^2 + (1/3)*(1 + 1/x)^(1/6)*((-1 + x)/x)^(5/6)*x^3 - (19*ArcTan[(1 - (2*(1 + 1/x)^(1/6))/((-1 + x)/x)^(1/6))/Sqrt[3]])/(54*Sqrt[3]) + (19*ArcTan[(1 + (2*(1 + 1/x)^(1/6))/((-1 + x)/x)^(1/6))/Sqrt[3]])/(54*Sqrt[3]) + (19/81)*ArcTanh[(1 + 1/x)^(1/6)/((-1 + x)/x)^(1/6)] - (19/324)*Log[1 + (1 + 1/x)^(1/3)/((-1 + x)/x)^(1/3) - (1 + 1/x)^(1/6)/((-1 + x)/x)^(1/6)] + (19/324)*Log[1 + (1 + 1/x)^(1/3)/((-1 + x)/x)^(1/3) + (1 + 1/x)^(1/6)/((-1 + x)/x)^(1/6)]}
{E^(ArcCoth[x]/3)*x, x, 14, (1/6)*(1 + 1/x)^(1/6)*((-1 + x)/x)^(5/6)*x + (1/2)*(1 + 1/x)^(7/6)*((-1 + x)/x)^(5/6)*x^2 - ArcTan[(1 - (2*(1 + 1/x)^(1/6))/((-1 + x)/x)^(1/6))/Sqrt[3]]/(6*Sqrt[3]) + ArcTan[(1 + (2*(1 + 1/x)^(1/6))/((-1 + x)/x)^(1/6))/Sqrt[3]]/(6*Sqrt[3]) + (1/9)*ArcTanh[(1 + 1/x)^(1/6)/((-1 + x)/x)^(1/6)] - (1/36)*Log[1 + (1 + 1/x)^(1/3)/((-1 + x)/x)^(1/3) - (1 + 1/x)^(1/6)/((-1 + x)/x)^(1/6)] + (1/36)*Log[1 + (1 + 1/x)^(1/3)/((-1 + x)/x)^(1/3) + (1 + 1/x)^(1/6)/((-1 + x)/x)^(1/6)]}
{E^(ArcCoth[x]/3), x, 13, (1 + 1/x)^(1/6)*((-1 + x)/x)^(5/6)*x - ArcTan[(1 - (2*(1 + 1/x)^(1/6))/((-1 + x)/x)^(1/6))/Sqrt[3]]/Sqrt[3] + ArcTan[(1 + (2*(1 + 1/x)^(1/6))/((-1 + x)/x)^(1/6))/Sqrt[3]]/Sqrt[3] + (2/3)*ArcTanh[(1 + 1/x)^(1/6)/((-1 + x)/x)^(1/6)] - (1/6)*Log[1 + (1 + 1/x)^(1/3)/((-1 + x)/x)^(1/3) - (1 + 1/x)^(1/6)/((-1 + x)/x)^(1/6)] + (1/6)*Log[1 + (1 + 1/x)^(1/3)/((-1 + x)/x)^(1/3) + (1 + 1/x)^(1/6)/((-1 + x)/x)^(1/6)]}
{E^(ArcCoth[x]/3)/x, x, 25, (-Sqrt[3])*ArcTan[(1 - (2*(1 + 1/x)^(1/6))/((-1 + x)/x)^(1/6))/Sqrt[3]] + Sqrt[3]*ArcTan[(1 + (2*(1 + 1/x)^(1/6))/((-1 + x)/x)^(1/6))/Sqrt[3]] - ArcTan[Sqrt[3] - (2*((-1 + x)/x)^(1/6))/(1 + 1/x)^(1/6)] + ArcTan[Sqrt[3] + (2*((-1 + x)/x)^(1/6))/(1 + 1/x)^(1/6)] + 2*ArcTan[((-1 + x)/x)^(1/6)/(1 + 1/x)^(1/6)] + 2*ArcTanh[(1 + 1/x)^(1/6)/((-1 + x)/x)^(1/6)] - (1/2)*Log[1 + (1 + 1/x)^(1/3)/((-1 + x)/x)^(1/3) - (1 + 1/x)^(1/6)/((-1 + x)/x)^(1/6)] + (1/2)*Log[1 + (1 + 1/x)^(1/3)/((-1 + x)/x)^(1/3) + (1 + 1/x)^(1/6)/((-1 + x)/x)^(1/6)] + (1/2)*Sqrt[3]*Log[1 - (Sqrt[3]*((-1 + x)/x)^(1/6))/(1 + 1/x)^(1/6) + ((-1 + x)/x)^(1/3)/(1 + 1/x)^(1/3)] - (1/2)*Sqrt[3]*Log[1 + (Sqrt[3]*((-1 + x)/x)^(1/6))/(1 + 1/x)^(1/6) + ((-1 + x)/x)^(1/3)/(1 + 1/x)^(1/3)]}
{E^(ArcCoth[x]/3)/x^2, x, 14, (1 + 1/x)^(1/6)*((-1 + x)/x)^(5/6) - (1/3)*ArcTan[Sqrt[3] - (2*((-1 + x)/x)^(1/6))/(1 + 1/x)^(1/6)] + (1/3)*ArcTan[Sqrt[3] + (2*((-1 + x)/x)^(1/6))/(1 + 1/x)^(1/6)] + (2/3)*ArcTan[((-1 + x)/x)^(1/6)/(1 + 1/x)^(1/6)] + Log[1 - (Sqrt[3]*((-1 + x)/x)^(1/6))/(1 + 1/x)^(1/6) + ((-1 + x)/x)^(1/3)/(1 + 1/x)^(1/3)]/(2*Sqrt[3]) - Log[1 + (Sqrt[3]*((-1 + x)/x)^(1/6))/(1 + 1/x)^(1/6) + ((-1 + x)/x)^(1/3)/(1 + 1/x)^(1/3)]/(2*Sqrt[3])}
{E^(ArcCoth[x]/3)/x^3, x, 15, (1/6)*(1 + 1/x)^(1/6)*((-1 + x)/x)^(5/6) + (1/2)*(1 + 1/x)^(7/6)*((-1 + x)/x)^(5/6) - (1/18)*ArcTan[Sqrt[3] - (2*((-1 + x)/x)^(1/6))/(1 + 1/x)^(1/6)] + (1/18)*ArcTan[Sqrt[3] + (2*((-1 + x)/x)^(1/6))/(1 + 1/x)^(1/6)] + (1/9)*ArcTan[((-1 + x)/x)^(1/6)/(1 + 1/x)^(1/6)] + Log[1 - (Sqrt[3]*((-1 + x)/x)^(1/6))/(1 + 1/x)^(1/6) + ((-1 + x)/x)^(1/3)/(1 + 1/x)^(1/3)]/(12*Sqrt[3]) - Log[1 + (Sqrt[3]*((-1 + x)/x)^(1/6))/(1 + 1/x)^(1/6) + ((-1 + x)/x)^(1/3)/(1 + 1/x)^(1/3)]/(12*Sqrt[3])}
{E^(ArcCoth[x]/3)/x^4, x, 16, (19/54)*(1 + 1/x)^(1/6)*((-1 + x)/x)^(5/6) + (1/18)*(1 + 1/x)^(7/6)*((-1 + x)/x)^(5/6) + ((1 + 1/x)^(7/6)*((-1 + x)/x)^(5/6))/(3*x) - (19/162)*ArcTan[Sqrt[3] - (2*((-1 + x)/x)^(1/6))/(1 + 1/x)^(1/6)] + (19/162)*ArcTan[Sqrt[3] + (2*((-1 + x)/x)^(1/6))/(1 + 1/x)^(1/6)] + (19/81)*ArcTan[((-1 + x)/x)^(1/6)/(1 + 1/x)^(1/6)] + (19*Log[1 - (Sqrt[3]*((-1 + x)/x)^(1/6))/(1 + 1/x)^(1/6) + ((-1 + x)/x)^(1/3)/(1 + 1/x)^(1/3)])/(108*Sqrt[3]) - (19*Log[1 + (Sqrt[3]*((-1 + x)/x)^(1/6))/(1 + 1/x)^(1/6) + ((-1 + x)/x)^(1/3)/(1 + 1/x)^(1/3)])/(108*Sqrt[3])}


{E^((2*ArcCoth[x])/3)*x^2, x, 6, (14/27)*(1 + 1/x)^(1/3)*((-1 + x)/x)^(2/3)*x + (4/9)*(1 + 1/x)^(1/3)*((-1 + x)/x)^(2/3)*x^2 + (1/3)*(1 + 1/x)^(1/3)*((-1 + x)/x)^(2/3)*x^3 - (22*ArcTan[1/Sqrt[3] + (2*((-1 + x)/x)^(1/3))/(Sqrt[3]*(1 + 1/x)^(1/3))])/(27*Sqrt[3]) - (11/27)*Log[(1 + 1/x)^(1/3) - ((-1 + x)/x)^(1/3)] - (11*Log[x])/81}
{E^((2*ArcCoth[x])/3)*x, x, 4, (1/3)*(1 + 1/x)^(1/3)*((-1 + x)/x)^(2/3)*x + (1/2)*(1 + 1/x)^(4/3)*((-1 + x)/x)^(2/3)*x^2 - (2*ArcTan[1/Sqrt[3] + (2*((-1 + x)/x)^(1/3))/(Sqrt[3]*(1 + 1/x)^(1/3))])/(3*Sqrt[3]) - (1/3)*Log[(1 + 1/x)^(1/3) - ((-1 + x)/x)^(1/3)] - Log[x]/9}
{E^((2*ArcCoth[x])/3), x, 3, (1 + 1/x)^(1/3)*((-1 + x)/x)^(2/3)*x - (2*ArcTan[1/Sqrt[3] + (2*((-1 + x)/x)^(1/3))/(Sqrt[3]*(1 + 1/x)^(1/3))])/Sqrt[3] - Log[(1 + 1/x)^(1/3) - ((-1 + x)/x)^(1/3)] - Log[x]/3}
{E^((2*ArcCoth[x])/3)/x, x, 4, (-Sqrt[3])*ArcTan[1/Sqrt[3] - (2*((-1 + x)/x)^(1/3))/(Sqrt[3]*(1 + 1/x)^(1/3))] - Sqrt[3]*ArcTan[1/Sqrt[3] + (2*((-1 + x)/x)^(1/3))/(Sqrt[3]*(1 + 1/x)^(1/3))] - (3/2)*Log[(1 + 1/x)^(1/3) - ((-1 + x)/x)^(1/3)] - (3/2)*Log[1 + ((-1 + x)/x)^(1/3)/(1 + 1/x)^(1/3)] - (1/2)*Log[1 + 1/x] - Log[x]/2}
{E^((2*ArcCoth[x])/3)/x^2, x, 3, (1 + 1/x)^(1/3)*((-1 + x)/x)^(2/3) - (2*ArcTan[1/Sqrt[3] - (2*((-1 + x)/x)^(1/3))/(Sqrt[3]*(1 + 1/x)^(1/3))])/Sqrt[3] - Log[1 + ((-1 + x)/x)^(1/3)/(1 + 1/x)^(1/3)] - (1/3)*Log[1 + 1/x]}
{E^((2*ArcCoth[x])/3)/x^3, x, 4, (1/3)*(1 + 1/x)^(1/3)*((-1 + x)/x)^(2/3) + (1/2)*(1 + 1/x)^(4/3)*((-1 + x)/x)^(2/3) - (2*ArcTan[1/Sqrt[3] - (2*((-1 + x)/x)^(1/3))/(Sqrt[3]*(1 + 1/x)^(1/3))])/(3*Sqrt[3]) - (1/3)*Log[1 + ((-1 + x)/x)^(1/3)/(1 + 1/x)^(1/3)] - (1/9)*Log[1 + 1/x]}


(* ::Subsubsection:: *)
(*n<0*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m E^(n/4 ArcCoth[a x])*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{E^(ArcCoth[a*x]/4)*x^2, x, 19, (37*(1 - 1/(a*x))^(7/8)*(1 + 1/(a*x))^(1/8)*x)/(96*a^2) + (3*(1 - 1/(a*x))^(7/8)*(1 + 1/(a*x))^(1/8)*x^2)/(8*a) + (1/3)*(1 - 1/(a*x))^(7/8)*(1 + 1/(a*x))^(1/8)*x^3 - (11*ArcTan[1 - (Sqrt[2]*(1 + 1/(a*x))^(1/8))/(1 - 1/(a*x))^(1/8)])/(64*Sqrt[2]*a^3) + (11*ArcTan[1 + (Sqrt[2]*(1 + 1/(a*x))^(1/8))/(1 - 1/(a*x))^(1/8)])/(64*Sqrt[2]*a^3) + (11*ArcTan[(1 + 1/(a*x))^(1/8)/(1 - 1/(a*x))^(1/8)])/(64*a^3) + (11*ArcTanh[(1 + 1/(a*x))^(1/8)/(1 - 1/(a*x))^(1/8)])/(64*a^3) - (11*Log[1 - (Sqrt[2]*(1 + 1/(a*x))^(1/8))/(1 - 1/(a*x))^(1/8) + (1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(128*Sqrt[2]*a^3) + (11*Log[1 + (Sqrt[2]*(1 + 1/(a*x))^(1/8))/(1 - 1/(a*x))^(1/8) + (1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)])/(128*Sqrt[2]*a^3)}
{E^(ArcCoth[a*x]/4)*x^1, x, 17, ((1 - 1/(a*x))^(7/8)*(1 + 1/(a*x))^(1/8)*x)/(8*a) + (1/2)*(1 - 1/(a*x))^(7/8)*(1 + 1/(a*x))^(9/8)*x^2 - ArcTan[1 - (Sqrt[2]*(1 + 1/(a*x))^(1/8))/(1 - 1/(a*x))^(1/8)]/(16*Sqrt[2]*a^2) + ArcTan[1 + (Sqrt[2]*(1 + 1/(a*x))^(1/8))/(1 - 1/(a*x))^(1/8)]/(16*Sqrt[2]*a^2) + ArcTan[(1 + 1/(a*x))^(1/8)/(1 - 1/(a*x))^(1/8)]/(16*a^2) + ArcTanh[(1 + 1/(a*x))^(1/8)/(1 - 1/(a*x))^(1/8)]/(16*a^2) - Log[1 - (Sqrt[2]*(1 + 1/(a*x))^(1/8))/(1 - 1/(a*x))^(1/8) + (1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)]/(32*Sqrt[2]*a^2) + Log[1 + (Sqrt[2]*(1 + 1/(a*x))^(1/8))/(1 - 1/(a*x))^(1/8) + (1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)]/(32*Sqrt[2]*a^2)}
{E^(ArcCoth[a*x]/4)*x^0, x, 16, (1 - 1/(a*x))^(7/8)*(1 + 1/(a*x))^(1/8)*x - ArcTan[1 - (Sqrt[2]*(1 + 1/(a*x))^(1/8))/(1 - 1/(a*x))^(1/8)]/(2*Sqrt[2]*a) + ArcTan[1 + (Sqrt[2]*(1 + 1/(a*x))^(1/8))/(1 - 1/(a*x))^(1/8)]/(2*Sqrt[2]*a) + ArcTan[(1 + 1/(a*x))^(1/8)/(1 - 1/(a*x))^(1/8)]/(2*a) + ArcTanh[(1 + 1/(a*x))^(1/8)/(1 - 1/(a*x))^(1/8)]/(2*a) - Log[1 - (Sqrt[2]*(1 + 1/(a*x))^(1/8))/(1 - 1/(a*x))^(1/8) + (1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)]/(4*Sqrt[2]*a) + Log[1 + (Sqrt[2]*(1 + 1/(a*x))^(1/8))/(1 - 1/(a*x))^(1/8) + (1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)]/(4*Sqrt[2]*a)}
{E^(ArcCoth[a*x]/4)/x^1, x, 39, (-Sqrt[2 + Sqrt[2]])*ArcTan[(Sqrt[2 - Sqrt[2]] - (2*(1 - 1/(a*x))^(1/8))/(1 + 1/(a*x))^(1/8))/Sqrt[2 + Sqrt[2]]] - Sqrt[2 - Sqrt[2]]*ArcTan[(Sqrt[2 + Sqrt[2]] - (2*(1 - 1/(a*x))^(1/8))/(1 + 1/(a*x))^(1/8))/Sqrt[2 - Sqrt[2]]] + Sqrt[2 + Sqrt[2]]*ArcTan[(Sqrt[2 - Sqrt[2]] + (2*(1 - 1/(a*x))^(1/8))/(1 + 1/(a*x))^(1/8))/Sqrt[2 + Sqrt[2]]] + Sqrt[2 - Sqrt[2]]*ArcTan[(Sqrt[2 + Sqrt[2]] + (2*(1 - 1/(a*x))^(1/8))/(1 + 1/(a*x))^(1/8))/Sqrt[2 - Sqrt[2]]] - Sqrt[2]*ArcTan[1 - (Sqrt[2]*(1 + 1/(a*x))^(1/8))/(1 - 1/(a*x))^(1/8)] + Sqrt[2]*ArcTan[1 + (Sqrt[2]*(1 + 1/(a*x))^(1/8))/(1 - 1/(a*x))^(1/8)] + 2*ArcTan[(1 + 1/(a*x))^(1/8)/(1 - 1/(a*x))^(1/8)] + 2*ArcTanh[(1 + 1/(a*x))^(1/8)/(1 - 1/(a*x))^(1/8)] + (1/2)*Sqrt[2 - Sqrt[2]]*Log[1 + (1 - 1/(a*x))^(1/4)/(1 + 1/(a*x))^(1/4) - (Sqrt[2 - Sqrt[2]]*(1 - 1/(a*x))^(1/8))/(1 + 1/(a*x))^(1/8)] - (1/2)*Sqrt[2 - Sqrt[2]]*Log[1 + (1 - 1/(a*x))^(1/4)/(1 + 1/(a*x))^(1/4) + (Sqrt[2 - Sqrt[2]]*(1 - 1/(a*x))^(1/8))/(1 + 1/(a*x))^(1/8)] + (1/2)*Sqrt[2 + Sqrt[2]]*Log[1 + (1 - 1/(a*x))^(1/4)/(1 + 1/(a*x))^(1/4) - (Sqrt[2 + Sqrt[2]]*(1 - 1/(a*x))^(1/8))/(1 + 1/(a*x))^(1/8)] - (1/2)*Sqrt[2 + Sqrt[2]]*Log[1 + (1 - 1/(a*x))^(1/4)/(1 + 1/(a*x))^(1/4) + (Sqrt[2 + Sqrt[2]]*(1 - 1/(a*x))^(1/8))/(1 + 1/(a*x))^(1/8)] - Log[1 - (Sqrt[2]*(1 + 1/(a*x))^(1/8))/(1 - 1/(a*x))^(1/8) + (1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)]/Sqrt[2] + Log[1 + (Sqrt[2]*(1 + 1/(a*x))^(1/8))/(1 - 1/(a*x))^(1/8) + (1 + 1/(a*x))^(1/4)/(1 - 1/(a*x))^(1/4)]/Sqrt[2]}
{E^(ArcCoth[a*x]/4)/x^2, x, 25, a*(1 - 1/(a*x))^(7/8)*(1 + 1/(a*x))^(1/8) - (1/4)*Sqrt[2 + Sqrt[2]]*a*ArcTan[(Sqrt[2 - Sqrt[2]] - (2*(1 - 1/(a*x))^(1/8))/(1 + 1/(a*x))^(1/8))/Sqrt[2 + Sqrt[2]]] - (1/4)*Sqrt[2 - Sqrt[2]]*a*ArcTan[(Sqrt[2 + Sqrt[2]] - (2*(1 - 1/(a*x))^(1/8))/(1 + 1/(a*x))^(1/8))/Sqrt[2 - Sqrt[2]]] + (1/4)*Sqrt[2 + Sqrt[2]]*a*ArcTan[(Sqrt[2 - Sqrt[2]] + (2*(1 - 1/(a*x))^(1/8))/(1 + 1/(a*x))^(1/8))/Sqrt[2 + Sqrt[2]]] + (1/4)*Sqrt[2 - Sqrt[2]]*a*ArcTan[(Sqrt[2 + Sqrt[2]] + (2*(1 - 1/(a*x))^(1/8))/(1 + 1/(a*x))^(1/8))/Sqrt[2 - Sqrt[2]]] + (1/8)*Sqrt[2 - Sqrt[2]]*a*Log[1 + (1 - 1/(a*x))^(1/4)/(1 + 1/(a*x))^(1/4) - (Sqrt[2 - Sqrt[2]]*(1 - 1/(a*x))^(1/8))/(1 + 1/(a*x))^(1/8)] - (1/8)*Sqrt[2 - Sqrt[2]]*a*Log[1 + (1 - 1/(a*x))^(1/4)/(1 + 1/(a*x))^(1/4) + (Sqrt[2 - Sqrt[2]]*(1 - 1/(a*x))^(1/8))/(1 + 1/(a*x))^(1/8)] + (1/8)*Sqrt[2 + Sqrt[2]]*a*Log[1 + (1 - 1/(a*x))^(1/4)/(1 + 1/(a*x))^(1/4) - (Sqrt[2 + Sqrt[2]]*(1 - 1/(a*x))^(1/8))/(1 + 1/(a*x))^(1/8)] - (1/8)*Sqrt[2 + Sqrt[2]]*a*Log[1 + (1 - 1/(a*x))^(1/4)/(1 + 1/(a*x))^(1/4) + (Sqrt[2 + Sqrt[2]]*(1 - 1/(a*x))^(1/8))/(1 + 1/(a*x))^(1/8)]}
{E^(ArcCoth[a*x]/4)/x^3, x, 26, (1/8)*a^2*(1 - 1/(a*x))^(7/8)*(1 + 1/(a*x))^(1/8) + (1/2)*a^2*(1 - 1/(a*x))^(7/8)*(1 + 1/(a*x))^(9/8) - (1/32)*Sqrt[2 + Sqrt[2]]*a^2*ArcTan[(Sqrt[2 - Sqrt[2]] - (2*(1 - 1/(a*x))^(1/8))/(1 + 1/(a*x))^(1/8))/Sqrt[2 + Sqrt[2]]] - (1/32)*Sqrt[2 - Sqrt[2]]*a^2*ArcTan[(Sqrt[2 + Sqrt[2]] - (2*(1 - 1/(a*x))^(1/8))/(1 + 1/(a*x))^(1/8))/Sqrt[2 - Sqrt[2]]] + (1/32)*Sqrt[2 + Sqrt[2]]*a^2*ArcTan[(Sqrt[2 - Sqrt[2]] + (2*(1 - 1/(a*x))^(1/8))/(1 + 1/(a*x))^(1/8))/Sqrt[2 + Sqrt[2]]] + (1/32)*Sqrt[2 - Sqrt[2]]*a^2*ArcTan[(Sqrt[2 + Sqrt[2]] + (2*(1 - 1/(a*x))^(1/8))/(1 + 1/(a*x))^(1/8))/Sqrt[2 - Sqrt[2]]] + (1/64)*Sqrt[2 - Sqrt[2]]*a^2*Log[1 + (1 - 1/(a*x))^(1/4)/(1 + 1/(a*x))^(1/4) - (Sqrt[2 - Sqrt[2]]*(1 - 1/(a*x))^(1/8))/(1 + 1/(a*x))^(1/8)] - (1/64)*Sqrt[2 - Sqrt[2]]*a^2*Log[1 + (1 - 1/(a*x))^(1/4)/(1 + 1/(a*x))^(1/4) + (Sqrt[2 - Sqrt[2]]*(1 - 1/(a*x))^(1/8))/(1 + 1/(a*x))^(1/8)] + (1/64)*Sqrt[2 + Sqrt[2]]*a^2*Log[1 + (1 - 1/(a*x))^(1/4)/(1 + 1/(a*x))^(1/4) - (Sqrt[2 + Sqrt[2]]*(1 - 1/(a*x))^(1/8))/(1 + 1/(a*x))^(1/8)] - (1/64)*Sqrt[2 + Sqrt[2]]*a^2*Log[1 + (1 - 1/(a*x))^(1/4)/(1 + 1/(a*x))^(1/4) + (Sqrt[2 + Sqrt[2]]*(1 - 1/(a*x))^(1/8))/(1 + 1/(a*x))^(1/8)]}


(* ::Subsubsection:: *)
(*n<0*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m E^(n ArcCoth[a x]) with m symbolic*)


{E^(4*ArcCoth[a*x])*x^m, x, 5, x^(1 + m)/(1 + m) + (4*x^(1 + m))/(1 - a*x) - 4*x^(1 + m)*Hypergeometric2F1[1, 1 + m, 2 + m, a*x]}
{E^(3*ArcCoth[a*x])*x^m, x, 9, -((3*x^(1 + m)*Hypergeometric2F1[1/2, (1/2)*(-1 - m), (1 - m)/2, 1/(a^2*x^2)])/(1 + m)) - (x^m*Hypergeometric2F1[1/2, -(m/2), 1 - m/2, 1/(a^2*x^2)])/(a*m) + (4*x^(1 + m)*Hypergeometric2F1[3/2, (1/2)*(-1 - m), (1 - m)/2, 1/(a^2*x^2)])/(1 + m) + (4*x^m*Hypergeometric2F1[3/2, -(m/2), 1 - m/2, 1/(a^2*x^2)])/(a*m)}
{E^(2*ArcCoth[a*x])*x^m, x, 4, x^(1 + m)/(1 + m) - (2*x^(1 + m)*Hypergeometric2F1[1, 1 + m, 2 + m, a*x])/(1 + m)}
{E^(1*ArcCoth[a*x])*x^m, x, 4, (x^(1 + m)*Hypergeometric2F1[1/2, (1/2)*(-1 - m), (1 - m)/2, 1/(a^2*x^2)])/(1 + m) + (x^m*Hypergeometric2F1[1/2, -(m/2), 1 - m/2, 1/(a^2*x^2)])/(a*m)}
{x^m/E^(1*ArcCoth[a*x]), x, 4, (x^(1 + m)*Hypergeometric2F1[1/2, (1/2)*(-1 - m), (1 - m)/2, 1/(a^2*x^2)])/(1 + m) - (x^m*Hypergeometric2F1[1/2, -(m/2), 1 - m/2, 1/(a^2*x^2)])/(a*m)}
{x^m/E^(2*ArcCoth[a*x]), x, 4, x^(1 + m)/(1 + m) - (2*x^(1 + m)*Hypergeometric2F1[1, 1 + m, 2 + m, (-a)*x])/(1 + m)}
{x^m/E^(3*ArcCoth[a*x]), x, 9, -((3*x^(1 + m)*Hypergeometric2F1[1/2, (1/2)*(-1 - m), (1 - m)/2, 1/(a^2*x^2)])/(1 + m)) + (x^m*Hypergeometric2F1[1/2, -(m/2), 1 - m/2, 1/(a^2*x^2)])/(a*m) + (4*x^(1 + m)*Hypergeometric2F1[3/2, (1/2)*(-1 - m), (1 - m)/2, 1/(a^2*x^2)])/(1 + m) - (4*x^m*Hypergeometric2F1[3/2, -(m/2), 1 - m/2, 1/(a^2*x^2)])/(a*m)}


{E^(5*ArcCoth[a*x]/2)*x^m, x, 2, (x^(1 + m)*AppellF1[-1 - m, 5/4, -(5/4), -m, 1/(a*x), -(1/(a*x))])/(1 + m)}
{E^(3*ArcCoth[a*x]/2)*x^m, x, 2, (x^(1 + m)*AppellF1[-1 - m, 3/4, -(3/4), -m, 1/(a*x), -(1/(a*x))])/(1 + m)}
{E^(1*ArcCoth[a*x]/2)*x^m, x, 2, (x^(1 + m)*AppellF1[-1 - m, 1/4, -(1/4), -m, 1/(a*x), -(1/(a*x))])/(1 + m)}
{x^m/E^(1*ArcCoth[a*x]/2), x, 2, (x^(1 + m)*AppellF1[-1 - m, -(1/4), 1/4, -m, 1/(a*x), -(1/(a*x))])/(1 + m)}
{x^m/E^(3*ArcCoth[a*x]/2), x, 2, (x^(1 + m)*AppellF1[-1 - m, -(3/4), 3/4, -m, 1/(a*x), -(1/(a*x))])/(1 + m)}
{x^m/E^(5*ArcCoth[a*x]/2), x, 2, (x^(1 + m)*AppellF1[-1 - m, -(5/4), 5/4, -m, 1/(a*x), -(1/(a*x))])/(1 + m)}


{E^(2*ArcCoth[x]/3)*x^m, x, 2, (x^(1 + m)*AppellF1[-1 - m, 1/3, -(1/3), -m, 1/x, -(1/x)])/(1 + m)}
{E^(1*ArcCoth[x]/3)*x^m, x, 2, (x^(1 + m)*AppellF1[-1 - m, 1/6, -(1/6), -m, 1/x, -(1/x)])/(1 + m)}


{E^(ArcCoth[a*x]/4)*x^m, x, 2, (x^(1 + m)*AppellF1[-1 - m, 1/8, -(1/8), -m, 1/(a*x), -(1/(a*x))])/(1 + m)}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m E^(n ArcCoth[a x]) with n symbolic*)


{E^(n*ArcCoth[a*x])*x^m, x, 2, (x^(1 + m)*AppellF1[-1 - m, n/2, -(n/2), -m, 1/(a*x), -(1/(a*x))])/(1 + m)}


{E^(n*ArcCoth[a*x])*x^2, x, 5, (n*(1 - 1/(a*x))^(1 - n/2)*(1 + 1/(a*x))^((2 + n)/2)*x^2)/(6*a) + (1/3)*(1 - 1/(a*x))^(1 - n/2)*(1 + 1/(a*x))^((2 + n)/2)*x^3 + (2*(2 + n^2)*(1 - 1/(a*x))^(1 - n/2)*(1 + 1/(a*x))^((1/2)*(-2 + n))*Hypergeometric2F1[2, 1 - n/2, 2 - n/2, (a - 1/x)/(a + 1/x)])/(3*a^3*(2 - n))}
{E^(n*ArcCoth[a*x])*x^1, x, 3, (1/2)*(1 - 1/(a*x))^(1 - n/2)*(1 + 1/(a*x))^((2 + n)/2)*x^2 + (2*n*(1 - 1/(a*x))^(1 - n/2)*(1 + 1/(a*x))^((1/2)*(-2 + n))*Hypergeometric2F1[2, 1 - n/2, 2 - n/2, (a - 1/x)/(a + 1/x)])/(a^2*(2 - n))}
{E^(n*ArcCoth[a*x])*x^0, x, 2, (4*(1 - 1/(a*x))^(1 - n/2)*(1 + 1/(a*x))^((1/2)*(-2 + n))*Hypergeometric2F1[2, 1 - n/2, 2 - n/2, (a - 1/x)/(a + 1/x)])/(a*(2 - n))}
{E^(n*ArcCoth[a*x])/x^1, x, 4, -((2*(1 + 1/(a*x))^(n/2)*Hypergeometric2F1[1, -(n/2), 1 - n/2, (a - 1/x)/(a + 1/x)])/((1 - 1/(a*x))^(n/2)*n)) + (2^(1 + n/2)*Hypergeometric2F1[-(n/2), -(n/2), 1 - n/2, (a - 1/x)/(2*a)])/((1 - 1/(a*x))^(n/2)*n)}
{E^(n*ArcCoth[a*x])/x^2, x, 2, (2^(1 + n/2)*a*(1 - 1/(a*x))^(1 - n/2)*Hypergeometric2F1[1 - n/2, -(n/2), 2 - n/2, (a - 1/x)/(2*a)])/(2 - n)}
{E^(n*ArcCoth[a*x])/x^3, x, 3, (1/2)*a^2*(1 - 1/(a*x))^(1 - n/2)*(1 + 1/(a*x))^((2 + n)/2) + (2^(n/2)*a^2*n*(1 - 1/(a*x))^(1 - n/2)*Hypergeometric2F1[1 - n/2, -(n/2), 2 - n/2, (a - 1/x)/(2*a)])/(2 - n)}
{E^(n*ArcCoth[a*x])/x^4, x, 4, (1/6)*a^3*n*(1 - 1/(a*x))^(1 - n/2)*(1 + 1/(a*x))^((2 + n)/2) + (a^2*(1 - 1/(a*x))^(1 - n/2)*(1 + 1/(a*x))^((2 + n)/2))/(3*x) + (2^(n/2)*a^3*(2 + n^2)*(1 - 1/(a*x))^(1 - n/2)*Hypergeometric2F1[1 - n/2, -(n/2), 2 - n/2, (a - 1/x)/(2*a)])/(3*(2 - n))}
{E^(n*ArcCoth[a*x])/x^5, x, 4, (1/24)*a^3*(1 - 1/(a*x))^(1 - n/2)*(1 + 1/(a*x))^((2 + n)/2)*(a*(6 + n^2) + (2*n)/x) + (a^2*(1 - 1/(a*x))^(1 - n/2)*(1 + 1/(a*x))^((2 + n)/2))/(4*x^2) + (2^(-2 + n/2)*a^4*n*(8 + n^2)*(1 - 1/(a*x))^(1 - n/2)*Hypergeometric2F1[1 - n/2, -(n/2), 2 - n/2, (a - 1/x)/(2*a)])/(3*(2 - n))}


(* ::Section::Closed:: *)
(*Integrands of the form u E^(n ArcCoth[a x]) (c-c a x)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form E^(n ArcCoth[a x])  (c-c a x)^p*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{E^ArcCoth[a*x]*(c - a*c*x)^p, x, 4, (Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x*(c - a*c*x)^p)/(1 + p) + (((a - 1/x)/(a + 1/x))^(1/2 - p)*Sqrt[1 + 1/(a*x)]*(c - a*c*x)^p*Hypergeometric2F1[1/2 - p, -p, 1 - p, 2/((a + 1/x)*x)])/(a*p*(1 + p)*Sqrt[1 - 1/(a*x)])}

{E^ArcCoth[a*x]*(c - a*c*x)^4, x, 9, (-(7/8))*a*c^4*Sqrt[1 - 1/(a^2*x^2)]*x^2 + (17/15)*a^2*c^4*(1 - 1/(a^2*x^2))^(3/2)*x^3 - (3/4)*a^3*c^4*(1 - 1/(a^2*x^2))^(3/2)*x^4 + (1/5)*a^4*c^4*(1 - 1/(a^2*x^2))^(3/2)*x^5 + (7*c^4*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(8*a)}
{E^ArcCoth[a*x]*(c - a*c*x)^3, x, 8, (-(5/8))*a*c^3*Sqrt[1 - 1/(a^2*x^2)]*x^2 + (2/3)*a^2*c^3*(1 - 1/(a^2*x^2))^(3/2)*x^3 - (1/4)*a^3*c^3*(1 - 1/(a^2*x^2))^(3/2)*x^4 + (5*c^3*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(8*a)}
{E^ArcCoth[a*x]*(c - a*c*x)^2, x, 7, (-(1/2))*a*c^2*Sqrt[1 - 1/(a^2*x^2)]*x^2 + (1/3)*a^2*c^2*(1 - 1/(a^2*x^2))^(3/2)*x^3 + (c^2*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(2*a)}
{E^ArcCoth[a*x]*(c - a*c*x), x, 6, (-(1/2))*a*c*Sqrt[1 - 1/(a^2*x^2)]*x^2 + (c*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(2*a)}
{E^ArcCoth[a*x]/(c - a*c*x), x, 7, (2*(a + 1/x))/(a^2*c*Sqrt[1 - 1/(a^2*x^2)]) - ArcTanh[Sqrt[1 - 1/(a^2*x^2)]]/(a*c)}
{E^ArcCoth[a*x]/(c - a*c*x)^2, x, 3, -((a^2*(1 - 1/(a^2*x^2))^(3/2))/(3*c^2*(a - 1/x)^3))}
{E^ArcCoth[a*x]/(c - a*c*x)^3, x, 4, (a^3*(1 - 1/(a^2*x^2))^(3/2))/(5*c^3*(a - 1/x)^4) - (4*a^2*(1 - 1/(a^2*x^2))^(3/2))/(15*c^3*(a - 1/x)^3)}
{E^ArcCoth[a*x]/(c - a*c*x)^4, x, 6, -((a^4*(1 - 1/(a^2*x^2))^(3/2))/(7*c^4*(a - 1/x)^5)) + (12*a^3*(1 - 1/(a^2*x^2))^(3/2))/(35*c^4*(a - 1/x)^4) - (23*a^2*(1 - 1/(a^2*x^2))^(3/2))/(105*c^4*(a - 1/x)^3)}
{E^ArcCoth[a*x]/(c - a*c*x)^5, x, 8, (a^5*(1 - 1/(a^2*x^2))^(3/2))/(9*c^5*(a - 1/x)^6) - (8*a^4*(1 - 1/(a^2*x^2))^(3/2))/(21*c^5*(a - 1/x)^5) + (47*a^3*(1 - 1/(a^2*x^2))^(3/2))/(105*c^5*(a - 1/x)^4) - (58*a^2*(1 - 1/(a^2*x^2))^(3/2))/(315*c^5*(a - 1/x)^3)}


{E^(2*ArcCoth[a*x])*(c - a*c*x)^p, x, 5, (2*(c - a*c*x)^p)/(a*p) - (c - a*c*x)^(1 + p)/(a*c*(1 + p))}

{E^(2*ArcCoth[a*x])*(c - a*c*x)^5, x, 4, (2*c^5*(1 - a*x)^5)/(5*a) - (c^5*(1 - a*x)^6)/(6*a)}
{E^(2*ArcCoth[a*x])*(c - a*c*x)^4, x, 4, (c^4*(1 - a*x)^4)/(2*a) - (c^4*(1 - a*x)^5)/(5*a)}
{E^(2*ArcCoth[a*x])*(c - a*c*x)^3, x, 4, (2*c^3*(1 - a*x)^3)/(3*a) - (c^3*(1 - a*x)^4)/(4*a)}
{E^(2*ArcCoth[a*x])*(c - a*c*x)^2, x, 4, -(c^2*x) + (a^2*c^2*x^3)/3}
{E^(2*ArcCoth[a*x])*(c - a*c*x), x, 1, -(c*x) - (a*c*x^2)/2, (c*E^(2*ArcCoth[a*x])*(1 - a^2*x^2))/(2*a)}
{E^(2*ArcCoth[a*x])/(c - a*c*x), x, 4, -2/(a*c*(1 - a*x)) - Log[1 - a*x]/(a*c)}
{E^(2*ArcCoth[a*x])/(c - a*c*x)^2, x, 3, -(x/(c^2*(1 - a*x)^2))}
{E^(2*ArcCoth[a*x])/(c - a*c*x)^3, x, 4, -2/(3*a*c^3*(1 - a*x)^3) + 1/(2*a*c^3*(1 - a*x)^2)}
{E^(2*ArcCoth[a*x])/(c - a*c*x)^4, x, 4, -1/(2*a*c^4*(1 - a*x)^4) + 1/(3*a*c^4*(1 - a*x)^3)}


{E^(3*ArcCoth[a*x])*(c - a*c*x)^p, x, 5, (3*Sqrt[1 + 1/(a*x)]*(c - a*c*x)^p)/(a*p*(1 + p)*Sqrt[1 - 1/(a*x)]) + ((1 + 1/(a*x))^(3/2)*x*(c - a*c*x)^p)/((1 + p)*Sqrt[1 - 1/(a*x)]) - (3*((a - 1/x)/(a + 1/x))^(3/2 - p)*Sqrt[1 + 1/(a*x)]*(c - a*c*x)^p*Hypergeometric2F1[1 - p, 3/2 - p, 2 - p, 2/((a + 1/x)*x)])/(a^2*p*(1 - p^2)*(1 - 1/(a*x))^(3/2)*x)}

{E^(3*ArcCoth[a*x])*(c - a*c*x)^4, x, 8, (3/8)*a*c^4*Sqrt[1 - 1/(a^2*x^2)]*x^2 - (1/4)*a^3*c^4*(1 - 1/(a^2*x^2))^(3/2)*x^4 + (1/5)*a^4*c^4*(1 - 1/(a^2*x^2))^(5/2)*x^5 - (3*c^4*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(8*a)}
{E^(3*ArcCoth[a*x])*(c - a*c*x)^3, x, 7, (3/8)*a*c^3*Sqrt[1 - 1/(a^2*x^2)]*x^2 - (1/4)*a^3*c^3*(1 - 1/(a^2*x^2))^(3/2)*x^4 - (3*c^3*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(8*a)}
{E^(3*ArcCoth[a*x])*(c - a*c*x)^2, x, 8, (1/2)*a*c^2*Sqrt[1 - 1/(a^2*x^2)]*x^2 + (1/3)*a^2*c^2*(1 - 1/(a^2*x^2))^(3/2)*x^3 - (c^2*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(2*a)}
{E^(3*ArcCoth[a*x])*(c - a*c*x), x, 8, -2*c*Sqrt[1 - 1/(a^2*x^2)]*x - (1/2)*a*c*Sqrt[1 - 1/(a^2*x^2)]*x^2 - (3*c*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(2*a)}
{E^(3*ArcCoth[a*x])/(c - a*c*x), x, 9, (8*(a + 1/x))/(3*a^2*c*(1 - 1/(a^2*x^2))^(3/2)) + 4/(3*a^2*c*Sqrt[1 - 1/(a^2*x^2)]*x) - ArcTanh[Sqrt[1 - 1/(a^2*x^2)]]/(a*c)}
{E^(3*ArcCoth[a*x])/(c - a*c*x)^2, x, 3, -((a^4*(1 - 1/(a^2*x^2))^(5/2))/(5*c^2*(a - 1/x)^5))}
{E^(3*ArcCoth[a*x])/(c - a*c*x)^3, x, 4, (a^5*(1 - 1/(a^2*x^2))^(5/2))/(7*c^3*(a - 1/x)^6) - (6*a^4*(1 - 1/(a^2*x^2))^(5/2))/(35*c^3*(a - 1/x)^5)}
{E^(3*ArcCoth[a*x])/(c - a*c*x)^4, x, 6, -((47*(a + 1/x)^5)/(315*a^6*c^4*(1 - 1/(a^2*x^2))^(5/2))) + (16*(a + 1/x)^6)/(63*a^7*c^4*(1 - 1/(a^2*x^2))^(7/2)) - (a + 1/x)^7/(9*a^8*c^4*(1 - 1/(a^2*x^2))^(9/2))}
{E^(3*ArcCoth[a*x])/(c - a*c*x)^5, x, 7, -((152*(a + 1/x)^5)/(1155*a^6*c^5*(1 - 1/(a^2*x^2))^(5/2))) + (79*(a + 1/x)^6)/(231*a^7*c^5*(1 - 1/(a^2*x^2))^(7/2)) - (10*(a + 1/x)^7)/(33*a^8*c^5*(1 - 1/(a^2*x^2))^(9/2)) + (a + 1/x)^8/(11*a^9*c^5*(1 - 1/(a^2*x^2))^(11/2))}


{E^(4*ArcCoth[a*x])*(c - a*c*x)^p, x, 5, (4*c*(c - a*c*x)^(-1 + p))/(a*(1 - p)) + (4*(c - a*c*x)^p)/(a*p) - (c - a*c*x)^(1 + p)/(a*c*(1 + p))}

{E^(4*ArcCoth[a*x])*(c - a*c*x)^5, x, 4, -((c^5*(1 - a*x)^4)/a) + (4*c^5*(1 - a*x)^5)/(5*a) - (c^5*(1 - a*x)^6)/(6*a)}
{E^(4*ArcCoth[a*x])*(c - a*c*x)^4, x, 5, c^4*x - (2*a^2*c^4*x^3)/3 + (a^4*c^4*x^5)/5}
{E^(4*ArcCoth[a*x])*(c - a*c*x)^3, x, 4, (2*c^3*(1 + a*x)^3)/(3*a) - (c^3*(1 + a*x)^4)/(4*a)}
{E^(4*ArcCoth[a*x])*(c - a*c*x)^2, x, 3, (c^2*(1 + a*x)^3)/(3*a)}
{E^(4*ArcCoth[a*x])*(c - a*c*x), x, 4, -3*c*x - (1/2)*a*c*x^2 - (4*c*Log[1 - a*x])/a}
{E^(4*ArcCoth[a*x])/(c - a*c*x), x, 4, 2/(a*c*(1 - a*x)^2) - 4/(a*c*(1 - a*x)) - Log[1 - a*x]/(a*c)}
{E^(4*ArcCoth[a*x])/(c - a*c*x)^2, x, 3, (1 + a*x)^3/(6*a*c^2*(1 - a*x)^3)}
{E^(4*ArcCoth[a*x])/(c - a*c*x)^3, x, 4, 1/(a*c^3*(1 - a*x)^4) - 4/(3*a*c^3*(1 - a*x)^3) + 1/(2*a*c^3*(1 - a*x)^2)}
{E^(4*ArcCoth[a*x])/(c - a*c*x)^4, x, 4, 4/(5*a*c^4*(1 - a*x)^5) - 1/(a*c^4*(1 - a*x)^4) + 1/(3*a*c^4*(1 - a*x)^3)}


(* ::Subsubsection::Closed:: *)
(*n<0*)


{(c - a*c*x)^p/E^ArcCoth[a*x], x, 3, (((a - 1/x)/(a + 1/x))^(-(1/2) - p)*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x*(c - a*c*x)^p*Hypergeometric2F1[-1 - p, -(1/2) - p, -p, 2/((a + 1/x)*x)])/(1 + p)}

{(c - a*c*x)^3/E^ArcCoth[a*x], x, 9, (20/3)*c^3*Sqrt[1 - 1/(a^2*x^2)]*x - (27/8)*a*c^3*Sqrt[1 - 1/(a^2*x^2)]*x^2 + (4/3)*a^2*c^3*Sqrt[1 - 1/(a^2*x^2)]*x^3 - (1/4)*a^3*c^3*Sqrt[1 - 1/(a^2*x^2)]*x^4 - (35*c^3*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(8*a)}
{(c - a*c*x)^2/E^ArcCoth[a*x], x, 8, (11/3)*c^2*Sqrt[1 - 1/(a^2*x^2)]*x - (3/2)*a*c^2*Sqrt[1 - 1/(a^2*x^2)]*x^2 + (1/3)*a^2*c^2*Sqrt[1 - 1/(a^2*x^2)]*x^3 - (5*c^2*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(2*a)}
{(c - a*c*x)/E^ArcCoth[a*x], x, 7, 2*c*Sqrt[1 - 1/(a^2*x^2)]*x - (1/2)*a*c*Sqrt[1 - 1/(a^2*x^2)]*x^2 - (3*c*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(2*a)}
{1/(E^ArcCoth[a*x]*(c - a*c*x)), x, 5, -(ArcTanh[Sqrt[1 - 1/(a^2*x^2)]]/(a*c))}
{1/(E^ArcCoth[a*x]*(c - a*c*x)^2), x, 3, -(Sqrt[1 - 1/(a^2*x^2)]/(c^2*(a - 1/x)))}
{1/(E^ArcCoth[a*x]*(c - a*c*x)^3), x, 4, (a*Sqrt[1 - 1/(a^2*x^2)])/(3*c^3*(a - 1/x)^2) - (2*Sqrt[1 - 1/(a^2*x^2)])/(3*c^3*(a - 1/x))}
{1/(E^ArcCoth[a*x]*(c - a*c*x)^4), x, 6, -((a^2*Sqrt[1 - 1/(a^2*x^2)])/(5*c^4*(a - 1/x)^3)) + (8*a*Sqrt[1 - 1/(a^2*x^2)])/(15*c^4*(a - 1/x)^2) - (7*Sqrt[1 - 1/(a^2*x^2)])/(15*c^4*(a - 1/x))}
{1/(E^ArcCoth[a*x]*(c - a*c*x)^5), x, 7, (a^3*Sqrt[1 - 1/(a^2*x^2)])/(7*c^5*(a - 1/x)^4) - (18*a^2*Sqrt[1 - 1/(a^2*x^2)])/(35*c^5*(a - 1/x)^3) + (23*a*Sqrt[1 - 1/(a^2*x^2)])/(35*c^5*(a - 1/x)^2) - (12*Sqrt[1 - 1/(a^2*x^2)])/(35*c^5*(a - 1/x))}


{(c - a*c*x)^p/E^(2*ArcCoth[a*x]), x, 4, ((c - a*c*x)^(2 + p)*Hypergeometric2F1[1, 2 + p, 3 + p, (1/2)*(1 - a*x)])/(2*a*c^2*(2 + p))}

{(c - a*c*x)^4/E^(2*ArcCoth[a*x]), x, 4, 16*c^4*x - (4*c^4*(1 - a*x)^2)/a - (4*c^4*(1 - a*x)^3)/(3*a) - (c^4*(1 - a*x)^4)/(2*a) - (c^4*(1 - a*x)^5)/(5*a) - (32*c^4*Log[1 + a*x])/a}
{(c - a*c*x)^3/E^(2*ArcCoth[a*x]), x, 4, 8*c^3*x - (2*c^3*(1 - a*x)^2)/a - (2*c^3*(1 - a*x)^3)/(3*a) - (c^3*(1 - a*x)^4)/(4*a) - (16*c^3*Log[1 + a*x])/a}
{(c - a*c*x)^2/E^(2*ArcCoth[a*x]), x, 4, 4*c^2*x - (c^2*(1 - a*x)^2)/a - (c^2*(1 - a*x)^3)/(3*a) - (8*c^2*Log[1 + a*x])/a}
{(c - a*c*x)/E^(2*ArcCoth[a*x]), x, 4, 3*c*x - (1/2)*a*c*x^2 - (4*c*Log[1 + a*x])/a}
{1/(E^(2*ArcCoth[a*x])*(c - a*c*x)), x, 3, -(Log[1 + a*x]/(a*c))}
{1/(E^(2*ArcCoth[a*x])*(c - a*c*x)^2), x, 4, -(ArcTanh[a*x]/(a*c^2))}
{1/(E^(2*ArcCoth[a*x])*(c - a*c*x)^3), x, 5, -(1/(2*a*c^3*(1 - a*x))) - ArcTanh[a*x]/(2*a*c^3)}
{1/(E^(2*ArcCoth[a*x])*(c - a*c*x)^4), x, 5, -(1/(4*a*c^4*(1 - a*x)^2)) - 1/(4*a*c^4*(1 - a*x)) - ArcTanh[a*x]/(4*a*c^4)}
{1/(E^(2*ArcCoth[a*x])*(c - a*c*x)^5), x, 5, -(1/(6*a*c^5*(1 - a*x)^3)) - 1/(8*a*c^5*(1 - a*x)^2) - 1/(8*a*c^5*(1 - a*x)) - ArcTanh[a*x]/(8*a*c^5)}


{(c - a*c*x)^p/E^(3*ArcCoth[a*x]), x, 3, (((a - 1/x)/(a + 1/x))^(-(3/2) - p)*(1 - 1/(a*x))^(3/2)*x*(c - a*c*x)^p*Hypergeometric2F1[-(3/2) - p, -1 - p, -p, 2/((a + 1/x)*x)])/((1 + p)*Sqrt[1 + 1/(a*x)])}

{(c - a*c*x)^3/E^(3*ArcCoth[a*x]), x, 10, (32*c^3*(a - 1/x))/(a^2*Sqrt[1 - 1/(a^2*x^2)]) + 30*c^3*Sqrt[1 - 1/(a^2*x^2)]*x - (67/8)*a*c^3*Sqrt[1 - 1/(a^2*x^2)]*x^2 + 2*a^2*c^3*Sqrt[1 - 1/(a^2*x^2)]*x^3 - (1/4)*a^3*c^3*Sqrt[1 - 1/(a^2*x^2)]*x^4 - (315*c^3*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(8*a)}
{(c - a*c*x)^2/E^(3*ArcCoth[a*x]), x, 9, (16*c^2*(a - 1/x))/(a^2*Sqrt[1 - 1/(a^2*x^2)]) + (35/3)*c^2*Sqrt[1 - 1/(a^2*x^2)]*x - (5/2)*a*c^2*Sqrt[1 - 1/(a^2*x^2)]*x^2 + (1/3)*a^2*c^2*Sqrt[1 - 1/(a^2*x^2)]*x^3 - (35*c^2*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(2*a)}
{(c - a*c*x)/E^(3*ArcCoth[a*x]), x, 8, (8*c*(a - 1/x))/(a^2*Sqrt[1 - 1/(a^2*x^2)]) + 4*c*Sqrt[1 - 1/(a^2*x^2)]*x - (1/2)*a*c*Sqrt[1 - 1/(a^2*x^2)]*x^2 - (15*c*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(2*a)}
{1/(E^(3*ArcCoth[a*x])*(c - a*c*x)), x, 6, (2*(a - 1/x))/(a^2*c*Sqrt[1 - 1/(a^2*x^2)]) - ArcTanh[Sqrt[1 - 1/(a^2*x^2)]]/(a*c)}
{1/(E^(3*ArcCoth[a*x])*(c - a*c*x)^2), x, 3, (a - 1/x)/(a^2*c^2*Sqrt[1 - 1/(a^2*x^2)])}
{1/(E^(3*ArcCoth[a*x])*(c - a*c*x)^3), x, 3, 1/(a*c^3*Sqrt[1 - 1/(a^2*x^2)])}
{1/(E^(3*ArcCoth[a*x])*(c - a*c*x)^4), x, 5, 2/(3*a*c^4*Sqrt[1 - 1/(a^2*x^2)]) - 1/(3*a^2*c^4*Sqrt[1 - 1/(a^2*x^2)]*(a - 1/x)*x^2)}
{1/(E^(3*ArcCoth[a*x])*(c - a*c*x)^5), x, 6, -((4*(a + 1/x))/(5*a^2*c^5*(1 - 1/(a^2*x^2))^(3/2))) + (a + 1/x)^2/(5*a^3*c^5*(1 - 1/(a^2*x^2))^(5/2)) + (5*a + 2/x)/(5*a^2*c^5*Sqrt[1 - 1/(a^2*x^2)])}
{1/(E^(3*ArcCoth[a*x])*(c - a*c*x)^6), x, 7, -((46*(a + 1/x))/(35*a^2*c^6*(1 - 1/(a^2*x^2))^(3/2))) + (24*(a + 1/x)^2)/(35*a^3*c^6*(1 - 1/(a^2*x^2))^(5/2)) - (a + 1/x)^3/(7*a^4*c^6*(1 - 1/(a^2*x^2))^(7/2)) + (35*a + 13/x)/(35*a^2*c^6*Sqrt[1 - 1/(a^2*x^2)])}


(* ::Subsection::Closed:: *)
(*Integrands of the form E^(n ArcCoth[a x])  (c-c a x)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{E^ArcCoth[a*x]*(c - a*c*x)^(9/2), x, 7, -((32*(a - 1/x)^3*(1 + 1/(a*x))^(3/2)*(c - a*c*x)^(9/2))/(99*a^4*(1 - 1/(a*x))^(9/2))) + (9088*(1 + 1/(a*x))^(3/2)*(c - a*c*x)^(9/2))/(3465*a^4*(1 - 1/(a*x))^(9/2)*x^3) - (768*(1 + 1/(a*x))^(3/2)*(c - a*c*x)^(9/2))/(385*a^3*(1 - 1/(a*x))^(9/2)*x^2) + (128*(1 + 1/(a*x))^(3/2)*(c - a*c*x)^(9/2))/(231*a^2*(1 - 1/(a*x))^(9/2)*x) + (2*(a - 1/x)^4*(1 + 1/(a*x))^(3/2)*x*(c - a*c*x)^(9/2))/(11*a^4*(1 - 1/(a*x))^(9/2))}
{E^ArcCoth[a*x]*(c - a*c*x)^(7/2), x, 6, -((8*(1 + 1/(a*x))^(3/2)*(c - a*c*x)^(7/2))/(21*a*(1 - 1/(a*x))^(7/2))) - (568*(1 + 1/(a*x))^(3/2)*(c - a*c*x)^(7/2))/(315*a^3*(1 - 1/(a*x))^(7/2)*x^2) + (48*(1 + 1/(a*x))^(3/2)*(c - a*c*x)^(7/2))/(35*a^2*(1 - 1/(a*x))^(7/2)*x) + (2*(a - 1/x)^3*(1 + 1/(a*x))^(3/2)*x*(c - a*c*x)^(7/2))/(9*a^3*(1 - 1/(a*x))^(7/2))}
{E^ArcCoth[a*x]*(c - a*c*x)^(5/2), x, 5, (64*a^2*c^4*(1 - 1/(a^2*x^2))^(3/2)*x^3)/(105*(c - a*c*x)^(3/2)) + (16*a^2*c^3*(1 - 1/(a^2*x^2))^(3/2)*x^3)/(35*Sqrt[c - a*c*x]) + (2/7)*a^2*c^2*(1 - 1/(a^2*x^2))^(3/2)*x^3*Sqrt[c - a*c*x], -((36*(1 + 1/(a*x))^(3/2)*(c - a*c*x)^(5/2))/(35*a*(1 - 1/(a*x))^(5/2))) + (142*(1 + 1/(a*x))^(3/2)*(c - a*c*x)^(5/2))/(105*a^2*(1 - 1/(a*x))^(5/2)*x) + (2*(1 + 1/(a*x))^(3/2)*x*(c - a*c*x)^(5/2))/(7*(1 - 1/(a*x))^(5/2))}
{E^ArcCoth[a*x]*(c - a*c*x)^(3/2), x, 4, (8*a^2*c^3*(1 - 1/(a^2*x^2))^(3/2)*x^3)/(15*(c - a*c*x)^(3/2)) + (2*a^2*c^2*(1 - 1/(a^2*x^2))^(3/2)*x^3)/(5*Sqrt[c - a*c*x]), -((14*(1 + 1/(a*x))^(3/2)*(c - a*c*x)^(3/2))/(15*a*(1 - 1/(a*x))^(3/2))) + (2*(1 + 1/(a*x))^(3/2)*x*(c - a*c*x)^(3/2))/(5*(1 - 1/(a*x))^(3/2))}
{E^ArcCoth[a*x]*(c - a*c*x)^(1/2), x, 1, (2*E^ArcCoth[a*x]*(1 + a*x)*Sqrt[c - a*c*x])/(3*a)}
{E^ArcCoth[a*x]/(c - a*c*x)^(1/2), x, 5, (2*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x)/Sqrt[c - a*c*x] - (2*Sqrt[2]*Sqrt[1 - 1/(a*x)]*ArcTanh[(Sqrt[2]*Sqrt[1/x])/(Sqrt[a]*Sqrt[1 + 1/(a*x)])])/(Sqrt[a]*Sqrt[1/x]*Sqrt[c - a*c*x])}
{E^ArcCoth[a*x]/(c - a*c*x)^(3/2), x, 5, -((a*(1 - 1/(a*x))^(3/2)*Sqrt[1 + 1/(a*x)]*x)/((a - 1/x)*(c - a*c*x)^(3/2))) - (Sqrt[a]*(1 - 1/(a*x))^(3/2)*ArcTanh[(Sqrt[2]*Sqrt[1/x])/(Sqrt[a]*Sqrt[1 + 1/(a*x)])])/(Sqrt[2]*(1/x)^(3/2)*(c - a*c*x)^(3/2))}
{E^ArcCoth[a*x]/(c - a*c*x)^(5/2), x, 6, (a^2*(1 - 1/(a*x))^(5/2)*Sqrt[1 + 1/(a*x)]*x^2)/(8*(a - 1/x)*(c - a*c*x)^(5/2)) - (a^3*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(3/2)*x^2)/(4*(a - 1/x)^2*(c - a*c*x)^(5/2)) + (a^(3/2)*(1 - 1/(a*x))^(5/2)*ArcTanh[(Sqrt[2]*Sqrt[1/x])/(Sqrt[a]*Sqrt[1 + 1/(a*x)])])/(8*Sqrt[2]*(1/x)^(5/2)*(c - a*c*x)^(5/2))}
{E^ArcCoth[a*x]/(c - a*c*x)^(7/2), x, 7, -((a^4*(1 - 1/(a*x))^(7/2)*(1 + 1/(a*x))^(3/2)*x^2)/(6*(a - 1/x)^3*(c - a*c*x)^(7/2))) - (a^3*(1 - 1/(a*x))^(7/2)*Sqrt[1 + 1/(a*x)]*x^3)/(32*(a - 1/x)*(c - a*c*x)^(7/2)) + (a^4*(1 - 1/(a*x))^(7/2)*(1 + 1/(a*x))^(3/2)*x^3)/(16*(a - 1/x)^2*(c - a*c*x)^(7/2)) - (a^(5/2)*(1 - 1/(a*x))^(7/2)*ArcTanh[(Sqrt[2]*Sqrt[1/x])/(Sqrt[a]*Sqrt[1 + 1/(a*x)])])/(32*Sqrt[2]*(1/x)^(7/2)*(c - a*c*x)^(7/2))}


{E^(2*ArcCoth[a*x])*(c - a*c*x)^(7/2), x, 5, (4*(c - a*c*x)^(7/2))/(7*a) - (2*(c - a*c*x)^(9/2))/(9*a*c)}
{E^(2*ArcCoth[a*x])*(c - a*c*x)^(5/2), x, 5, (4*(c - a*c*x)^(5/2))/(5*a) - (2*(c - a*c*x)^(7/2))/(7*a*c)}
{E^(2*ArcCoth[a*x])*(c - a*c*x)^(3/2), x, 5, (4*(c - a*c*x)^(3/2))/(3*a) - (2*(c - a*c*x)^(5/2))/(5*a*c)}
{E^(2*ArcCoth[a*x])*(c - a*c*x)^(1/2), x, 5, (4*Sqrt[c - a*c*x])/a - (2*(c - a*c*x)^(3/2))/(3*a*c)}
{E^(2*ArcCoth[a*x])/(c - a*c*x)^(1/2), x, 5, -(4/(a*Sqrt[c - a*c*x])) - (2*Sqrt[c - a*c*x])/(a*c)}
{E^(2*ArcCoth[a*x])/(c - a*c*x)^(3/2), x, 5, -(4/(3*a*(c - a*c*x)^(3/2))) + 2/(a*c*Sqrt[c - a*c*x])}
{E^(2*ArcCoth[a*x])/(c - a*c*x)^(5/2), x, 5, -(4/(5*a*(c - a*c*x)^(5/2))) + 2/(3*a*c*(c - a*c*x)^(3/2))}
{E^(2*ArcCoth[a*x])/(c - a*c*x)^(7/2), x, 5, -(4/(7*a*(c - a*c*x)^(7/2))) + 2/(5*a*c*(c - a*c*x)^(5/2))}


{E^(3*ArcCoth[a*x])*(c - a*c*x)^(9/2), x, 6, (-8*(1 + 1/(a*x))^(5/2)*(c - a*c*x)^(9/2))/(33*a*(1 - 1/(a*x))^(9/2)) - (856*(1 + 1/(a*x))^(5/2)*(c - a*c*x)^(9/2))/(1155*a^3*(1 - 1/(a*x))^(9/2)*x^2) + (16*(1 + 1/(a*x))^(5/2)*(c - a*c*x)^(9/2))/(21*a^2*(1 - 1/(a*x))^(9/2)*x) + (2*(a - x^(-1))^3*(1 + 1/(a*x))^(5/2)*x*(c - a*c*x)^(9/2))/(11*a^3*(1 - 1/(a*x))^(9/2))}
{E^(3*ArcCoth[a*x])*(c - a*c*x)^(7/2), x, 5, (-44*(1 + 1/(a*x))^(5/2)*(c - a*c*x)^(7/2))/(63*a*(1 - 1/(a*x))^(7/2)) + (214*(1 + 1/(a*x))^(5/2)*(c - a*c*x)^(7/2))/(315*a^2*(1 - 1/(a*x))^(7/2)*x) + (2*(1 + 1/(a*x))^(5/2)*x*(c - a*c*x)^(7/2))/(9*(1 - 1/(a*x))^(7/2))}
{E^(3*ArcCoth[a*x])*(c - a*c*x)^(5/2), x, 4, (-18*(1 + 1/(a*x))^(5/2)*(c - a*c*x)^(5/2))/(35*a*(1 - 1/(a*x))^(5/2)) + (2*(1 + 1/(a*x))^(5/2)*x*(c - a*c*x)^(5/2))/(7*(1 - 1/(a*x))^(5/2))}
{E^(3*ArcCoth[a*x])*(c - a*c*x)^(3/2), x, 1, (2*E^(3*ArcCoth[a*x])*(1 + a*x)*(c - a*c*x)^(3/2))/(5*a)}
{E^(3*ArcCoth[a*x])*(c - a*c*x)^(1/2), x, 6, (4*Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(a*Sqrt[1 - 1/(a*x)]) + (2*(1 + 1/(a*x))^(3/2)*x*Sqrt[c - a*c*x])/(3*Sqrt[1 - 1/(a*x)]) - (4*Sqrt[2]*Sqrt[1/x]*Sqrt[c - a*c*x]*ArcTanh[(Sqrt[2]*Sqrt[1/x])/(Sqrt[a]*Sqrt[1 + 1/(a*x)])])/(a^(3/2)*Sqrt[1 - 1/(a*x)])}
{E^(3*ArcCoth[a*x])/(c - a*c*x)^(1/2), x, 6, -((6*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])/((a - 1/x)*Sqrt[c - a*c*x])) + (2*a*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2)*x)/((a - 1/x)*Sqrt[c - a*c*x]) - (3*Sqrt[2]*Sqrt[1 - 1/(a*x)]*ArcTanh[(Sqrt[2]*Sqrt[1/x])/(Sqrt[a]*Sqrt[1 + 1/(a*x)])])/(Sqrt[a]*Sqrt[1/x]*Sqrt[c - a*c*x])}
{E^(3*ArcCoth[a*x])/(c - a*c*x)^(3/2), x, 6, -((3*a*(1 - 1/(a*x))^(3/2)*Sqrt[1 + 1/(a*x)]*x)/(4*(a - 1/x)*(c - a*c*x)^(3/2))) - (a^2*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(3/2)*x)/(2*(a - 1/x)^2*(c - a*c*x)^(3/2)) - (3*Sqrt[a]*(1 - 1/(a*x))^(3/2)*ArcTanh[(Sqrt[2]*Sqrt[1/x])/(Sqrt[a]*Sqrt[1 + 1/(a*x)])])/(4*Sqrt[2]*(1/x)^(3/2)*(c - a*c*x)^(3/2))}
{E^(3*ArcCoth[a*x])/(c - a*c*x)^(5/2), x, 7, (a^2*(1 - 1/(a*x))^(5/2)*Sqrt[1 + 1/(a*x)]*x^2)/(16*(a - 1/x)*(c - a*c*x)^(5/2)) + (a^3*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(3/2)*x^2)/(24*(a - 1/x)^2*(c - a*c*x)^(5/2)) - (a^4*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(5/2)*x^2)/(6*(a - 1/x)^3*(c - a*c*x)^(5/2)) + (a^(3/2)*(1 - 1/(a*x))^(5/2)*ArcTanh[(Sqrt[2]*Sqrt[1/x])/(Sqrt[a]*Sqrt[1 + 1/(a*x)])])/(16*Sqrt[2]*(1/x)^(5/2)*(c - a*c*x)^(5/2))}
{E^(3*ArcCoth[a*x])/(c - a*c*x)^(7/2), x, 8, -((a^5*(1 - 1/(a*x))^(7/2)*(1 + 1/(a*x))^(5/2)*x^2)/(8*(a - 1/x)^4*(c - a*c*x)^(7/2))) - (3*a^3*(1 - 1/(a*x))^(7/2)*Sqrt[1 + 1/(a*x)]*x^3)/(256*(a - 1/x)*(c - a*c*x)^(7/2)) - (a^4*(1 - 1/(a*x))^(7/2)*(1 + 1/(a*x))^(3/2)*x^3)/(128*(a - 1/x)^2*(c - a*c*x)^(7/2)) + (a^5*(1 - 1/(a*x))^(7/2)*(1 + 1/(a*x))^(5/2)*x^3)/(32*(a - 1/x)^3*(c - a*c*x)^(7/2)) - (3*a^(5/2)*(1 - 1/(a*x))^(7/2)*ArcTanh[(Sqrt[2]*Sqrt[1/x])/(Sqrt[a]*Sqrt[1 + 1/(a*x)])])/(256*Sqrt[2]*(1/x)^(7/2)*(c - a*c*x)^(7/2))}


(* ::Subsubsection::Closed:: *)
(*n<0*)


{(c - a*c*x)^(9/2)/E^ArcCoth[a*x], x, 8, (16384*c^5*Sqrt[1 - 1/(a^2*x^2)]*x)/(693*Sqrt[c - a*c*x]) + (4096/693)*c^4*Sqrt[1 - 1/(a^2*x^2)]*x*Sqrt[c - a*c*x] + (512/231)*c^3*Sqrt[1 - 1/(a^2*x^2)]*x*(c - a*c*x)^(3/2) + (640/693)*c^2*Sqrt[1 - 1/(a^2*x^2)]*x*(c - a*c*x)^(5/2) + (40/99)*c*Sqrt[1 - 1/(a^2*x^2)]*x*(c - a*c*x)^(7/2) + (2/11)*Sqrt[1 - 1/(a^2*x^2)]*x*(c - a*c*x)^(9/2), -((40*(a - 1/x)^4*Sqrt[1 + 1/(a*x)]*(c - a*c*x)^(9/2))/(99*a^5*(1 - 1/(a*x))^(9/2))) - (22016*Sqrt[1 + 1/(a*x)]*(c - a*c*x)^(9/2))/(693*a^5*(1 - 1/(a*x))^(9/2)*x^4) + (1024*Sqrt[1 + 1/(a*x)]*(c - a*c*x)^(9/2))/(99*a^4*(1 - 1/(a*x))^(9/2)*x^3) - (512*Sqrt[1 + 1/(a*x)]*(c - a*c*x)^(9/2))/(231*a^3*(1 - 1/(a*x))^(9/2)*x^2) + (640*(a - 1/x)^3*Sqrt[1 + 1/(a*x)]*(c - a*c*x)^(9/2))/(693*a^5*(1 - 1/(a*x))^(9/2)*x) + (2*(a - 1/x)^5*Sqrt[1 + 1/(a*x)]*x*(c - a*c*x)^(9/2))/(11*a^5*(1 - 1/(a*x))^(9/2))}
{(c - a*c*x)^(7/2)/E^ArcCoth[a*x], x, 7, (4096*c^4*Sqrt[1 - 1/(a^2*x^2)]*x)/(315*Sqrt[c - a*c*x]) + (1024/315)*c^3*Sqrt[1 - 1/(a^2*x^2)]*x*Sqrt[c - a*c*x] + (128/105)*c^2*Sqrt[1 - 1/(a^2*x^2)]*x*(c - a*c*x)^(3/2) + (32/63)*c*Sqrt[1 - 1/(a^2*x^2)]*x*(c - a*c*x)^(5/2) + (2/9)*Sqrt[1 - 1/(a^2*x^2)]*x*(c - a*c*x)^(7/2), -((32*(a - 1/x)^3*Sqrt[1 + 1/(a*x)]*(c - a*c*x)^(7/2))/(63*a^4*(1 - 1/(a*x))^(7/2))) + (5504*Sqrt[1 + 1/(a*x)]*(c - a*c*x)^(7/2))/(315*a^4*(1 - 1/(a*x))^(7/2)*x^3) - (256*Sqrt[1 + 1/(a*x)]*(c - a*c*x)^(7/2))/(45*a^3*(1 - 1/(a*x))^(7/2)*x^2) + (128*Sqrt[1 + 1/(a*x)]*(c - a*c*x)^(7/2))/(105*a^2*(1 - 1/(a*x))^(7/2)*x) + (2*(a - 1/x)^4*Sqrt[1 + 1/(a*x)]*x*(c - a*c*x)^(7/2))/(9*a^4*(1 - 1/(a*x))^(7/2))}
{(c - a*c*x)^(5/2)/E^ArcCoth[a*x], x, 6, (256*c^3*Sqrt[1 - 1/(a^2*x^2)]*x)/(35*Sqrt[c - a*c*x]) + (64/35)*c^2*Sqrt[1 - 1/(a^2*x^2)]*x*Sqrt[c - a*c*x] + (24/35)*c*Sqrt[1 - 1/(a^2*x^2)]*x*(c - a*c*x)^(3/2) + (2/7)*Sqrt[1 - 1/(a^2*x^2)]*x*(c - a*c*x)^(5/2), -((24*Sqrt[1 + 1/(a*x)]*(c - a*c*x)^(5/2))/(35*a*(1 - 1/(a*x))^(5/2))) - (344*Sqrt[1 + 1/(a*x)]*(c - a*c*x)^(5/2))/(35*a^3*(1 - 1/(a*x))^(5/2)*x^2) + (16*Sqrt[1 + 1/(a*x)]*(c - a*c*x)^(5/2))/(5*a^2*(1 - 1/(a*x))^(5/2)*x) + (2*(a - 1/x)^3*Sqrt[1 + 1/(a*x)]*x*(c - a*c*x)^(5/2))/(7*a^3*(1 - 1/(a*x))^(5/2))}
{(c - a*c*x)^(3/2)/E^ArcCoth[a*x], x, 5, (64*c^2*Sqrt[1 - 1/(a^2*x^2)]*x)/(15*Sqrt[c - a*c*x]) + (16/15)*c*Sqrt[1 - 1/(a^2*x^2)]*x*Sqrt[c - a*c*x] + (2/5)*Sqrt[1 - 1/(a^2*x^2)]*x*(c - a*c*x)^(3/2), -((28*Sqrt[1 + 1/(a*x)]*(c - a*c*x)^(3/2))/(15*a*(1 - 1/(a*x))^(3/2))) + (86*Sqrt[1 + 1/(a*x)]*(c - a*c*x)^(3/2))/(15*a^2*(1 - 1/(a*x))^(3/2)*x) + (2*Sqrt[1 + 1/(a*x)]*x*(c - a*c*x)^(3/2))/(5*(1 - 1/(a*x))^(3/2))}
{(c - a*c*x)^(1/2)/E^ArcCoth[a*x], x, 4, (8*c*Sqrt[1 - 1/(a^2*x^2)]*x)/(3*Sqrt[c - a*c*x]) + (2/3)*Sqrt[1 - 1/(a^2*x^2)]*x*Sqrt[c - a*c*x], -((10*Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(3*a*Sqrt[1 - 1/(a*x)])) + (2*Sqrt[1 + 1/(a*x)]*x*Sqrt[c - a*c*x])/(3*Sqrt[1 - 1/(a*x)])}
{1/(E^ArcCoth[a*x]*(c - a*c*x)^(1/2)), x, 1, (2*(1 + a*x))/(E^ArcCoth[a*x]*(a*Sqrt[c - a*c*x]))}
{1/(E^ArcCoth[a*x]*(c - a*c*x)^(3/2)), x, 4, -((Sqrt[2]*Sqrt[a]*(1 - 1/(a*x))^(3/2)*ArcTanh[(Sqrt[2]*Sqrt[1/x])/(Sqrt[a]*Sqrt[1 + 1/(a*x)])])/((1/x)^(3/2)*(c - a*c*x)^(3/2)))}
{1/(E^ArcCoth[a*x]*(c - a*c*x)^(5/2)), x, 5, -((a^2*(1 - 1/(a*x))^(5/2)*Sqrt[1 + 1/(a*x)]*x^2)/(2*(a - 1/x)*(c - a*c*x)^(5/2))) + (a^(3/2)*(1 - 1/(a*x))^(5/2)*ArcTanh[(Sqrt[2]*Sqrt[1/x])/(Sqrt[a]*Sqrt[1 + 1/(a*x)])])/(2*Sqrt[2]*(1/x)^(5/2)*(c - a*c*x)^(5/2))}
{1/(E^ArcCoth[a*x]*(c - a*c*x)^(7/2)), x, 6, -((a^3*(1 - 1/(a*x))^(7/2)*Sqrt[1 + 1/(a*x)]*x^2)/(4*(a - 1/x)^2*(c - a*c*x)^(7/2))) + (3*a^3*(1 - 1/(a*x))^(7/2)*Sqrt[1 + 1/(a*x)]*x^3)/(16*(a - 1/x)*(c - a*c*x)^(7/2)) - (3*a^(5/2)*(1 - 1/(a*x))^(7/2)*ArcTanh[(Sqrt[2]*Sqrt[1/x])/(Sqrt[a]*Sqrt[1 + 1/(a*x)])])/(16*Sqrt[2]*(1/x)^(7/2)*(c - a*c*x)^(7/2))}


{(c - a*c*x)^(7/2)/E^(2*ArcCoth[a*x]), x, 10, -((32*c^3*Sqrt[c - a*c*x])/a) - (16*c^2*(c - a*c*x)^(3/2))/(3*a) - (8*c*(c - a*c*x)^(5/2))/(5*a) - (4*(c - a*c*x)^(7/2))/(7*a) - (2*(c - a*c*x)^(9/2))/(9*a*c) + (32*Sqrt[2]*c^(7/2)*ArcTanh[Sqrt[c - a*c*x]/(Sqrt[2]*Sqrt[c])])/a}
{(c - a*c*x)^(5/2)/E^(2*ArcCoth[a*x]), x, 9, -((16*c^2*Sqrt[c - a*c*x])/a) - (8*c*(c - a*c*x)^(3/2))/(3*a) - (4*(c - a*c*x)^(5/2))/(5*a) - (2*(c - a*c*x)^(7/2))/(7*a*c) + (16*Sqrt[2]*c^(5/2)*ArcTanh[Sqrt[c - a*c*x]/(Sqrt[2]*Sqrt[c])])/a}
{(c - a*c*x)^(3/2)/E^(2*ArcCoth[a*x]), x, 8, -((8*c*Sqrt[c - a*c*x])/a) - (4*(c - a*c*x)^(3/2))/(3*a) - (2*(c - a*c*x)^(5/2))/(5*a*c) + (8*Sqrt[2]*c^(3/2)*ArcTanh[Sqrt[c - a*c*x]/(Sqrt[2]*Sqrt[c])])/a}
{(c - a*c*x)^(1/2)/E^(2*ArcCoth[a*x]), x, 7, -((4*Sqrt[c - a*c*x])/a) - (2*(c - a*c*x)^(3/2))/(3*a*c) + (4*Sqrt[2]*Sqrt[c]*ArcTanh[Sqrt[c - a*c*x]/(Sqrt[2]*Sqrt[c])])/a}
{1/(E^(2*ArcCoth[a*x])*(c - a*c*x)^(1/2)), x, 6, -((2*Sqrt[c - a*c*x])/(a*c)) + (2*Sqrt[2]*ArcTanh[Sqrt[c - a*c*x]/(Sqrt[2]*Sqrt[c])])/(a*Sqrt[c])}
{1/(E^(2*ArcCoth[a*x])*(c - a*c*x)^(3/2)), x, 5, (Sqrt[2]*ArcTanh[Sqrt[c - a*c*x]/(Sqrt[2]*Sqrt[c])])/(a*c^(3/2))}
{1/(E^(2*ArcCoth[a*x])*(c - a*c*x)^(5/2)), x, 6, -(1/(a*c^2*Sqrt[c - a*c*x])) + ArcTanh[Sqrt[c - a*c*x]/(Sqrt[2]*Sqrt[c])]/(Sqrt[2]*a*c^(5/2))}
{1/(E^(2*ArcCoth[a*x])*(c - a*c*x)^(7/2)), x, 7, -(1/(3*a*c^2*(c - a*c*x)^(3/2))) - 1/(2*a*c^3*Sqrt[c - a*c*x]) + ArcTanh[Sqrt[c - a*c*x]/(Sqrt[2]*Sqrt[c])]/(2*Sqrt[2]*a*c^(7/2))}
{1/(E^(2*ArcCoth[a*x])*(c - a*c*x)^(9/2)), x, 8, -(1/(5*a*c^2*(c - a*c*x)^(5/2))) - 1/(6*a*c^3*(c - a*c*x)^(3/2)) - 1/(4*a*c^4*Sqrt[c - a*c*x]) + ArcTanh[Sqrt[c - a*c*x]/(Sqrt[2]*Sqrt[c])]/(4*Sqrt[2]*a*c^(9/2))}


{(c - a*c*x)^(9/2)/E^(3*ArcCoth[a*x]), x, 9, -((16*(a - 1/x)^5*(c - a*c*x)^(9/2))/(33*a^6*(1 - 1/(a*x))^(9/2)*Sqrt[1 + 1/(a*x)])) - (94208*(c - a*c*x)^(9/2))/(231*a^6*(1 - 1/(a*x))^(9/2)*Sqrt[1 + 1/(a*x)]*x^5) - (40960*(c - a*c*x)^(9/2))/(231*a^5*(1 - 1/(a*x))^(9/2)*Sqrt[1 + 1/(a*x)]*x^4) + (4096*(c - a*c*x)^(9/2))/(231*a^4*(1 - 1/(a*x))^(9/2)*Sqrt[1 + 1/(a*x)]*x^3) - (1024*(a - 1/x)^3*(c - a*c*x)^(9/2))/(231*a^6*(1 - 1/(a*x))^(9/2)*Sqrt[1 + 1/(a*x)]*x^2) + (320*(a - 1/x)^4*(c - a*c*x)^(9/2))/(231*a^6*(1 - 1/(a*x))^(9/2)*Sqrt[1 + 1/(a*x)]*x) + (2*(a - 1/x)^6*x*(c - a*c*x)^(9/2))/(11*a^6*(1 - 1/(a*x))^(9/2)*Sqrt[1 + 1/(a*x)])}
{(c - a*c*x)^(7/2)/E^(3*ArcCoth[a*x]), x, 8, -((40*(a - 1/x)^4*(c - a*c*x)^(7/2))/(63*a^5*(1 - 1/(a*x))^(7/2)*Sqrt[1 + 1/(a*x)])) + (11776*(c - a*c*x)^(7/2))/(63*a^5*(1 - 1/(a*x))^(7/2)*Sqrt[1 + 1/(a*x)]*x^4) + (5120*(c - a*c*x)^(7/2))/(63*a^4*(1 - 1/(a*x))^(7/2)*Sqrt[1 + 1/(a*x)]*x^3) - (512*(c - a*c*x)^(7/2))/(63*a^3*(1 - 1/(a*x))^(7/2)*Sqrt[1 + 1/(a*x)]*x^2) + (128*(a - 1/x)^3*(c - a*c*x)^(7/2))/(63*a^5*(1 - 1/(a*x))^(7/2)*Sqrt[1 + 1/(a*x)]*x) + (2*(a - 1/x)^5*x*(c - a*c*x)^(7/2))/(9*a^5*(1 - 1/(a*x))^(7/2)*Sqrt[1 + 1/(a*x)])}
{(c - a*c*x)^(5/2)/E^(3*ArcCoth[a*x]), x, 7, -((32*(a - 1/x)^3*(c - a*c*x)^(5/2))/(35*a^4*(1 - 1/(a*x))^(5/2)*Sqrt[1 + 1/(a*x)])) - (2944*(c - a*c*x)^(5/2))/(35*a^4*(1 - 1/(a*x))^(5/2)*Sqrt[1 + 1/(a*x)]*x^3) - (256*(c - a*c*x)^(5/2))/(7*a^3*(1 - 1/(a*x))^(5/2)*Sqrt[1 + 1/(a*x)]*x^2) + (128*(c - a*c*x)^(5/2))/(35*a^2*(1 - 1/(a*x))^(5/2)*Sqrt[1 + 1/(a*x)]*x) + (2*(a - 1/x)^4*x*(c - a*c*x)^(5/2))/(7*a^4*(1 - 1/(a*x))^(5/2)*Sqrt[1 + 1/(a*x)])}
{(c - a*c*x)^(3/2)/E^(3*ArcCoth[a*x]), x, 6, -((8*(c - a*c*x)^(3/2))/(5*a*(1 - 1/(a*x))^(3/2)*Sqrt[1 + 1/(a*x)])) + (184*(c - a*c*x)^(3/2))/(5*a^3*(1 - 1/(a*x))^(3/2)*Sqrt[1 + 1/(a*x)]*x^2) + (16*(c - a*c*x)^(3/2))/(a^2*(1 - 1/(a*x))^(3/2)*Sqrt[1 + 1/(a*x)]*x) + (2*(a - 1/x)^3*x*(c - a*c*x)^(3/2))/(5*a^3*(1 - 1/(a*x))^(3/2)*Sqrt[1 + 1/(a*x)])}
{(c - a*c*x)^(1/2)/E^(3*ArcCoth[a*x]), x, 5, -((20*Sqrt[c - a*c*x])/(3*a*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])) - (46*Sqrt[c - a*c*x])/(3*a^2*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x) + (2*x*Sqrt[c - a*c*x])/(3*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])}
{1/(E^(3*ArcCoth[a*x])*(c - a*c*x)^(1/2)), x, 4, (6*Sqrt[1 - 1/(a*x)])/(a*Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x]) + (2*Sqrt[1 - 1/(a*x)]*x)/(Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])}
{1/(E^(3*ArcCoth[a*x])*(c - a*c*x)^(3/2)), x, 1, -((2*(1 + a*x))/(E^(3*ArcCoth[a*x])*(a*(c - a*c*x)^(3/2))))}
{1/(E^(3*ArcCoth[a*x])*(c - a*c*x)^(5/2)), x, 5, (a*(1 - 1/(a*x))^(5/2)*x^2)/(Sqrt[1 + 1/(a*x)]*(c - a*c*x)^(5/2)) - (a^(3/2)*(1 - 1/(a*x))^(5/2)*ArcTanh[(Sqrt[2]*Sqrt[1/x])/(Sqrt[a]*Sqrt[1 + 1/(a*x)])])/(Sqrt[2]*(1/x)^(5/2)*(c - a*c*x)^(5/2))}
{1/(E^(3*ArcCoth[a*x])*(c - a*c*x)^(7/2)), x, 6, -((a^2*(1 - 1/(a*x))^(7/2)*x^2)/(2*(a - 1/x)*Sqrt[1 + 1/(a*x)]*(c - a*c*x)^(7/2))) - (3*a^2*(1 - 1/(a*x))^(7/2)*x^3)/(4*Sqrt[1 + 1/(a*x)]*(c - a*c*x)^(7/2)) + (3*a^(5/2)*(1 - 1/(a*x))^(7/2)*ArcTanh[(Sqrt[2]*Sqrt[1/x])/(Sqrt[a]*Sqrt[1 + 1/(a*x)])])/(4*Sqrt[2]*(1/x)^(7/2)*(c - a*c*x)^(7/2))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m E^(n ArcCoth[a x]) (c-c a x)^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{E^ArcCoth[x]*x*(1 + x), x, 7, Sqrt[1 + 1/x]*Sqrt[(-1 + x)/x]*x + (1/3)*(1 + 1/x)^(3/2)*Sqrt[(-1 + x)/x]*x^2 + (1/3)*(1 + 1/x)^(5/2)*Sqrt[(-1 + x)/x]*x^3 + ArcTanh[Sqrt[1 + 1/x]*Sqrt[(-1 + x)/x]]}
{E^ArcCoth[x]*(1 + x), x, 6, (3/2)*Sqrt[1 + 1/x]*Sqrt[(-1 + x)/x]*x + (1/2)*(1 + 1/x)^(3/2)*Sqrt[(-1 + x)/x]*x^2 + (3/2)*ArcTanh[Sqrt[1 + 1/x]*Sqrt[(-1 + x)/x]]}

{E^ArcCoth[x]*(1 - x)*x, x, 3, (-(1/3))*(1 - 1/x^2)^(3/2)*x^3}
{E^ArcCoth[x]*(1 - x), x, 6, (-(1/2))*Sqrt[1 - 1/x^2]*x^2 + (1/2)*ArcTanh[Sqrt[1 - 1/x^2]]}


{E^ArcCoth[x]*x*(1 + x)^2, x, 8, (15/8)*Sqrt[1 + 1/x]*Sqrt[(-1 + x)/x]*x + (5/8)*(1 + 1/x)^(3/2)*Sqrt[(-1 + x)/x]*x^2 + (1/4)*(1 + 1/x)^(5/2)*Sqrt[(-1 + x)/x]*x^3 + (1/4)*(1 + 1/x)^(7/2)*Sqrt[(-1 + x)/x]*x^4 + (15/8)*ArcTanh[Sqrt[1 + 1/x]*Sqrt[(-1 + x)/x]]}
{E^ArcCoth[x]*(1 + x)^2, x, 7, (5/2)*Sqrt[1 + 1/x]*Sqrt[(-1 + x)/x]*x + (5/6)*(1 + 1/x)^(3/2)*Sqrt[(-1 + x)/x]*x^2 + (1/3)*(1 + 1/x)^(5/2)*Sqrt[(-1 + x)/x]*x^3 + (5/2)*ArcTanh[Sqrt[1 + 1/x]*Sqrt[(-1 + x)/x]]}

{E^ArcCoth[x]*(1 - x)^2*x, x, 8, (1/8)*Sqrt[1 - 1/x^2]*x^2 - (1/3)*(1 - 1/x^2)^(3/2)*x^3 + (1/4)*(1 - 1/x^2)^(3/2)*x^4 - (1/8)*ArcTanh[Sqrt[1 - 1/x^2]]}
{E^ArcCoth[x]*(1 - x)^2, x, 7, (-(1/2))*Sqrt[1 - 1/x^2]*x^2 + (1/3)*(1 - 1/x^2)^(3/2)*x^3 + (1/2)*ArcTanh[Sqrt[1 - 1/x^2]]}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{(E^ArcCoth[x]*x)/(1 + x), x, 3, Sqrt[1 + 1/x]*Sqrt[(-1 + x)/x]*x}
{E^ArcCoth[x]/(1 + x), x, 4, ArcTanh[Sqrt[1 + 1/x]*Sqrt[(-1 + x)/x]]}

{(E^ArcCoth[x]*x)/(1 - x), x, 8, (2*(1 + 1/x))/Sqrt[1 - 1/x^2] - Sqrt[1 - 1/x^2]*x - 2*ArcTanh[Sqrt[1 - 1/x^2]]}
{E^ArcCoth[x]/(1 - x), x, 7, (2*(1 + 1/x))/Sqrt[1 - 1/x^2] - ArcTanh[Sqrt[1 - 1/x^2]]}


{(E^ArcCoth[x]*x)/(1 + x)^2, x, 5, -(Sqrt[(-1 + x)/x]/Sqrt[1 + 1/x]) + ArcTanh[Sqrt[1 + 1/x]*Sqrt[(-1 + x)/x]]}
{E^ArcCoth[x]/(1 + x)^2, x, 3, Sqrt[(-1 + x)/x]/Sqrt[1 + 1/x]}

{(E^ArcCoth[x]*x)/(1 - x)^2, x, 9, -((4*(1 + 1/x))/(3*(1 - 1/x^2)^(3/2))) - (3 + 5/x)/(3*Sqrt[1 - 1/x^2]) + ArcTanh[Sqrt[1 - 1/x^2]]}
{E^ArcCoth[x]/(1 - x)^2, x, 3, -((1 - 1/x^2)^(3/2)/(3*(1 - 1/x)^3))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m E^(n ArcCoth[a x]) (c-c a x)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{E^ArcCoth[a*x]*x^m*Sqrt[c - a*c*x], x, 3, (2*x^(1 + m)*Sqrt[c - a*c*x]*Hypergeometric2F1[-(1/2), -(3/2) - m, -(1/2) - m, -(1/(a*x))])/((3 + 2*m)*Sqrt[1 - 1/(a*x)])}

{E^ArcCoth[a*x]*x^2*Sqrt[c - a*c*x], x, 5, (16*(1 + 1/(a*x))^(3/2)*x*Sqrt[c - a*c*x])/(105*a^2*Sqrt[1 - 1/(a*x)]) - (8*(1 + 1/(a*x))^(3/2)*x^2*Sqrt[c - a*c*x])/(35*a*Sqrt[1 - 1/(a*x)]) + (2*(1 + 1/(a*x))^(3/2)*x^3*Sqrt[c - a*c*x])/(7*Sqrt[1 - 1/(a*x)])}
{E^ArcCoth[a*x]*x*Sqrt[c - a*c*x], x, 4, -((4*(1 + 1/(a*x))^(3/2)*x*Sqrt[c - a*c*x])/(15*a*Sqrt[1 - 1/(a*x)])) + (2*(1 + 1/(a*x))^(3/2)*x^2*Sqrt[c - a*c*x])/(5*Sqrt[1 - 1/(a*x)])}
{E^ArcCoth[a*x]*Sqrt[c - a*c*x], x, 1, (2*E^ArcCoth[a*x]*(1 + a*x)*Sqrt[c - a*c*x])/(3*a)}
{(E^ArcCoth[a*x]*Sqrt[c - a*c*x])/x, x, 5, (2*Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/Sqrt[1 - 1/(a*x)] - (2*Sqrt[x^(-1)]*Sqrt[c - a*c*x]*ArcSinh[Sqrt[x^(-1)]/Sqrt[a]])/(Sqrt[a]*Sqrt[1 - 1/(a*x)])}
{(E^ArcCoth[a*x]*Sqrt[c - a*c*x])/x^2, x, 5, -((Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(Sqrt[1 - 1/(a*x)]*x)) - (Sqrt[a]*Sqrt[x^(-1)]*Sqrt[c - a*c*x]*ArcSinh[Sqrt[x^(-1)]/Sqrt[a]])/Sqrt[1 - 1/(a*x)]}


{E^(2*ArcCoth[a*x])*x^3*Sqrt[c - a*c*x], x, 5, (4*Sqrt[c - a*c*x])/a^4 - (14*(c - a*c*x)^(3/2))/(3*a^4*c) + (18*(c - a*c*x)^(5/2))/(5*a^4*c^2) - (10*(c - a*c*x)^(7/2))/(7*a^4*c^3) + (2*(c - a*c*x)^(9/2))/(9*a^4*c^4)}
{E^(2*ArcCoth[a*x])*x^2*Sqrt[c - a*c*x], x, 5, (4*Sqrt[c - a*c*x])/a^3 - (10*(c - a*c*x)^(3/2))/(3*a^3*c) + (8*(c - a*c*x)^(5/2))/(5*a^3*c^2) - (2*(c - a*c*x)^(7/2))/(7*a^3*c^3)}
{E^(2*ArcCoth[a*x])*x*Sqrt[c - a*c*x], x, 5, (4*Sqrt[c - a*c*x])/a^2 - (2*(c - a*c*x)^(3/2))/(a^2*c) + (2*(c - a*c*x)^(5/2))/(5*a^2*c^2)}
{E^(2*ArcCoth[a*x])*Sqrt[c - a*c*x], x, 5, (4*Sqrt[c - a*c*x])/a - (2*(c - a*c*x)^(3/2))/(3*a*c)}
{(E^(2*ArcCoth[a*x])*Sqrt[c - a*c*x])/x, x, 6, 2*Sqrt[c - a*c*x] + 2*Sqrt[c]*ArcTanh[Sqrt[c - a*c*x]/Sqrt[c]]}
{(E^(2*ArcCoth[a*x])*Sqrt[c - a*c*x])/x^2, x, 6, Sqrt[c - a*c*x]/x + 3*a*Sqrt[c]*ArcTanh[Sqrt[c - a*c*x]/Sqrt[c]]}
{(E^(2*ArcCoth[a*x])*Sqrt[c - a*c*x])/x^3, x, 7, Sqrt[c - a*c*x]/(2*x^2) + (7*a*Sqrt[c - a*c*x])/(4*x) + (7/4)*a^2*Sqrt[c]*ArcTanh[Sqrt[c - a*c*x]/Sqrt[c]]}
{(E^(2*ArcCoth[a*x])*Sqrt[c - a*c*x])/x^4, x, 8, Sqrt[c - a*c*x]/(3*x^3) + (11*a*Sqrt[c - a*c*x])/(12*x^2) + (11*a^2*Sqrt[c - a*c*x])/(8*x) + (11/8)*a^3*Sqrt[c]*ArcTanh[Sqrt[c - a*c*x]/Sqrt[c]]}
{(E^(2*ArcCoth[a*x])*Sqrt[c - a*c*x])/x^5, x, 9, Sqrt[c - a*c*x]/(4*x^4) + (5*a*Sqrt[c - a*c*x])/(8*x^3) + (25*a^2*Sqrt[c - a*c*x])/(32*x^2) + (75*a^3*Sqrt[c - a*c*x])/(64*x) + (75/64)*a^4*Sqrt[c]*ArcTanh[Sqrt[c - a*c*x]/Sqrt[c]]}


{E^(3*ArcCoth[a*x])*x^3*Sqrt[c - a*c*x], x, 10, (1576*Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(315*a^4*Sqrt[1 - 1/(a*x)]) + (472*Sqrt[1 + 1/(a*x)]*x*Sqrt[c - a*c*x])/(315*a^3*Sqrt[1 - 1/(a*x)]) + (92*Sqrt[1 + 1/(a*x)]*x^2*Sqrt[c - a*c*x])/(105*a^2*Sqrt[1 - 1/(a*x)]) + (38*Sqrt[1 + 1/(a*x)]*x^3*Sqrt[c - a*c*x])/(63*a*Sqrt[1 - 1/(a*x)]) + (2*Sqrt[1 + 1/(a*x)]*x^4*Sqrt[c - a*c*x])/(9*Sqrt[1 - 1/(a*x)]) - (4*Sqrt[2]*Sqrt[1/x]*Sqrt[c - a*c*x]*ArcTanh[(Sqrt[2]*Sqrt[1/x])/(Sqrt[a]*Sqrt[1 + 1/(a*x)])])/(a^(9/2)*Sqrt[1 - 1/(a*x)])}
{E^(3*ArcCoth[a*x])*x^2*Sqrt[c - a*c*x], x, 9, (104*Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(21*a^3*Sqrt[1 - 1/(a*x)]) + (32*Sqrt[1 + 1/(a*x)]*x*Sqrt[c - a*c*x])/(21*a^2*Sqrt[1 - 1/(a*x)]) + (6*Sqrt[1 + 1/(a*x)]*x^2*Sqrt[c - a*c*x])/(7*a*Sqrt[1 - 1/(a*x)]) + (2*Sqrt[1 + 1/(a*x)]*x^3*Sqrt[c - a*c*x])/(7*Sqrt[1 - 1/(a*x)]) - (4*Sqrt[2]*Sqrt[1/x]*Sqrt[c - a*c*x]*ArcTanh[(Sqrt[2]*Sqrt[1/x])/(Sqrt[a]*Sqrt[1 + 1/(a*x)])])/(a^(7/2)*Sqrt[1 - 1/(a*x)])}
{E^(3*ArcCoth[a*x])*x*Sqrt[c - a*c*x], x, 7, (4*Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(a^2*Sqrt[1 - 1/(a*x)]) + (2*(1 + 1/(a*x))^(3/2)*x*Sqrt[c - a*c*x])/(3*a*Sqrt[1 - 1/(a*x)]) + (2*(1 + 1/(a*x))^(5/2)*x^2*Sqrt[c - a*c*x])/(5*Sqrt[1 - 1/(a*x)]) - (4*Sqrt[2]*Sqrt[1/x]*Sqrt[c - a*c*x]*ArcTanh[(Sqrt[2]*Sqrt[1/x])/(Sqrt[a]*Sqrt[1 + 1/(a*x)])])/(a^(5/2)*Sqrt[1 - 1/(a*x)])}
{E^(3*ArcCoth[a*x])*Sqrt[c - a*c*x], x, 6, (4*Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(a*Sqrt[1 - 1/(a*x)]) + (2*(1 + 1/(a*x))^(3/2)*x*Sqrt[c - a*c*x])/(3*Sqrt[1 - 1/(a*x)]) - (4*Sqrt[2]*Sqrt[1/x]*Sqrt[c - a*c*x]*ArcTanh[(Sqrt[2]*Sqrt[1/x])/(Sqrt[a]*Sqrt[1 + 1/(a*x)])])/(a^(3/2)*Sqrt[1 - 1/(a*x)])}
{(E^(3*ArcCoth[a*x])*Sqrt[c - a*c*x])/x, x, 8, (2*Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/Sqrt[1 - 1/(a*x)] + (2*Sqrt[1/x]*Sqrt[c - a*c*x]*ArcSinh[Sqrt[1/x]/Sqrt[a]])/(Sqrt[a]*Sqrt[1 - 1/(a*x)]) - (4*Sqrt[2]*Sqrt[1/x]*Sqrt[c - a*c*x]*ArcTanh[(Sqrt[2]*Sqrt[1/x])/(Sqrt[a]*Sqrt[1 + 1/(a*x)])])/(Sqrt[a]*Sqrt[1 - 1/(a*x)])}
{(E^(3*ArcCoth[a*x])*Sqrt[c - a*c*x])/x^2, x, 8, (Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(Sqrt[1 - 1/(a*x)]*x) + (5*Sqrt[a]*Sqrt[1/x]*Sqrt[c - a*c*x]*ArcSinh[Sqrt[1/x]/Sqrt[a]])/Sqrt[1 - 1/(a*x)] - (4*Sqrt[2]*Sqrt[a]*Sqrt[1/x]*Sqrt[c - a*c*x]*ArcTanh[(Sqrt[2]*Sqrt[1/x])/(Sqrt[a]*Sqrt[1 + 1/(a*x)])])/Sqrt[1 - 1/(a*x)]}
{(E^(3*ArcCoth[a*x])*Sqrt[c - a*c*x])/x^3, x, 9, (7*a*Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(4*Sqrt[1 - 1/(a*x)]*x) + (a*(1 + 1/(a*x))^(3/2)*Sqrt[c - a*c*x])/(2*Sqrt[1 - 1/(a*x)]*x) + (23*a^(3/2)*Sqrt[1/x]*Sqrt[c - a*c*x]*ArcSinh[Sqrt[1/x]/Sqrt[a]])/(4*Sqrt[1 - 1/(a*x)]) - (4*Sqrt[2]*a^(3/2)*Sqrt[1/x]*Sqrt[c - a*c*x]*ArcTanh[(Sqrt[2]*Sqrt[1/x])/(Sqrt[a]*Sqrt[1 + 1/(a*x)])])/Sqrt[1 - 1/(a*x)]}
{(E^(3*ArcCoth[a*x])*Sqrt[c - a*c*x])/x^4, x, 10, (a*(1 + 1/(a*x))^(3/2)*Sqrt[c - a*c*x])/(3*Sqrt[1 - 1/(a*x)]*x^2) + (13*a^2*Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(8*Sqrt[1 - 1/(a*x)]*x) + (3*a^2*(1 + 1/(a*x))^(3/2)*Sqrt[c - a*c*x])/(4*Sqrt[1 - 1/(a*x)]*x) + (45*a^(5/2)*Sqrt[1/x]*Sqrt[c - a*c*x]*ArcSinh[Sqrt[1/x]/Sqrt[a]])/(8*Sqrt[1 - 1/(a*x)]) - (4*Sqrt[2]*a^(5/2)*Sqrt[1/x]*Sqrt[c - a*c*x]*ArcTanh[(Sqrt[2]*Sqrt[1/x])/(Sqrt[a]*Sqrt[1 + 1/(a*x)])])/Sqrt[1 - 1/(a*x)]}
{(E^(3*ArcCoth[a*x])*Sqrt[c - a*c*x])/x^5, x, 11, (a*(1 + 1/(a*x))^(3/2)*Sqrt[c - a*c*x])/(4*Sqrt[1 - 1/(a*x)]*x^3) + (11*a^2*(1 + 1/(a*x))^(3/2)*Sqrt[c - a*c*x])/(24*Sqrt[1 - 1/(a*x)]*x^2) + (107*a^3*Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(64*Sqrt[1 - 1/(a*x)]*x) + (21*a^3*(1 + 1/(a*x))^(3/2)*Sqrt[c - a*c*x])/(32*Sqrt[1 - 1/(a*x)]*x) + (363*a^(7/2)*Sqrt[1/x]*Sqrt[c - a*c*x]*ArcSinh[Sqrt[1/x]/Sqrt[a]])/(64*Sqrt[1 - 1/(a*x)]) - (4*Sqrt[2]*a^(7/2)*Sqrt[1/x]*Sqrt[c - a*c*x]*ArcTanh[(Sqrt[2]*Sqrt[1/x])/(Sqrt[a]*Sqrt[1 + 1/(a*x)])])/Sqrt[1 - 1/(a*x)]}


{E^ArcCoth[x]*x*(1 + x)^(3/2), x, 6, (46*Sqrt[-((1 - x)/x)]*(1 + x)^(3/2))/(21*(1 + 1/x)^(3/2)) + (92*Sqrt[-((1 - x)/x)]*(1 + x)^(3/2))/(21*(1 + 1/x)^(3/2)*x) + (8*Sqrt[-((1 - x)/x)]*x*(1 + x)^(3/2))/(7*(1 + 1/x)^(3/2)) + (2*Sqrt[-((1 - x)/x)]*x^2*(1 + x)^(3/2))/(7*(1 + 1/x)^(3/2))}
{E^ArcCoth[x]*(1 + x)^(3/2), x, 5, (28*Sqrt[-((1 - x)/x)]*(1 + x)^(3/2))/(15*(1 + 1/x)^(3/2)) + (86*Sqrt[-((1 - x)/x)]*(1 + x)^(3/2))/(15*(1 + 1/x)^(3/2)*x) + (2*Sqrt[-((1 - x)/x)]*x*(1 + x)^(3/2))/(5*(1 + 1/x)^(3/2))}

{E^ArcCoth[x]*(1 - x)^(3/2)*x, x, 5, (44*(1 + 1/x)^(3/2)*(1 - x)^(3/2))/(105*(1 - 1/x)^(3/2)) - (22*(1 + 1/x)^(3/2)*(1 - x)^(3/2)*x)/(35*(1 - 1/x)^(3/2)) + (2*(1 + 1/x)^(3/2)*(1 - x)^(3/2)*x^2)/(7*(1 - 1/x)^(3/2))}
{E^ArcCoth[x]*(1 - x)^(3/2), x, 4, (-14*(1 + x^(-1))^(3/2)*(1 - x)^(3/2))/(15*(1 - x^(-1))^(3/2)) + (2*(1 + x^(-1))^(3/2)*(1 - x)^(3/2)*x)/(5*(1 - x^(-1))^(3/2))}


{E^ArcCoth[x]*x*Sqrt[1 + x], x, 5, (12*Sqrt[-((1 - x)/x)]*Sqrt[1 + x])/(5*Sqrt[1 + 1/x]) + (6*Sqrt[-((1 - x)/x)]*x*Sqrt[1 + x])/(5*Sqrt[1 + 1/x]) + (2*Sqrt[-((1 - x)/x)]*x^2*Sqrt[1 + x])/(5*Sqrt[1 + 1/x])}
{E^ArcCoth[x]*Sqrt[1 + x], x, 4, (10*Sqrt[-((1 - x)/x)]*Sqrt[1 + x])/(3*Sqrt[1 + 1/x]) + (2*Sqrt[-((1 - x)/x)]*x*Sqrt[1 + x])/(3*Sqrt[1 + 1/x])}

{E^ArcCoth[x]*Sqrt[1 - x]*x, x, 4, -((4*(1 + 1/x)^(3/2)*Sqrt[1 - x]*x)/(15*Sqrt[1 - 1/x])) + (2*(1 + 1/x)^(3/2)*Sqrt[1 - x]*x^2)/(5*Sqrt[1 - 1/x])}
{E^ArcCoth[x]*Sqrt[1 - x], x, 1, (2/3)*E^ArcCoth[x]*Sqrt[1 - x]*(1 + x)}


{(E^ArcCoth[x]*x)/Sqrt[1 + x], x, 4, (4*Sqrt[1 + 1/x]*Sqrt[-((1 - x)/x)]*x)/(3*Sqrt[1 + x]) + (2*Sqrt[1 + 1/x]*Sqrt[-((1 - x)/x)]*x^2)/(3*Sqrt[1 + x])}
{E^ArcCoth[x]/Sqrt[1 + x], x, 3, (2*Sqrt[1 + 1/x]*Sqrt[-((1 - x)/x)]*x)/Sqrt[1 + x]}

{(E^ArcCoth[x]*x)/Sqrt[1 - x], x, 6, (2*Sqrt[1 - 1/x]*Sqrt[1 + 1/x]*x)/Sqrt[1 - x] + (2*Sqrt[1 - 1/x]*(1 + 1/x)^(3/2)*x^2)/(3*Sqrt[1 - x]) - (2*Sqrt[2]*Sqrt[1 - 1/x]*ArcTanh[(Sqrt[2]*Sqrt[1/x])/Sqrt[1 + 1/x]])/(Sqrt[1 - x]*Sqrt[1/x])}
{E^ArcCoth[x]/Sqrt[1 - x], x, 5, (2*Sqrt[1 - x^(-1)]*Sqrt[1 + x^(-1)]*x)/Sqrt[1 - x] - (2*Sqrt[2]*Sqrt[1 - x^(-1)]*ArcTanh[(Sqrt[2]*Sqrt[x^(-1)])/Sqrt[1 + x^(-1)]])/(Sqrt[1 - x]*Sqrt[x^(-1)])}


{(E^ArcCoth[x]*x)/(1 + x)^(3/2), x, 5, (2*(1 + 1/x)^(3/2)*Sqrt[-((1 - x)/x)]*x^2)/(1 + x)^(3/2) + (Sqrt[2]*(1 + 1/x)^(3/2)*ArcTan[(Sqrt[2]*Sqrt[1/x])/Sqrt[-((1 - x)/x)]])/((1/x)^(3/2)*(1 + x)^(3/2))}
{E^ArcCoth[x]/(1 + x)^(3/2), x, 4, -((Sqrt[2]*(1 + 1/x)^(3/2)*ArcTan[(Sqrt[2]*Sqrt[1/x])/Sqrt[-((1 - x)/x)]])/((1/x)^(3/2)*(1 + x)^(3/2)))}

{(E^ArcCoth[x]*x)/(1 - x)^(3/2), x, 6, (5*(1 - 1/x)^(3/2)*Sqrt[1 + 1/x]*x^2)/(2*(1 - x)^(3/2)) - (Sqrt[1 - 1/x]*(1 + 1/x)^(3/2)*x^2)/(2*(1 - x)^(3/2)) - (5*(1 - 1/x)^(3/2)*ArcTanh[(Sqrt[2]*Sqrt[1/x])/Sqrt[1 + 1/x]])/(Sqrt[2]*(1 - x)^(3/2)*(1/x)^(3/2))}
{E^ArcCoth[x]/(1 - x)^(3/2), x, 5, -((Sqrt[1 - x^(-1)]*Sqrt[1 + x^(-1)]*x)/(1 - x)^(3/2)) - ((1 - x^(-1))^(3/2)*ArcTanh[(Sqrt[2]*Sqrt[x^(-1)])/Sqrt[1 + x^(-1)]])/(Sqrt[2]*(1 - x)^(3/2)*(x^(-1))^(3/2))}


(* ::Subsubsection::Closed:: *)
(*n<0*)


{(x^m*Sqrt[c - a*c*x])/E^ArcCoth[a*x], x, 4, If[$VersionNumber>=8, (2*Sqrt[1 + 1/(a*x)]*x^(1 + m)*Sqrt[c - a*c*x])/((3 + 2*m)*Sqrt[1 - 1/(a*x)]) - (2*(5 + 4*m)*x^m*Sqrt[c - a*c*x]*Hypergeometric2F1[1/2, -(1/2) - m, 1/2 - m, -(1/(a*x))])/(a*(1 + 2*m)*(3 + 2*m)*Sqrt[1 - 1/(a*x)]), (2*Sqrt[1 + 1/(a*x)]*x^(1 + m)*Sqrt[c - a*c*x])/((3 + 2*m)*Sqrt[1 - 1/(a*x)]) - (2*(5 + 4*m)*x^m*Sqrt[c - a*c*x]*Hypergeometric2F1[1/2, -(1/2) - m, 1/2 - m, -(1/(a*x))])/(a*(3 + 8*m + 4*m^2)*Sqrt[1 - 1/(a*x)])]}

{(x^2*Sqrt[c - a*c*x])/E^ArcCoth[a*x], x, 6, (152*c*Sqrt[1 - 1/(a^2*x^2)]*x)/(105*a^2*Sqrt[c - a*c*x]) + (38*Sqrt[1 - 1/(a^2*x^2)]*x*Sqrt[c - a*c*x])/(105*a^2) + (6*Sqrt[1 - 1/(a^2*x^2)]*x*(c - a*c*x)^(3/2))/(35*a^2*c) - (2*Sqrt[1 - 1/(a^2*x^2)]*x^2*(c - a*c*x)^(3/2))/(7*a*c), -((208*Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(105*a^3*Sqrt[1 - 1/(a*x)])) + (104*Sqrt[1 + 1/(a*x)]*x*Sqrt[c - a*c*x])/(105*a^2*Sqrt[1 - 1/(a*x)]) - (26*Sqrt[1 + 1/(a*x)]*x^2*Sqrt[c - a*c*x])/(35*a*Sqrt[1 - 1/(a*x)]) + (2*Sqrt[1 + 1/(a*x)]*x^3*Sqrt[c - a*c*x])/(7*Sqrt[1 - 1/(a*x)])}
{(x*Sqrt[c - a*c*x])/E^ArcCoth[a*x], x, 5, -((8*c*Sqrt[1 - 1/(a^2*x^2)]*x)/(5*a*Sqrt[c - a*c*x])) - (2*Sqrt[1 - 1/(a^2*x^2)]*x*Sqrt[c - a*c*x])/(5*a) - (2*Sqrt[1 - 1/(a^2*x^2)]*x*(c - a*c*x)^(3/2))/(5*a*c), (12*Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(5*a^2*Sqrt[1 - 1/(a*x)]) - (6*Sqrt[1 + 1/(a*x)]*x*Sqrt[c - a*c*x])/(5*a*Sqrt[1 - 1/(a*x)]) + (2*Sqrt[1 + 1/(a*x)]*x^2*Sqrt[c - a*c*x])/(5*Sqrt[1 - 1/(a*x)])}
{Sqrt[c - a*c*x]/E^ArcCoth[a*x], x, 4, (8*c*Sqrt[1 - 1/(a^2*x^2)]*x)/(3*Sqrt[c - a*c*x]) + (2/3)*Sqrt[1 - 1/(a^2*x^2)]*x*Sqrt[c - a*c*x], -((10*Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(3*a*Sqrt[1 - 1/(a*x)])) + (2*Sqrt[1 + 1/(a*x)]*x*Sqrt[c - a*c*x])/(3*Sqrt[1 - 1/(a*x)])}
{Sqrt[c - a*c*x]/(E^ArcCoth[a*x]*x), x, 5, (2*Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/Sqrt[1 - 1/(a*x)] + (2*Sqrt[x^(-1)]*Sqrt[c - a*c*x]*ArcSinh[Sqrt[x^(-1)]/Sqrt[a]])/(Sqrt[a]*Sqrt[1 - 1/(a*x)])}
{Sqrt[c - a*c*x]/(E^ArcCoth[a*x]*x^2), x, 5, (Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(Sqrt[1 - 1/(a*x)]*x) - (3*Sqrt[a]*Sqrt[x^(-1)]*Sqrt[c - a*c*x]*ArcSinh[Sqrt[x^(-1)]/Sqrt[a]])/Sqrt[1 - 1/(a*x)]}


{(x^3*Sqrt[c - a*c*x])/E^(2*ArcCoth[a*x]), x, 9, (4*Sqrt[c - a*c*x])/a^4 + (2*(c - a*c*x)^(3/2))/(3*a^4*c) + (2*(c - a*c*x)^(5/2))/(5*a^4*c^2) - (2*(c - a*c*x)^(7/2))/(7*a^4*c^3) + (2*(c - a*c*x)^(9/2))/(9*a^4*c^4) - (4*Sqrt[2]*Sqrt[c]*ArcTanh[Sqrt[c - a*c*x]/(Sqrt[2]*Sqrt[c])])/a^4}
{(x^2*Sqrt[c - a*c*x])/E^(2*ArcCoth[a*x]), x, 9, -((4*Sqrt[c - a*c*x])/a^3) - (2*(c - a*c*x)^(3/2))/(3*a^3*c) - (2*(c - a*c*x)^(7/2))/(7*a^3*c^3) + (4*Sqrt[2]*Sqrt[c]*ArcTanh[Sqrt[c - a*c*x]/(Sqrt[2]*Sqrt[c])])/a^3}
{(x*Sqrt[c - a*c*x])/E^(2*ArcCoth[a*x]), x, 8, (4*Sqrt[c - a*c*x])/a^2 + (2*(c - a*c*x)^(3/2))/(3*a^2*c) + (2*(c - a*c*x)^(5/2))/(5*a^2*c^2) - (4*Sqrt[2]*Sqrt[c]*ArcTanh[Sqrt[c - a*c*x]/(Sqrt[2]*Sqrt[c])])/a^2}
{Sqrt[c - a*c*x]/E^(2*ArcCoth[a*x]), x, 7, -((4*Sqrt[c - a*c*x])/a) - (2*(c - a*c*x)^(3/2))/(3*a*c) + (4*Sqrt[2]*Sqrt[c]*ArcTanh[Sqrt[c - a*c*x]/(Sqrt[2]*Sqrt[c])])/a}
{Sqrt[c - a*c*x]/(E^(2*ArcCoth[a*x])*x), x, 9, 2*Sqrt[c - a*c*x] + 2*Sqrt[c]*ArcTanh[Sqrt[c - a*c*x]/Sqrt[c]] - 4*Sqrt[2]*Sqrt[c]*ArcTanh[Sqrt[c - a*c*x]/(Sqrt[2]*Sqrt[c])]}
{Sqrt[c - a*c*x]/(E^(2*ArcCoth[a*x])*x^2), x, 9, Sqrt[c - a*c*x]/x - 5*a*Sqrt[c]*ArcTanh[Sqrt[c - a*c*x]/Sqrt[c]] + 4*Sqrt[2]*a*Sqrt[c]*ArcTanh[Sqrt[c - a*c*x]/(Sqrt[2]*Sqrt[c])]}
{Sqrt[c - a*c*x]/(E^(2*ArcCoth[a*x])*x^3), x, 10, Sqrt[c - a*c*x]/(2*x^2) - (9*a*Sqrt[c - a*c*x])/(4*x) + (23/4)*a^2*Sqrt[c]*ArcTanh[Sqrt[c - a*c*x]/Sqrt[c]] - 4*Sqrt[2]*a^2*Sqrt[c]*ArcTanh[Sqrt[c - a*c*x]/(Sqrt[2]*Sqrt[c])]}
{Sqrt[c - a*c*x]/(E^(2*ArcCoth[a*x])*x^4), x, 11, Sqrt[c - a*c*x]/(3*x^3) - (13*a*Sqrt[c - a*c*x])/(12*x^2) + (19*a^2*Sqrt[c - a*c*x])/(8*x) - (45/8)*a^3*Sqrt[c]*ArcTanh[Sqrt[c - a*c*x]/Sqrt[c]] + 4*Sqrt[2]*a^3*Sqrt[c]*ArcTanh[Sqrt[c - a*c*x]/(Sqrt[2]*Sqrt[c])]}
{Sqrt[c - a*c*x]/(E^(2*ArcCoth[a*x])*x^5), x, 12, Sqrt[c - a*c*x]/(4*x^4) - (17*a*Sqrt[c - a*c*x])/(24*x^3) + (107*a^2*Sqrt[c - a*c*x])/(96*x^2) - (149*a^3*Sqrt[c - a*c*x])/(64*x) + (363/64)*a^4*Sqrt[c]*ArcTanh[Sqrt[c - a*c*x]/Sqrt[c]] - 4*Sqrt[2]*a^4*Sqrt[c]*ArcTanh[Sqrt[c - a*c*x]/(Sqrt[2]*Sqrt[c])]}


{(x^3*Sqrt[c - a*c*x])/E^(3*ArcCoth[a*x]), x, 8, (1312*Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(45*a^4*Sqrt[1 - 1/(a*x)]) - (656*Sqrt[1 + 1/(a*x)]*x*Sqrt[c - a*c*x])/(45*a^3*Sqrt[1 - 1/(a*x)]) - (82*x^2*Sqrt[c - a*c*x])/(9*a^2*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]) + (164*Sqrt[1 + 1/(a*x)]*x^2*Sqrt[c - a*c*x])/(15*a^2*Sqrt[1 - 1/(a*x)]) - (8*x^3*Sqrt[c - a*c*x])/(9*a*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]) + (2*x^4*Sqrt[c - a*c*x])/(9*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])}
{(x^2*Sqrt[c - a*c*x])/E^(3*ArcCoth[a*x]), x, 7, -((2672*Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(105*a^3*Sqrt[1 - 1/(a*x)])) - (334*x*Sqrt[c - a*c*x])/(35*a^2*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]) + (1336*Sqrt[1 + 1/(a*x)]*x*Sqrt[c - a*c*x])/(105*a^2*Sqrt[1 - 1/(a*x)]) - (44*x^2*Sqrt[c - a*c*x])/(35*a*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]) + (2*x^3*Sqrt[c - a*c*x])/(7*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])}
{(x^1*Sqrt[c - a*c*x])/E^(3*ArcCoth[a*x]), x, 6, -((158*Sqrt[c - a*c*x])/(15*a^2*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])) + (316*Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(15*a^2*Sqrt[1 - 1/(a*x)]) - (32*x*Sqrt[c - a*c*x])/(15*a*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]) + (2*x^2*Sqrt[c - a*c*x])/(5*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])}
{Sqrt[c - a*c*x]/E^(3*ArcCoth[a*x]), x, 5, -((20*Sqrt[c - a*c*x])/(3*a*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])) - (46*Sqrt[c - a*c*x])/(3*a^2*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x) + (2*x*Sqrt[c - a*c*x])/(3*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])}
{Sqrt[c - a*c*x]/(E^(3*ArcCoth[a*x])*x^1), x, 6, (2*Sqrt[c - a*c*x])/(Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]) + (10*Sqrt[c - a*c*x])/(a*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x) - (2*Sqrt[x^(-1)]*Sqrt[c - a*c*x]*ArcSinh[Sqrt[x^(-1)]/Sqrt[a]])/(Sqrt[a]*Sqrt[1 - 1/(a*x)])}
{Sqrt[c - a*c*x]/(E^(3*ArcCoth[a*x])*x^2), x, 6, (-8*Sqrt[c - a*c*x])/(Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x) - (Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(Sqrt[1 - 1/(a*x)]*x) + (7*Sqrt[a]*Sqrt[x^(-1)]*Sqrt[c - a*c*x]*ArcSinh[Sqrt[x^(-1)]/Sqrt[a]])/Sqrt[1 - 1/(a*x)]}
{Sqrt[c - a*c*x]/(E^(3*ArcCoth[a*x])*x^3), x, 7, (-8*Sqrt[c - a*c*x])/(Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x^2) - (Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(2*Sqrt[1 - 1/(a*x)]*x^2) + (47*a*Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(4*Sqrt[1 - 1/(a*x)]*x) - (47*a^(3/2)*Sqrt[x^(-1)]*Sqrt[c - a*c*x]*ArcSinh[Sqrt[x^(-1)]/Sqrt[a]])/(4*Sqrt[1 - 1/(a*x)])}
{Sqrt[c - a*c*x]/(E^(3*ArcCoth[a*x])*x^4), x, 8, (-8*Sqrt[c - a*c*x])/(Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x^3) - (Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(3*Sqrt[1 - 1/(a*x)]*x^3) + (119*a*Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(12*Sqrt[1 - 1/(a*x)]*x^2) - (119*a^2*Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(8*Sqrt[1 - 1/(a*x)]*x) + (119*a^(5/2)*Sqrt[x^(-1)]*Sqrt[c - a*c*x]*ArcSinh[Sqrt[x^(-1)]/Sqrt[a]])/(8*Sqrt[1 - 1/(a*x)])}
{Sqrt[c - a*c*x]/(E^(3*ArcCoth[a*x])*x^5), x, 9, (-8*Sqrt[c - a*c*x])/(Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x^4) - (Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(4*Sqrt[1 - 1/(a*x)]*x^4) + (223*a*Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(24*Sqrt[1 - 1/(a*x)]*x^3) - (1115*a^2*Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(96*Sqrt[1 - 1/(a*x)]*x^2) + (1115*a^3*Sqrt[1 + 1/(a*x)]*Sqrt[c - a*c*x])/(64*Sqrt[1 - 1/(a*x)]*x) - (1115*a^(7/2)*Sqrt[x^(-1)]*Sqrt[c - a*c*x]*ArcSinh[Sqrt[x^(-1)]/Sqrt[a]])/(64*Sqrt[1 - 1/(a*x)])}


(* ::Subsection::Closed:: *)
(*Integrands of the form E^(n ArcCoth[a x])  (c-c a x)^p with n symbolic*)


{E^(n*ArcCoth[a*x])*(c - a*c*x)^(n/2 + 2), x, 6, -(((56 + 14*n + n^2)*(1 - 1/(a*x))^(-2 - n/2)*(1 + 1/(a*x))^((2 + n)/2)*(c - a*c*x)^((4 + n)/2))/(a*(4 + n)*(6 + n))) + (2*(56 + 14*n + n^2)*(1 - 1/(a*x))^(-2 - n/2)*(1 + 1/(a*x))^((2 + n)/2)*(c - a*c*x)^((4 + n)/2))/(a^2*(6 + n)*(8 + 6*n + n^2)*x) + ((8 + n)*(1 - 1/(a*x))^(-2 - n/2)*(1 + 1/(a*x))^((2 + n)/2)*x*(c - a*c*x)^((4 + n)/2))/(6 + n) - ((a - 1/x)*(1 - 1/(a*x))^(-2 - n/2)*(1 + 1/(a*x))^((2 + n)/2)*x*(c - a*c*x)^((4 + n)/2))/a}
{E^(n*ArcCoth[a*x])*(c - a*c*x)^(n/2 + 1), x, 4, If[$VersionNumber>=8, -((2*(6 + n)*(1 - 1/(a*x))^(-1 - n/2)*(1 + 1/(a*x))^((2 + n)/2)*(c - a*c*x)^((2 + n)/2))/(a*(2 + n)*(4 + n))) + (2*(1 - 1/(a*x))^(-1 - n/2)*(1 + 1/(a*x))^((2 + n)/2)*x*(c - a*c*x)^((2 + n)/2))/(4 + n), -((2*(6 + n)*(1 - 1/(a*x))^(-1 - n/2)*(1 + 1/(a*x))^((2 + n)/2)*(c - a*c*x)^((2 + n)/2))/(a*(8 + 6*n + n^2))) + (2*(1 - 1/(a*x))^(-1 - n/2)*(1 + 1/(a*x))^((2 + n)/2)*x*(c - a*c*x)^((2 + n)/2))/(4 + n)]}
{E^(n*ArcCoth[a*x])*(c - a*c*x)^(n/2 + 0), x, 1, (2*E^(n*ArcCoth[a*x])*(1 + a*x)*(c - a*c*x)^(n/2))/(a*(2 + n))}
{E^(n*ArcCoth[a*x])*(c - a*c*x)^(n/2 - 1), x, 3, (2*(1 - 1/(a*x))^(1 - n/2)*(1 + 1/(a*x))^(n/2)*x*(c - a*c*x)^((1/2)*(-2 + n))*Hypergeometric2F1[1, -(n/2), 1 - n/2, 2/((a + 1/x)*x)])/n}
{E^(n*ArcCoth[a*x])*(c - a*c*x)^(n/2 - 2), x, 3, -((2*(1 - 1/(a*x))^(2 - n/2)*(1 + 1/(a*x))^((1/2)*(-2 + n))*x*(c - a*c*x)^((1/2)*(-4 + n))*Hypergeometric2F1[2, 1 - n/2, 2 - n/2, 2/((a + 1/x)*x)])/(2 - n))}


{E^(n*ArcCoth[a*x])*(c - a*c*x)^p, x, 3, (((a - 1/x)/(a + 1/x))^((1/2)*(n - 2*p))*(1 + 1/(a*x))^((2 + n)/2)*x*(c - a*c*x)^p*Hypergeometric2F1[(1/2)*(n - 2*p), -1 - p, -p, 2/((a + 1/x)*x)])/((1 - 1/(a*x))^(n/2)*(1 + p))}

{E^(n*ArcCoth[a*x])*(c - a*c*x)^3, x, 3, -((32*c^3*(1 - 1/(a*x))^(4 - n/2)*(1 + 1/(a*x))^((1/2)*(-8 + n))*Hypergeometric2F1[5, 4 - n/2, 5 - n/2, (a - 1/x)/(a + 1/x)])/(a*(8 - n)))}
{E^(n*ArcCoth[a*x])*(c - a*c*x)^2, x, 3, (16*c^2*(1 - 1/(a*x))^(3 - n/2)*(1 + 1/(a*x))^((1/2)*(-6 + n))*Hypergeometric2F1[4, 3 - n/2, 4 - n/2, (a - 1/x)/(a + 1/x)])/(a*(6 - n))}
{E^(n*ArcCoth[a*x])*(c - a*c*x)^1, x, 3, -((8*c*(1 - 1/(a*x))^(2 - n/2)*(1 + 1/(a*x))^((1/2)*(-4 + n))*Hypergeometric2F1[3, 2 - n/2, 3 - n/2, (a - 1/x)/(a + 1/x)])/(a*(4 - n)))}
{E^(n*ArcCoth[a*x])/(c - a*c*x)^1, x, 3, (2*(1 + 1/(a*x))^(n/2)*Hypergeometric2F1[1, -(n/2), 1 - n/2, (a - 1/x)/(a + 1/x)])/((1 - 1/(a*x))^(n/2)*(a*c*n))}
{E^(n*ArcCoth[a*x])/(c - a*c*x)^2, x, 3, -(((1 - 1/(a*x))^(-1 - n/2)*(1 + 1/(a*x))^((2 + n)/2))/(a*c^2*(2 + n)))}
{E^(n*ArcCoth[a*x])/(c - a*c*x)^3, x, 4, If[$VersionNumber>=8, ((1 - 1/(a*x))^(-2 - n/2)*(1 + 1/(a*x))^((2 + n)/2))/(a*c^3*(4 + n)) - ((3 + n)*(1 - 1/(a*x))^(-1 - n/2)*(1 + 1/(a*x))^((2 + n)/2))/(a*c^3*(2 + n)*(4 + n)), -(((3 + n)*(1 - 1/(a*x))^((1/2)*(-2 - n))*(1 + 1/(a*x))^((2 + n)/2))/(a*c^3*(8 + 6*n + n^2))) + ((1 - 1/(a*x))^(-2 - n/2)*(1 + 1/(a*x))^((2 + n)/2))/(a*c^3*(4 + n))]}
{E^(n*ArcCoth[a*x])/(c - a*c*x)^4, x, 6, If[$VersionNumber>=8, ((5 + n)*(1 - 1/(a*x))^(-3 - n/2)*(1 + 1/(a*x))^((2 + n)/2))/(a*c^4*(6 + n)) - ((14 + 8*n + n^2)*(1 - 1/(a*x))^(-2 - n/2)*(1 + 1/(a*x))^((2 + n)/2))/(a*c^4*(4 + n)*(6 + n)) - ((14 + 8*n + n^2)*(1 - 1/(a*x))^(-1 - n/2)*(1 + 1/(a*x))^((2 + n)/2))/(a*c^4*(6 + n)*(8 + 6*n + n^2)) - ((1 - 1/(a*x))^(-3 - n/2)*(1 + 1/(a*x))^((2 + n)/2))/(a^2*c^4*x), -(((14 + 8*n + n^2)*(1 - 1/(a*x))^((1/2)*(-4 - n))*(1 + 1/(a*x))^((2 + n)/2))/(a*c^4*(24 + 10*n + n^2))) - ((14 + 8*n + n^2)*(1 - 1/(a*x))^((1/2)*(-2 - n))*(1 + 1/(a*x))^((2 + n)/2))/(a*c^4*(48 + 44*n + 12*n^2 + n^3)) + ((5 + n)*(1 - 1/(a*x))^(-3 - n/2)*(1 + 1/(a*x))^((2 + n)/2))/(a*c^4*(6 + n)) - ((1 - 1/(a*x))^(-3 - n/2)*(1 + 1/(a*x))^((2 + n)/2))/(a^2*c^4*x)]}


{E^(n*ArcCoth[a*x])*(c - a*c*x)^(5/2), x, 3, ((2/7)*((a - 1/x)/(a + 1/x))^((1/2)*(-5 + n))*(1 + 1/(a*x))^((2 + n)/2)*x*(c - a*c*x)^(5/2)*Hypergeometric2F1[-(7/2), (1/2)*(-5 + n), -(5/2), 2/((a + 1/x)*x)])/(1 - 1/(a*x))^(n/2)}
{E^(n*ArcCoth[a*x])*(c - a*c*x)^(3/2), x, 3, ((2/5)*((a - 1/x)/(a + 1/x))^((1/2)*(-3 + n))*(1 + 1/(a*x))^((2 + n)/2)*x*(c - a*c*x)^(3/2)*Hypergeometric2F1[-(5/2), (1/2)*(-3 + n), -(3/2), 2/((a + 1/x)*x)])/(1 - 1/(a*x))^(n/2)}
{E^(n*ArcCoth[a*x])*(c - a*c*x)^(1/2), x, 3, ((2/3)*((a - 1/x)/(a + 1/x))^((1/2)*(-1 + n))*(1 + 1/(a*x))^((2 + n)/2)*x*Sqrt[c - a*c*x]*Hypergeometric2F1[-(3/2), (1/2)*(-1 + n), -(1/2), 2/((a + 1/x)*x)])/(1 - 1/(a*x))^(n/2)}
{E^(n*ArcCoth[a*x])/(c - a*c*x)^(1/2), x, 3, (2*((a - 1/x)/(a + 1/x))^((1 + n)/2)*(1 + 1/(a*x))^((2 + n)/2)*x*Hypergeometric2F1[-(1/2), (1 + n)/2, 1/2, 2/((a + 1/x)*x)])/((1 - 1/(a*x))^(n/2)*Sqrt[c - a*c*x])}
{E^(n*ArcCoth[a*x])/(c - a*c*x)^(3/2), x, 3, -((2*((a - 1/x)/(a + 1/x))^((3 + n)/2)*(1 + 1/(a*x))^((2 + n)/2)*x*Hypergeometric2F1[1/2, (3 + n)/2, 3/2, 2/((a + 1/x)*x)])/((1 - 1/(a*x))^(n/2)*(c - a*c*x)^(3/2)))}
{E^(n*ArcCoth[a*x])/(c - a*c*x)^(5/2), x, 4, -((a*(1 - 1/(a*x))^((2 - n)/2)*(1 + 1/(a*x))^((2 + n)/2)*x^2)/((3 + n)*(c - a*c*x)^(5/2))) + (a*((a - 1/x)/(a + 1/x))^((3 + n)/2)*(1 - 1/(a*x))^((2 - n)/2)*(1 + 1/(a*x))^((2 + n)/2)*x^2*Hypergeometric2F1[1/2, (3 + n)/2, 3/2, 2/((a + 1/x)*x)])/((3 + n)*(c - a*c*x)^(5/2))}
{E^(n*ArcCoth[a*x])/(c - a*c*x)^(7/2), x, 5, -((a*(1 - 1/(a*x))^((2 - n)/2)*(1 + 1/(a*x))^((2 + n)/2)*x^2)/((5 + n)*(c - a*c*x)^(7/2))) + (3*a^2*(1 - 1/(a*x))^((4 - n)/2)*(1 + 1/(a*x))^((2 + n)/2)*x^3)/(2*(15 + 8*n + n^2)*(c - a*c*x)^(7/2)) - (3*a^2*((a - 1/x)/(a + 1/x))^((3 + n)/2)*(1 - 1/(a*x))^((4 - n)/2)*(1 + 1/(a*x))^((2 + n)/2)*x^3*Hypergeometric2F1[1/2, (3 + n)/2, 3/2, 2/((a + 1/x)*x)])/(2*(15 + 8*n + n^2)*(c - a*c*x)^(7/2))}


(* ::Section::Closed:: *)
(*Integrands of the form u E^(n ArcCoth[a x]) (c-c/(a x))^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form E^(n ArcCoth[a x]) (c-c/(a x))^p*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{E^ArcCoth[a*x]*(c - c/(a*x))^4, x, 9, -((c^4*(1 - 1/(a^2*x^2))^(3/2))/(3*a)) + (c^4*Sqrt[1 - 1/(a^2*x^2)]*(6*a - 1/x))/(2*a^2) + c^4*(1 - 1/(a^2*x^2))^(3/2)*x - (c^4*ArcCsc[a*x])/(2*a) - (3*c^4*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/a}
{E^ArcCoth[a*x]*(c - c/(a*x))^3, x, 8, (c^3*Sqrt[1 - 1/(a^2*x^2)]*(4*a + 1/x))/(2*a^2) + c^3*(1 - 1/(a^2*x^2))^(3/2)*x + (c^3*ArcCsc[a*x])/(2*a) - (2*c^3*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/a}
{E^ArcCoth[a*x]*(c - c/(a*x))^2, x, 7, (c^2*Sqrt[1 - 1/(a^2*x^2)]*(a + 1/x)*x)/a + (c^2*ArcCsc[a*x])/a - (c^2*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/a}
{E^ArcCoth[a*x]*(c - c/(a*x)), x, 3, c*Sqrt[1 - 1/(a^2*x^2)]*x + (c*ArcCsc[a*x])/a}
{E^ArcCoth[a*x]/(c - c/(a*x)), x, 7, -((2*(a + 1/x))/(a^2*c*Sqrt[1 - 1/(a^2*x^2)])) + (Sqrt[1 - 1/(a^2*x^2)]*x)/c + (2*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(a*c)}
{E^ArcCoth[a*x]/(c - c/(a*x))^2, x, 8, -((4*(a + 1/x))/(3*a^2*c^2*(1 - 1/(a^2*x^2))^(3/2))) - (9*a + 11/x)/(3*a^2*c^2*Sqrt[1 - 1/(a^2*x^2)]) + (Sqrt[1 - 1/(a^2*x^2)]*x)/c^2 + (3*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(a*c^2)}
{E^ArcCoth[a*x]/(c - c/(a*x))^3, x, 9, -((8*(a + 1/x))/(5*a^2*c^3*(1 - 1/(a^2*x^2))^(5/2))) - (4*(5*a + 8/x))/(15*a^2*c^3*(1 - 1/(a^2*x^2))^(3/2)) - (60*a + 79/x)/(15*a^2*c^3*Sqrt[1 - 1/(a^2*x^2)]) + (Sqrt[1 - 1/(a^2*x^2)]*x)/c^3 + (4*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(a*c^3)}
{E^ArcCoth[a*x]/(c - c/(a*x))^4, x, 10, -((16*(a + 1/x))/(7*a^2*c^4*(1 - 1/(a^2*x^2))^(7/2))) - (4*(7*a + 17/x))/(35*a^2*c^4*(1 - 1/(a^2*x^2))^(5/2)) - (175*a + 307/x)/(105*a^2*c^4*(1 - 1/(a^2*x^2))^(3/2)) - (525*a + 719/x)/(105*a^2*c^4*Sqrt[1 - 1/(a^2*x^2)]) + (Sqrt[1 - 1/(a^2*x^2)]*x)/c^4 + (5*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(a*c^4)}


{E^(2*ArcCoth[a*x])*(c - c/(a*x))^5, x, 5, -c^5/(4*a^5*x^4) + c^5/(a^4*x^3) - c^5/(a^3*x^2) - (2*c^5)/(a^2*x) + c^5*x - (3*c^5*Log[x])/a}
{E^(2*ArcCoth[a*x])*(c - c/(a*x))^4, x, 5, c^4/(3*a^4*x^3) - c^4/(a^3*x^2) + c^4*x - (2*c^4*Log[x])/a}
{E^(2*ArcCoth[a*x])*(c - c/(a*x))^3, x, 5, -c^3/(2*a^3*x^2) + c^3/(a^2*x) + c^3*x - (c^3*Log[x])/a}
{E^(2*ArcCoth[a*x])*(c - c/(a*x))^2, x, 6, c^2/(a^2*x) + c^2*x}
{E^(2*ArcCoth[a*x])*(c - c/(a*x)), x, 5, c*x + (c*Log[x])/a}
{E^(2*ArcCoth[a*x])/(c - c/(a*x)), x, 5, x/c + 2/(a*c*(1 - a*x)) + (3*Log[1 - a*x])/(a*c)}
{E^(2*ArcCoth[a*x])/(c - c/(a*x))^2, x, 5, x/c^2 - 1/(a*c^2*(1 - a*x)^2) + 5/(a*c^2*(1 - a*x)) + (4*Log[1 - a*x])/(a*c^2)}
{E^(2*ArcCoth[a*x])/(c - c/(a*x))^3, x, 5, x/c^3 + 2/(3*a*c^3*(1 - a*x)^3) - 7/(2*a*c^3*(1 - a*x)^2) + 9/(a*c^3*(1 - a*x)) + (5*Log[1 - a*x])/(a*c^3)}
{E^(2*ArcCoth[a*x])/(c - c/(a*x))^4, x, 5, x/c^4 - 1/(2*a*c^4*(1 - a*x)^4) + 3/(a*c^4*(1 - a*x)^3) - 8/(a*c^4*(1 - a*x)^2) + 14/(a*c^4*(1 - a*x)) + (6*Log[1 - a*x])/(a*c^4)}


{E^(3*ArcCoth[a*x])*(c - c/(a*x))^4, x, 8, (c^4*Sqrt[1 - 1/(a^2*x^2)]*(2*a + 3/x))/(2*a^2) + (c^4*(1 - 1/(a^2*x^2))^(3/2)*(3*a + 1/x)*x)/(3*a) + (3*c^4*ArcCsc[a*x])/(2*a) - (c^4*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/a}
{E^(3*ArcCoth[a*x])*(c - c/(a*x))^3, x, 4, (3*c^3*Sqrt[1 - 1/(a^2*x^2)])/(2*a^2*x) + c^3*(1 - 1/(a^2*x^2))^(3/2)*x + (3*c^3*ArcCsc[a*x])/(2*a)}
{E^(3*ArcCoth[a*x])*(c - c/(a*x))^2, x, 8, (c^2*Sqrt[1 - 1/(a^2*x^2)]*(a - 1/x)*x)/a + (c^2*ArcCsc[a*x])/a + (c^2*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/a}
{E^(3*ArcCoth[a*x])*(c - c/(a*x)), x, 8, c*Sqrt[1 - 1/(a^2*x^2)]*x - (c*ArcCsc[a*x])/a + (2*c*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/a}
{E^(3*ArcCoth[a*x])/(c - c/(a*x)), x, 8, -((8*(a + 1/x))/(3*a^2*c*(1 - 1/(a^2*x^2))^(3/2))) - (4*(3*a + 4/x))/(3*a^2*c*Sqrt[1 - 1/(a^2*x^2)]) + (Sqrt[1 - 1/(a^2*x^2)]*x)/c + (4*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(a*c)}
{E^(3*ArcCoth[a*x])/(c - c/(a*x))^2, x, 9, -((16*(a + 1/x))/(5*a^2*c^2*(1 - 1/(a^2*x^2))^(5/2))) - (4*(5*a + 11/x))/(15*a^2*c^2*(1 - 1/(a^2*x^2))^(3/2)) - (75*a + 103/x)/(15*a^2*c^2*Sqrt[1 - 1/(a^2*x^2)]) + (Sqrt[1 - 1/(a^2*x^2)]*x)/c^2 + (5*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(a*c^2)}
{E^(3*ArcCoth[a*x])/(c - c/(a*x))^3, x, 10, -((32*(a + 1/x))/(7*a^2*c^3*(1 - 1/(a^2*x^2))^(7/2))) - (2*(7*a + 13/x))/(7*a^2*c^3*(1 - 1/(a^2*x^2))^(3/2)) - (42*a + 59/x)/(7*a^2*c^3*Sqrt[1 - 1/(a^2*x^2)]) - 16/(7*a^2*c^3*(1 - 1/(a^2*x^2))^(5/2)*x) + (Sqrt[1 - 1/(a^2*x^2)]*x)/c^3 + (6*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(a*c^3)}
{E^(3*ArcCoth[a*x])/(c - c/(a*x))^4, x, 11, (16*(9*a - 5/x))/(63*a^2*c^4*(1 - 1/(a^2*x^2))^(7/2)) - (64*(a + 1/x))/(9*a^2*c^4*(1 - 1/(a^2*x^2))^(9/2)) - (8*(21*a + 41/x))/(105*a^2*c^4*(1 - 1/(a^2*x^2))^(5/2)) - (735*a + 1417/x)/(315*a^2*c^4*(1 - 1/(a^2*x^2))^(3/2)) - (2205*a + 3149/x)/(315*a^2*c^4*Sqrt[1 - 1/(a^2*x^2)]) + (Sqrt[1 - 1/(a^2*x^2)]*x)/c^4 + (7*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(a*c^4)}


{E^(4*ArcCoth[a*x])*(c - c/(a*x))^5, x, 5, c^5/(4*a^5*x^4) - c^5/(3*a^4*x^3) - c^5/(a^3*x^2) + (2*c^5)/(a^2*x) + c^5*x - (c^5*Log[x])/a}
{E^(4*ArcCoth[a*x])*(c - c/(a*x))^4, x, 6, -c^4/(3*a^4*x^3) + (2*c^4)/(a^2*x) + c^4*x}
{E^(4*ArcCoth[a*x])*(c - c/(a*x))^3, x, 5, c^3/(2*a^3*x^2) + c^3/(a^2*x) + c^3*x + (c^3*Log[x])/a}
{E^(4*ArcCoth[a*x])*(c - c/(a*x))^2, x, 5, -(c^2/(a^2*x)) + c^2*x + (2*c^2*Log[x])/a}
{E^(4*ArcCoth[a*x])*(c - c/(a*x)), x, 5, c*x - (c*Log[x])/a + (4*c*Log[1 - a*x])/a}
{E^(4*ArcCoth[a*x])/(c - c/(a*x)), x, 5, x/c - 2/(a*c*(1 - a*x)^2) + 8/(a*c*(1 - a*x)) + (5*Log[1 - a*x])/(a*c)}
{E^(4*ArcCoth[a*x])/(c - c/(a*x))^2, x, 5, x/c^2 + 4/(3*a*c^2*(1 - a*x)^3) - 6/(a*c^2*(1 - a*x)^2) + 13/(a*c^2*(1 - a*x)) + (6*Log[1 - a*x])/(a*c^2)}
{E^(4*ArcCoth[a*x])/(c - c/(a*x))^3, x, 5, x/c^3 - 1/(a*c^3*(1 - a*x)^4) + 16/(3*a*c^3*(1 - a*x)^3) - 25/(2*a*c^3*(1 - a*x)^2) + 19/(a*c^3*(1 - a*x)) + (7*Log[1 - a*x])/(a*c^3)}
{E^(4*ArcCoth[a*x])/(c - c/(a*x))^4, x, 5, x/c^4 + 4/(5*a*c^4*(1 - a*x)^5) - 5/(a*c^4*(1 - a*x)^4) + 41/(3*a*c^4*(1 - a*x)^3) - 22/(a*c^4*(1 - a*x)^2) + 26/(a*c^4*(1 - a*x)) + (8*Log[1 - a*x])/(a*c^4)}


(* ::Subsubsection::Closed:: *)
(*n<0*)


{(c - c/(a*x))^4/E^ArcCoth[a*x], x, 10, -((32*c^4*Sqrt[1 - 1/(a^2*x^2)])/(3*a)) - (c^4*Sqrt[1 - 1/(a^2*x^2)])/(3*a^3*x^2) + (5*c^4*Sqrt[1 - 1/(a^2*x^2)])/(2*a^2*x) + c^4*Sqrt[1 - 1/(a^2*x^2)]*x - (25*c^4*ArcCsc[a*x])/(2*a) - (5*c^4*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/a}
{(c - c/(a*x))^3/E^ArcCoth[a*x], x, 9, -((4*c^3*Sqrt[1 - 1/(a^2*x^2)])/a) + (c^3*Sqrt[1 - 1/(a^2*x^2)])/(2*a^2*x) + c^3*Sqrt[1 - 1/(a^2*x^2)]*x - (13*c^3*ArcCsc[a*x])/(2*a) - (4*c^3*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/a}
{(c - c/(a*x))^2/E^ArcCoth[a*x], x, 8, -((c^2*Sqrt[1 - 1/(a^2*x^2)])/a) + c^2*Sqrt[1 - 1/(a^2*x^2)]*x - (3*c^2*ArcCsc[a*x])/a - (3*c^2*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/a}
{(c - c/(a*x))^1/E^ArcCoth[a*x], x, 7, c*Sqrt[1 - 1/(a^2*x^2)]*x - (c*ArcCsc[a*x])/a - (2*c*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/a}
{1/(E^ArcCoth[a*x]*(c - c/(a*x))^1), x, 2, (Sqrt[1 - 1/(a^2*x^2)]*x)/c}
{1/(E^ArcCoth[a*x]*(c - c/(a*x))^2), x, 6, (2*Sqrt[1 - 1/(a^2*x^2)]*x)/c^2 - (a*Sqrt[1 - 1/(a^2*x^2)]*x)/(c^2*(a - 1/x)) + ArcTanh[Sqrt[1 - 1/(a^2*x^2)]]/(a*c^2)}
{1/(E^ArcCoth[a*x]*(c - c/(a*x))^3), x, 8, -((2*(a + 1/x))/(3*a^2*c^3*(1 - 1/(a^2*x^2))^(3/2))) - (6*a + 7/x)/(3*a^2*c^3*Sqrt[1 - 1/(a^2*x^2)]) + (Sqrt[1 - 1/(a^2*x^2)]*x)/c^3 + (2*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(a*c^3)}
{1/(E^ArcCoth[a*x]*(c - c/(a*x))^4), x, 9, -((4*(a + 1/x))/(5*a^2*c^4*(1 - 1/(a^2*x^2))^(5/2))) - (5*a + 7/x)/(5*a^2*c^4*(1 - 1/(a^2*x^2))^(3/2)) - (15*a + 19/x)/(5*a^2*c^4*Sqrt[1 - 1/(a^2*x^2)]) + (Sqrt[1 - 1/(a^2*x^2)]*x)/c^4 + (3*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(a*c^4)}


{(c - c/(a*x))^4/E^(2*ArcCoth[a*x]), x, 5, c^4/(3*a^4*x^3) - (3*c^4)/(a^3*x^2) + (16*c^4)/(a^2*x) + c^4*x + (26*c^4*Log[x])/a - (32*c^4*Log[1 + a*x])/a}
{(c - c/(a*x))^3/E^(2*ArcCoth[a*x]), x, 5, -c^3/(2*a^3*x^2) + (5*c^3)/(a^2*x) + c^3*x + (11*c^3*Log[x])/a - (16*c^3*Log[1 + a*x])/a}
{(c - c/(a*x))^2/E^(2*ArcCoth[a*x]), x, 5, c^2/(a^2*x) + c^2*x + (4*c^2*Log[x])/a - (8*c^2*Log[1 + a*x])/a}
{(c - c/(a*x))^1/E^(2*ArcCoth[a*x]), x, 5, c*x + (c*Log[x])/a - (4*c*Log[1 + a*x])/a}
{1/(E^(2*ArcCoth[a*x])*(c - c/(a*x))^1), x, 5, x/c - Log[1 + a*x]/(a*c)}
{1/(E^(2*ArcCoth[a*x])*(c - c/(a*x))^2), x, 6, x/c^2 - ArcTanh[a*x]/(a*c^2)}
{1/(E^(2*ArcCoth[a*x])*(c - c/(a*x))^3), x, 5, x/c^3 + 1/(2*a*c^3*(1 - a*x)) + (5*Log[1 - a*x])/(4*a*c^3) - Log[1 + a*x]/(4*a*c^3)}
{1/(E^(2*ArcCoth[a*x])*(c - c/(a*x))^4), x, 5, x/c^4 - 1/(4*a*c^4*(1 - a*x)^2) + 7/(4*a*c^4*(1 - a*x)) + (17*Log[1 - a*x])/(8*a*c^4) - Log[1 + a*x]/(8*a*c^4)}


{(c - c/(a*x))^4/E^(3*ArcCoth[a*x]), x, 11, (68*c^4*Sqrt[1 - 1/(a^2*x^2)])/(3*a) + (64*c^4*(a - 1/x))/(a^2*Sqrt[1 - 1/(a^2*x^2)]) + (c^4*Sqrt[1 - 1/(a^2*x^2)])/(3*a^3*x^2) - (7*c^4*Sqrt[1 - 1/(a^2*x^2)])/(2*a^2*x) + c^4*Sqrt[1 - 1/(a^2*x^2)]*x + (91*c^4*ArcCsc[a*x])/(2*a) - (7*c^4*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/a}
{(c - c/(a*x))^3/E^(3*ArcCoth[a*x]), x, 10, (6*c^3*Sqrt[1 - 1/(a^2*x^2)])/a + (32*c^3*(a - 1/x))/(a^2*Sqrt[1 - 1/(a^2*x^2)]) - (c^3*Sqrt[1 - 1/(a^2*x^2)])/(2*a^2*x) + c^3*Sqrt[1 - 1/(a^2*x^2)]*x + (33*c^3*ArcCsc[a*x])/(2*a) - (6*c^3*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/a}
{(c - c/(a*x))^2/E^(3*ArcCoth[a*x]), x, 9, (c^2*Sqrt[1 - 1/(a^2*x^2)])/a + (16*c^2*(a - 1/x))/(a^2*Sqrt[1 - 1/(a^2*x^2)]) + c^2*Sqrt[1 - 1/(a^2*x^2)]*x + (5*c^2*ArcCsc[a*x])/a - (5*c^2*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/a}
{(c - c/(a*x))^1/E^(3*ArcCoth[a*x]), x, 8, (8*c*(a - 1/x))/(a^2*Sqrt[1 - 1/(a^2*x^2)]) + c*Sqrt[1 - 1/(a^2*x^2)]*x + (c*ArcCsc[a*x])/a - (4*c*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/a}
{1/(E^(3*ArcCoth[a*x])*(c - c/(a*x))^1), x, 6, (2*(a - 1/x))/(a^2*c*Sqrt[1 - 1/(a^2*x^2)]) + (Sqrt[1 - 1/(a^2*x^2)]*x)/c - (2*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(a*c)}
{1/(E^(3*ArcCoth[a*x])*(c - c/(a*x))^2), x, 6, (2*Sqrt[1 - 1/(a^2*x^2)]*x)/c^2 - ((a - 1/x)*x)/(a*c^2*Sqrt[1 - 1/(a^2*x^2)]) - ArcTanh[Sqrt[1 - 1/(a^2*x^2)]]/(a*c^2)}
{1/(E^(3*ArcCoth[a*x])*(c - c/(a*x))^3), x, 3, -(2/(a^2*c^3*Sqrt[1 - 1/(a^2*x^2)]*x)) + x/(c^3*Sqrt[1 - 1/(a^2*x^2)])}
{1/(E^(3*ArcCoth[a*x])*(c - c/(a*x))^4), x, 7, (8*Sqrt[1 - 1/(a^2*x^2)]*x)/(3*c^4) - (a*x)/(3*c^4*Sqrt[1 - 1/(a^2*x^2)]*(a - 1/x)) - ((4*a + 3/x)*x)/(3*a*c^4*Sqrt[1 - 1/(a^2*x^2)]) + ArcTanh[Sqrt[1 - 1/(a^2*x^2)]]/(a*c^4)}
{1/(E^(3*ArcCoth[a*x])*(c - c/(a*x))^5), x, 9, -((2*(a + 1/x))/(5*a^2*c^5*(1 - 1/(a^2*x^2))^(5/2))) - (10*a + 13/x)/(15*a^2*c^5*(1 - 1/(a^2*x^2))^(3/2)) - (30*a + 41/x)/(15*a^2*c^5*Sqrt[1 - 1/(a^2*x^2)]) + (Sqrt[1 - 1/(a^2*x^2)]*x)/c^5 + (2*ArcTanh[Sqrt[1 - 1/(a^2*x^2)]])/(a*c^5)}


(* ::Subsection::Closed:: *)
(*Integrands of the form E^(n ArcCoth[a x]) (c-c/(a x))^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{E^ArcCoth[a*x]*(c - c/(a*x))^(9/2), x, 8, (173*c^5*Sqrt[1 - 1/(a^2*x^2)])/(105*a*Sqrt[c - c/(a*x)]) + (227*c^4*Sqrt[1 - 1/(a^2*x^2)]*Sqrt[c - c/(a*x)])/(105*a) + (59*c^3*Sqrt[1 - 1/(a^2*x^2)]*(c - c/(a*x))^(3/2))/(35*a) + (9*c^2*Sqrt[1 - 1/(a^2*x^2)]*(c - c/(a*x))^(5/2))/(7*a) + c*Sqrt[1 - 1/(a^2*x^2)]*(c - c/(a*x))^(7/2)*x - (7*c^(9/2)*ArcTanh[(Sqrt[c]*Sqrt[1 - 1/(a^2*x^2)])/Sqrt[c - c/(a*x)]])/a, ((400*a - 227/x)*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(9/2))/(105*a^2*(1 - 1/(a*x))^(9/2)) + (59*(a - 1/x)^2*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(9/2))/(35*a^3*(1 - 1/(a*x))^(9/2)) + (9*(a - 1/x)^3*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(9/2))/(7*a^4*(1 - 1/(a*x))^(9/2)) + ((a - 1/x)^4*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(9/2)*x)/(a^4*(1 - 1/(a*x))^(9/2)) - (7*(c - c/(a*x))^(9/2)*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*(1 - 1/(a*x))^(9/2))}
{E^ArcCoth[a*x]*(c - c/(a*x))^(7/2), x, 7, (49*c^4*Sqrt[1 - 1/(a^2*x^2)])/(15*a*Sqrt[c - c/(a*x)]) + (31*c^3*Sqrt[1 - 1/(a^2*x^2)]*Sqrt[c - c/(a*x)])/(15*a) + (7*c^2*Sqrt[1 - 1/(a^2*x^2)]*(c - c/(a*x))^(3/2))/(5*a) + c*Sqrt[1 - 1/(a^2*x^2)]*(c - c/(a*x))^(5/2)*x - (5*c^(7/2)*ArcTanh[(Sqrt[c]*Sqrt[1 - 1/(a^2*x^2)])/Sqrt[c - c/(a*x)]])/a, ((80*a - 31/x)*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(7/2))/(15*a^2*(1 - 1/(a*x))^(7/2)) + (7*(a - 1/x)^2*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(7/2))/(5*a^3*(1 - 1/(a*x))^(7/2)) + ((a - 1/x)^3*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(7/2)*x)/(a^3*(1 - 1/(a*x))^(7/2)) - (5*(c - c/(a*x))^(7/2)*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*(1 - 1/(a*x))^(7/2))}
{E^ArcCoth[a*x]*(c - c/(a*x))^(5/2), x, 7, -((2*c^4*(1 - 1/(a^2*x^2))^(3/2))/(3*a*(c - c/(a*x))^(3/2))) + (3*c^3*Sqrt[1 - 1/(a^2*x^2)])/(a*Sqrt[c - c/(a*x)]) + (c^4*(1 - 1/(a^2*x^2))^(3/2)*x)/(c - c/(a*x))^(3/2) - (3*c^(5/2)*ArcTanh[(Sqrt[c]*Sqrt[1 - 1/(a^2*x^2)])/Sqrt[c - c/(a*x)]])/a, (3*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(5/2))/(a*(1 - 1/(a*x))^(5/2)) - (2*(1 + 1/(a*x))^(3/2)*(c - c/(a*x))^(5/2))/(3*a*(1 - 1/(a*x))^(5/2)) + ((1 + 1/(a*x))^(3/2)*(c - c/(a*x))^(5/2)*x)/(1 - 1/(a*x))^(5/2) - (3*(c - c/(a*x))^(5/2)*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*(1 - 1/(a*x))^(5/2))}
{E^ArcCoth[a*x]*(c - c/(a*x))^(3/2), x, 5, (c^2*Sqrt[1 - 1/(a^2*x^2)])/(a*Sqrt[c - c/(a*x)]) + (c^3*(1 - 1/(a^2*x^2))^(3/2)*x)/(c - c/(a*x))^(3/2) - (c^(3/2)*ArcTanh[(Sqrt[c]*Sqrt[1 - 1/(a^2*x^2)])/Sqrt[c - c/(a*x)]])/a}
{E^ArcCoth[a*x]*Sqrt[c - c/(a*x)], x, 4, (c*Sqrt[1 - 1/(a^2*x^2)]*x)/Sqrt[c - c/(a*x)] + (Sqrt[c]*ArcTanh[(Sqrt[c]*Sqrt[1 - 1/(a^2*x^2)])/Sqrt[c - c/(a*x)]])/a}
{E^ArcCoth[a*x]/Sqrt[c - c/(a*x)], x, 8, (Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x)/Sqrt[c - c/(a*x)] + (3*Sqrt[1 - 1/(a*x)]*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*Sqrt[c - c/(a*x)]) - (2*Sqrt[2]*Sqrt[1 - 1/(a*x)]*ArcTanh[Sqrt[1 + 1/(a*x)]/Sqrt[2]])/(a*Sqrt[c - c/(a*x)])}
{E^ArcCoth[a*x]/(c - c/(a*x))^(3/2), x, 9, (-2*(1 - 1/(a*x))^(3/2)*Sqrt[1 + 1/(a*x)])/((a - x^(-1))*(c - c/(a*x))^(3/2)) + (a*(1 - 1/(a*x))^(3/2)*Sqrt[1 + 1/(a*x)]*x)/((a - x^(-1))*(c - c/(a*x))^(3/2)) + (5*(1 - 1/(a*x))^(3/2)*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*(c - c/(a*x))^(3/2)) - (7*(1 - 1/(a*x))^(3/2)*ArcTanh[Sqrt[1 + 1/(a*x)]/Sqrt[2]])/(Sqrt[2]*a*(c - c/(a*x))^(3/2))}
{E^ArcCoth[a*x]/(c - c/(a*x))^(5/2), x, 10, (-3*a*(1 - 1/(a*x))^(5/2)*Sqrt[1 + 1/(a*x)])/(2*(a - x^(-1))^2*(c - c/(a*x))^(5/2)) - (23*(1 - 1/(a*x))^(5/2)*Sqrt[1 + 1/(a*x)])/(8*(a - x^(-1))*(c - c/(a*x))^(5/2)) + (a^2*(1 - 1/(a*x))^(5/2)*Sqrt[1 + 1/(a*x)]*x)/((a - x^(-1))^2*(c - c/(a*x))^(5/2)) + (7*(1 - 1/(a*x))^(5/2)*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*(c - c/(a*x))^(5/2)) - (79*(1 - 1/(a*x))^(5/2)*ArcTanh[Sqrt[1 + 1/(a*x)]/Sqrt[2]])/(8*Sqrt[2]*a*(c - c/(a*x))^(5/2))}


{E^(2*ArcCoth[a*x])*(c - c/(a*x))^(9/2), x, 12, (5*c^4*Sqrt[c - c/(a*x)])/a + (5*c^3*(c - c/(a*x))^(3/2))/(3*a) + (c^2*(c - c/(a*x))^(5/2))/a + (5*c*(c - c/(a*x))^(7/2))/(7*a) + (c - c/(a*x))^(9/2)*x - (5*c^(9/2)*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]])/a}
{E^(2*ArcCoth[a*x])*(c - c/(a*x))^(7/2), x, 11, (3*c^3*Sqrt[c - c/(a*x)])/a + (c^2*(c - c/(a*x))^(3/2))/a + (3*c*(c - c/(a*x))^(5/2))/(5*a) + (c - c/(a*x))^(7/2)*x - (3*c^(7/2)*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]])/a}
{E^(2*ArcCoth[a*x])*(c - c/(a*x))^(5/2), x, 10, (c^2*Sqrt[c - c/(a*x)])/a + (c*(c - c/(a*x))^(3/2))/(3*a) + (c - c/(a*x))^(5/2)*x - (c^(5/2)*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]])/a}
{E^(2*ArcCoth[a*x])*(c - c/(a*x))^(3/2), x, 9, -((c*Sqrt[c - c/(a*x)])/a) + (c - c/(a*x))^(3/2)*x + (c^(3/2)*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]])/a}
{E^(2*ArcCoth[a*x])*Sqrt[c - c/(a*x)], x, 8, Sqrt[c - c/(a*x)]*x + (3*Sqrt[c]*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]])/a}
{E^(2*ArcCoth[a*x])/Sqrt[c - c/(a*x)], x, 9, -5/(a*Sqrt[c - c/(a*x)]) + x/Sqrt[c - c/(a*x)] + (5*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]])/(a*Sqrt[c])}
{E^(2*ArcCoth[a*x])/(c - c/(a*x))^(3/2), x, 10, -7/(3*a*(c - c/(a*x))^(3/2)) - 7/(a*c*Sqrt[c - c/(a*x)]) + x/(c - c/(a*x))^(3/2) + (7*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]])/(a*c^(3/2))}
{E^(2*ArcCoth[a*x])/(c - c/(a*x))^(5/2), x, 11, -9/(5*a*(c - c/(a*x))^(5/2)) - 3/(a*c*(c - c/(a*x))^(3/2)) - 9/(a*c^2*Sqrt[c - c/(a*x)]) + x/(c - c/(a*x))^(5/2) + (9*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]])/(a*c^(5/2))}
{E^(2*ArcCoth[a*x])/(c - c/(a*x))^(7/2), x, 12, -11/(7*a*(c - c/(a*x))^(7/2)) - 11/(5*a*c*(c - c/(a*x))^(5/2)) - 11/(3*a*c^2*(c - c/(a*x))^(3/2)) - 11/(a*c^3*Sqrt[c - c/(a*x)]) + x/(c - c/(a*x))^(7/2) + (11*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]])/(a*c^(7/2))}


{E^(3*ArcCoth[a*x])*(c - c/(a*x))^(9/2), x, 8, (3*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(9/2))/(a*(1 - 1/(a*x))^(9/2)) + (3*(28*a - 17/x)*(1 + 1/(a*x))^(3/2)*(c - c/(a*x))^(9/2))/(35*a^2*(1 - 1/(a*x))^(9/2)) + (9*(a - 1/x)^2*(1 + 1/(a*x))^(3/2)*(c - c/(a*x))^(9/2))/(7*a^3*(1 - 1/(a*x))^(9/2)) + ((a - 1/x)^3*(1 + 1/(a*x))^(3/2)*(c - c/(a*x))^(9/2)*x)/(a^3*(1 - 1/(a*x))^(9/2)) - (3*(c - c/(a*x))^(9/2)*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*(1 - 1/(a*x))^(9/2))}
{E^(3*ArcCoth[a*x])*(c - c/(a*x))^(7/2), x, 8, (Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(7/2))/(a*(1 - 1/(a*x))^(7/2)) + ((1 + 1/(a*x))^(3/2)*(c - c/(a*x))^(7/2))/(3*a*(1 - 1/(a*x))^(7/2)) - (2*(1 + 1/(a*x))^(5/2)*(c - c/(a*x))^(7/2))/(5*a*(1 - 1/(a*x))^(7/2)) + ((1 + 1/(a*x))^(5/2)*(c - c/(a*x))^(7/2)*x)/(1 - 1/(a*x))^(7/2) - ((c - c/(a*x))^(7/2)*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*(1 - 1/(a*x))^(7/2))}
{E^(3*ArcCoth[a*x])*(c - c/(a*x))^(5/2), x, 6, -((c^4*(1 - 1/(a^2*x^2))^(3/2))/(3*a*(c - c/(a*x))^(3/2))) - (c^3*Sqrt[1 - 1/(a^2*x^2)])/(a*Sqrt[c - c/(a*x)]) + (c^5*(1 - 1/(a^2*x^2))^(5/2)*x)/(c - c/(a*x))^(5/2) + (c^(5/2)*ArcTanh[(Sqrt[c]*Sqrt[1 - 1/(a^2*x^2)])/Sqrt[c - c/(a*x)]])/a}
{E^(3*ArcCoth[a*x])*(c - c/(a*x))^(3/2), x, 5, -((3*c^2*Sqrt[1 - 1/(a^2*x^2)])/(a*Sqrt[c - c/(a*x)])) + (c^3*(1 - 1/(a^2*x^2))^(3/2)*x)/(c - c/(a*x))^(3/2) + (3*c^(3/2)*ArcTanh[(Sqrt[c]*Sqrt[1 - 1/(a^2*x^2)])/Sqrt[c - c/(a*x)]])/a}
{E^(3*ArcCoth[a*x])*Sqrt[c - c/(a*x)], x, 8, (Sqrt[1 + 1/(a*x)]*Sqrt[c - c/(a*x)]*x)/Sqrt[1 - 1/(a*x)] + (5*Sqrt[c - c/(a*x)]*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*Sqrt[1 - 1/(a*x)]) - (4*Sqrt[2]*Sqrt[c - c/(a*x)]*ArcTanh[Sqrt[1 + 1/(a*x)]/Sqrt[2]])/(a*Sqrt[1 - 1/(a*x)])}
{E^(3*ArcCoth[a*x])/Sqrt[c - c/(a*x)], x, 9, -((3*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])/((a - 1/x)*Sqrt[c - c/(a*x)])) + (a*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x)/((a - 1/x)*Sqrt[c - c/(a*x)]) + (7*Sqrt[1 - 1/(a*x)]*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*Sqrt[c - c/(a*x)]) - (5*Sqrt[2]*Sqrt[1 - 1/(a*x)]*ArcTanh[Sqrt[1 + 1/(a*x)]/Sqrt[2]])/(a*Sqrt[c - c/(a*x)])}
{E^(3*ArcCoth[a*x])/(c - c/(a*x))^(3/2), x, 10, -((2*a*(1 - 1/(a*x))^(3/2)*Sqrt[1 + 1/(a*x)])/((a - 1/x)^2*(c - c/(a*x))^(3/2))) - (15*(1 - 1/(a*x))^(3/2)*Sqrt[1 + 1/(a*x)])/(4*(a - 1/x)*(c - c/(a*x))^(3/2)) + (a^2*(1 - 1/(a*x))^(3/2)*Sqrt[1 + 1/(a*x)]*x)/((a - 1/x)^2*(c - c/(a*x))^(3/2)) + (9*(1 - 1/(a*x))^(3/2)*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*(c - c/(a*x))^(3/2)) - (51*(1 - 1/(a*x))^(3/2)*ArcTanh[Sqrt[1 + 1/(a*x)]/Sqrt[2]])/(4*Sqrt[2]*a*(c - c/(a*x))^(3/2))}
{E^(3*ArcCoth[a*x])/(c - c/(a*x))^(5/2), x, 11, -((5*a^2*(1 - 1/(a*x))^(5/2)*Sqrt[1 + 1/(a*x)])/(3*(a - 1/x)^3*(c - c/(a*x))^(5/2))) - (29*a*(1 - 1/(a*x))^(5/2)*Sqrt[1 + 1/(a*x)])/(12*(a - 1/x)^2*(c - c/(a*x))^(5/2)) - (73*(1 - 1/(a*x))^(5/2)*Sqrt[1 + 1/(a*x)])/(16*(a - 1/x)*(c - c/(a*x))^(5/2)) + (a^3*(1 - 1/(a*x))^(5/2)*Sqrt[1 + 1/(a*x)]*x)/((a - 1/x)^3*(c - c/(a*x))^(5/2)) + (11*(1 - 1/(a*x))^(5/2)*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*(c - c/(a*x))^(5/2)) - (249*(1 - 1/(a*x))^(5/2)*ArcTanh[Sqrt[1 + 1/(a*x)]/Sqrt[2]])/(16*Sqrt[2]*a*(c - c/(a*x))^(5/2))}


(* ::Subsubsection::Closed:: *)
(*n<0*)


{(c - c/(a*x))^(7/2)/E^ArcCoth[a*x], x, 7, -(((80*a - 7/x)*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(7/2))/(5*a^2*(1 - 1/(a*x))^(7/2))) + (3*(a - 1/x)^2*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(7/2))/(5*a^3*(1 - 1/(a*x))^(7/2)) + ((a - 1/x)^3*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(7/2)*x)/(a^3*(1 - 1/(a*x))^(7/2)) - (9*(c - c/(a*x))^(7/2)*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*(1 - 1/(a*x))^(7/2))}
{(c - c/(a*x))^(5/2)/E^ArcCoth[a*x], x, 6, -(((16*a + 1/x)*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(5/2))/(3*a^2*(1 - 1/(a*x))^(5/2))) + ((a - 1/x)^2*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(5/2)*x)/(a^2*(1 - 1/(a*x))^(5/2)) - (7*(c - c/(a*x))^(5/2)*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*(1 - 1/(a*x))^(5/2))}
{(c - c/(a*x))^(3/2)/E^ArcCoth[a*x], x, 6, (-2*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(3/2))/(a*(1 - 1/(a*x))^(3/2)) + (Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(3/2)*x)/(1 - 1/(a*x))^(3/2) - (5*(c - c/(a*x))^(3/2)*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*(1 - 1/(a*x))^(3/2))}
{Sqrt[c - c/(a*x)]/E^ArcCoth[a*x], x, 4, (c*Sqrt[1 - 1/(a^2*x^2)]*x)/Sqrt[c - c/(a*x)] - (3*Sqrt[c]*ArcTanh[(Sqrt[c]*Sqrt[1 - 1/(a^2*x^2)])/Sqrt[c - c/(a*x)]])/a}
{1/(E^ArcCoth[a*x]*Sqrt[c - c/(a*x)]), x, 4, (Sqrt[1 - 1/(a^2*x^2)]*x)/Sqrt[c - c/(a*x)] - ArcTanh[(Sqrt[c]*Sqrt[1 - 1/(a^2*x^2)])/Sqrt[c - c/(a*x)]]/(a*Sqrt[c])}
{1/(E^ArcCoth[a*x]*(c - c/(a*x))^(3/2)), x, 9, ((1 - 1/(a*x))^(3/2)*Sqrt[1 + 1/(a*x)]*x)/(c - c/(a*x))^(3/2) + ((1 - 1/(a*x))^(3/2)*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*(c - c/(a*x))^(3/2)) - (Sqrt[2]*(1 - 1/(a*x))^(3/2)*ArcTanh[Sqrt[1 + 1/(a*x)]/Sqrt[2]])/(a*(c - c/(a*x))^(3/2))}
{1/(E^ArcCoth[a*x]*(c - c/(a*x))^(5/2)), x, 10, (-3*(1 - 1/(a*x))^(5/2)*Sqrt[1 + 1/(a*x)])/(2*(a - x^(-1))*(c - c/(a*x))^(5/2)) + (a*(1 - 1/(a*x))^(5/2)*Sqrt[1 + 1/(a*x)]*x)/((a - x^(-1))*(c - c/(a*x))^(5/2)) + (3*(1 - 1/(a*x))^(5/2)*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*(c - c/(a*x))^(5/2)) - (9*(1 - 1/(a*x))^(5/2)*ArcTanh[Sqrt[1 + 1/(a*x)]/Sqrt[2]])/(2*Sqrt[2]*a*(c - c/(a*x))^(5/2))}
{1/(E^ArcCoth[a*x]*(c - c/(a*x))^(7/2)), x, 11, (-5*a*(1 - 1/(a*x))^(7/2)*Sqrt[1 + 1/(a*x)])/(4*(a - x^(-1))^2*(c - c/(a*x))^(7/2)) - (35*(1 - 1/(a*x))^(7/2)*Sqrt[1 + 1/(a*x)])/(16*(a - x^(-1))*(c - c/(a*x))^(7/2)) + (a^2*(1 - 1/(a*x))^(7/2)*Sqrt[1 + 1/(a*x)]*x)/((a - x^(-1))^2*(c - c/(a*x))^(7/2)) + (5*(1 - 1/(a*x))^(7/2)*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*(c - c/(a*x))^(7/2)) - (115*(1 - 1/(a*x))^(7/2)*ArcTanh[Sqrt[1 + 1/(a*x)]/Sqrt[2]])/(16*Sqrt[2]*a*(c - c/(a*x))^(7/2))}


{(c - c/(a*x))^(7/2)/E^(2*ArcCoth[a*x]), x, 14, -((21*c^3*Sqrt[c - c/(a*x)])/a) - (5*c^2*(c - c/(a*x))^(3/2))/(3*a) + (3*c*(c - c/(a*x))^(5/2))/(5*a) + (c - c/(a*x))^(7/2)*x - (11*c^(7/2)*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]])/a + (32*Sqrt[2]*c^(7/2)*ArcTanh[Sqrt[c - c/(a*x)]/(Sqrt[2]*Sqrt[c])])/a}
{(c - c/(a*x))^(5/2)/E^(2*ArcCoth[a*x]), x, 13, -((7*c^2*Sqrt[c - c/(a*x)])/a) + (c*(c - c/(a*x))^(3/2))/(3*a) + (c - c/(a*x))^(5/2)*x - (9*c^(5/2)*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]])/a + (16*Sqrt[2]*c^(5/2)*ArcTanh[Sqrt[c - c/(a*x)]/(Sqrt[2]*Sqrt[c])])/a}
{(c - c/(a*x))^(3/2)/E^(2*ArcCoth[a*x]), x, 12, -((c*Sqrt[c - c/(a*x)])/a) + (c - c/(a*x))^(3/2)*x - (7*c^(3/2)*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]])/a + (8*Sqrt[2]*c^(3/2)*ArcTanh[Sqrt[c - c/(a*x)]/(Sqrt[2]*Sqrt[c])])/a}
{Sqrt[c - c/(a*x)]/E^(2*ArcCoth[a*x]), x, 11, Sqrt[c - c/(a*x)]*x - (5*Sqrt[c]*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]])/a + (4*Sqrt[2]*Sqrt[c]*ArcTanh[Sqrt[c - c/(a*x)]/(Sqrt[2]*Sqrt[c])])/a}
{1/(E^(2*ArcCoth[a*x])*Sqrt[c - c/(a*x)]), x, 11, (Sqrt[c - c/(a*x)]*x)/c - (3*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]])/(a*Sqrt[c]) + (2*Sqrt[2]*ArcTanh[Sqrt[c - c/(a*x)]/(Sqrt[2]*Sqrt[c])])/(a*Sqrt[c])}
{1/(E^(2*ArcCoth[a*x])*(c - c/(a*x))^(3/2)), x, 12, (Sqrt[c - c/(a*x)]*x)/c^2 - ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]]/(a*c^(3/2)) + (Sqrt[2]*ArcTanh[Sqrt[c - c/(a*x)]/(Sqrt[2]*Sqrt[c])])/(a*c^(3/2))}
{1/(E^(2*ArcCoth[a*x])*(c - c/(a*x))^(5/2)), x, 12, -(2/(a*c^2*Sqrt[c - c/(a*x)])) + x/(c^2*Sqrt[c - c/(a*x)]) + ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]]/(a*c^(5/2)) + ArcTanh[Sqrt[c - c/(a*x)]/(Sqrt[2]*Sqrt[c])]/(Sqrt[2]*a*c^(5/2))}
{1/(E^(2*ArcCoth[a*x])*(c - c/(a*x))^(7/2)), x, 13, -(4/(3*a*c^2*(c - c/(a*x))^(3/2))) - 7/(2*a*c^3*Sqrt[c - c/(a*x)]) + x/(c^2*(c - c/(a*x))^(3/2)) + (3*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]])/(a*c^(7/2)) + ArcTanh[Sqrt[c - c/(a*x)]/(Sqrt[2]*Sqrt[c])]/(2*Sqrt[2]*a*c^(7/2))}
{1/(E^(2*ArcCoth[a*x])*(c - c/(a*x))^(9/2)), x, 14, -(6/(5*a*c^2*(c - c/(a*x))^(5/2))) - 11/(6*a*c^3*(c - c/(a*x))^(3/2)) - 21/(4*a*c^4*Sqrt[c - c/(a*x)]) + x/(c^2*(c - c/(a*x))^(5/2)) + (5*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]])/(a*c^(9/2)) + ArcTanh[Sqrt[c - c/(a*x)]/(Sqrt[2]*Sqrt[c])]/(4*Sqrt[2]*a*c^(9/2))}


{(c - c/(a*x))^(9/2)/E^(3*ArcCoth[a*x]), x, 9, (10*(a - 1/x)^4*(c - c/(a*x))^(9/2))/(a^5*(1 - 1/(a*x))^(9/2)*Sqrt[1 + 1/(a*x)]) + (5*(304*a - 65/x)*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(9/2))/(7*a^2*(1 - 1/(a*x))^(9/2)) + (135*(a - 1/x)^2*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(9/2))/(7*a^3*(1 - 1/(a*x))^(9/2)) + (65*(a - 1/x)^3*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(9/2))/(7*a^4*(1 - 1/(a*x))^(9/2)) + ((a - 1/x)^5*(c - c/(a*x))^(9/2)*x)/(a^5*(1 - 1/(a*x))^(9/2)*Sqrt[1 + 1/(a*x)]) - (15*(c - c/(a*x))^(9/2)*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*(1 - 1/(a*x))^(9/2))}
{(c - c/(a*x))^(7/2)/E^(3*ArcCoth[a*x]), x, 8, (10*(a - 1/x)^3*(c - c/(a*x))^(7/2))/(a^4*(1 - 1/(a*x))^(7/2)*Sqrt[1 + 1/(a*x)]) + ((1360*a - 311/x)*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(7/2))/(15*a^2*(1 - 1/(a*x))^(7/2)) + (47*(a - 1/x)^2*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(7/2))/(5*a^3*(1 - 1/(a*x))^(7/2)) + ((a - 1/x)^4*(c - c/(a*x))^(7/2)*x)/(a^4*(1 - 1/(a*x))^(7/2)*Sqrt[1 + 1/(a*x)]) - (13*(c - c/(a*x))^(7/2)*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*(1 - 1/(a*x))^(7/2))}
{(c - c/(a*x))^(5/2)/E^(3*ArcCoth[a*x]), x, 7, (10*(a - 1/x)^2*(c - c/(a*x))^(5/2))/(a^3*(1 - 1/(a*x))^(5/2)*Sqrt[1 + 1/(a*x)]) + ((112*a - 29/x)*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(5/2))/(3*a^2*(1 - 1/(a*x))^(5/2)) + ((a - 1/x)^3*(c - c/(a*x))^(5/2)*x)/(a^3*(1 - 1/(a*x))^(5/2)*Sqrt[1 + 1/(a*x)]) - (11*(c - c/(a*x))^(5/2)*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*(1 - 1/(a*x))^(5/2))}
{(c - c/(a*x))^(3/2)/E^(3*ArcCoth[a*x]), x, 6, ((21*a + 1/x)*(c - c/(a*x))^(3/2))/(a^2*(1 - 1/(a*x))^(3/2)*Sqrt[1 + 1/(a*x)]) + ((a - 1/x)^2*(c - c/(a*x))^(3/2)*x)/(a^2*(1 - 1/(a*x))^(3/2)*Sqrt[1 + 1/(a*x)]) - (9*(c - c/(a*x))^(3/2)*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*(1 - 1/(a*x))^(3/2))}
{Sqrt[c - c/(a*x)]/E^(3*ArcCoth[a*x]), x, 6, (9*Sqrt[c - c/(a*x)])/(a*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]) + (Sqrt[c - c/(a*x)]*x)/(Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]) - (7*Sqrt[c - c/(a*x)]*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*Sqrt[1 - 1/(a*x)])}
{1/(E^(3*ArcCoth[a*x])*Sqrt[c - c/(a*x)]), x, 5, (5*Sqrt[c - c/(a*x)])/(a*c*Sqrt[1 - 1/(a^2*x^2)]) + (Sqrt[c - c/(a*x)]*x)/(c*Sqrt[1 - 1/(a^2*x^2)]) - (5*ArcTanh[(Sqrt[c]*Sqrt[1 - 1/(a^2*x^2)])/Sqrt[c - c/(a*x)]])/(a*Sqrt[c])}
{1/(E^(3*ArcCoth[a*x])*(c - c/(a*x))^(3/2)), x, 5, (3*Sqrt[1 - 1/(a^2*x^2)]*x)/(c*Sqrt[c - c/(a*x)]) - (2*Sqrt[c - c/(a*x)]*x)/(c^2*Sqrt[1 - 1/(a^2*x^2)]) - (3*ArcTanh[(Sqrt[c]*Sqrt[1 - 1/(a^2*x^2)])/Sqrt[c - c/(a*x)]])/(a*c^(3/2))}
{1/(E^(3*ArcCoth[a*x])*(c - c/(a*x))^(5/2)), x, 9, (2*(1 - 1/(a*x))^(5/2))/(a*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(5/2)) + ((1 - 1/(a*x))^(5/2)*x)/(Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(5/2)) - ((1 - 1/(a*x))^(5/2)*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*(c - c/(a*x))^(5/2)) - ((1 - 1/(a*x))^(5/2)*ArcTanh[Sqrt[1 + 1/(a*x)]/Sqrt[2]])/(Sqrt[2]*a*(c - c/(a*x))^(5/2))}
{1/(E^(3*ArcCoth[a*x])*(c - c/(a*x))^(7/2)), x, 10, (7*(1 - 1/(a*x))^(7/2))/(4*a*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(7/2)) - (3*(1 - 1/(a*x))^(7/2))/(2*(a - x^(-1))*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(7/2)) + (a*(1 - 1/(a*x))^(7/2)*x)/((a - x^(-1))*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^(7/2)) + ((1 - 1/(a*x))^(7/2)*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*(c - c/(a*x))^(7/2)) - (11*(1 - 1/(a*x))^(7/2)*ArcTanh[Sqrt[1 + 1/(a*x)]/Sqrt[2]])/(4*Sqrt[2]*a*(c - c/(a*x))^(7/2))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m E^(n ArcCoth[a x]) (c-c/(a x))^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{E^ArcCoth[a*x]*Sqrt[c - c/(a*x)]*x^m, x, 3, (Sqrt[c - c/(a*x)]*x^(1 + m)*Hypergeometric2F1[-(1/2), -1 - m, -m, -(1/(a*x))])/((1 + m)*Sqrt[1 - 1/(a*x)])}

{E^ArcCoth[a*x]*Sqrt[c - c/(a*x)]*x^2, x, 6, -((c*Sqrt[1 - 1/(a^2*x^2)]*x)/(8*a^2*Sqrt[c - c/(a*x)])) + (c*Sqrt[1 - 1/(a^2*x^2)]*x^2)/(12*a*Sqrt[c - c/(a*x)]) + (c*Sqrt[1 - 1/(a^2*x^2)]*x^3)/(3*Sqrt[c - c/(a*x)]) + (Sqrt[c]*ArcTanh[(Sqrt[c]*Sqrt[1 - 1/(a^2*x^2)])/Sqrt[c - c/(a*x)]])/(8*a^3)}
{E^ArcCoth[a*x]*Sqrt[c - c/(a*x)]*x^1, x, 5, (c*Sqrt[1 - 1/(a^2*x^2)]*x)/(4*a*Sqrt[c - c/(a*x)]) + (c*Sqrt[1 - 1/(a^2*x^2)]*x^2)/(2*Sqrt[c - c/(a*x)]) - (Sqrt[c]*ArcTanh[(Sqrt[c]*Sqrt[1 - 1/(a^2*x^2)])/Sqrt[c - c/(a*x)]])/(4*a^2)}
{E^ArcCoth[a*x]*Sqrt[c - c/(a*x)]*x^0, x, 4, (c*Sqrt[1 - 1/(a^2*x^2)]*x)/Sqrt[c - c/(a*x)] + (Sqrt[c]*ArcTanh[(Sqrt[c]*Sqrt[1 - 1/(a^2*x^2)])/Sqrt[c - c/(a*x)]])/a}
{E^ArcCoth[a*x]*Sqrt[c - c/(a*x)]/x^1, x, 4, -((2*c*Sqrt[1 - 1/(a^2*x^2)])/Sqrt[c - c/(a*x)]) + 2*Sqrt[c]*ArcTanh[(Sqrt[c]*Sqrt[1 - 1/(a^2*x^2)])/Sqrt[c - c/(a*x)]]}
{E^ArcCoth[a*x]*Sqrt[c - c/(a*x)]/x^2, x, 2, -((2*a*c^2*(1 - 1/(a^2*x^2))^(3/2))/(3*(c - c/(a*x))^(3/2)))}
{E^ArcCoth[a*x]*Sqrt[c - c/(a*x)]/x^3, x, 3, -((2*a^2*c^2*(1 - 1/(a^2*x^2))^(3/2))/(15*(c - c/(a*x))^(3/2))) + (2*a^2*c*(1 - 1/(a^2*x^2))^(3/2))/(5*Sqrt[c - c/(a*x)])}
{E^ArcCoth[a*x]*Sqrt[c - c/(a*x)]/x^4, x, 4, (8*a^3*c^2*(1 - 1/(a^2*x^2))^(3/2))/(105*(c - c/(a*x))^(3/2)) - (8*a^3*c*(1 - 1/(a^2*x^2))^(3/2))/(35*Sqrt[c - c/(a*x)]) - (2*a*c^2*(1 - 1/(a^2*x^2))^(3/2))/(7*(c - c/(a*x))^(3/2)*x^2)}
{E^ArcCoth[a*x]*Sqrt[c - c/(a*x)]/x^5, x, 5, -((16*a^4*c^2*(1 - 1/(a^2*x^2))^(3/2))/(315*(c - c/(a*x))^(3/2))) + (16*a^4*c*(1 - 1/(a^2*x^2))^(3/2))/(105*Sqrt[c - c/(a*x)]) - (2*a*c^2*(1 - 1/(a^2*x^2))^(3/2))/(9*(c - c/(a*x))^(3/2)*x^3) + (4*a^2*c^2*(1 - 1/(a^2*x^2))^(3/2))/(21*(c - c/(a*x))^(3/2)*x^2)}


{E^(2*ArcCoth[a*x])*Sqrt[c - c/(a*x)]*x^3, x, 11, (75*Sqrt[c - c/(a*x)]*x)/(64*a^3) + (25*Sqrt[c - c/(a*x)]*x^2)/(32*a^2) + (5*Sqrt[c - c/(a*x)]*x^3)/(8*a) + (Sqrt[c - c/(a*x)]*x^4)/4 + (75*Sqrt[c]*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]])/(64*a^4)}
{E^(2*ArcCoth[a*x])*Sqrt[c - c/(a*x)]*x^2, x, 10, (11*Sqrt[c - c/(a*x)]*x)/(8*a^2) + (11*Sqrt[c - c/(a*x)]*x^2)/(12*a) + (Sqrt[c - c/(a*x)]*x^3)/3 + (11*Sqrt[c]*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]])/(8*a^3)}
{E^(2*ArcCoth[a*x])*Sqrt[c - c/(a*x)]*x, x, 9, (7*Sqrt[c - c/(a*x)]*x)/(4*a) + (Sqrt[c - c/(a*x)]*x^2)/2 + (7*Sqrt[c]*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]])/(4*a^2)}
{E^(2*ArcCoth[a*x])*Sqrt[c - c/(a*x)], x, 8, Sqrt[c - c/(a*x)]*x + (3*Sqrt[c]*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]])/a}
{(E^(2*ArcCoth[a*x])*Sqrt[c - c/(a*x)])/x, x, 8, 2*Sqrt[c - c/(a*x)] + 2*Sqrt[c]*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]]}
{(E^(2*ArcCoth[a*x])*Sqrt[c - c/(a*x)])/x^2, x, 7, 4*a*Sqrt[c - c/(a*x)] - (2*a*(c - c/(a*x))^(3/2))/(3*c)}
{(E^(2*ArcCoth[a*x])*Sqrt[c - c/(a*x)])/x^3, x, 7, 4*a^2*Sqrt[c - c/(a*x)] - (2*a^2*(c - c/(a*x))^(3/2))/c + (2*a^2*(c - c/(a*x))^(5/2))/(5*c^2)}
{(E^(2*ArcCoth[a*x])*Sqrt[c - c/(a*x)])/x^4, x, 7, 4*a^3*Sqrt[c - c/(a*x)] - (10*a^3*(c - c/(a*x))^(3/2))/(3*c) + (8*a^3*(c - c/(a*x))^(5/2))/(5*c^2) - (2*a^3*(c - c/(a*x))^(7/2))/(7*c^3)}
{(E^(2*ArcCoth[a*x])*Sqrt[c - c/(a*x)])/x^5, x, 7, 4*a^4*Sqrt[c - c/(a*x)] - (14*a^4*(c - c/(a*x))^(3/2))/(3*c) + (18*a^4*(c - c/(a*x))^(5/2))/(5*c^2) - (10*a^4*(c - c/(a*x))^(7/2))/(7*c^3) + (2*a^4*(c - c/(a*x))^(9/2))/(9*c^4)}


{E^(3*ArcCoth[a*x])*Sqrt[c - c/(a*x)]*x^3, x, 11, (149*Sqrt[1 + 1/(a*x)]*Sqrt[c - c/(a*x)]*x)/(64*a^3*Sqrt[1 - 1/(a*x)]) + (107*Sqrt[1 + 1/(a*x)]*Sqrt[c - c/(a*x)]*x^2)/(96*a^2*Sqrt[1 - 1/(a*x)]) + (17*Sqrt[1 + 1/(a*x)]*Sqrt[c - c/(a*x)]*x^3)/(24*a*Sqrt[1 - 1/(a*x)]) + (Sqrt[1 + 1/(a*x)]*Sqrt[c - c/(a*x)]*x^4)/(4*Sqrt[1 - 1/(a*x)]) + (363*Sqrt[c - c/(a*x)]*ArcTanh[Sqrt[1 + 1/(a*x)]])/(64*a^4*Sqrt[1 - 1/(a*x)]) - (4*Sqrt[2]*Sqrt[c - c/(a*x)]*ArcTanh[Sqrt[1 + 1/(a*x)]/Sqrt[2]])/(a^4*Sqrt[1 - 1/(a*x)])}
{E^(3*ArcCoth[a*x])*Sqrt[c - c/(a*x)]*x^2, x, 10, (19*Sqrt[1 + 1/(a*x)]*Sqrt[c - c/(a*x)]*x)/(8*a^2*Sqrt[1 - 1/(a*x)]) + (13*Sqrt[1 + 1/(a*x)]*Sqrt[c - c/(a*x)]*x^2)/(12*a*Sqrt[1 - 1/(a*x)]) + (Sqrt[1 + 1/(a*x)]*Sqrt[c - c/(a*x)]*x^3)/(3*Sqrt[1 - 1/(a*x)]) + (45*Sqrt[c - c/(a*x)]*ArcTanh[Sqrt[1 + 1/(a*x)]])/(8*a^3*Sqrt[1 - 1/(a*x)]) - (4*Sqrt[2]*Sqrt[c - c/(a*x)]*ArcTanh[Sqrt[1 + 1/(a*x)]/Sqrt[2]])/(a^3*Sqrt[1 - 1/(a*x)])}
{E^(3*ArcCoth[a*x])*Sqrt[c - c/(a*x)]*x, x, 9, (9*Sqrt[1 + 1/(a*x)]*Sqrt[c - c/(a*x)]*x)/(4*a*Sqrt[1 - 1/(a*x)]) + (Sqrt[1 + 1/(a*x)]*Sqrt[c - c/(a*x)]*x^2)/(2*Sqrt[1 - 1/(a*x)]) + (23*Sqrt[c - c/(a*x)]*ArcTanh[Sqrt[1 + 1/(a*x)]])/(4*a^2*Sqrt[1 - 1/(a*x)]) - (4*Sqrt[2]*Sqrt[c - c/(a*x)]*ArcTanh[Sqrt[1 + 1/(a*x)]/Sqrt[2]])/(a^2*Sqrt[1 - 1/(a*x)])}
{E^(3*ArcCoth[a*x])*Sqrt[c - c/(a*x)], x, 8, (Sqrt[1 + 1/(a*x)]*Sqrt[c - c/(a*x)]*x)/Sqrt[1 - 1/(a*x)] + (5*Sqrt[c - c/(a*x)]*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*Sqrt[1 - 1/(a*x)]) - (4*Sqrt[2]*Sqrt[c - c/(a*x)]*ArcTanh[Sqrt[1 + 1/(a*x)]/Sqrt[2]])/(a*Sqrt[1 - 1/(a*x)])}
{(E^(3*ArcCoth[a*x])*Sqrt[c - c/(a*x)])/x, x, 8, (2*Sqrt[1 + 1/(a*x)]*Sqrt[c - c/(a*x)])/Sqrt[1 - 1/(a*x)] + (2*Sqrt[c - c/(a*x)]*ArcTanh[Sqrt[1 + 1/(a*x)]])/Sqrt[1 - 1/(a*x)] - (4*Sqrt[2]*Sqrt[c - c/(a*x)]*ArcTanh[Sqrt[1 + 1/(a*x)]/Sqrt[2]])/Sqrt[1 - 1/(a*x)]}
{(E^(3*ArcCoth[a*x])*Sqrt[c - c/(a*x)])/x^2, x, 5, (2*a*c^2*(1 - 1/(a^2*x^2))^(3/2))/(3*(c - c/(a*x))^(3/2)) + (4*a*c*Sqrt[1 - 1/(a^2*x^2)])/Sqrt[c - c/(a*x)] - 4*Sqrt[2]*a*Sqrt[c]*ArcTanh[(Sqrt[c]*Sqrt[1 - 1/(a^2*x^2)])/(Sqrt[2]*Sqrt[c - c/(a*x)])]}
{(E^(3*ArcCoth[a*x])*Sqrt[c - c/(a*x)])/x^3, x, 6, (2*a^2*c^3*(1 - 1/(a^2*x^2))^(5/2))/(5*(c - c/(a*x))^(5/2)) + (2*a^2*c^2*(1 - 1/(a^2*x^2))^(3/2))/(3*(c - c/(a*x))^(3/2)) + (4*a^2*c*Sqrt[1 - 1/(a^2*x^2)])/Sqrt[c - c/(a*x)] - 4*Sqrt[2]*a^2*Sqrt[c]*ArcTanh[(Sqrt[c]*Sqrt[1 - 1/(a^2*x^2)])/(Sqrt[2]*Sqrt[c - c/(a*x)])]}
{(E^(3*ArcCoth[a*x])*Sqrt[c - c/(a*x)])/x^4, x, 7, (4*a^3*c^3*(1 - 1/(a^2*x^2))^(5/2))/(7*(c - c/(a*x))^(5/2)) + (2*a^3*c^2*(1 - 1/(a^2*x^2))^(3/2))/(3*(c - c/(a*x))^(3/2)) - (2*a^3*c^2*(1 - 1/(a^2*x^2))^(5/2))/(7*(c - c/(a*x))^(3/2)) + (4*a^3*c*Sqrt[1 - 1/(a^2*x^2)])/Sqrt[c - c/(a*x)] - 4*Sqrt[2]*a^3*Sqrt[c]*ArcTanh[(Sqrt[c]*Sqrt[1 - 1/(a^2*x^2)])/(Sqrt[2]*Sqrt[c - c/(a*x)])]}
{(E^(3*ArcCoth[a*x])*Sqrt[c - c/(a*x)])/x^5, x, 8, (4*a^4*Sqrt[1 + 1/(a*x)]*Sqrt[c - c/(a*x)])/Sqrt[1 - 1/(a*x)] + (2*a^4*(1 + 1/(a*x))^(3/2)*Sqrt[c - c/(a*x)])/(3*Sqrt[1 - 1/(a*x)]) + (2*a^4*(1 + 1/(a*x))^(5/2)*Sqrt[c - c/(a*x)])/(5*Sqrt[1 - 1/(a*x)]) - (2*a^4*(1 + 1/(a*x))^(7/2)*Sqrt[c - c/(a*x)])/(7*Sqrt[1 - 1/(a*x)]) + (2*a^4*(1 + 1/(a*x))^(9/2)*Sqrt[c - c/(a*x)])/(9*Sqrt[1 - 1/(a*x)]) - (4*Sqrt[2]*a^4*Sqrt[c - c/(a*x)]*ArcTanh[Sqrt[1 + 1/(a*x)]/Sqrt[2]])/Sqrt[1 - 1/(a*x)]}


(* ::Subsubsection::Closed:: *)
(*n<0*)


{(Sqrt[c - c/(a*x)]*x^m)/E^ArcCoth[a*x], x, 4, (Sqrt[1 + 1/(a*x)]*Sqrt[c - c/(a*x)]*x^(1 + m))/((1 + m)*Sqrt[1 - 1/(a*x)]) - ((3 + 4*m)*Sqrt[c - c/(a*x)]*x^m*Hypergeometric2F1[1/2, -m, 1 - m, -(1/(a*x))])/(2*a*m*(1 + m)*Sqrt[1 - 1/(a*x)])}

{(Sqrt[c - c/(a*x)]*x^2)/E^ArcCoth[a*x], x, 6, (11*c*Sqrt[1 - 1/(a^2*x^2)]*x)/(8*a^2*Sqrt[c - c/(a*x)]) - (11*c*Sqrt[1 - 1/(a^2*x^2)]*x^2)/(12*a*Sqrt[c - c/(a*x)]) + (c*Sqrt[1 - 1/(a^2*x^2)]*x^3)/(3*Sqrt[c - c/(a*x)]) - (11*Sqrt[c]*ArcTanh[(Sqrt[c]*Sqrt[1 - 1/(a^2*x^2)])/Sqrt[c - c/(a*x)]])/(8*a^3)}
{(Sqrt[c - c/(a*x)]*x)/E^ArcCoth[a*x], x, 5, -((7*c*Sqrt[1 - 1/(a^2*x^2)]*x)/(4*a*Sqrt[c - c/(a*x)])) + (c*Sqrt[1 - 1/(a^2*x^2)]*x^2)/(2*Sqrt[c - c/(a*x)]) + (7*Sqrt[c]*ArcTanh[(Sqrt[c]*Sqrt[1 - 1/(a^2*x^2)])/Sqrt[c - c/(a*x)]])/(4*a^2)}
{Sqrt[c - c/(a*x)]/E^ArcCoth[a*x], x, 4, (c*Sqrt[1 - 1/(a^2*x^2)]*x)/Sqrt[c - c/(a*x)] - (3*Sqrt[c]*ArcTanh[(Sqrt[c]*Sqrt[1 - 1/(a^2*x^2)])/Sqrt[c - c/(a*x)]])/a}
{Sqrt[c - c/(a*x)]/(E^ArcCoth[a*x]*x), x, 4, (2*c*Sqrt[1 - 1/(a^2*x^2)])/Sqrt[c - c/(a*x)] + 2*Sqrt[c]*ArcTanh[(Sqrt[c]*Sqrt[1 - 1/(a^2*x^2)])/Sqrt[c - c/(a*x)]]}
{Sqrt[c - c/(a*x)]/(E^ArcCoth[a*x]*x^2), x, 3, -((8*a*c*Sqrt[1 - 1/(a^2*x^2)])/(3*Sqrt[c - c/(a*x)])) - (2/3)*a*Sqrt[1 - 1/(a^2*x^2)]*Sqrt[c - c/(a*x)]}
{Sqrt[c - c/(a*x)]/(E^ArcCoth[a*x]*x^3), x, 4, (8*a^2*c*Sqrt[1 - 1/(a^2*x^2)])/(5*Sqrt[c - c/(a*x)]) + (2/5)*a^2*Sqrt[1 - 1/(a^2*x^2)]*Sqrt[c - c/(a*x)] + (2*a^2*Sqrt[1 - 1/(a^2*x^2)]*(c - c/(a*x))^(3/2))/(5*c)}
{Sqrt[c - c/(a*x)]/(E^ArcCoth[a*x]*x^4), x, 5, -((104*a^3*c*Sqrt[1 - 1/(a^2*x^2)])/(105*Sqrt[c - c/(a*x)])) - (104/105)*a^3*Sqrt[1 - 1/(a^2*x^2)]*Sqrt[c - c/(a*x)] + (2*c*Sqrt[1 - 1/(a^2*x^2)])/(7*Sqrt[c - c/(a*x)]*x^3) - (26*a*c*Sqrt[1 - 1/(a^2*x^2)])/(35*Sqrt[c - c/(a*x)]*x^2)}


{(Sqrt[c - c/(a*x)]*x^3)/E^(2*ArcCoth[a*x]), x, 14, -((149*Sqrt[c - c/(a*x)]*x)/(64*a^3)) + (107*Sqrt[c - c/(a*x)]*x^2)/(96*a^2) - (17*Sqrt[c - c/(a*x)]*x^3)/(24*a) + (1/4)*Sqrt[c - c/(a*x)]*x^4 + (363*Sqrt[c]*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]])/(64*a^4) - (4*Sqrt[2]*Sqrt[c]*ArcTanh[Sqrt[c - c/(a*x)]/(Sqrt[2]*Sqrt[c])])/a^4}
{(Sqrt[c - c/(a*x)]*x^2)/E^(2*ArcCoth[a*x]), x, 13, (19*Sqrt[c - c/(a*x)]*x)/(8*a^2) - (13*Sqrt[c - c/(a*x)]*x^2)/(12*a) + (1/3)*Sqrt[c - c/(a*x)]*x^3 - (45*Sqrt[c]*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]])/(8*a^3) + (4*Sqrt[2]*Sqrt[c]*ArcTanh[Sqrt[c - c/(a*x)]/(Sqrt[2]*Sqrt[c])])/a^3}
{(Sqrt[c - c/(a*x)]*x)/E^(2*ArcCoth[a*x]), x, 12, -((9*Sqrt[c - c/(a*x)]*x)/(4*a)) + (1/2)*Sqrt[c - c/(a*x)]*x^2 + (23*Sqrt[c]*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]])/(4*a^2) - (4*Sqrt[2]*Sqrt[c]*ArcTanh[Sqrt[c - c/(a*x)]/(Sqrt[2]*Sqrt[c])])/a^2}
{Sqrt[c - c/(a*x)]/E^(2*ArcCoth[a*x]), x, 11, Sqrt[c - c/(a*x)]*x - (5*Sqrt[c]*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]])/a + (4*Sqrt[2]*Sqrt[c]*ArcTanh[Sqrt[c - c/(a*x)]/(Sqrt[2]*Sqrt[c])])/a}
{Sqrt[c - c/(a*x)]/(E^(2*ArcCoth[a*x])*x), x, 11, 2*Sqrt[c - c/(a*x)] + 2*Sqrt[c]*ArcTanh[Sqrt[c - c/(a*x)]/Sqrt[c]] - 4*Sqrt[2]*Sqrt[c]*ArcTanh[Sqrt[c - c/(a*x)]/(Sqrt[2]*Sqrt[c])]}
{Sqrt[c - c/(a*x)]/(E^(2*ArcCoth[a*x])*x^2), x, 9, -4*a*Sqrt[c - c/(a*x)] - (2*a*(c - c/(a*x))^(3/2))/(3*c) + 4*Sqrt[2]*a*Sqrt[c]*ArcTanh[Sqrt[c - c/(a*x)]/(Sqrt[2]*Sqrt[c])]}
{Sqrt[c - c/(a*x)]/(E^(2*ArcCoth[a*x])*x^3), x, 10, 4*a^2*Sqrt[c - c/(a*x)] + (2*a^2*(c - c/(a*x))^(3/2))/(3*c) + (2*a^2*(c - c/(a*x))^(5/2))/(5*c^2) - 4*Sqrt[2]*a^2*Sqrt[c]*ArcTanh[Sqrt[c - c/(a*x)]/(Sqrt[2]*Sqrt[c])]}
{Sqrt[c - c/(a*x)]/(E^(2*ArcCoth[a*x])*x^4), x, 11, -4*a^3*Sqrt[c - c/(a*x)] - (2*a^3*(c - c/(a*x))^(3/2))/(3*c) - (2*a^3*(c - c/(a*x))^(7/2))/(7*c^3) + 4*Sqrt[2]*a^3*Sqrt[c]*ArcTanh[Sqrt[c - c/(a*x)]/(Sqrt[2]*Sqrt[c])]}
{Sqrt[c - c/(a*x)]/(E^(2*ArcCoth[a*x])*x^5), x, 11, 4*a^4*Sqrt[c - c/(a*x)] + (2*a^4*(c - c/(a*x))^(3/2))/(3*c) + (2*a^4*(c - c/(a*x))^(5/2))/(5*c^2) - (2*a^4*(c - c/(a*x))^(7/2))/(7*c^3) + (2*a^4*(c - c/(a*x))^(9/2))/(9*c^4) - 4*Sqrt[2]*a^4*Sqrt[c]*ArcTanh[Sqrt[c - c/(a*x)]/(Sqrt[2]*Sqrt[c])]}


{(Sqrt[c - c/(a*x)]*x^3)/E^(3*ArcCoth[a*x]), x, 9, -((1115*Sqrt[c - c/(a*x)])/(64*a^4*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])) - (1115*Sqrt[c - c/(a*x)]*x)/(192*a^3*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]) + (223*Sqrt[c - c/(a*x)]*x^2)/(96*a^2*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]) - (25*Sqrt[c - c/(a*x)]*x^3)/(24*a*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]) + (Sqrt[c - c/(a*x)]*x^4)/(4*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]) + (1115*Sqrt[c - c/(a*x)]*ArcTanh[Sqrt[1 + 1/(a*x)]])/(64*a^4*Sqrt[1 - 1/(a*x)])}
{(Sqrt[c - c/(a*x)]*x^2)/E^(3*ArcCoth[a*x]), x, 8, (119*Sqrt[c - c/(a*x)])/(8*a^3*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]) + (119*Sqrt[c - c/(a*x)]*x)/(24*a^2*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]) - (19*Sqrt[c - c/(a*x)]*x^2)/(12*a*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]) + (Sqrt[c - c/(a*x)]*x^3)/(3*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]) - (119*Sqrt[c - c/(a*x)]*ArcTanh[Sqrt[1 + 1/(a*x)]])/(8*a^3*Sqrt[1 - 1/(a*x)])}
{(Sqrt[c - c/(a*x)]*x)/E^(3*ArcCoth[a*x]), x, 7, (-47*Sqrt[c - c/(a*x)])/(4*a^2*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]) - (13*Sqrt[c - c/(a*x)]*x)/(4*a*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]) + (Sqrt[c - c/(a*x)]*x^2)/(2*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]) + (47*Sqrt[c - c/(a*x)]*ArcTanh[Sqrt[1 + 1/(a*x)]])/(4*a^2*Sqrt[1 - 1/(a*x)])}
{Sqrt[c - c/(a*x)]/E^(3*ArcCoth[a*x]), x, 6, (9*Sqrt[c - c/(a*x)])/(a*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]) + (Sqrt[c - c/(a*x)]*x)/(Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]) - (7*Sqrt[c - c/(a*x)]*ArcTanh[Sqrt[1 + 1/(a*x)]])/(a*Sqrt[1 - 1/(a*x)])}
{Sqrt[c - c/(a*x)]/(E^(3*ArcCoth[a*x])*x), x, 6, (-8*Sqrt[c - c/(a*x)])/(Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]) - (2*Sqrt[1 + 1/(a*x)]*Sqrt[c - c/(a*x)])/Sqrt[1 - 1/(a*x)] + (2*Sqrt[c - c/(a*x)]*ArcTanh[Sqrt[1 + 1/(a*x)]])/Sqrt[1 - 1/(a*x)]}
{Sqrt[c - c/(a*x)]/(E^(3*ArcCoth[a*x])*x^2), x, 4, (64*a*Sqrt[c - c/(a*x)])/(3*Sqrt[1 - 1/(a^2*x^2)]) - (16*a*(c - c/(a*x))^(3/2))/(3*c*Sqrt[1 - 1/(a^2*x^2)]) - (2*a*(c - c/(a*x))^(5/2))/(3*c^2*Sqrt[1 - 1/(a^2*x^2)])}
{Sqrt[c - c/(a*x)]/(E^(3*ArcCoth[a*x])*x^3), x, 5, -((224*a^2*c*Sqrt[1 - 1/(a^2*x^2)])/(15*Sqrt[c - c/(a*x)])) - (56/15)*a^2*Sqrt[1 - 1/(a^2*x^2)]*Sqrt[c - c/(a*x)] - (7*a^2*Sqrt[1 - 1/(a^2*x^2)]*(c - c/(a*x))^(3/2))/(5*c) - (a^2*(c - c/(a*x))^(7/2))/(c^3*Sqrt[1 - 1/(a^2*x^2)])}
{Sqrt[c - c/(a*x)]/(E^(3*ArcCoth[a*x])*x^4), x, 6, (1888*a^3*c*Sqrt[1 - 1/(a^2*x^2)])/(105*Sqrt[c - c/(a*x)]) + (472/105)*a^3*Sqrt[1 - 1/(a^2*x^2)]*Sqrt[c - c/(a*x)] + (59*a^3*Sqrt[1 - 1/(a^2*x^2)]*(c - c/(a*x))^(3/2))/(35*c) + (2*a^3*Sqrt[1 - 1/(a^2*x^2)]*(c - c/(a*x))^(5/2))/(7*c^2) + (a^3*(c - c/(a*x))^(7/2))/(c^3*Sqrt[1 - 1/(a^2*x^2)])}
{Sqrt[c - c/(a*x)]/(E^(3*ArcCoth[a*x])*x^5), x, 4, -((8*a^4*Sqrt[c - c/(a*x)])/(Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])) - (32*a^4*Sqrt[1 + 1/(a*x)]*Sqrt[c - c/(a*x)])/Sqrt[1 - 1/(a*x)] + (50*a^4*(1 + 1/(a*x))^(3/2)*Sqrt[c - c/(a*x)])/(3*Sqrt[1 - 1/(a*x)]) - (38*a^4*(1 + 1/(a*x))^(5/2)*Sqrt[c - c/(a*x)])/(5*Sqrt[1 - 1/(a*x)]) + (2*a^4*(1 + 1/(a*x))^(7/2)*Sqrt[c - c/(a*x)])/Sqrt[1 - 1/(a*x)] - (2*a^4*(1 + 1/(a*x))^(9/2)*Sqrt[c - c/(a*x)])/(9*Sqrt[1 - 1/(a*x)])}


(* ::Subsection::Closed:: *)
(*Integrands of the form E^(n ArcCoth[a x]) (c-c/(a x))^p with n symbolic*)


{E^(n*ArcCoth[a*x])*(c - c/(a*x)), x, 5, c*(1 - 1/(a*x))^(1 - n/2)*(1 + 1/(a*x))^(n/2)*x - (2*c*(1 - n)*(1 + 1/(a*x))^(n/2)*Hypergeometric2F1[1, n/2, (2 + n)/2, (a + 1/x)/(a - 1/x)])/((1 - 1/(a*x))^(n/2)*(a*n)) - (2^(n/2)*c*(1 - 1/(a*x))^(1 - n/2)*Hypergeometric2F1[1 - n/2, 1 - n/2, 2 - n/2, (a - 1/x)/(2*a)])/(a*(2 - n))}
{E^(n*ArcCoth[a*x])/(c - c/(a*x)), x, 3, ((1 + 1/(a*x))^((2 + n)/2)*x)/((1 - 1/(a*x))^(n/2)*c) - (2*(1 + n)*(1 + 1/(a*x))^(n/2)*Hypergeometric2F1[1, -(n/2), 1 - n/2, (a - 1/x)/(a + 1/x)])/((1 - 1/(a*x))^(n/2)*(a*c*n))}
{E^(n*ArcCoth[a*x])/(c - c/(a*x))^2, x, 5, -(((3 + n)*(1 - 1/(a*x))^(-1 - n/2)*(1 + 1/(a*x))^((2 + n)/2))/(a*c^2*(2 + n))) + ((1 - 1/(a*x))^(-1 - n/2)*(1 + 1/(a*x))^((2 + n)/2)*x)/c^2 - (2*(2 + n)*(1 + 1/(a*x))^(n/2)*Hypergeometric2F1[1, -(n/2), 1 - n/2, (a - 1/x)/(a + 1/x)])/((1 - 1/(a*x))^(n/2)*(a*c^2*n))}


{E^(n*ArcCoth[a*x])*(c - c/(a*x))^(3/2), x, 3, -((2^(5/2 - n/2)*(1 + 1/(a*x))^((2 + n)/2)*(c - c/(a*x))^(3/2)*AppellF1[(2 + n)/2, (1/2)*(-3 + n), 2, (4 + n)/2, (a + 1/x)/(2*a), 1 + 1/(a*x)])/(a*(2 + n)*(1 - 1/(a*x))^(3/2)))}
{E^(n*ArcCoth[a*x])*Sqrt[c - c/(a*x)], x, 3, -((2^(3/2 - n/2)*(1 + 1/(a*x))^((2 + n)/2)*Sqrt[c - c/(a*x)]*AppellF1[(2 + n)/2, (1/2)*(-1 + n), 2, (4 + n)/2, (a + 1/x)/(2*a), 1 + 1/(a*x)])/(a*(2 + n)*Sqrt[1 - 1/(a*x)]))}
{E^(n*ArcCoth[a*x])/Sqrt[c - c/(a*x)], x, 3, -((2^(1/2 - n/2)*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^((2 + n)/2)*AppellF1[(2 + n)/2, (1 + n)/2, 2, (4 + n)/2, (a + 1/x)/(2*a), 1 + 1/(a*x)])/(a*(2 + n)*Sqrt[c - c/(a*x)]))}
{E^(n*ArcCoth[a*x])/(c - c/(a*x))^(3/2), x, 3, -((2^(-(1/2) - n/2)*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^((2 + n)/2)*AppellF1[(2 + n)/2, (3 + n)/2, 2, (4 + n)/2, (a + 1/x)/(2*a), 1 + 1/(a*x)])/(a*(2 + n)*(c - c/(a*x))^(3/2)))}


(* ::Subsection::Closed:: *)
(*Integrands of the form E^(n ArcCoth[a x]) (c-c/(a x))^p with p symbolic*)


{E^(n*ArcCoth[a*x])*(c - c/(a*x))^p, x, 3, -((2^(1 - n/2 + p)*(1 + 1/(a*x))^((2 + n)/2)*(c - c/(a*x))^p*AppellF1[(2 + n)/2, (1/2)*(n - 2*p), 2, (4 + n)/2, (a + 1/x)/(2*a), 1 + 1/(a*x)])/((1 - 1/(a*x))^p*(a*(2 + n))))}


{(c - c/(a*x))^p*E^(2*p*ArcCoth[a*x]), x, 3, -(((1 + 1/(a*x))^(1 + p)*(c - c/(a*x))^p*Hypergeometric2F1[2, 1 + p, 2 + p, 1 + 1/(a*x)])/((1 - 1/(a*x))^p*(a*(1 + p))))}
{(c - c/(a*x))^p/E^(2*p*ArcCoth[a*x]), x, 3, -((4^p*(1 + 1/(a*x))^(1 - p)*(c - c/(a*x))^p*AppellF1[1 - p, -2*p, 2, 2 - p, (a + 1/x)/(2*a), 1 + 1/(a*x)])/((1 - 1/(a*x))^p*(a*(1 - p))))}


{(c - c/(a*x))^p*E^(2*ArcCoth[a*x]), x, 7, (c - c/(a*x))^p*x + ((2 - p)*(c - c/(a*x))^p*Hypergeometric2F1[1, p, 1 + p, 1 - 1/(a*x)])/(a*p)}
{(c - c/(a*x))^p*E^ArcCoth[a*x], x, 3, -((2^(1/2 + p)*(1 + 1/(a*x))^(3/2)*(c - c/(a*x))^p*AppellF1[3/2, 1/2 - p, 2, 5/2, (a + 1/x)/(2*a), 1 + 1/(a*x)])/((1 - 1/(a*x))^p*(3*a)))}
{(c - c/(a*x))^p/E^ArcCoth[a*x], x, 3, -((2^(3/2 + p)*Sqrt[1 + 1/(a*x)]*(c - c/(a*x))^p*AppellF1[1/2, -(1/2) - p, 2, 3/2, (a + 1/x)/(2*a), 1 + 1/(a*x)])/((1 - 1/(a*x))^p*a))}
{(c - c/(a*x))^p/E^(2*ArcCoth[a*x]), x, 9, ((c - c/(a*x))^(2 + p)*x)/c^2 + ((c - c/(a*x))^(2 + p)*Hypergeometric2F1[1, 2 + p, 3 + p, (a - 1/x)/(2*a)])/(2*a*c^2*(2 + p)) - ((c - c/(a*x))^(2 + p)*Hypergeometric2F1[1, 2 + p, 3 + p, 1 - 1/(a*x)])/(a*c^2)}


(* ::Section::Closed:: *)
(*Integrands of the form u E^(n ArcCoth[a x]) (c-c a^2 x^2)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form E^(n ArcCoth[a x]) (c-c a^2 x^2)^p*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{E^ArcCoth[a*x]*(c - a^2*c*x^2)^4, x, 13, (35/128)*c^4*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x + (35/384)*a*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2)*x^2 + (7/192)*a^2*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(5/2)*x^3 + (1/64)*a^3*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(7/2)*x^4 + (1/144)*a^4*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(9/2)*x^5 - (5/144)*a^5*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(11/2)*x^6 + (5/72)*a^6*c^4*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(11/2)*x^7 - (7/72)*a^7*c^4*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(11/2)*x^8 + (1/9)*a^8*c^4*(1 - 1/(a*x))^(7/2)*(1 + 1/(a*x))^(11/2)*x^9 + (35*c^4*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/(128*a)}
{E^ArcCoth[a*x]*(c - a^2*c*x^2)^3, x, 11, (5/16)*c^3*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x + (5/48)*a*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2)*x^2 + (1/24)*a^2*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(5/2)*x^3 + (1/56)*a^3*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(7/2)*x^4 - (1/14)*a^4*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(9/2)*x^5 + (5/42)*a^5*c^3*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(9/2)*x^6 - (1/7)*a^6*c^3*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(9/2)*x^7 + (5*c^3*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/(16*a)}
{E^ArcCoth[a*x]*(c - a^2*c*x^2)^2, x, 9, (3/8)*c^2*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x + (1/8)*a*c^2*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2)*x^2 + (1/20)*a^2*c^2*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(5/2)*x^3 - (3/20)*a^3*c^2*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(7/2)*x^4 + (1/5)*a^4*c^2*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(7/2)*x^5 + (3*c^2*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/(8*a)}
{E^ArcCoth[a*x]*(c - a^2*c*x^2), x, 7, (1/2)*c*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x + (1/6)*a*c*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2)*x^2 - (1/3)*a^2*c*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(5/2)*x^3 + (c*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/(2*a)}
{E^ArcCoth[a*x]/(c - a^2*c*x^2), x, 1, E^ArcCoth[a*x]/(a*c)}
{E^ArcCoth[a*x]/(c - a^2*c*x^2)^2, x, 2, (2*E^ArcCoth[a*x])/(3*a*c^2) - (E^ArcCoth[a*x]*(1 - 2*a*x))/(3*a*c^2*(1 - a^2*x^2))}
{E^ArcCoth[a*x]/(c - a^2*c*x^2)^3, x, 3, (8*E^ArcCoth[a*x])/(15*a*c^3) - (E^ArcCoth[a*x]*(1 - 4*a*x))/(15*a*c^3*(1 - a^2*x^2)^2) - (4*E^ArcCoth[a*x]*(1 - 2*a*x))/(15*a*c^3*(1 - a^2*x^2))}
{E^ArcCoth[a*x]/(c - a^2*c*x^2)^4, x, 4, (16*E^ArcCoth[a*x])/(35*a*c^4) - (E^ArcCoth[a*x]*(1 - 6*a*x))/(35*a*c^4*(1 - a^2*x^2)^3) - (2*E^ArcCoth[a*x]*(1 - 4*a*x))/(35*a*c^4*(1 - a^2*x^2)^2) - (8*E^ArcCoth[a*x]*(1 - 2*a*x))/(35*a*c^4*(1 - a^2*x^2))}


{E^(2*ArcCoth[a*x])*(c - a^2*c*x^2)^5, x, 4, -((16*c^5*(1 + a*x)^7)/(7*a)) + (4*c^5*(1 + a*x)^8)/a - (8*c^5*(1 + a*x)^9)/(3*a) + (4*c^5*(1 + a*x)^10)/(5*a) - (c^5*(1 + a*x)^11)/(11*a)}
{E^(2*ArcCoth[a*x])*(c - a^2*c*x^2)^4, x, 4, -((4*c^4*(1 + a*x)^6)/(3*a)) + (12*c^4*(1 + a*x)^7)/(7*a) - (3*c^4*(1 + a*x)^8)/(4*a) + (c^4*(1 + a*x)^9)/(9*a)}
{E^(2*ArcCoth[a*x])*(c - a^2*c*x^2)^3, x, 4, -((4*c^3*(1 + a*x)^5)/(5*a)) + (2*c^3*(1 + a*x)^6)/(3*a) - (c^3*(1 + a*x)^7)/(7*a)}
{E^(2*ArcCoth[a*x])*(c - a^2*c*x^2)^2, x, 4, -((c^2*(1 + a*x)^4)/(2*a)) + (c^2*(1 + a*x)^5)/(5*a)}
{E^(2*ArcCoth[a*x])*(c - a^2*c*x^2)^1, x, 3, -((c*(1 + a*x)^3)/(3*a))}
{E^(2*ArcCoth[a*x])/(c - a^2*c*x^2)^1, x, 3, -(1/(a*c*(1 - a*x)))}
{E^(2*ArcCoth[a*x])/(c - a^2*c*x^2)^2, x, 5, -(1/(4*a*c^2*(1 - a*x)^2)) - 1/(4*a*c^2*(1 - a*x)) - ArcTanh[a*x]/(4*a*c^2)}
{E^(2*ArcCoth[a*x])/(c - a^2*c*x^2)^3, x, 5, -(1/(12*a*c^3*(1 - a*x)^3)) - 1/(8*a*c^3*(1 - a*x)^2) - 3/(16*a*c^3*(1 - a*x)) + 1/(16*a*c^3*(1 + a*x)) - ArcTanh[a*x]/(4*a*c^3)}
{E^(2*ArcCoth[a*x])/(c - a^2*c*x^2)^4, x, 5, -(1/(32*a*c^4*(1 - a*x)^4)) - 1/(16*a*c^4*(1 - a*x)^3) - 3/(32*a*c^4*(1 - a*x)^2) - 5/(32*a*c^4*(1 - a*x)) + 1/(64*a*c^4*(1 + a*x)^2) + 5/(64*a*c^4*(1 + a*x)) - (15*ArcTanh[a*x])/(64*a*c^4)}


{E^(3*ArcCoth[a*x])*(c - a^2*c*x^2)^4, x, 13, (-(55/128))*c^4*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x - (55/384)*a*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2)*x^2 - (11/192)*a^2*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(5/2)*x^3 - (11/448)*a^3*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(7/2)*x^4 - (11*a^4*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(9/2)*x^5)/1008 - (5*a^5*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(11/2)*x^6)/1008 + (5/168)*a^6*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(13/2)*x^7 - (5/72)*a^7*c^4*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(13/2)*x^8 + (1/9)*a^8*c^4*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(13/2)*x^9 - (55*c^4*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/(128*a)}
{E^(3*ArcCoth[a*x])*(c - a^2*c*x^2)^3, x, 11, (-(9/16))*c^3*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x - (3/16)*a*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2)*x^2 - (3/40)*a^2*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(5/2)*x^3 - (9/280)*a^3*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(7/2)*x^4 - (1/70)*a^4*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(9/2)*x^5 + (1/14)*a^5*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(11/2)*x^6 - (1/7)*a^6*c^3*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(11/2)*x^7 - (9*c^3*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/(16*a)}
{E^(3*ArcCoth[a*x])*(c - a^2*c*x^2)^2, x, 9, (-(7/8))*c^2*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x - (7/24)*a*c^2*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2)*x^2 - (7/60)*a^2*c^2*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(5/2)*x^3 - (1/20)*a^3*c^2*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(7/2)*x^4 + (1/5)*a^4*c^2*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(9/2)*x^5 - (7*c^2*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/(8*a)}
{E^(3*ArcCoth[a*x])*(c - a^2*c*x^2), x, 7, (-(5/2))*c*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x - (5/6)*a*c*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2)*x^2 - (1/3)*a^2*c*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(5/2)*x^3 - (5*c*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/(2*a)}
{E^(3*ArcCoth[a*x])/(c - a^2*c*x^2), x, 1, E^(3*ArcCoth[a*x])/(3*a*c)}
{E^(3*ArcCoth[a*x])/(c - a^2*c*x^2)^2, x, 2, -((2*E^(3*ArcCoth[a*x]))/(15*a*c^2)) + (E^(3*ArcCoth[a*x])*(3 - 2*a*x))/(5*a*c^2*(1 - a^2*x^2))}
{E^(3*ArcCoth[a*x])/(c - a^2*c*x^2)^3, x, 3, -((8*E^(3*ArcCoth[a*x]))/(35*a*c^3)) - (E^(3*ArcCoth[a*x])*(3 - 4*a*x))/(7*a*c^3*(1 - a^2*x^2)^2) + (12*E^(3*ArcCoth[a*x])*(3 - 2*a*x))/(35*a*c^3*(1 - a^2*x^2))}
{E^(3*ArcCoth[a*x])/(c - a^2*c*x^2)^4, x, 4, -((16*E^(3*ArcCoth[a*x]))/(63*a*c^4)) - (E^(3*ArcCoth[a*x])*(1 - 2*a*x))/(9*a*c^4*(1 - a^2*x^2)^3) - (10*E^(3*ArcCoth[a*x])*(3 - 4*a*x))/(63*a*c^4*(1 - a^2*x^2)^2) + (8*E^(3*ArcCoth[a*x])*(3 - 2*a*x))/(21*a*c^4*(1 - a^2*x^2))}


{E^(4*ArcCoth[a*x])*(c - a^2*c*x^2)^5, x, 4, (c^5*(1 + a*x)^8)/a - (4*c^5*(1 + a*x)^9)/(3*a) + (3*c^5*(1 + a*x)^10)/(5*a) - (c^5*(1 + a*x)^11)/(11*a)}
{E^(4*ArcCoth[a*x])*(c - a^2*c*x^2)^4, x, 4, (4*c^4*(1 + a*x)^7)/(7*a) - (c^4*(1 + a*x)^8)/(2*a) + (c^4*(1 + a*x)^9)/(9*a)}
{E^(4*ArcCoth[a*x])*(c - a^2*c*x^2)^3, x, 4, (c^3*(1 + a*x)^6)/(3*a) - (c^3*(1 + a*x)^7)/(7*a)}
{E^(4*ArcCoth[a*x])*(c - a^2*c*x^2)^2, x, 3, (c^2*(1 + a*x)^5)/(5*a)}
{E^(4*ArcCoth[a*x])*(c - a^2*c*x^2)^1, x, 4, -4*c*x - (c*(1 + a*x)^2)/a - (c*(1 + a*x)^3)/(3*a) - (8*c*Log[1 - a*x])/a}
{E^(4*ArcCoth[a*x])/(c - a^2*c*x^2)^1, x, 3, x/(c*(1 - a*x)^2)}
{E^(4*ArcCoth[a*x])/(c - a^2*c*x^2)^2, x, 3, 1/(3*a*c^2*(1 - a*x)^3)}
{E^(4*ArcCoth[a*x])/(c - a^2*c*x^2)^3, x, 5, 1/(8*a*c^3*(1 - a*x)^4) + 1/(12*a*c^3*(1 - a*x)^3) + 1/(16*a*c^3*(1 - a*x)^2) + 1/(16*a*c^3*(1 - a*x)) + ArcTanh[a*x]/(16*a*c^3)}
{E^(4*ArcCoth[a*x])/(c - a^2*c*x^2)^4, x, 5, 1/(20*a*c^4*(1 - a*x)^5) + 1/(16*a*c^4*(1 - a*x)^4) + 1/(16*a*c^4*(1 - a*x)^3) + 1/(16*a*c^4*(1 - a*x)^2) + 5/(64*a*c^4*(1 - a*x)) - 1/(64*a*c^4*(1 + a*x)) + (3*ArcTanh[a*x])/(32*a*c^4)}


(* ::Subsubsection::Closed:: *)
(*n<0*)


{(c - a^2*c*x^2)^4/E^ArcCoth[a*x], x, 13, (-(35/128))*c^4*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x - (35/384)*a*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2)*x^2 - (7/192)*a^2*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(5/2)*x^3 - (1/64)*a^3*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(7/2)*x^4 + (1/16)*a^4*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(9/2)*x^5 - (5/48)*a^5*c^4*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(9/2)*x^6 + (1/8)*a^6*c^4*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(9/2)*x^7 - (1/8)*a^7*c^4*(1 - 1/(a*x))^(7/2)*(1 + 1/(a*x))^(9/2)*x^8 + (1/9)*a^8*c^4*(1 - 1/(a*x))^(9/2)*(1 + 1/(a*x))^(9/2)*x^9 - (35*c^4*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/(128*a)}
{(c - a^2*c*x^2)^3/E^ArcCoth[a*x], x, 11, (-(5/16))*c^3*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x - (5/48)*a*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2)*x^2 - (1/24)*a^2*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(5/2)*x^3 + (1/8)*a^3*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(7/2)*x^4 - (1/6)*a^4*c^3*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(7/2)*x^5 + (1/6)*a^5*c^3*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(7/2)*x^6 - (1/7)*a^6*c^3*(1 - 1/(a*x))^(7/2)*(1 + 1/(a*x))^(7/2)*x^7 - (5*c^3*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/(16*a)}
{(c - a^2*c*x^2)^2/E^ArcCoth[a*x], x, 9, (-(3/8))*c^2*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x - (1/8)*a*c^2*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2)*x^2 + (1/4)*a^2*c^2*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(5/2)*x^3 - (1/4)*a^3*c^2*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(5/2)*x^4 + (1/5)*a^4*c^2*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(5/2)*x^5 - (3*c^2*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/(8*a)}
{(c - a^2*c*x^2)/E^ArcCoth[a*x], x, 7, (-(1/2))*c*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x + (1/2)*a*c*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2)*x^2 - (1/3)*a^2*c*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(3/2)*x^3 - (c*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/(2*a)}
{1/(E^ArcCoth[a*x]*(c - a^2*c*x^2)), x, 1, -(1/(a*c*E^ArcCoth[a*x]))}
{1/(E^ArcCoth[a*x]*(c - a^2*c*x^2)^2), x, 2, -(2/(E^ArcCoth[a*x]*(3*a*c^2))) + (1 + 2*a*x)/(E^ArcCoth[a*x]*(3*a*c^2*(1 - a^2*x^2)))}
{1/(E^ArcCoth[a*x]*(c - a^2*c*x^2)^3), x, 3, -(8/(E^ArcCoth[a*x]*(15*a*c^3))) + (1 + 4*a*x)/(E^ArcCoth[a*x]*(15*a*c^3*(1 - a^2*x^2)^2)) + (4*(1 + 2*a*x))/(E^ArcCoth[a*x]*(15*a*c^3*(1 - a^2*x^2)))}
{1/(E^ArcCoth[a*x]*(c - a^2*c*x^2)^4), x, 4, -(16/(E^ArcCoth[a*x]*(35*a*c^4))) + (1 + 6*a*x)/(E^ArcCoth[a*x]*(35*a*c^4*(1 - a^2*x^2)^3)) + (2*(1 + 4*a*x))/(E^ArcCoth[a*x]*(35*a*c^4*(1 - a^2*x^2)^2)) + (8*(1 + 2*a*x))/(E^ArcCoth[a*x]*(35*a*c^4*(1 - a^2*x^2)))}


{(c - a^2*c*x^2)^4/E^(2*ArcCoth[a*x]), x, 4, (4*c^4*(1 - a*x)^6)/(3*a) - (12*c^4*(1 - a*x)^7)/(7*a) + (3*c^4*(1 - a*x)^8)/(4*a) - (c^4*(1 - a*x)^9)/(9*a)}
{(c - a^2*c*x^2)^3/E^(2*ArcCoth[a*x]), x, 4, (4*c^3*(1 - a*x)^5)/(5*a) - (2*c^3*(1 - a*x)^6)/(3*a) + (c^3*(1 - a*x)^7)/(7*a)}
{(c - a^2*c*x^2)^2/E^(2*ArcCoth[a*x]), x, 4, (c^2*(1 - a*x)^4)/(2*a) - (c^2*(1 - a*x)^5)/(5*a)}
{(c - a^2*c*x^2)/E^(2*ArcCoth[a*x]), x, 3, (c*(1 - a*x)^3)/(3*a)}
{1/(E^(2*ArcCoth[a*x])*(c - a^2*c*x^2)), x, 3, 1/(a*c*(1 + a*x))}
{1/(E^(2*ArcCoth[a*x])*(c - a^2*c*x^2)^2), x, 5, 1/(4*a*c^2*(1 + a*x)^2) + 1/(4*a*c^2*(1 + a*x)) - ArcTanh[a*x]/(4*a*c^2)}
{1/(E^(2*ArcCoth[a*x])*(c - a^2*c*x^2)^3), x, 5, -(1/(16*a*c^3*(1 - a*x))) + 1/(12*a*c^3*(1 + a*x)^3) + 1/(8*a*c^3*(1 + a*x)^2) + 3/(16*a*c^3*(1 + a*x)) - ArcTanh[a*x]/(4*a*c^3)}
{1/(E^(2*ArcCoth[a*x])*(c - a^2*c*x^2)^4), x, 5, -(1/(64*a*c^4*(1 - a*x)^2)) - 5/(64*a*c^4*(1 - a*x)) + 1/(32*a*c^4*(1 + a*x)^4) + 1/(16*a*c^4*(1 + a*x)^3) + 3/(32*a*c^4*(1 + a*x)^2) + 5/(32*a*c^4*(1 + a*x)) - (15*ArcTanh[a*x])/(64*a*c^4)}


{(c - a^2*c*x^2)^4/E^(3*ArcCoth[a*x]), x, 13, (55/128)*c^4*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x + (55/384)*a*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2)*x^2 + (11/192)*a^2*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(5/2)*x^3 - (11/64)*a^3*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(7/2)*x^4 + (11/48)*a^4*c^4*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(7/2)*x^5 - (11/48)*a^5*c^4*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(7/2)*x^6 + (11/56)*a^6*c^4*(1 - 1/(a*x))^(7/2)*(1 + 1/(a*x))^(7/2)*x^7 - (11/72)*a^7*c^4*(1 - 1/(a*x))^(9/2)*(1 + 1/(a*x))^(7/2)*x^8 + (1/9)*a^8*c^4*(1 - 1/(a*x))^(11/2)*(1 + 1/(a*x))^(7/2)*x^9 + (55*c^4*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/(128*a)}
{(c - a^2*c*x^2)^3/E^(3*ArcCoth[a*x]), x, 11, (9/16)*c^3*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x + (3/16)*a*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2)*x^2 - (3/8)*a^2*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(5/2)*x^3 + (3/8)*a^3*c^3*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(5/2)*x^4 - (3/10)*a^4*c^3*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(5/2)*x^5 + (3/14)*a^5*c^3*(1 - 1/(a*x))^(7/2)*(1 + 1/(a*x))^(5/2)*x^6 - (1/7)*a^6*c^3*(1 - 1/(a*x))^(9/2)*(1 + 1/(a*x))^(5/2)*x^7 + (9*c^3*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/(16*a)}
{(c - a^2*c*x^2)^2/E^(3*ArcCoth[a*x]), x, 9, (7/8)*c^2*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x - (7/8)*a*c^2*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2)*x^2 + (7/12)*a^2*c^2*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(3/2)*x^3 - (7/20)*a^3*c^2*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(3/2)*x^4 + (1/5)*a^4*c^2*(1 - 1/(a*x))^(7/2)*(1 + 1/(a*x))^(3/2)*x^5 + (7*c^2*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/(8*a)}
{(c - a^2*c*x^2)/E^(3*ArcCoth[a*x]), x, 7, (-(5/2))*c*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]*x + (5/6)*a*c*(1 - 1/(a*x))^(3/2)*Sqrt[1 + 1/(a*x)]*x^2 - (1/3)*a^2*c*(1 - 1/(a*x))^(5/2)*Sqrt[1 + 1/(a*x)]*x^3 + (5*c*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/(2*a)}
{1/(E^(3*ArcCoth[a*x])*(c - a^2*c*x^2)), x, 1, -1/(3*a*c*E^(3*ArcCoth[a*x]))}
{1/(E^(3*ArcCoth[a*x])*(c - a^2*c*x^2)^2), x, 2, 2/(E^(3*ArcCoth[a*x])*(15*a*c^2)) - (3 + 2*a*x)/(E^(3*ArcCoth[a*x])*(5*a*c^2*(1 - a^2*x^2)))}
{1/(E^(3*ArcCoth[a*x])*(c - a^2*c*x^2)^3), x, 3, 8/(E^(3*ArcCoth[a*x])*(35*a*c^3)) + (3 + 4*a*x)/(E^(3*ArcCoth[a*x])*(7*a*c^3*(1 - a^2*x^2)^2)) - (12*(3 + 2*a*x))/(E^(3*ArcCoth[a*x])*(35*a*c^3*(1 - a^2*x^2)))}
{1/(E^(3*ArcCoth[a*x])*(c - a^2*c*x^2)^4), x, 4, 16/(E^(3*ArcCoth[a*x])*(63*a*c^4)) + (1 + 2*a*x)/(E^(3*ArcCoth[a*x])*(9*a*c^4*(1 - a^2*x^2)^3)) + (10*(3 + 4*a*x))/(E^(3*ArcCoth[a*x])*(63*a*c^4*(1 - a^2*x^2)^2)) - (8*(3 + 2*a*x))/(E^(3*ArcCoth[a*x])*(21*a*c^4*(1 - a^2*x^2)))}


(* ::Subsection::Closed:: *)
(*Integrands of the form E^(n ArcCoth[a x])  (c-c a^2 x^2)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{E^ArcCoth[a*x]*(c - a^2*c*x^2)^(9/2), x, 4, (8*(1 + a*x)^6*(c - a^2*c*x^2)^(9/2))/(3*a^10*(1 - 1/(a^2*x^2))^(9/2)*x^9) - (32*(1 + a*x)^7*(c - a^2*c*x^2)^(9/2))/(7*a^10*(1 - 1/(a^2*x^2))^(9/2)*x^9) + (3*(1 + a*x)^8*(c - a^2*c*x^2)^(9/2))/(a^10*(1 - 1/(a^2*x^2))^(9/2)*x^9) - (8*(1 + a*x)^9*(c - a^2*c*x^2)^(9/2))/(9*a^10*(1 - 1/(a^2*x^2))^(9/2)*x^9) + ((1 + a*x)^10*(c - a^2*c*x^2)^(9/2))/(10*a^10*(1 - 1/(a^2*x^2))^(9/2)*x^9)}
{E^ArcCoth[a*x]*(c - a^2*c*x^2)^(7/2), x, 4, -((8*(1 + a*x)^5*(c - a^2*c*x^2)^(7/2))/(5*a^8*(1 - 1/(a^2*x^2))^(7/2)*x^7)) + (2*(1 + a*x)^6*(c - a^2*c*x^2)^(7/2))/(a^8*(1 - 1/(a^2*x^2))^(7/2)*x^7) - (6*(1 + a*x)^7*(c - a^2*c*x^2)^(7/2))/(7*a^8*(1 - 1/(a^2*x^2))^(7/2)*x^7) + ((1 + a*x)^8*(c - a^2*c*x^2)^(7/2))/(8*a^8*(1 - 1/(a^2*x^2))^(7/2)*x^7)}
{E^ArcCoth[a*x]*(c - a^2*c*x^2)^(5/2), x, 4, ((1 + a*x)^4*(c - a^2*c*x^2)^(5/2))/(a^6*(1 - 1/(a^2*x^2))^(5/2)*x^5) - (4*(1 + a*x)^5*(c - a^2*c*x^2)^(5/2))/(5*a^6*(1 - 1/(a^2*x^2))^(5/2)*x^5) + ((1 + a*x)^6*(c - a^2*c*x^2)^(5/2))/(6*a^6*(1 - 1/(a^2*x^2))^(5/2)*x^5)}
{E^ArcCoth[a*x]*(c - a^2*c*x^2)^(3/2), x, 4, -((2*(1 + a*x)^3*(c - a^2*c*x^2)^(3/2))/(3*a^4*(1 - 1/(a^2*x^2))^(3/2)*x^3)) + ((1 + a*x)^4*(c - a^2*c*x^2)^(3/2))/(4*a^4*(1 - 1/(a^2*x^2))^(3/2)*x^3)}
{E^ArcCoth[a*x]*Sqrt[c - a^2*c*x^2], x, 3, Sqrt[c - a^2*c*x^2]/(a*Sqrt[1 - 1/(a^2*x^2)]) + (x*Sqrt[c - a^2*c*x^2])/(2*Sqrt[1 - 1/(a^2*x^2)])}
{E^ArcCoth[a*x]/Sqrt[c - a^2*c*x^2], x, 3, (Sqrt[1 - 1/(a^2*x^2)]*x*Log[1 - a*x])/Sqrt[c - a^2*c*x^2]}
{E^ArcCoth[a*x]/(c - a^2*c*x^2)^(3/2), x, 5, (a^2*(1 - 1/(a^2*x^2))^(3/2)*x^3)/(2*(1 - a*x)*(c - a^2*c*x^2)^(3/2)) + (a^2*(1 - 1/(a^2*x^2))^(3/2)*x^3*ArcTanh[a*x])/(2*(c - a^2*c*x^2)^(3/2))}
{E^ArcCoth[a*x]/(c - a^2*c*x^2)^(5/2), x, 5, -((a^4*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(8*(1 - a*x)^2*(c - a^2*c*x^2)^(5/2))) - (a^4*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(4*(1 - a*x)*(c - a^2*c*x^2)^(5/2)) + (a^4*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(8*(1 + a*x)*(c - a^2*c*x^2)^(5/2)) - (3*a^4*(1 - 1/(a^2*x^2))^(5/2)*x^5*ArcTanh[a*x])/(8*(c - a^2*c*x^2)^(5/2))}
{E^ArcCoth[a*x]/(c - a^2*c*x^2)^(7/2), x, 5, (a^6*(1 - 1/(a^2*x^2))^(7/2)*x^7)/(24*(1 - a*x)^3*(c - a^2*c*x^2)^(7/2)) + (3*a^6*(1 - 1/(a^2*x^2))^(7/2)*x^7)/(32*(1 - a*x)^2*(c - a^2*c*x^2)^(7/2)) + (3*a^6*(1 - 1/(a^2*x^2))^(7/2)*x^7)/(16*(1 - a*x)*(c - a^2*c*x^2)^(7/2)) - (a^6*(1 - 1/(a^2*x^2))^(7/2)*x^7)/(32*(1 + a*x)^2*(c - a^2*c*x^2)^(7/2)) - (a^6*(1 - 1/(a^2*x^2))^(7/2)*x^7)/(8*(1 + a*x)*(c - a^2*c*x^2)^(7/2)) + (5*a^6*(1 - 1/(a^2*x^2))^(7/2)*x^7*ArcTanh[a*x])/(16*(c - a^2*c*x^2)^(7/2))}


{E^(2*ArcCoth[a*x])*(c - a^2*c*x^2)^(9/2), x, 10, (-(77/256))*c^4*x*Sqrt[c - a^2*c*x^2] - (77/384)*c^3*x*(c - a^2*c*x^2)^(3/2) - (77/480)*c^2*x*(c - a^2*c*x^2)^(5/2) - (11/80)*c*x*(c - a^2*c*x^2)^(7/2) + (11*(c - a^2*c*x^2)^(9/2))/(90*a) + ((1 + a*x)*(c - a^2*c*x^2)^(9/2))/(10*a) - (77*c^(9/2)*ArcTan[(a*Sqrt[c]*x)/Sqrt[c - a^2*c*x^2]])/(256*a)}
{E^(2*ArcCoth[a*x])*(c - a^2*c*x^2)^(7/2), x, 9, (-(45/128))*c^3*x*Sqrt[c - a^2*c*x^2] - (15/64)*c^2*x*(c - a^2*c*x^2)^(3/2) - (3/16)*c*x*(c - a^2*c*x^2)^(5/2) + (9*(c - a^2*c*x^2)^(7/2))/(56*a) + ((1 + a*x)*(c - a^2*c*x^2)^(7/2))/(8*a) - (45*c^(7/2)*ArcTan[(a*Sqrt[c]*x)/Sqrt[c - a^2*c*x^2]])/(128*a)}
{E^(2*ArcCoth[a*x])*(c - a^2*c*x^2)^(5/2), x, 8, (-(7/16))*c^2*x*Sqrt[c - a^2*c*x^2] - (7/24)*c*x*(c - a^2*c*x^2)^(3/2) + (7*(c - a^2*c*x^2)^(5/2))/(30*a) + ((1 + a*x)*(c - a^2*c*x^2)^(5/2))/(6*a) - (7*c^(5/2)*ArcTan[(a*Sqrt[c]*x)/Sqrt[c - a^2*c*x^2]])/(16*a)}
{E^(2*ArcCoth[a*x])*(c - a^2*c*x^2)^(3/2), x, 7, (-(5/8))*c*x*Sqrt[c - a^2*c*x^2] + (5*(c - a^2*c*x^2)^(3/2))/(12*a) + ((1 + a*x)*(c - a^2*c*x^2)^(3/2))/(4*a) - (5*c^(3/2)*ArcTan[(a*Sqrt[c]*x)/Sqrt[c - a^2*c*x^2]])/(8*a)}
{E^(2*ArcCoth[a*x])*Sqrt[c - a^2*c*x^2], x, 6, (3*Sqrt[c - a^2*c*x^2])/(2*a) + ((1 + a*x)*Sqrt[c - a^2*c*x^2])/(2*a) - (3*Sqrt[c]*ArcTan[(a*Sqrt[c]*x)/Sqrt[c - a^2*c*x^2]])/(2*a)}
{E^(2*ArcCoth[a*x])/Sqrt[c - a^2*c*x^2], x, 5, -((2*(1 + a*x))/(a*Sqrt[c - a^2*c*x^2])) + ArcTan[(a*Sqrt[c]*x)/Sqrt[c - a^2*c*x^2]]/(a*Sqrt[c])}
{E^(2*ArcCoth[a*x])/(c - a^2*c*x^2)^(3/2), x, 4, -((2*(1 + a*x))/(3*a*(c - a^2*c*x^2)^(3/2))) - x/(3*c*Sqrt[c - a^2*c*x^2])}
{E^(2*ArcCoth[a*x])/(c - a^2*c*x^2)^(5/2), x, 5, -((2*(1 + a*x))/(5*a*(c - a^2*c*x^2)^(5/2))) - x/(5*c*(c - a^2*c*x^2)^(3/2)) - (2*x)/(5*c^2*Sqrt[c - a^2*c*x^2])}
{E^(2*ArcCoth[a*x])/(c - a^2*c*x^2)^(7/2), x, 6, -((2*(1 + a*x))/(7*a*(c - a^2*c*x^2)^(7/2))) - x/(7*c*(c - a^2*c*x^2)^(5/2)) - (4*x)/(21*c^2*(c - a^2*c*x^2)^(3/2)) - (8*x)/(21*c^3*Sqrt[c - a^2*c*x^2])}
{E^(2*ArcCoth[a*x])/(c - a^2*c*x^2)^(9/2), x, 7, -((2*(1 + a*x))/(9*a*(c - a^2*c*x^2)^(9/2))) - x/(9*c*(c - a^2*c*x^2)^(7/2)) - (2*x)/(15*c^2*(c - a^2*c*x^2)^(5/2)) - (8*x)/(45*c^3*(c - a^2*c*x^2)^(3/2)) - (16*x)/(45*c^4*Sqrt[c - a^2*c*x^2])}


{E^(3*ArcCoth[a*x])*(c - a^2*c*x^2)^(9/2), x, 4, -((8*(1 + a*x)^7*(c - a^2*c*x^2)^(9/2))/(7*a^10*(1 - 1/(a^2*x^2))^(9/2)*x^9)) + (3*(1 + a*x)^8*(c - a^2*c*x^2)^(9/2))/(2*a^10*(1 - 1/(a^2*x^2))^(9/2)*x^9) - (2*(1 + a*x)^9*(c - a^2*c*x^2)^(9/2))/(3*a^10*(1 - 1/(a^2*x^2))^(9/2)*x^9) + ((1 + a*x)^10*(c - a^2*c*x^2)^(9/2))/(10*a^10*(1 - 1/(a^2*x^2))^(9/2)*x^9)}
{E^(3*ArcCoth[a*x])*(c - a^2*c*x^2)^(7/2), x, 4, (2*(1 + a*x)^6*(c - a^2*c*x^2)^(7/2))/(3*a^8*(1 - 1/(a^2*x^2))^(7/2)*x^7) - (4*(1 + a*x)^7*(c - a^2*c*x^2)^(7/2))/(7*a^8*(1 - 1/(a^2*x^2))^(7/2)*x^7) + ((1 + a*x)^8*(c - a^2*c*x^2)^(7/2))/(8*a^8*(1 - 1/(a^2*x^2))^(7/2)*x^7)}
{E^(3*ArcCoth[a*x])*(c - a^2*c*x^2)^(5/2), x, 4, -((2*(1 + a*x)^5*(c - a^2*c*x^2)^(5/2))/(5*a^6*(1 - 1/(a^2*x^2))^(5/2)*x^5)) + ((1 + a*x)^6*(c - a^2*c*x^2)^(5/2))/(6*a^6*(1 - 1/(a^2*x^2))^(5/2)*x^5)}
{E^(3*ArcCoth[a*x])*(c - a^2*c*x^2)^(3/2), x, 3, ((1 + a*x)^4*(c - a^2*c*x^2)^(3/2))/(4*a^4*(1 - 1/(a^2*x^2))^(3/2)*x^3)}
{E^(3*ArcCoth[a*x])*Sqrt[c - a^2*c*x^2], x, 4, (3*Sqrt[c - a^2*c*x^2])/(a*Sqrt[1 - 1/(a^2*x^2)]) + (x*Sqrt[c - a^2*c*x^2])/(2*Sqrt[1 - 1/(a^2*x^2)]) + (4*Sqrt[c - a^2*c*x^2]*Log[1 - a*x])/(a^2*Sqrt[1 - 1/(a^2*x^2)]*x)}
{E^(3*ArcCoth[a*x])/Sqrt[c - a^2*c*x^2], x, 4, (2*Sqrt[1 - 1/(a^2*x^2)]*x)/((1 - a*x)*Sqrt[c - a^2*c*x^2]) + (Sqrt[1 - 1/(a^2*x^2)]*x*Log[1 - a*x])/Sqrt[c - a^2*c*x^2]}
{E^(3*ArcCoth[a*x])/(c - a^2*c*x^2)^(3/2), x, 3, -((a^2*(1 - 1/(a^2*x^2))^(3/2)*x^3)/(2*(1 - a*x)^2*(c - a^2*c*x^2)^(3/2)))}
{E^(3*ArcCoth[a*x])/(c - a^2*c*x^2)^(5/2), x, 5, (a^4*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(6*(1 - a*x)^3*(c - a^2*c*x^2)^(5/2)) + (a^4*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(8*(1 - a*x)^2*(c - a^2*c*x^2)^(5/2)) + (a^4*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(8*(1 - a*x)*(c - a^2*c*x^2)^(5/2)) + (a^4*(1 - 1/(a^2*x^2))^(5/2)*x^5*ArcTanh[a*x])/(8*(c - a^2*c*x^2)^(5/2))}
{E^(3*ArcCoth[a*x])/(c - a^2*c*x^2)^(7/2), x, 5, -((a^6*(1 - 1/(a^2*x^2))^(7/2)*x^7)/(16*(1 - a*x)^4*(c - a^2*c*x^2)^(7/2))) - (a^6*(1 - 1/(a^2*x^2))^(7/2)*x^7)/(12*(1 - a*x)^3*(c - a^2*c*x^2)^(7/2)) - (3*a^6*(1 - 1/(a^2*x^2))^(7/2)*x^7)/(32*(1 - a*x)^2*(c - a^2*c*x^2)^(7/2)) - (a^6*(1 - 1/(a^2*x^2))^(7/2)*x^7)/(8*(1 - a*x)*(c - a^2*c*x^2)^(7/2)) + (a^6*(1 - 1/(a^2*x^2))^(7/2)*x^7)/(32*(1 + a*x)*(c - a^2*c*x^2)^(7/2)) - (5*a^6*(1 - 1/(a^2*x^2))^(7/2)*x^7*ArcTanh[a*x])/(32*(c - a^2*c*x^2)^(7/2))}


(* ::Subsubsection::Closed:: *)
(*n<0*)


{(c - a^2*c*x^2)^(9/2)/E^ArcCoth[a*x], x, 4, (8*(1 - a*x)^6*(c - a^2*c*x^2)^(9/2))/(3*a^10*(1 - 1/(a^2*x^2))^(9/2)*x^9) - (32*(1 - a*x)^7*(c - a^2*c*x^2)^(9/2))/(7*a^10*(1 - 1/(a^2*x^2))^(9/2)*x^9) + (3*(1 - a*x)^8*(c - a^2*c*x^2)^(9/2))/(a^10*(1 - 1/(a^2*x^2))^(9/2)*x^9) - (8*(1 - a*x)^9*(c - a^2*c*x^2)^(9/2))/(9*a^10*(1 - 1/(a^2*x^2))^(9/2)*x^9) + ((1 - a*x)^10*(c - a^2*c*x^2)^(9/2))/(10*a^10*(1 - 1/(a^2*x^2))^(9/2)*x^9)}
{(c - a^2*c*x^2)^(7/2)/E^ArcCoth[a*x], x, 4, -((8*(1 - a*x)^5*(c - a^2*c*x^2)^(7/2))/(5*a^8*(1 - 1/(a^2*x^2))^(7/2)*x^7)) + (2*(1 - a*x)^6*(c - a^2*c*x^2)^(7/2))/(a^8*(1 - 1/(a^2*x^2))^(7/2)*x^7) - (6*(1 - a*x)^7*(c - a^2*c*x^2)^(7/2))/(7*a^8*(1 - 1/(a^2*x^2))^(7/2)*x^7) + ((1 - a*x)^8*(c - a^2*c*x^2)^(7/2))/(8*a^8*(1 - 1/(a^2*x^2))^(7/2)*x^7)}
{(c - a^2*c*x^2)^(5/2)/E^ArcCoth[a*x], x, 4, ((1 - a*x)^4*(c - a^2*c*x^2)^(5/2))/(a^6*(1 - 1/(a^2*x^2))^(5/2)*x^5) - (4*(1 - a*x)^5*(c - a^2*c*x^2)^(5/2))/(5*a^6*(1 - 1/(a^2*x^2))^(5/2)*x^5) + ((1 - a*x)^6*(c - a^2*c*x^2)^(5/2))/(6*a^6*(1 - 1/(a^2*x^2))^(5/2)*x^5)}
{(c - a^2*c*x^2)^(3/2)/E^ArcCoth[a*x], x, 4, -((2*(1 - a*x)^3*(c - a^2*c*x^2)^(3/2))/(3*a^4*(1 - 1/(a^2*x^2))^(3/2)*x^3)) + ((1 - a*x)^4*(c - a^2*c*x^2)^(3/2))/(4*a^4*(1 - 1/(a^2*x^2))^(3/2)*x^3)}
{Sqrt[c - a^2*c*x^2]/E^ArcCoth[a*x], x, 3, -(Sqrt[c - a^2*c*x^2]/(a*Sqrt[1 - 1/(a^2*x^2)])) + (x*Sqrt[c - a^2*c*x^2])/(2*Sqrt[1 - 1/(a^2*x^2)])}
{1/(E^ArcCoth[a*x]*Sqrt[c - a^2*c*x^2]), x, 3, (Sqrt[1 - 1/(a^2*x^2)]*x*Log[1 + a*x])/Sqrt[c - a^2*c*x^2]}
{1/(E^ArcCoth[a*x]*(c - a^2*c*x^2)^(3/2)), x, 5, (a^2*(1 - 1/(a^2*x^2))^(3/2)*x^3)/(2*(1 + a*x)*(c - a^2*c*x^2)^(3/2)) - (a^2*(1 - 1/(a^2*x^2))^(3/2)*x^3*ArcTanh[a*x])/(2*(c - a^2*c*x^2)^(3/2))}
{1/(E^ArcCoth[a*x]*(c - a^2*c*x^2)^(5/2)), x, 5, (a^4*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(8*(1 - a*x)*(c - a^2*c*x^2)^(5/2)) - (a^4*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(8*(1 + a*x)^2*(c - a^2*c*x^2)^(5/2)) - (a^4*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(4*(1 + a*x)*(c - a^2*c*x^2)^(5/2)) + (3*a^4*(1 - 1/(a^2*x^2))^(5/2)*x^5*ArcTanh[a*x])/(8*(c - a^2*c*x^2)^(5/2))}
{1/(E^ArcCoth[a*x]*(c - a^2*c*x^2)^(7/2)), x, 5, -((a^6*(1 - 1/(a^2*x^2))^(7/2)*x^7)/(32*(1 - a*x)^2*(c - a^2*c*x^2)^(7/2))) - (a^6*(1 - 1/(a^2*x^2))^(7/2)*x^7)/(8*(1 - a*x)*(c - a^2*c*x^2)^(7/2)) + (a^6*(1 - 1/(a^2*x^2))^(7/2)*x^7)/(24*(1 + a*x)^3*(c - a^2*c*x^2)^(7/2)) + (3*a^6*(1 - 1/(a^2*x^2))^(7/2)*x^7)/(32*(1 + a*x)^2*(c - a^2*c*x^2)^(7/2)) + (3*a^6*(1 - 1/(a^2*x^2))^(7/2)*x^7)/(16*(1 + a*x)*(c - a^2*c*x^2)^(7/2)) - (5*a^6*(1 - 1/(a^2*x^2))^(7/2)*x^7*ArcTanh[a*x])/(16*(c - a^2*c*x^2)^(7/2))}


{(c - a^2*c*x^2)^(5/2)/E^(2*ArcCoth[a*x]), x, 8, (-(7/16))*c^2*x*Sqrt[c - a^2*c*x^2] - (7/24)*c*x*(c - a^2*c*x^2)^(3/2) - (7*(c - a^2*c*x^2)^(5/2))/(30*a) - ((1 - a*x)*(c - a^2*c*x^2)^(5/2))/(6*a) - (7*c^(5/2)*ArcTan[(a*Sqrt[c]*x)/Sqrt[c - a^2*c*x^2]])/(16*a)}
{(c - a^2*c*x^2)^(3/2)/E^(2*ArcCoth[a*x]), x, 7, (-(5/8))*c*x*Sqrt[c - a^2*c*x^2] - (5*(c - a^2*c*x^2)^(3/2))/(12*a) - ((1 - a*x)*(c - a^2*c*x^2)^(3/2))/(4*a) - (5*c^(3/2)*ArcTan[(a*Sqrt[c]*x)/Sqrt[c - a^2*c*x^2]])/(8*a)}
{Sqrt[c - a^2*c*x^2]/E^(2*ArcCoth[a*x]), x, 6, -((3*Sqrt[c - a^2*c*x^2])/(2*a)) - ((1 - a*x)*Sqrt[c - a^2*c*x^2])/(2*a) - (3*Sqrt[c]*ArcTan[(a*Sqrt[c]*x)/Sqrt[c - a^2*c*x^2]])/(2*a)}
{1/(E^(2*ArcCoth[a*x])*Sqrt[c - a^2*c*x^2]), x, 5, (2*(1 - a*x))/(a*Sqrt[c - a^2*c*x^2]) + ArcTan[(a*Sqrt[c]*x)/Sqrt[c - a^2*c*x^2]]/(a*Sqrt[c])}
{1/(E^(2*ArcCoth[a*x])*(c - a^2*c*x^2)^(3/2)), x, 4, (2*(1 - a*x))/(3*a*(c - a^2*c*x^2)^(3/2)) - x/(3*c*Sqrt[c - a^2*c*x^2])}
{1/(E^(2*ArcCoth[a*x])*(c - a^2*c*x^2)^(5/2)), x, 5, (2*(1 - a*x))/(5*a*(c - a^2*c*x^2)^(5/2)) - x/(5*c*(c - a^2*c*x^2)^(3/2)) - (2*x)/(5*c^2*Sqrt[c - a^2*c*x^2])}
{1/(E^(2*ArcCoth[a*x])*(c - a^2*c*x^2)^(7/2)), x, 6, (2*(1 - a*x))/(7*a*(c - a^2*c*x^2)^(7/2)) - x/(7*c*(c - a^2*c*x^2)^(5/2)) - (4*x)/(21*c^2*(c - a^2*c*x^2)^(3/2)) - (8*x)/(21*c^3*Sqrt[c - a^2*c*x^2])}
{1/(E^(2*ArcCoth[a*x])*(c - a^2*c*x^2)^(9/2)), x, 7, (2*(1 - a*x))/(9*a*(c - a^2*c*x^2)^(9/2)) - x/(9*c*(c - a^2*c*x^2)^(7/2)) - (2*x)/(15*c^2*(c - a^2*c*x^2)^(5/2)) - (8*x)/(45*c^3*(c - a^2*c*x^2)^(3/2)) - (16*x)/(45*c^4*Sqrt[c - a^2*c*x^2])}


{(c - a^2*c*x^2)^(9/2)/E^(3*ArcCoth[a*x]), x, 4, -((8*(1 - a*x)^7*(c - a^2*c*x^2)^(9/2))/(7*a^10*(1 - 1/(a^2*x^2))^(9/2)*x^9)) + (3*(1 - a*x)^8*(c - a^2*c*x^2)^(9/2))/(2*a^10*(1 - 1/(a^2*x^2))^(9/2)*x^9) - (2*(1 - a*x)^9*(c - a^2*c*x^2)^(9/2))/(3*a^10*(1 - 1/(a^2*x^2))^(9/2)*x^9) + ((1 - a*x)^10*(c - a^2*c*x^2)^(9/2))/(10*a^10*(1 - 1/(a^2*x^2))^(9/2)*x^9)}
{(c - a^2*c*x^2)^(7/2)/E^(3*ArcCoth[a*x]), x, 4, (2*(1 - a*x)^6*(c - a^2*c*x^2)^(7/2))/(3*a^8*(1 - 1/(a^2*x^2))^(7/2)*x^7) - (4*(1 - a*x)^7*(c - a^2*c*x^2)^(7/2))/(7*a^8*(1 - 1/(a^2*x^2))^(7/2)*x^7) + ((1 - a*x)^8*(c - a^2*c*x^2)^(7/2))/(8*a^8*(1 - 1/(a^2*x^2))^(7/2)*x^7)}
{(c - a^2*c*x^2)^(5/2)/E^(3*ArcCoth[a*x]), x, 4, -((2*(1 - a*x)^5*(c - a^2*c*x^2)^(5/2))/(5*a^6*(1 - 1/(a^2*x^2))^(5/2)*x^5)) + ((1 - a*x)^6*(c - a^2*c*x^2)^(5/2))/(6*a^6*(1 - 1/(a^2*x^2))^(5/2)*x^5)}
{(c - a^2*c*x^2)^(3/2)/E^(3*ArcCoth[a*x]), x, 3, ((1 - a*x)^4*(c - a^2*c*x^2)^(3/2))/(4*a^4*(1 - 1/(a^2*x^2))^(3/2)*x^3)}
{Sqrt[c - a^2*c*x^2]/E^(3*ArcCoth[a*x]), x, 4, -((3*Sqrt[c - a^2*c*x^2])/(a*Sqrt[1 - 1/(a^2*x^2)])) + (x*Sqrt[c - a^2*c*x^2])/(2*Sqrt[1 - 1/(a^2*x^2)]) + (4*Sqrt[c - a^2*c*x^2]*Log[1 + a*x])/(a^2*Sqrt[1 - 1/(a^2*x^2)]*x)}
{1/(E^(3*ArcCoth[a*x])*Sqrt[c - a^2*c*x^2]), x, 4, (2*Sqrt[1 - 1/(a^2*x^2)]*x)/((1 + a*x)*Sqrt[c - a^2*c*x^2]) + (Sqrt[1 - 1/(a^2*x^2)]*x*Log[1 + a*x])/Sqrt[c - a^2*c*x^2]}
{1/(E^(3*ArcCoth[a*x])*(c - a^2*c*x^2)^(3/2)), x, 3, -((a^2*(1 - 1/(a^2*x^2))^(3/2)*x^3)/(2*(1 + a*x)^2*(c - a^2*c*x^2)^(3/2)))}
{1/(E^(3*ArcCoth[a*x])*(c - a^2*c*x^2)^(5/2)), x, 5, (a^4*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(6*(1 + a*x)^3*(c - a^2*c*x^2)^(5/2)) + (a^4*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(8*(1 + a*x)^2*(c - a^2*c*x^2)^(5/2)) + (a^4*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(8*(1 + a*x)*(c - a^2*c*x^2)^(5/2)) - (a^4*(1 - 1/(a^2*x^2))^(5/2)*x^5*ArcTanh[a*x])/(8*(c - a^2*c*x^2)^(5/2))}
{1/(E^(3*ArcCoth[a*x])*(c - a^2*c*x^2)^(7/2)), x, 5, (a^6*(1 - 1/(a^2*x^2))^(7/2)*x^7)/(32*(1 - a*x)*(c - a^2*c*x^2)^(7/2)) - (a^6*(1 - 1/(a^2*x^2))^(7/2)*x^7)/(16*(1 + a*x)^4*(c - a^2*c*x^2)^(7/2)) - (a^6*(1 - 1/(a^2*x^2))^(7/2)*x^7)/(12*(1 + a*x)^3*(c - a^2*c*x^2)^(7/2)) - (3*a^6*(1 - 1/(a^2*x^2))^(7/2)*x^7)/(32*(1 + a*x)^2*(c - a^2*c*x^2)^(7/2)) - (a^6*(1 - 1/(a^2*x^2))^(7/2)*x^7)/(8*(1 + a*x)*(c - a^2*c*x^2)^(7/2)) + (5*a^6*(1 - 1/(a^2*x^2))^(7/2)*x^7*ArcTanh[a*x])/(32*(c - a^2*c*x^2)^(7/2))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m E^(n ArcCoth[a x]) (c-c a^2 x^2)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{E^ArcCoth[a*x]*x^2*Sqrt[c - a^2*c*x^2], x, 4, (x^2*Sqrt[c - a^2*c*x^2])/(3*a*Sqrt[1 - 1/(a^2*x^2)]) + (x^3*Sqrt[c - a^2*c*x^2])/(4*Sqrt[1 - 1/(a^2*x^2)])}
{E^ArcCoth[a*x]*x*Sqrt[c - a^2*c*x^2], x, 4, (x*Sqrt[c - a^2*c*x^2])/(2*a*Sqrt[1 - 1/(a^2*x^2)]) + (x^2*Sqrt[c - a^2*c*x^2])/(3*Sqrt[1 - 1/(a^2*x^2)])}
{E^ArcCoth[a*x]*Sqrt[c - a^2*c*x^2], x, 3, Sqrt[c - a^2*c*x^2]/(a*Sqrt[1 - 1/(a^2*x^2)]) + (x*Sqrt[c - a^2*c*x^2])/(2*Sqrt[1 - 1/(a^2*x^2)])}
{(E^ArcCoth[a*x]*Sqrt[c - a^2*c*x^2])/x, x, 4, Sqrt[c - a^2*c*x^2]/Sqrt[1 - 1/(a^2*x^2)] + (Sqrt[c - a^2*c*x^2]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)]*x)}
{(E^ArcCoth[a*x]*Sqrt[c - a^2*c*x^2])/x^2, x, 4, -(Sqrt[c - a^2*c*x^2]/(a*Sqrt[1 - 1/(a^2*x^2)]*x^2)) + (Sqrt[c - a^2*c*x^2]*Log[x])/(Sqrt[1 - 1/(a^2*x^2)]*x)}


{E^(2*ArcCoth[a*x])*x^3*Sqrt[c - a^2*c*x^2], x, 8, (3*x^2*Sqrt[c - a^2*c*x^2])/(5*a^2) + (x^3*Sqrt[c - a^2*c*x^2])/(2*a) + (1/5)*x^4*Sqrt[c - a^2*c*x^2] + (3*(8 + 5*a*x)*Sqrt[c - a^2*c*x^2])/(20*a^4) - (3*Sqrt[c]*ArcTan[(a*Sqrt[c]*x)/Sqrt[c - a^2*c*x^2]])/(4*a^4)}
{E^(2*ArcCoth[a*x])*x^2*Sqrt[c - a^2*c*x^2], x, 7, (2*x^2*Sqrt[c - a^2*c*x^2])/(3*a) + (1/4)*x^3*Sqrt[c - a^2*c*x^2] + ((32 + 21*a*x)*Sqrt[c - a^2*c*x^2])/(24*a^3) - (7*Sqrt[c]*ArcTan[(a*Sqrt[c]*x)/Sqrt[c - a^2*c*x^2]])/(8*a^3)}
{E^(2*ArcCoth[a*x])*x*Sqrt[c - a^2*c*x^2], x, 6, (1/3)*x^2*Sqrt[c - a^2*c*x^2] + ((5 + 3*a*x)*Sqrt[c - a^2*c*x^2])/(3*a^2) - (Sqrt[c]*ArcTan[(a*Sqrt[c]*x)/Sqrt[c - a^2*c*x^2]])/a^2}
{E^(2*ArcCoth[a*x])*Sqrt[c - a^2*c*x^2], x, 6, (3*Sqrt[c - a^2*c*x^2])/(2*a) + ((1 + a*x)*Sqrt[c - a^2*c*x^2])/(2*a) - (3*Sqrt[c]*ArcTan[(a*Sqrt[c]*x)/Sqrt[c - a^2*c*x^2]])/(2*a)}
{(E^(2*ArcCoth[a*x])*Sqrt[c - a^2*c*x^2])/x, x, 9, Sqrt[c - a^2*c*x^2] - 2*Sqrt[c]*ArcTan[(a*Sqrt[c]*x)/Sqrt[c - a^2*c*x^2]] + Sqrt[c]*ArcTanh[Sqrt[c - a^2*c*x^2]/Sqrt[c]]}
{(E^(2*ArcCoth[a*x])*Sqrt[c - a^2*c*x^2])/x^2, x, 9, Sqrt[c - a^2*c*x^2]/x - a*Sqrt[c]*ArcTan[(a*Sqrt[c]*x)/Sqrt[c - a^2*c*x^2]] + 2*a*Sqrt[c]*ArcTanh[Sqrt[c - a^2*c*x^2]/Sqrt[c]]}
{(E^(2*ArcCoth[a*x])*Sqrt[c - a^2*c*x^2])/x^3, x, 7, Sqrt[c - a^2*c*x^2]/(2*x^2) + (2*a*Sqrt[c - a^2*c*x^2])/x + (3/2)*a^2*Sqrt[c]*ArcTanh[Sqrt[c - a^2*c*x^2]/Sqrt[c]]}
{(E^(2*ArcCoth[a*x])*Sqrt[c - a^2*c*x^2])/x^4, x, 8, Sqrt[c - a^2*c*x^2]/(3*x^3) + (a*Sqrt[c - a^2*c*x^2])/x^2 + (5*a^2*Sqrt[c - a^2*c*x^2])/(3*x) + a^3*Sqrt[c]*ArcTanh[Sqrt[c - a^2*c*x^2]/Sqrt[c]]}
{(E^(2*ArcCoth[a*x])*Sqrt[c - a^2*c*x^2])/x^5, x, 9, Sqrt[c - a^2*c*x^2]/(4*x^4) + (2*a*Sqrt[c - a^2*c*x^2])/(3*x^3) + (7*a^2*Sqrt[c - a^2*c*x^2])/(8*x^2) + (4*a^3*Sqrt[c - a^2*c*x^2])/(3*x) + (7/8)*a^4*Sqrt[c]*ArcTanh[Sqrt[c - a^2*c*x^2]/Sqrt[c]]}


{E^(3*ArcCoth[a*x])*x^3*Sqrt[c - a^2*c*x^2], x, 4, (4*Sqrt[c - a^2*c*x^2])/(a^4*Sqrt[1 - 1/(a^2*x^2)]) + (2*x*Sqrt[c - a^2*c*x^2])/(a^3*Sqrt[1 - 1/(a^2*x^2)]) + (4*x^2*Sqrt[c - a^2*c*x^2])/(3*a^2*Sqrt[1 - 1/(a^2*x^2)]) + (3*x^3*Sqrt[c - a^2*c*x^2])/(4*a*Sqrt[1 - 1/(a^2*x^2)]) + (x^4*Sqrt[c - a^2*c*x^2])/(5*Sqrt[1 - 1/(a^2*x^2)]) + (4*Sqrt[c - a^2*c*x^2]*Log[1 - a*x])/(a^5*Sqrt[1 - 1/(a^2*x^2)]*x)}
{E^(3*ArcCoth[a*x])*x^2*Sqrt[c - a^2*c*x^2], x, 4, (4*Sqrt[c - a^2*c*x^2])/(a^3*Sqrt[1 - 1/(a^2*x^2)]) + (2*x*Sqrt[c - a^2*c*x^2])/(a^2*Sqrt[1 - 1/(a^2*x^2)]) + (x^2*Sqrt[c - a^2*c*x^2])/(a*Sqrt[1 - 1/(a^2*x^2)]) + (x^3*Sqrt[c - a^2*c*x^2])/(4*Sqrt[1 - 1/(a^2*x^2)]) + (4*Sqrt[c - a^2*c*x^2]*Log[1 - a*x])/(a^4*Sqrt[1 - 1/(a^2*x^2)]*x)}
{E^(3*ArcCoth[a*x])*x*Sqrt[c - a^2*c*x^2], x, 4, (4*Sqrt[c - a^2*c*x^2])/(a^2*Sqrt[1 - 1/(a^2*x^2)]) + (3*x*Sqrt[c - a^2*c*x^2])/(2*a*Sqrt[1 - 1/(a^2*x^2)]) + (x^2*Sqrt[c - a^2*c*x^2])/(3*Sqrt[1 - 1/(a^2*x^2)]) + (4*Sqrt[c - a^2*c*x^2]*Log[1 - a*x])/(a^3*Sqrt[1 - 1/(a^2*x^2)]*x)}
{E^(3*ArcCoth[a*x])*Sqrt[c - a^2*c*x^2], x, 4, (3*Sqrt[c - a^2*c*x^2])/(a*Sqrt[1 - 1/(a^2*x^2)]) + (x*Sqrt[c - a^2*c*x^2])/(2*Sqrt[1 - 1/(a^2*x^2)]) + (4*Sqrt[c - a^2*c*x^2]*Log[1 - a*x])/(a^2*Sqrt[1 - 1/(a^2*x^2)]*x)}
{(E^(3*ArcCoth[a*x])*Sqrt[c - a^2*c*x^2])/x, x, 4, Sqrt[c - a^2*c*x^2]/Sqrt[1 - 1/(a^2*x^2)] - (Sqrt[c - a^2*c*x^2]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)]*x) + (4*Sqrt[c - a^2*c*x^2]*Log[1 - a*x])/(a*Sqrt[1 - 1/(a^2*x^2)]*x)}
{(E^(3*ArcCoth[a*x])*Sqrt[c - a^2*c*x^2])/x^2, x, 4, Sqrt[c - a^2*c*x^2]/(a*Sqrt[1 - 1/(a^2*x^2)]*x^2) - (3*Sqrt[c - a^2*c*x^2]*Log[x])/(Sqrt[1 - 1/(a^2*x^2)]*x) + (4*Sqrt[c - a^2*c*x^2]*Log[1 - a*x])/(Sqrt[1 - 1/(a^2*x^2)]*x)}
{(E^(3*ArcCoth[a*x])*Sqrt[c - a^2*c*x^2])/x^3, x, 4, Sqrt[c - a^2*c*x^2]/(2*a*Sqrt[1 - 1/(a^2*x^2)]*x^3) + (3*Sqrt[c - a^2*c*x^2])/(Sqrt[1 - 1/(a^2*x^2)]*x^2) - (4*a*Sqrt[c - a^2*c*x^2]*Log[x])/(Sqrt[1 - 1/(a^2*x^2)]*x) + (4*a*Sqrt[c - a^2*c*x^2]*Log[1 - a*x])/(Sqrt[1 - 1/(a^2*x^2)]*x)}
{(E^(3*ArcCoth[a*x])*Sqrt[c - a^2*c*x^2])/x^4, x, 4, Sqrt[c - a^2*c*x^2]/(3*a*Sqrt[1 - 1/(a^2*x^2)]*x^4) + (3*Sqrt[c - a^2*c*x^2])/(2*Sqrt[1 - 1/(a^2*x^2)]*x^3) + (4*a*Sqrt[c - a^2*c*x^2])/(Sqrt[1 - 1/(a^2*x^2)]*x^2) - (4*a^2*Sqrt[c - a^2*c*x^2]*Log[x])/(Sqrt[1 - 1/(a^2*x^2)]*x) + (4*a^2*Sqrt[c - a^2*c*x^2]*Log[1 - a*x])/(Sqrt[1 - 1/(a^2*x^2)]*x)}
{(E^(3*ArcCoth[a*x])*Sqrt[c - a^2*c*x^2])/x^5, x, 4, Sqrt[c - a^2*c*x^2]/(4*a*Sqrt[1 - 1/(a^2*x^2)]*x^5) + Sqrt[c - a^2*c*x^2]/(Sqrt[1 - 1/(a^2*x^2)]*x^4) + (2*a*Sqrt[c - a^2*c*x^2])/(Sqrt[1 - 1/(a^2*x^2)]*x^3) + (4*a^2*Sqrt[c - a^2*c*x^2])/(Sqrt[1 - 1/(a^2*x^2)]*x^2) - (4*a^3*Sqrt[c - a^2*c*x^2]*Log[x])/(Sqrt[1 - 1/(a^2*x^2)]*x) + (4*a^3*Sqrt[c - a^2*c*x^2]*Log[1 - a*x])/(Sqrt[1 - 1/(a^2*x^2)]*x)}


{E^ArcCoth[a*x]/(c - a^2*c*x^2)^(3/2)*x^4, x, 4, ((1 - 1/(a^2*x^2))^(3/2)*x^4)/(a*(c - a^2*c*x^2)^(3/2)) + ((1 - 1/(a^2*x^2))^(3/2)*x^5)/(2*(c - a^2*c*x^2)^(3/2)) + ((1 - 1/(a^2*x^2))^(3/2)*x^3)/(2*a^2*(1 - a*x)*(c - a^2*c*x^2)^(3/2)) + (7*(1 - 1/(a^2*x^2))^(3/2)*x^3*Log[1 - a*x])/(4*a^2*(c - a^2*c*x^2)^(3/2)) + ((1 - 1/(a^2*x^2))^(3/2)*x^3*Log[1 + a*x])/(4*a^2*(c - a^2*c*x^2)^(3/2))}
{E^ArcCoth[a*x]/(c - a^2*c*x^2)^(3/2)*x^3, x, 4, ((1 - 1/(a^2*x^2))^(3/2)*x^4)/(c - a^2*c*x^2)^(3/2) + ((1 - 1/(a^2*x^2))^(3/2)*x^3)/(2*a*(1 - a*x)*(c - a^2*c*x^2)^(3/2)) + (5*(1 - 1/(a^2*x^2))^(3/2)*x^3*Log[1 - a*x])/(4*a*(c - a^2*c*x^2)^(3/2)) - ((1 - 1/(a^2*x^2))^(3/2)*x^3*Log[1 + a*x])/(4*a*(c - a^2*c*x^2)^(3/2))}
{E^ArcCoth[a*x]/(c - a^2*c*x^2)^(3/2)*x^2, x, 4, ((1 - 1/(a^2*x^2))^(3/2)*x^3)/(2*(1 - a*x)*(c - a^2*c*x^2)^(3/2)) + (3*(1 - 1/(a^2*x^2))^(3/2)*x^3*Log[1 - a*x])/(4*(c - a^2*c*x^2)^(3/2)) + ((1 - 1/(a^2*x^2))^(3/2)*x^3*Log[1 + a*x])/(4*(c - a^2*c*x^2)^(3/2))}
{E^ArcCoth[a*x]/(c - a^2*c*x^2)^(3/2)*x^1, x, 5, (a*(1 - 1/(a^2*x^2))^(3/2)*x^3)/(2*(1 - a*x)*(c - a^2*c*x^2)^(3/2)) - (a*(1 - 1/(a^2*x^2))^(3/2)*x^3*ArcTanh[a*x])/(2*(c - a^2*c*x^2)^(3/2))}
{E^ArcCoth[a*x]/(c - a^2*c*x^2)^(3/2)*x^0, x, 5, (a^2*(1 - 1/(a^2*x^2))^(3/2)*x^3)/(2*(1 - a*x)*(c - a^2*c*x^2)^(3/2)) + (a^2*(1 - 1/(a^2*x^2))^(3/2)*x^3*ArcTanh[a*x])/(2*(c - a^2*c*x^2)^(3/2))}
{E^ArcCoth[a*x]/(c - a^2*c*x^2)^(3/2)/x^1, x, 4, (a^3*(1 - 1/(a^2*x^2))^(3/2)*x^3)/(2*(1 - a*x)*(c - a^2*c*x^2)^(3/2)) + (a^3*(1 - 1/(a^2*x^2))^(3/2)*x^3*Log[x])/(c - a^2*c*x^2)^(3/2) - (3*a^3*(1 - 1/(a^2*x^2))^(3/2)*x^3*Log[1 - a*x])/(4*(c - a^2*c*x^2)^(3/2)) - (a^3*(1 - 1/(a^2*x^2))^(3/2)*x^3*Log[1 + a*x])/(4*(c - a^2*c*x^2)^(3/2))}
{E^ArcCoth[a*x]/(c - a^2*c*x^2)^(3/2)/x^2, x, 4, -((a^3*(1 - 1/(a^2*x^2))^(3/2)*x^2)/(c - a^2*c*x^2)^(3/2)) + (a^4*(1 - 1/(a^2*x^2))^(3/2)*x^3)/(2*(1 - a*x)*(c - a^2*c*x^2)^(3/2)) + (a^4*(1 - 1/(a^2*x^2))^(3/2)*x^3*Log[x])/(c - a^2*c*x^2)^(3/2) - (5*a^4*(1 - 1/(a^2*x^2))^(3/2)*x^3*Log[1 - a*x])/(4*(c - a^2*c*x^2)^(3/2)) + (a^4*(1 - 1/(a^2*x^2))^(3/2)*x^3*Log[1 + a*x])/(4*(c - a^2*c*x^2)^(3/2))}
{E^ArcCoth[a*x]/(c - a^2*c*x^2)^(3/2)/x^3, x, 4, -((a^3*(1 - 1/(a^2*x^2))^(3/2)*x)/(2*(c - a^2*c*x^2)^(3/2))) - (a^4*(1 - 1/(a^2*x^2))^(3/2)*x^2)/(c - a^2*c*x^2)^(3/2) + (a^5*(1 - 1/(a^2*x^2))^(3/2)*x^3)/(2*(1 - a*x)*(c - a^2*c*x^2)^(3/2)) + (2*a^5*(1 - 1/(a^2*x^2))^(3/2)*x^3*Log[x])/(c - a^2*c*x^2)^(3/2) - (7*a^5*(1 - 1/(a^2*x^2))^(3/2)*x^3*Log[1 - a*x])/(4*(c - a^2*c*x^2)^(3/2)) - (a^5*(1 - 1/(a^2*x^2))^(3/2)*x^3*Log[1 + a*x])/(4*(c - a^2*c*x^2)^(3/2))}


{E^ArcCoth[a*x]/(c - a^2*c*x^2)^(5/2)*x^5, x, 4, ((1 - 1/(a^2*x^2))^(5/2)*x^6)/(c - a^2*c*x^2)^(5/2) - ((1 - 1/(a^2*x^2))^(5/2)*x^5)/(8*a*(1 - a*x)^2*(c - a^2*c*x^2)^(5/2)) + ((1 - 1/(a^2*x^2))^(5/2)*x^5)/(a*(1 - a*x)*(c - a^2*c*x^2)^(5/2)) - ((1 - 1/(a^2*x^2))^(5/2)*x^5)/(8*a*(1 + a*x)*(c - a^2*c*x^2)^(5/2)) + (23*(1 - 1/(a^2*x^2))^(5/2)*x^5*Log[1 - a*x])/(16*a*(c - a^2*c*x^2)^(5/2)) - (7*(1 - 1/(a^2*x^2))^(5/2)*x^5*Log[1 + a*x])/(16*a*(c - a^2*c*x^2)^(5/2))}
{E^ArcCoth[a*x]/(c - a^2*c*x^2)^(5/2)*x^4, x, 4, -(((1 - 1/(a^2*x^2))^(5/2)*x^5)/(8*(1 - a*x)^2*(c - a^2*c*x^2)^(5/2))) + (3*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(4*(1 - a*x)*(c - a^2*c*x^2)^(5/2)) + ((1 - 1/(a^2*x^2))^(5/2)*x^5)/(8*(1 + a*x)*(c - a^2*c*x^2)^(5/2)) + (11*(1 - 1/(a^2*x^2))^(5/2)*x^5*Log[1 - a*x])/(16*(c - a^2*c*x^2)^(5/2)) + (5*(1 - 1/(a^2*x^2))^(5/2)*x^5*Log[1 + a*x])/(16*(c - a^2*c*x^2)^(5/2))}
{E^ArcCoth[a*x]/(c - a^2*c*x^2)^(5/2)*x^3, x, 5, -((a*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(8*(1 - a*x)^2*(c - a^2*c*x^2)^(5/2))) + (a*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(2*(1 - a*x)*(c - a^2*c*x^2)^(5/2)) - (a*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(8*(1 + a*x)*(c - a^2*c*x^2)^(5/2)) - (3*a*(1 - 1/(a^2*x^2))^(5/2)*x^5*ArcTanh[a*x])/(8*(c - a^2*c*x^2)^(5/2))}
{E^ArcCoth[a*x]/(c - a^2*c*x^2)^(5/2)*x^2, x, 5, -((a^2*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(8*(1 - a*x)^2*(c - a^2*c*x^2)^(5/2))) + (a^2*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(4*(1 - a*x)*(c - a^2*c*x^2)^(5/2)) + (a^2*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(8*(1 + a*x)*(c - a^2*c*x^2)^(5/2)) + (a^2*(1 - 1/(a^2*x^2))^(5/2)*x^5*ArcTanh[a*x])/(8*(c - a^2*c*x^2)^(5/2))}
{E^ArcCoth[a*x]/(c - a^2*c*x^2)^(5/2)*x^1, x, 5, -((a^3*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(8*(1 - a*x)^2*(c - a^2*c*x^2)^(5/2))) - (a^3*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(8*(1 + a*x)*(c - a^2*c*x^2)^(5/2)) + (a^3*(1 - 1/(a^2*x^2))^(5/2)*x^5*ArcTanh[a*x])/(8*(c - a^2*c*x^2)^(5/2))}
{E^ArcCoth[a*x]/(c - a^2*c*x^2)^(5/2)*x^0, x, 5, -((a^4*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(8*(1 - a*x)^2*(c - a^2*c*x^2)^(5/2))) - (a^4*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(4*(1 - a*x)*(c - a^2*c*x^2)^(5/2)) + (a^4*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(8*(1 + a*x)*(c - a^2*c*x^2)^(5/2)) - (3*a^4*(1 - 1/(a^2*x^2))^(5/2)*x^5*ArcTanh[a*x])/(8*(c - a^2*c*x^2)^(5/2))}
{E^ArcCoth[a*x]/(c - a^2*c*x^2)^(5/2)/x^1, x, 4, -((a^5*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(8*(1 - a*x)^2*(c - a^2*c*x^2)^(5/2))) - (a^5*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(2*(1 - a*x)*(c - a^2*c*x^2)^(5/2)) - (a^5*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(8*(1 + a*x)*(c - a^2*c*x^2)^(5/2)) - (a^5*(1 - 1/(a^2*x^2))^(5/2)*x^5*Log[x])/(c - a^2*c*x^2)^(5/2) + (11*a^5*(1 - 1/(a^2*x^2))^(5/2)*x^5*Log[1 - a*x])/(16*(c - a^2*c*x^2)^(5/2)) + (5*a^5*(1 - 1/(a^2*x^2))^(5/2)*x^5*Log[1 + a*x])/(16*(c - a^2*c*x^2)^(5/2))}
{E^ArcCoth[a*x]/(c - a^2*c*x^2)^(5/2)/x^2, x, 4, (a^5*(1 - 1/(a^2*x^2))^(5/2)*x^4)/(c - a^2*c*x^2)^(5/2) - (a^6*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(8*(1 - a*x)^2*(c - a^2*c*x^2)^(5/2)) - (3*a^6*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(4*(1 - a*x)*(c - a^2*c*x^2)^(5/2)) + (a^6*(1 - 1/(a^2*x^2))^(5/2)*x^5)/(8*(1 + a*x)*(c - a^2*c*x^2)^(5/2)) - (a^6*(1 - 1/(a^2*x^2))^(5/2)*x^5*Log[x])/(c - a^2*c*x^2)^(5/2) + (23*a^6*(1 - 1/(a^2*x^2))^(5/2)*x^5*Log[1 - a*x])/(16*(c - a^2*c*x^2)^(5/2)) - (7*a^6*(1 - 1/(a^2*x^2))^(5/2)*x^5*Log[1 + a*x])/(16*(c - a^2*c*x^2)^(5/2))}


(* ::Subsubsection::Closed:: *)
(*n<0*)


{(x^2*Sqrt[c - a^2*c*x^2])/E^ArcCoth[a*x], x, 4, -(x^2*Sqrt[c - a^2*c*x^2])/(3*a*Sqrt[1 - 1/(a^2*x^2)]) + (x^3*Sqrt[c - a^2*c*x^2])/(4*Sqrt[1 - 1/(a^2*x^2)])}
{(x*Sqrt[c - a^2*c*x^2])/E^ArcCoth[a*x], x, 4, -(x*Sqrt[c - a^2*c*x^2])/(2*a*Sqrt[1 - 1/(a^2*x^2)]) + (x^2*Sqrt[c - a^2*c*x^2])/(3*Sqrt[1 - 1/(a^2*x^2)])}
{Sqrt[c - a^2*c*x^2]/E^ArcCoth[a*x], x, 3, -(Sqrt[c - a^2*c*x^2]/(a*Sqrt[1 - 1/(a^2*x^2)])) + (x*Sqrt[c - a^2*c*x^2])/(2*Sqrt[1 - 1/(a^2*x^2)])}
{Sqrt[c - a^2*c*x^2]/(E^ArcCoth[a*x]*x), x, 4, Sqrt[c - a^2*c*x^2]/Sqrt[1 - 1/(a^2*x^2)] - (Sqrt[c - a^2*c*x^2]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)]*x)}
{Sqrt[c - a^2*c*x^2]/(E^ArcCoth[a*x]*x^2), x, 4, Sqrt[c - a^2*c*x^2]/(a*Sqrt[1 - 1/(a^2*x^2)]*x^2) + (Sqrt[c - a^2*c*x^2]*Log[x])/(Sqrt[1 - 1/(a^2*x^2)]*x)}


{(x^3*Sqrt[c - a^2*c*x^2])/E^(2*ArcCoth[a*x]), x, 8, (3*x^2*Sqrt[c - a^2*c*x^2])/(5*a^2) - (x^3*Sqrt[c - a^2*c*x^2])/(2*a) + (1/5)*x^4*Sqrt[c - a^2*c*x^2] + (3*(8 - 5*a*x)*Sqrt[c - a^2*c*x^2])/(20*a^4) + (3*Sqrt[c]*ArcTan[(a*Sqrt[c]*x)/Sqrt[c - a^2*c*x^2]])/(4*a^4)}
{(x^2*Sqrt[c - a^2*c*x^2])/E^(2*ArcCoth[a*x]), x, 7, -((2*x^2*Sqrt[c - a^2*c*x^2])/(3*a)) + (1/4)*x^3*Sqrt[c - a^2*c*x^2] - ((32 - 21*a*x)*Sqrt[c - a^2*c*x^2])/(24*a^3) - (7*Sqrt[c]*ArcTan[(a*Sqrt[c]*x)/Sqrt[c - a^2*c*x^2]])/(8*a^3)}
{(x^1*Sqrt[c - a^2*c*x^2])/E^(2*ArcCoth[a*x]), x, 6, (1/3)*x^2*Sqrt[c - a^2*c*x^2] + ((5 - 3*a*x)*Sqrt[c - a^2*c*x^2])/(3*a^2) + (Sqrt[c]*ArcTan[(a*Sqrt[c]*x)/Sqrt[c - a^2*c*x^2]])/a^2}
{Sqrt[c - a^2*c*x^2]/E^(2*ArcCoth[a*x]), x, 6, -((3*Sqrt[c - a^2*c*x^2])/(2*a)) - ((1 - a*x)*Sqrt[c - a^2*c*x^2])/(2*a) - (3*Sqrt[c]*ArcTan[(a*Sqrt[c]*x)/Sqrt[c - a^2*c*x^2]])/(2*a)}
{Sqrt[c - a^2*c*x^2]/(E^(2*ArcCoth[a*x])*x^1), x, 9, Sqrt[c - a^2*c*x^2] + 2*Sqrt[c]*ArcTan[(a*Sqrt[c]*x)/Sqrt[c - a^2*c*x^2]] + Sqrt[c]*ArcTanh[Sqrt[c - a^2*c*x^2]/Sqrt[c]]}
{Sqrt[c - a^2*c*x^2]/(E^(2*ArcCoth[a*x])*x^2), x, 9, Sqrt[c - a^2*c*x^2]/x - a*Sqrt[c]*ArcTan[(a*Sqrt[c]*x)/Sqrt[c - a^2*c*x^2]] - 2*a*Sqrt[c]*ArcTanh[Sqrt[c - a^2*c*x^2]/Sqrt[c]]}
{Sqrt[c - a^2*c*x^2]/(E^(2*ArcCoth[a*x])*x^3), x, 7, Sqrt[c - a^2*c*x^2]/(2*x^2) - (2*a*Sqrt[c - a^2*c*x^2])/x + (3/2)*a^2*Sqrt[c]*ArcTanh[Sqrt[c - a^2*c*x^2]/Sqrt[c]]}
{Sqrt[c - a^2*c*x^2]/(E^(2*ArcCoth[a*x])*x^4), x, 8, Sqrt[c - a^2*c*x^2]/(3*x^3) - (a*Sqrt[c - a^2*c*x^2])/x^2 + (5*a^2*Sqrt[c - a^2*c*x^2])/(3*x) - a^3*Sqrt[c]*ArcTanh[Sqrt[c - a^2*c*x^2]/Sqrt[c]]}
{Sqrt[c - a^2*c*x^2]/(E^(2*ArcCoth[a*x])*x^5), x, 9, Sqrt[c - a^2*c*x^2]/(4*x^4) - (2*a*Sqrt[c - a^2*c*x^2])/(3*x^3) + (7*a^2*Sqrt[c - a^2*c*x^2])/(8*x^2) - (4*a^3*Sqrt[c - a^2*c*x^2])/(3*x) + (7/8)*a^4*Sqrt[c]*ArcTanh[Sqrt[c - a^2*c*x^2]/Sqrt[c]]}


{(x^3*Sqrt[c - a^2*c*x^2])/E^(3*ArcCoth[a*x]), x, 4, (4*Sqrt[c - a^2*c*x^2])/(a^4*Sqrt[1 - 1/(a^2*x^2)]) - (2*x*Sqrt[c - a^2*c*x^2])/(a^3*Sqrt[1 - 1/(a^2*x^2)]) + (4*x^2*Sqrt[c - a^2*c*x^2])/(3*a^2*Sqrt[1 - 1/(a^2*x^2)]) - (3*x^3*Sqrt[c - a^2*c*x^2])/(4*a*Sqrt[1 - 1/(a^2*x^2)]) + (x^4*Sqrt[c - a^2*c*x^2])/(5*Sqrt[1 - 1/(a^2*x^2)]) - (4*Sqrt[c - a^2*c*x^2]*Log[1 + a*x])/(a^5*Sqrt[1 - 1/(a^2*x^2)]*x)}
{(x^2*Sqrt[c - a^2*c*x^2])/E^(3*ArcCoth[a*x]), x, 4, (-4*Sqrt[c - a^2*c*x^2])/(a^3*Sqrt[1 - 1/(a^2*x^2)]) + (2*x*Sqrt[c - a^2*c*x^2])/(a^2*Sqrt[1 - 1/(a^2*x^2)]) - (x^2*Sqrt[c - a^2*c*x^2])/(a*Sqrt[1 - 1/(a^2*x^2)]) + (x^3*Sqrt[c - a^2*c*x^2])/(4*Sqrt[1 - 1/(a^2*x^2)]) + (4*Sqrt[c - a^2*c*x^2]*Log[1 + a*x])/(a^4*Sqrt[1 - 1/(a^2*x^2)]*x)}
{(x*Sqrt[c - a^2*c*x^2])/E^(3*ArcCoth[a*x]), x, 4, (4*Sqrt[c - a^2*c*x^2])/(a^2*Sqrt[1 - 1/(a^2*x^2)]) - (3*x*Sqrt[c - a^2*c*x^2])/(2*a*Sqrt[1 - 1/(a^2*x^2)]) + (x^2*Sqrt[c - a^2*c*x^2])/(3*Sqrt[1 - 1/(a^2*x^2)]) - (4*Sqrt[c - a^2*c*x^2]*Log[1 + a*x])/(a^3*Sqrt[1 - 1/(a^2*x^2)]*x)}
{Sqrt[c - a^2*c*x^2]/E^(3*ArcCoth[a*x]), x, 4, -((3*Sqrt[c - a^2*c*x^2])/(a*Sqrt[1 - 1/(a^2*x^2)])) + (x*Sqrt[c - a^2*c*x^2])/(2*Sqrt[1 - 1/(a^2*x^2)]) + (4*Sqrt[c - a^2*c*x^2]*Log[1 + a*x])/(a^2*Sqrt[1 - 1/(a^2*x^2)]*x)}
{Sqrt[c - a^2*c*x^2]/(E^(3*ArcCoth[a*x])*x), x, 4, Sqrt[c - a^2*c*x^2]/Sqrt[1 - 1/(a^2*x^2)] + (Sqrt[c - a^2*c*x^2]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)]*x) - (4*Sqrt[c - a^2*c*x^2]*Log[1 + a*x])/(a*Sqrt[1 - 1/(a^2*x^2)]*x)}
{Sqrt[c - a^2*c*x^2]/(E^(3*ArcCoth[a*x])*x^2), x, 4, -(Sqrt[c - a^2*c*x^2]/(a*Sqrt[1 - 1/(a^2*x^2)]*x^2)) - (3*Sqrt[c - a^2*c*x^2]*Log[x])/(Sqrt[1 - 1/(a^2*x^2)]*x) + (4*Sqrt[c - a^2*c*x^2]*Log[1 + a*x])/(Sqrt[1 - 1/(a^2*x^2)]*x)}
{Sqrt[c - a^2*c*x^2]/(E^(3*ArcCoth[a*x])*x^3), x, 4, -(Sqrt[c - a^2*c*x^2]/(2*a*Sqrt[1 - 1/(a^2*x^2)]*x^3)) + (3*Sqrt[c - a^2*c*x^2])/(Sqrt[1 - 1/(a^2*x^2)]*x^2) + (4*a*Sqrt[c - a^2*c*x^2]*Log[x])/(Sqrt[1 - 1/(a^2*x^2)]*x) - (4*a*Sqrt[c - a^2*c*x^2]*Log[1 + a*x])/(Sqrt[1 - 1/(a^2*x^2)]*x)}
{Sqrt[c - a^2*c*x^2]/(E^(3*ArcCoth[a*x])*x^4), x, 4, -(Sqrt[c - a^2*c*x^2]/(3*a*Sqrt[1 - 1/(a^2*x^2)]*x^4)) + (3*Sqrt[c - a^2*c*x^2])/(2*Sqrt[1 - 1/(a^2*x^2)]*x^3) - (4*a*Sqrt[c - a^2*c*x^2])/(Sqrt[1 - 1/(a^2*x^2)]*x^2) - (4*a^2*Sqrt[c - a^2*c*x^2]*Log[x])/(Sqrt[1 - 1/(a^2*x^2)]*x) + (4*a^2*Sqrt[c - a^2*c*x^2]*Log[1 + a*x])/(Sqrt[1 - 1/(a^2*x^2)]*x)}
{Sqrt[c - a^2*c*x^2]/(E^(3*ArcCoth[a*x])*x^5), x, 4, -(Sqrt[c - a^2*c*x^2]/(4*a*Sqrt[1 - 1/(a^2*x^2)]*x^5)) + Sqrt[c - a^2*c*x^2]/(Sqrt[1 - 1/(a^2*x^2)]*x^4) - (2*a*Sqrt[c - a^2*c*x^2])/(Sqrt[1 - 1/(a^2*x^2)]*x^3) + (4*a^2*Sqrt[c - a^2*c*x^2])/(Sqrt[1 - 1/(a^2*x^2)]*x^2) + (4*a^3*Sqrt[c - a^2*c*x^2]*Log[x])/(Sqrt[1 - 1/(a^2*x^2)]*x) - (4*a^3*Sqrt[c - a^2*c*x^2]*Log[1 + a*x])/(Sqrt[1 - 1/(a^2*x^2)]*x)}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m E^(n ArcCoth[a x]) (c-c a^2 x^2)^p with m symbolic*)


{E^(3*ArcCoth[a*x])*x^m*Sqrt[c - a^2*c*x^2], x, 5, (3*x^m*Sqrt[c - a^2*c*x^2])/(a*(1 + m)*Sqrt[1 - 1/(a^2*x^2)]) + (x^(1 + m)*Sqrt[c - a^2*c*x^2])/((2 + m)*Sqrt[1 - 1/(a^2*x^2)]) - (4*x^m*Sqrt[c - a^2*c*x^2]*Hypergeometric2F1[1, 1 + m, 2 + m, a*x])/(a*(1 + m)*Sqrt[1 - 1/(a^2*x^2)])}
{E^(2*ArcCoth[a*x])*x^m*Sqrt[c - a^2*c*x^2], x, 8, If[$VersionNumber>=8, (x^(1 + m)*Sqrt[c - a^2*c*x^2])/(2 + m) - (c*(3 + 2*m)*x^(1 + m)*Sqrt[1 - a^2*x^2]*Hypergeometric2F1[1/2, (1 + m)/2, (3 + m)/2, a^2*x^2])/((1 + m)*(2 + m)*Sqrt[c - a^2*c*x^2]) - (2*a*c*x^(2 + m)*Sqrt[1 - a^2*x^2]*Hypergeometric2F1[1/2, (2 + m)/2, (4 + m)/2, a^2*x^2])/((2 + m)*Sqrt[c - a^2*c*x^2]), (x^(1 + m)*Sqrt[c - a^2*c*x^2])/(2 + m) - (c*(3 + 2*m)*x^(1 + m)*Sqrt[1 - a^2*x^2]*Hypergeometric2F1[1/2, (1 + m)/2, (3 + m)/2, a^2*x^2])/((2 + 3*m + m^2)*Sqrt[c - a^2*c*x^2]) - (2*a*c*x^(2 + m)*Sqrt[1 - a^2*x^2]*Hypergeometric2F1[1/2, (2 + m)/2, (4 + m)/2, a^2*x^2])/((2 + m)*Sqrt[c - a^2*c*x^2])]}
{E^(1*ArcCoth[a*x])*x^m*Sqrt[c - a^2*c*x^2], x, 4, (x^m*Sqrt[c - a^2*c*x^2])/(a*(1 + m)*Sqrt[1 - 1/(a^2*x^2)]) + (x^(1 + m)*Sqrt[c - a^2*c*x^2])/((2 + m)*Sqrt[1 - 1/(a^2*x^2)])}
{(x^m*Sqrt[c - a^2*c*x^2])/E^(1*ArcCoth[a*x]), x, 4, -((x^m*Sqrt[c - a^2*c*x^2])/(a*(1 + m)*Sqrt[1 - 1/(a^2*x^2)])) + (x^(1 + m)*Sqrt[c - a^2*c*x^2])/((2 + m)*Sqrt[1 - 1/(a^2*x^2)])}
{(x^m*Sqrt[c - a^2*c*x^2])/E^(2*ArcCoth[a*x]), x, 8, If[$VersionNumber>=8, (x^(1 + m)*Sqrt[c - a^2*c*x^2])/(2 + m) - (c*(3 + 2*m)*x^(1 + m)*Sqrt[1 - a^2*x^2]*Hypergeometric2F1[1/2, (1 + m)/2, (3 + m)/2, a^2*x^2])/((1 + m)*(2 + m)*Sqrt[c - a^2*c*x^2]) + (2*a*c*x^(2 + m)*Sqrt[1 - a^2*x^2]*Hypergeometric2F1[1/2, (2 + m)/2, (4 + m)/2, a^2*x^2])/((2 + m)*Sqrt[c - a^2*c*x^2]), (x^(1 + m)*Sqrt[c - a^2*c*x^2])/(2 + m) - (c*(3 + 2*m)*x^(1 + m)*Sqrt[1 - a^2*x^2]*Hypergeometric2F1[1/2, (1 + m)/2, (3 + m)/2, a^2*x^2])/((2 + 3*m + m^2)*Sqrt[c - a^2*c*x^2]) + (2*a*c*x^(2 + m)*Sqrt[1 - a^2*x^2]*Hypergeometric2F1[1/2, (2 + m)/2, (4 + m)/2, a^2*x^2])/((2 + m)*Sqrt[c - a^2*c*x^2])]}
{(x^m*Sqrt[c - a^2*c*x^2])/E^(3*ArcCoth[a*x]), x, 5, -((3*x^m*Sqrt[c - a^2*c*x^2])/(a*(1 + m)*Sqrt[1 - 1/(a^2*x^2)])) + (x^(1 + m)*Sqrt[c - a^2*c*x^2])/((2 + m)*Sqrt[1 - 1/(a^2*x^2)]) + (4*x^m*Sqrt[c - a^2*c*x^2]*Hypergeometric2F1[1, 1 + m, 2 + m, (-a)*x])/(a*(1 + m)*Sqrt[1 - 1/(a^2*x^2)])}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m E^(n ArcCoth[a x]) (c-c a^2 x^2)^p with n symbolic*)


{E^(n*ArcCoth[a*x])*(c - c*a^2*x^2)^3, x, 3, -((256*c^3*(1 - 1/(a*x))^(4 - n/2)*(1 + 1/(a*x))^((1/2)*(-8 + n))*Hypergeometric2F1[8, 4 - n/2, 5 - n/2, (a - 1/x)/(a + 1/x)])/(a*(8 - n)))}
{E^(n*ArcCoth[a*x])*(c - c*a^2*x^2)^2, x, 3, (64*c^2*(1 - 1/(a*x))^(3 - n/2)*(1 + 1/(a*x))^((1/2)*(-6 + n))*Hypergeometric2F1[6, 3 - n/2, 4 - n/2, (a - 1/x)/(a + 1/x)])/(a*(6 - n))}
{E^(n*ArcCoth[a*x])*(c - c*a^2*x^2)^1, x, 3, -((16*c*(1 - 1/(a*x))^(2 - n/2)*(1 + 1/(a*x))^((1/2)*(-4 + n))*Hypergeometric2F1[4, 2 - n/2, 3 - n/2, (a - 1/x)/(a + 1/x)])/(a*(4 - n)))}
{E^(n*ArcCoth[a*x])*(c - c*a^2*x^2)^0, x, 2, (4*(1 - 1/(a*x))^(1 - n/2)*(1 + 1/(a*x))^((1/2)*(-2 + n))*Hypergeometric2F1[2, 1 - n/2, 2 - n/2, (a - 1/x)/(a + 1/x)])/(a*(2 - n))}
{E^(n*ArcCoth[a*x])/(c - c*a^2*x^2)^1, x, 1, E^(n*ArcCoth[a*x])/(a*c*n)}
{E^(n*ArcCoth[a*x])/(c - c*a^2*x^2)^2, x, 2, (2*E^(n*ArcCoth[a*x]))/(a*c^2*n*(4 - n^2)) - (E^(n*ArcCoth[a*x])*(n - 2*a*x))/(a*c^2*(4 - n^2)*(1 - a^2*x^2))}
{E^(n*ArcCoth[a*x])/(c - c*a^2*x^2)^3, x, 3, If[$VersionNumber>=8, (24*E^(n*ArcCoth[a*x]))/(a*c^3*n*(64 - 20*n^2 + n^4)) - (E^(n*ArcCoth[a*x])*(n - 4*a*x))/(a*c^3*(16 - n^2)*(1 - a^2*x^2)^2) - (12*E^(n*ArcCoth[a*x])*(n - 2*a*x))/(a*c^3*(4 - n^2)*(16 - n^2)*(1 - a^2*x^2)), (24*E^(n*ArcCoth[a*x]))/(a*c^3*n*(64 - 20*n^2 + n^4)) - (E^(n*ArcCoth[a*x])*(n - 4*a*x))/(a*c^3*(16 - n^2)*(1 - a^2*x^2)^2) - (12*E^(n*ArcCoth[a*x])*(n - 2*a*x))/(a*c^3*(64 - 20*n^2 + n^4)*(1 - a^2*x^2))]}
{E^(n*ArcCoth[a*x])/(c - c*a^2*x^2)^4, x, 4, If[$VersionNumber>=8, (720*E^(n*ArcCoth[a*x]))/(a*c^4*n*(36 - n^2)*(64 - 20*n^2 + n^4)) - (E^(n*ArcCoth[a*x])*(n - 6*a*x))/(a*c^4*(36 - n^2)*(1 - a^2*x^2)^3) - (30*E^(n*ArcCoth[a*x])*(n - 4*a*x))/(a*c^4*(16 - n^2)*(36 - n^2)*(1 - a^2*x^2)^2) - (360*E^(n*ArcCoth[a*x])*(n - 2*a*x))/(a*c^4*(4 - n^2)*(16 - n^2)*(36 - n^2)*(1 - a^2*x^2)), (720*E^(n*ArcCoth[a*x]))/(a*c^4*n*(36 - n^2)*(64 - 20*n^2 + n^4)) - (E^(n*ArcCoth[a*x])*(n - 6*a*x))/(a*c^4*(36 - n^2)*(1 - a^2*x^2)^3) - (30*E^(n*ArcCoth[a*x])*(n - 4*a*x))/(a*c^4*(576 - 52*n^2 + n^4)*(1 - a^2*x^2)^2) - (360*E^(n*ArcCoth[a*x])*(n - 2*a*x))/(a*c^4*(36 - n^2)*(64 - 20*n^2 + n^4)*(1 - a^2*x^2))]}


{E^(n*ArcCoth[a*x])*(c - a^2*c*x^2)^(3/2), x, 3, (32*(1 - 1/(a*x))^((5 - n)/2)*(1 + 1/(a*x))^((1/2)*(-5 + n))*(c - a^2*c*x^2)^(3/2)*Hypergeometric2F1[5, (5 - n)/2, (7 - n)/2, (a - 1/x)/(a + 1/x)])/(a^4*(5 - n)*(1 - 1/(a^2*x^2))^(3/2)*x^3)}
{E^(n*ArcCoth[a*x])*(c - a^2*c*x^2)^(1/2), x, 3, (8*(1 - 1/(a*x))^((3 - n)/2)*(1 + 1/(a*x))^((1/2)*(-3 + n))*Sqrt[c - a^2*c*x^2]*Hypergeometric2F1[3, (3 - n)/2, (5 - n)/2, (a - 1/x)/(a + 1/x)])/(a^2*(3 - n)*Sqrt[1 - 1/(a^2*x^2)]*x)}
{E^(n*ArcCoth[a*x])/(c - a^2*c*x^2)^(1/2), x, 3, (2*Sqrt[1 - 1/(a^2*x^2)]*(1 - 1/(a*x))^((1 - n)/2)*(1 + 1/(a*x))^((1/2)*(-1 + n))*x*Hypergeometric2F1[1, (1 - n)/2, (3 - n)/2, (a - 1/x)/(a + 1/x)])/((1 - n)*Sqrt[c - a^2*c*x^2])}
{E^(n*ArcCoth[a*x])/(c - a^2*c*x^2)^(3/2), x, 1, -((E^(n*ArcCoth[a*x])*(n - a*x))/(a*c*(1 - n^2)*Sqrt[c - a^2*c*x^2]))}
{E^(n*ArcCoth[a*x])/(c - a^2*c*x^2)^(5/2), x, 2, If[$VersionNumber>=8, -((E^(n*ArcCoth[a*x])*(n - 3*a*x))/(a*c*(9 - n^2)*(c - a^2*c*x^2)^(3/2))) - (6*E^(n*ArcCoth[a*x])*(n - a*x))/(a*c^2*(1 - n^2)*(9 - n^2)*Sqrt[c - a^2*c*x^2]), -((E^(n*ArcCoth[a*x])*(n - 3*a*x))/(a*c*(9 - n^2)*(c - a^2*c*x^2)^(3/2))) - (6*E^(n*ArcCoth[a*x])*(n - a*x))/(a*c^2*(9 - 10*n^2 + n^4)*Sqrt[c - a^2*c*x^2])]}
{E^(n*ArcCoth[a*x])/(c - a^2*c*x^2)^(7/2), x, 3, If[$VersionNumber>=8, -((E^(n*ArcCoth[a*x])*(n - 5*a*x))/(a*c*(25 - n^2)*(c - a^2*c*x^2)^(5/2))) - (20*E^(n*ArcCoth[a*x])*(n - 3*a*x))/(a*c^2*(9 - n^2)*(25 - n^2)*(c - a^2*c*x^2)^(3/2)) - (120*E^(n*ArcCoth[a*x])*(n - a*x))/(a*c^3*(1 - n^2)*(9 - n^2)*(25 - n^2)*Sqrt[c - a^2*c*x^2]), -((E^(n*ArcCoth[a*x])*(n - 5*a*x))/(a*c*(25 - n^2)*(c - a^2*c*x^2)^(5/2))) - (20*E^(n*ArcCoth[a*x])*(n - 3*a*x))/(a*c^2*(225 - 34*n^2 + n^4)*(c - a^2*c*x^2)^(3/2)) - (120*E^(n*ArcCoth[a*x])*(n - a*x))/(a*c^3*(25 - n^2)*(9 - 10*n^2 + n^4)*Sqrt[c - a^2*c*x^2])]}
{E^(n*ArcCoth[a*x])/(c - a^2*c*x^2)^(9/2), x, 4, If[$VersionNumber>=8, -((E^(n*ArcCoth[a*x])*(n - 7*a*x))/(a*c*(49 - n^2)*(c - a^2*c*x^2)^(7/2))) - (42*E^(n*ArcCoth[a*x])*(n - 5*a*x))/(a*c^2*(25 - n^2)*(49 - n^2)*(c - a^2*c*x^2)^(5/2)) - (840*E^(n*ArcCoth[a*x])*(n - 3*a*x))/(a*c^3*(9 - n^2)*(25 - n^2)*(49 - n^2)*(c - a^2*c*x^2)^(3/2)) - (5040*E^(n*ArcCoth[a*x])*(n - a*x))/(a*c^4*(1 - n^2)*(9 - n^2)*(25 - n^2)*(49 - n^2)*Sqrt[c - a^2*c*x^2]),-((E^(n*ArcCoth[a*x])*(n - 7*a*x))/(a*c*(49 - n^2)*(c - a^2*c*x^2)^(7/2))) - (42*E^(n*ArcCoth[a*x])*(n - 5*a*x))/(a*c^2*(1225 - 74*n^2 + n^4)*(c - a^2*c*x^2)^(5/2)) - (840*E^(n*ArcCoth[a*x])*(n - 3*a*x))/(a*c^3*(49 - n^2)*(225 - 34*n^2 + n^4)*(c - a^2*c*x^2)^(3/2)) - (5040*E^(n*ArcCoth[a*x])*(n - a*x))/(a*c^4*(1225 - 74*n^2 + n^4)*(9 - 10*n^2 + n^4)*Sqrt[c - a^2*c*x^2])]}


{E^(n*ArcCoth[a*x])/(c - a^2*c*x^2)^(3/2)*x^3, x, 7, If[$VersionNumber>=8, -(((2 + n)*(1 - 1/(a^2*x^2))^(3/2)*(1 - 1/(a*x))^((1/2)*(-1 - n))*(1 + 1/(a*x))^((1/2)*(-1 + n))*x^3)/(a*(1 + n)*(c - a^2*c*x^2)^(3/2))) + ((2 + 2*n + n^2)*(1 - 1/(a^2*x^2))^(3/2)*(1 - 1/(a*x))^((1 - n)/2)*(1 + 1/(a*x))^((1/2)*(-1 + n))*x^3)/(a*(1 - n)*(1 + n)*(c - a^2*c*x^2)^(3/2)) + ((1 - 1/(a^2*x^2))^(3/2)*(1 - 1/(a*x))^((1/2)*(-1 - n))*(1 + 1/(a*x))^((1/2)*(-1 + n))*x^4)/(c - a^2*c*x^2)^(3/2) - (2*n*(1 - 1/(a^2*x^2))^(3/2)*(1 - 1/(a*x))^((1 - n)/2)*(1 + 1/(a*x))^((1/2)*(-1 + n))*x^3*Hypergeometric2F1[1, (1/2)*(-1 + n), (1 + n)/2, (a + 1/x)/(a - 1/x)])/(a*(1 - n)*(c - a^2*c*x^2)^(3/2)), -(((2 + n)*(1 - 1/(a^2*x^2))^(3/2)*(1 - 1/(a*x))^((1/2)*(-1 - n))*(1 + 1/(a*x))^((1/2)*(-1 + n))*x^3)/(a*(1 + n)*(c - a^2*c*x^2)^(3/2))) + ((2 + 2*n + n^2)*(1 - 1/(a^2*x^2))^(3/2)*(1 - 1/(a*x))^((1 - n)/2)*(1 + 1/(a*x))^((1/2)*(-1 + n))*x^3)/(a*(1 - n^2)*(c - a^2*c*x^2)^(3/2)) + ((1 - 1/(a^2*x^2))^(3/2)*(1 - 1/(a*x))^((1/2)*(-1 - n))*(1 + 1/(a*x))^((1/2)*(-1 + n))*x^4)/(c - a^2*c*x^2)^(3/2) - (2*n*(1 - 1/(a^2*x^2))^(3/2)*(1 - 1/(a*x))^((1 - n)/2)*(1 + 1/(a*x))^((1/2)*(-1 + n))*x^3*Hypergeometric2F1[1, (1/2)*(-1 + n), (1 + n)/2, (a + 1/x)/(a - 1/x)])/(a*(1 - n)*(c - a^2*c*x^2)^(3/2))]}
{E^(n*ArcCoth[a*x])/(c - a^2*c*x^2)^(3/2)*x^2, x, 4, -((E^(n*ArcCoth[a*x])*(n - a*x))/(a^3*c*(1 - n^2)*Sqrt[c - a^2*c*x^2])) - (2*Sqrt[1 - 1/(a^2*x^2)]*(1 - 1/(a*x))^((1 - n)/2)*(1 + 1/(a*x))^((1/2)*(-1 + n))*x*Hypergeometric2F1[1, (1 - n)/2, (3 - n)/2, (a - 1/x)/(a + 1/x)])/(a^2*c*(1 - n)*Sqrt[c - a^2*c*x^2])}
{E^(n*ArcCoth[a*x])/(c - a^2*c*x^2)^(3/2)*x^1, x, 1, (E^(n*ArcCoth[a*x])*(1 - a*n*x))/(a^2*c*(1 - n^2)*Sqrt[c - a^2*c*x^2])}
{E^(n*ArcCoth[a*x])/(c - a^2*c*x^2)^(3/2)*x^0, x, 1, -((E^(n*ArcCoth[a*x])*(n - a*x))/(a*c*(1 - n^2)*Sqrt[c - a^2*c*x^2]))}
{E^(n*ArcCoth[a*x])/(c - a^2*c*x^2)^(3/2)/x^1, x, 5, -((a^3*(1 - 1/(a^2*x^2))^(3/2)*(1 - 1/(a*x))^((1/2)*(-1 - n))*(1 + 1/(a*x))^((1/2)*(-1 + n))*x^3)/((1 + n)*(c - a^2*c*x^2)^(3/2))) + (a^3*(1 - 1/(a^2*x^2))^(3/2)*(1 - 1/(a*x))^((1 - n)/2)*(1 + 1/(a*x))^((1/2)*(-1 + n))*x^3)/((1 - n^2)*(c - a^2*c*x^2)^(3/2)) - (2^((1 + n)/2)*a^3*(1 - 1/(a^2*x^2))^(3/2)*(1 - 1/(a*x))^((1 - n)/2)*x^3*Hypergeometric2F1[(1 - n)/2, (1 - n)/2, (3 - n)/2, (a - 1/x)/(2*a)])/((1 - n)*(c - a^2*c*x^2)^(3/2))}


{E^(n*ArcCoth[a*x])/(c - a^2*c*x^2)^(5/2)*x^4, x, 8, If[$VersionNumber>=8, -(((1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1/2)*(-3 - n))*(1 + 1/(a*x))^((1/2)*(-3 + n))*x^5)/((3 + n)*(c - a^2*c*x^2)^(5/2))) - ((6 + n)*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1/2)*(-1 - n))*(1 + 1/(a*x))^((1/2)*(-3 + n))*x^5)/((1 + n)*(3 + n)*(c - a^2*c*x^2)^(5/2)) + ((15 + 6*n + n^2)*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1 - n)/2)*(1 + 1/(a*x))^((1/2)*(-3 + n))*x^5)/((1 - n)*(1 + n)*(3 + n)*(c - a^2*c*x^2)^(5/2)) - ((18 + 7*n - 2*n^2 - n^3)*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((3 - n)/2)*(1 + 1/(a*x))^((1/2)*(-3 + n))*x^5)/((9 - 10*n^2 + n^4)*(c - a^2*c*x^2)^(5/2)) - (2*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1 - n)/2)*(1 + 1/(a*x))^((1/2)*(-1 + n))*x^5*Hypergeometric2F1[1, (1/2)*(-1 + n), (1 + n)/2, (a + 1/x)/(a - 1/x)])/((1 - n)*(c - a^2*c*x^2)^(5/2)), -(((1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1/2)*(-3 - n))*(1 + 1/(a*x))^((1/2)*(-3 + n))*x^5)/((3 + n)*(c - a^2*c*x^2)^(5/2))) - ((6 + n)*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1/2)*(-1 - n))*(1 + 1/(a*x))^((1/2)*(-3 + n))*x^5)/((3 + 4*n + n^2)*(c - a^2*c*x^2)^(5/2)) + ((15 + 6*n + n^2)*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1 - n)/2)*(1 + 1/(a*x))^((1/2)*(-3 + n))*x^5)/((3 + n - 3*n^2 - n^3)*(c - a^2*c*x^2)^(5/2)) - ((18 + 7*n - 2*n^2 - n^3)*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((3 - n)/2)*(1 + 1/(a*x))^((1/2)*(-3 + n))*x^5)/((9 - 10*n^2 + n^4)*(c - a^2*c*x^2)^(5/2)) - (2*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1 - n)/2)*(1 + 1/(a*x))^((1/2)*(-1 + n))*x^5*Hypergeometric2F1[1, (1/2)*(-1 + n), (1 + n)/2, (a + 1/x)/(a - 1/x)])/((1 - n)*(c - a^2*c*x^2)^(5/2))]}
{E^(n*ArcCoth[a*x])/(c - a^2*c*x^2)^(5/2)*x^3, x, 6, If[$VersionNumber>=8, -((a*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1/2)*(-3 - n))*(1 + 1/(a*x))^((1/2)*(-3 + n))*x^5)/((3 + n)*(c - a^2*c*x^2)^(5/2))) - (3*a*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1/2)*(-1 - n))*(1 + 1/(a*x))^((1/2)*(-3 + n))*x^5)/((3 + 4*n + n^2)*(c - a^2*c*x^2)^(5/2)) + (6*a*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1 - n)/2)*(1 + 1/(a*x))^((1/2)*(-3 + n))*x^5)/((3 + n)*(1 - n^2)*(c - a^2*c*x^2)^(5/2)) - (6*a*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((3 - n)/2)*(1 + 1/(a*x))^((1/2)*(-3 + n))*x^5)/((9 - 10*n^2 + n^4)*(c - a^2*c*x^2)^(5/2)), -((a*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1/2)*(-3 - n))*(1 + 1/(a*x))^((1/2)*(-3 + n))*x^5)/((3 + n)*(c - a^2*c*x^2)^(5/2))) - (3*a*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1/2)*(-1 - n))*(1 + 1/(a*x))^((1/2)*(-3 + n))*x^5)/((3 + 4*n + n^2)*(c - a^2*c*x^2)^(5/2)) + (6*a*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1 - n)/2)*(1 + 1/(a*x))^((1/2)*(-3 + n))*x^5)/((3 + n - 3*n^2 - n^3)*(c - a^2*c*x^2)^(5/2)) - (6*a*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((3 - n)/2)*(1 + 1/(a*x))^((1/2)*(-3 + n))*x^5)/((9 - 10*n^2 + n^4)*(c - a^2*c*x^2)^(5/2))]}
{E^(n*ArcCoth[a*x])/(c - a^2*c*x^2)^(5/2)*x^2, x, 2, -((E^(n*ArcCoth[a*x])*(n - 3*a*x))/(a^3*c*(9 - n^2)*(c - a^2*c*x^2)^(3/2))) + (E^(n*ArcCoth[a*x])*(3 - n^2)*(n - a*x))/(a^3*c^2*(9 - 10*n^2 + n^4)*Sqrt[c - a^2*c*x^2])}
{E^(n*ArcCoth[a*x])/(c - a^2*c*x^2)^(5/2)*x^1, x, 2, (E^(n*ArcCoth[a*x])*(3 - a*n*x))/(a^2*c*(9 - n^2)*(c - a^2*c*x^2)^(3/2)) + (2*E^(n*ArcCoth[a*x])*n*(n - a*x))/(a^2*c^2*(9 - 10*n^2 + n^4)*Sqrt[c - a^2*c*x^2])}
{E^(n*ArcCoth[a*x])/(c - a^2*c*x^2)^(5/2)*x^0, x, 2, If[$VersionNumber>=8, -((E^(n*ArcCoth[a*x])*(n - 3*a*x))/(a*c*(9 - n^2)*(c - a^2*c*x^2)^(3/2))) - (6*E^(n*ArcCoth[a*x])*(n - a*x))/(a*c^2*(1 - n^2)*(9 - n^2)*Sqrt[c - a^2*c*x^2]), -((E^(n*ArcCoth[a*x])*(n - 3*a*x))/(a*c*(9 - n^2)*(c - a^2*c*x^2)^(3/2))) - (6*E^(n*ArcCoth[a*x])*(n - a*x))/(a*c^2*(9 - 10*n^2 + n^4)*Sqrt[c - a^2*c*x^2])]}
{E^(n*ArcCoth[a*x])/(c - a^2*c*x^2)^(5/2)/x^1, x, 15, If[$VersionNumber>=8, -((a^5*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1/2)*(-3 - n))*(1 + 1/(a*x))^((1/2)*(-3 + n))*x^5)/((3 + n)*(c - a^2*c*x^2)^(5/2))) - (3*a^5*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1/2)*(-1 - n))*(1 + 1/(a*x))^((1/2)*(-3 + n))*x^5)/((3 + 4*n + n^2)*(c - a^2*c*x^2)^(5/2)) + (6*a^5*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1 - n)/2)*(1 + 1/(a*x))^((1/2)*(-3 + n))*x^5)/((3 + n)*(1 - n^2)*(c - a^2*c*x^2)^(5/2)) - (6*a^5*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((3 - n)/2)*(1 + 1/(a*x))^((1/2)*(-3 + n))*x^5)/((9 - 10*n^2 + n^4)*(c - a^2*c*x^2)^(5/2)) + (4*a^5*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1/2)*(-3 - n))*(1 + 1/(a*x))^((1/2)*(-1 + n))*x^5)/((3 + n)*(c - a^2*c*x^2)^(5/2)) + (8*a^5*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1/2)*(-1 - n))*(1 + 1/(a*x))^((1/2)*(-1 + n))*x^5)/((3 + 4*n + n^2)*(c - a^2*c*x^2)^(5/2)) - (8*a^5*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1 - n)/2)*(1 + 1/(a*x))^((1/2)*(-1 + n))*x^5)/((3 + n)*(1 - n^2)*(c - a^2*c*x^2)^(5/2)) - (6*a^5*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1/2)*(-3 - n))*(1 + 1/(a*x))^((1 + n)/2)*x^5)/((3 + n)*(c - a^2*c*x^2)^(5/2)) - (6*a^5*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1/2)*(-1 - n))*(1 + 1/(a*x))^((1 + n)/2)*x^5)/((3 + 4*n + n^2)*(c - a^2*c*x^2)^(5/2)) + (4*a^5*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1/2)*(-3 - n))*(1 + 1/(a*x))^((3 + n)/2)*x^5)/((3 + n)*(c - a^2*c*x^2)^(5/2)) - (2^((5 + n)/2)*a^5*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1/2)*(-3 - n))*x^5*Hypergeometric2F1[(1/2)*(-3 - n), (1/2)*(-3 - n), (1/2)*(-1 - n), (a - 1/x)/(2*a)])/((3 + n)*(c - a^2*c*x^2)^(5/2)), -((a^5*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1/2)*(-3 - n))*(1 + 1/(a*x))^((1/2)*(-3 + n))*x^5)/((3 + n)*(c - a^2*c*x^2)^(5/2))) - (3*a^5*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1/2)*(-1 - n))*(1 + 1/(a*x))^((1/2)*(-3 + n))*x^5)/((3 + 4*n + n^2)*(c - a^2*c*x^2)^(5/2)) + (6*a^5*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1 - n)/2)*(1 + 1/(a*x))^((1/2)*(-3 + n))*x^5)/((3 + n - 3*n^2 - n^3)*(c - a^2*c*x^2)^(5/2)) - (6*a^5*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((3 - n)/2)*(1 + 1/(a*x))^((1/2)*(-3 + n))*x^5)/((9 - 10*n^2 + n^4)*(c - a^2*c*x^2)^(5/2)) + (4*a^5*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1/2)*(-3 - n))*(1 + 1/(a*x))^((1/2)*(-1 + n))*x^5)/((3 + n)*(c - a^2*c*x^2)^(5/2)) + (8*a^5*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1/2)*(-1 - n))*(1 + 1/(a*x))^((1/2)*(-1 + n))*x^5)/((3 + 4*n + n^2)*(c - a^2*c*x^2)^(5/2)) - (8*a^5*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1 - n)/2)*(1 + 1/(a*x))^((1/2)*(-1 + n))*x^5)/((3 + n - 3*n^2 - n^3)*(c - a^2*c*x^2)^(5/2)) - (6*a^5*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1/2)*(-3 - n))*(1 + 1/(a*x))^((1 + n)/2)*x^5)/((3 + n)*(c - a^2*c*x^2)^(5/2)) - (6*a^5*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1/2)*(-1 - n))*(1 + 1/(a*x))^((1 + n)/2)*x^5)/((3 + 4*n + n^2)*(c - a^2*c*x^2)^(5/2)) + (4*a^5*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1/2)*(-3 - n))*(1 + 1/(a*x))^((3 + n)/2)*x^5)/((3 + n)*(c - a^2*c*x^2)^(5/2)) - (2^((5 + n)/2)*a^5*(1 - 1/(a^2*x^2))^(5/2)*(1 - 1/(a*x))^((1/2)*(-3 - n))*x^5*Hypergeometric2F1[(1/2)*(-3 - n), (1/2)*(-3 - n), (1/2)*(-1 - n), (a - 1/x)/(2*a)])/((3 + n)*(c - a^2*c*x^2)^(5/2))]}


(* ::Subsection::Closed:: *)
(*Integrands of the form E^(n ArcCoth[a x]) (c-c a^2 x^2)^p with p symbolic*)


{E^(n*ArcCoth[a*x])*(c - c*a^2*x^2)^p, x, 3, (((a - 1/x)/(a + 1/x))^((1/2)*(n - 2*p))*(1 - 1/(a*x))^(-(n/2) + p)*(1 + 1/(a*x))^(1 + n/2 + p)*x*(c - a^2*c*x^2)^p*Hypergeometric2F1[-1 - 2*p, (1/2)*(n - 2*p), -2*p, 2/((a + 1/x)*x)])/((1 - 1/(a^2*x^2))^p*(1 + 2*p))}


{(c - a^2*c*x^2)^p*E^(2*p*ArcCoth[a*x]), x, 3, ((1 + 1/(a*x))^(1 + 2*p)*x*(c - a^2*c*x^2)^p)/((1 + 2*p)*(1 - 1/(a^2*x^2))^p)}
{(c - a^2*c*x^2)^p/E^(2*p*ArcCoth[a*x]), x, 3, ((1 - 1/(a*x))^(1 + 2*p)*x*(c - a^2*c*x^2)^p)/((1 + 2*p)*(1 - 1/(a^2*x^2))^p)}


{E^(4*ArcCoth[a*x])*(c - a^2*c*x^2)^p, x, 4, (2^(2 + p)*c*(1 + a*x)^(1 - p)*(c - a^2*c*x^2)^(-1 + p)*Hypergeometric2F1[-2 - p, -1 + p, p, (1/2)*(1 - a*x)])/(a*(1 - p))}
{E^(3*ArcCoth[a*x])*(c - a^2*c*x^2)^p, x, 3, (((a - 1/x)/(a + 1/x))^(3/2 - p)*(1 - 1/(a*x))^(-(3/2) + p)*(1 + 1/(a*x))^(5/2 + p)*x*(c - a^2*c*x^2)^p*Hypergeometric2F1[-1 - 2*p, 3/2 - p, -2*p, 2/((a + 1/x)*x)])/((1 - 1/(a^2*x^2))^p*(1 + 2*p))}
{E^(2*ArcCoth[a*x])*(c - a^2*c*x^2)^p, x, 4, (2^(1 + p)*(c - a^2*c*x^2)^p*Hypergeometric2F1[-1 - p, p, 1 + p, (1/2)*(1 - a*x)])/((1 + a*x)^p*(a*p))}
{E^ArcCoth[a*x]*(c - a^2*c*x^2)^p, x, 3, (((a - 1/x)/(a + 1/x))^(1/2 - p)*(1 - 1/(a*x))^(-(1/2) + p)*(1 + 1/(a*x))^(3/2 + p)*x*(c - a^2*c*x^2)^p*Hypergeometric2F1[-1 - 2*p, 1/2 - p, -2*p, 2/((a + 1/x)*x)])/((1 - 1/(a^2*x^2))^p*(1 + 2*p))}
{(c - a^2*c*x^2)^p/E^ArcCoth[a*x], x, 3, (((a - 1/x)/(a + 1/x))^(-(1/2) - p)*(1 - 1/(a*x))^(1/2 + p)*(1 + 1/(a*x))^(1/2 + p)*x*(c - a^2*c*x^2)^p*Hypergeometric2F1[-1 - 2*p, -(1/2) - p, -2*p, 2/((a + 1/x)*x)])/((1 - 1/(a^2*x^2))^p*(1 + 2*p))}
{(c - a^2*c*x^2)^p/E^(2*ArcCoth[a*x]), x, 4, -((2^(1 + p)*(c - a^2*c*x^2)^p*Hypergeometric2F1[-1 - p, p, 1 + p, (1/2)*(1 + a*x)])/((1 - a*x)^p*(a*p)))}
{(c - a^2*c*x^2)^p/E^(3*ArcCoth[a*x]), x, 3, (((a - 1/x)/(a + 1/x))^(-(3/2) - p)*(1 - 1/(a*x))^(3/2 + p)*(1 + 1/(a*x))^(-(1/2) + p)*x*(c - a^2*c*x^2)^p*Hypergeometric2F1[-1 - 2*p, -(3/2) - p, -2*p, 2/((a + 1/x)*x)])/((1 - 1/(a^2*x^2))^p*(1 + 2*p))}


(* ::Section::Closed:: *)
(*Integrands of the form u E^(n ArcCoth[a x]) (c-c/(a^2 x^2))^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form E^(n ArcCoth[a x]) (c-c/(a^2 x^2))^p*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{E^ArcCoth[a*x]*(c - c/(a^2*x^2))^4, x, 14, -((51*c^4*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])/(16*a)) - (67*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2))/(48*a) - (91*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(5/2))/(120*a) - (131*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(7/2))/(280*a) + (61*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(9/2))/(70*a) + (47*c^4*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(9/2))/(42*a) + (8*c^4*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(9/2))/(7*a) + c^4*(1 - 1/(a*x))^(7/2)*(1 + 1/(a*x))^(9/2)*x + (35*c^4*ArcCsc[a*x])/(16*a) + (c^4*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/a}
{E^ArcCoth[a*x]*(c - c/(a^2*x^2))^3, x, 12, -((23*c^3*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])/(8*a)) - (31*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2))/(24*a) - (43*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(5/2))/(60*a) + (23*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(7/2))/(20*a) + (6*c^3*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(7/2))/(5*a) + c^3*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(7/2)*x + (15*c^3*ArcCsc[a*x])/(8*a) + (c^3*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/a}
{E^ArcCoth[a*x]*(c - c/(a^2*x^2))^2, x, 10, -((5*c^2*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])/(2*a)) - (7*c^2*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2))/(6*a) + (4*c^2*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(5/2))/(3*a) + c^2*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(5/2)*x + (3*c^2*ArcCsc[a*x])/(2*a) + (c^2*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/a}
{E^ArcCoth[a*x]*(c - c/(a^2*x^2)), x, 9, -((2*c*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])/a) + c*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2)*x + (c*ArcCsc[a*x])/a + (c*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/a}
{E^ArcCoth[a*x]/(c - c/(a^2*x^2)), x, 6, -((2*Sqrt[1 + 1/(a*x)])/(a*c*Sqrt[1 - 1/(a*x)])) + (Sqrt[1 + 1/(a*x)]*x)/(c*Sqrt[1 - 1/(a*x)]) + ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]]/(a*c)}
{E^ArcCoth[a*x]/(c - c/(a^2*x^2))^2, x, 8, -(4/(3*a*c^2*(1 - 1/(a*x))^(3/2)*Sqrt[1 + 1/(a*x)])) - 11/(3*a*c^2*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]) + (8*Sqrt[1 - 1/(a*x)])/(3*a*c^2*Sqrt[1 + 1/(a*x)]) + x/(c^2*(1 - 1/(a*x))^(3/2)*Sqrt[1 + 1/(a*x)]) + ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]]/(a*c^2)}
{E^ArcCoth[a*x]/(c - c/(a^2*x^2))^3, x, 10, -(6/(5*a*c^3*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(3/2))) - 29/(15*a*c^3*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(3/2)) - 34/(5*a*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2)) + (21*Sqrt[1 - 1/(a*x)])/(5*a*c^3*(1 + 1/(a*x))^(3/2)) + (16*Sqrt[1 - 1/(a*x)])/(5*a*c^3*Sqrt[1 + 1/(a*x)]) + x/(c^3*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(3/2)) + ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]]/(a*c^3)}
{E^ArcCoth[a*x]/(c - c/(a^2*x^2))^4, x, 12, -(8/(7*a*c^4*(1 - 1/(a*x))^(7/2)*(1 + 1/(a*x))^(5/2))) - 11/(7*a*c^4*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(5/2)) - 62/(21*a*c^4*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(5/2)) - 269/(21*a*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(5/2)) + (262*Sqrt[1 - 1/(a*x)])/(35*a*c^4*(1 + 1/(a*x))^(5/2)) + (163*Sqrt[1 - 1/(a*x)])/(35*a*c^4*(1 + 1/(a*x))^(3/2)) + (128*Sqrt[1 - 1/(a*x)])/(35*a*c^4*Sqrt[1 + 1/(a*x)]) + x/(c^4*(1 - 1/(a*x))^(7/2)*(1 + 1/(a*x))^(5/2)) + ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]]/(a*c^4)}


{E^(2*ArcCoth[a*x])*(c - c/(a^2*x^2))^5, x, 5, -(c^5/(9*a^10*x^9)) - c^5/(4*a^9*x^8) + (3*c^5)/(7*a^8*x^7) + (4*c^5)/(3*a^7*x^6) - (2*c^5)/(5*a^6*x^5) - (3*c^5)/(a^5*x^4) - (2*c^5)/(3*a^4*x^3) + (4*c^5)/(a^3*x^2) + (3*c^5)/(a^2*x) + c^5*x + (2*c^5*Log[x])/a}
{E^(2*ArcCoth[a*x])*(c - c/(a^2*x^2))^4, x, 5, c^4/(7*a^8*x^7) + c^4/(3*a^7*x^6) - (2*c^4)/(5*a^6*x^5) - (3*c^4)/(2*a^5*x^4) + (3*c^4)/(a^3*x^2) + (2*c^4)/(a^2*x) + c^4*x + (2*c^4*Log[x])/a}
{E^(2*ArcCoth[a*x])*(c - c/(a^2*x^2))^3, x, 5, -(c^3/(5*a^6*x^5)) - c^3/(2*a^5*x^4) + c^3/(3*a^4*x^3) + (2*c^3)/(a^3*x^2) + c^3/(a^2*x) + c^3*x + (2*c^3*Log[x])/a}
{E^(2*ArcCoth[a*x])*(c - c/(a^2*x^2))^2, x, 5, c^2/(3*a^4*x^3) + c^2/(a^3*x^2) + c^2*x + (2*c^2*Log[x])/a}
{E^(2*ArcCoth[a*x])*(c - c/(a^2*x^2)), x, 5, -(c/(a^2*x)) + c*x + (2*c*Log[x])/a}
{E^(2*ArcCoth[a*x])/(c - c/(a^2*x^2)), x, 5, x/c + 1/(a*c*(1 - a*x)) + (2*Log[1 - a*x])/(a*c)}
{E^(2*ArcCoth[a*x])/(c - c/(a^2*x^2))^2, x, 5, x/c^2 - 1/(4*a*c^2*(1 - a*x)^2) + 7/(4*a*c^2*(1 - a*x)) + (17*Log[1 - a*x])/(8*a*c^2) - Log[1 + a*x]/(8*a*c^2)}
{E^(2*ArcCoth[a*x])/(c - c/(a^2*x^2))^3, x, 5, x/c^3 + 1/(12*a*c^3*(1 - a*x)^3) - 5/(8*a*c^3*(1 - a*x)^2) + 39/(16*a*c^3*(1 - a*x)) - 1/(16*a*c^3*(1 + a*x)) + (9*Log[1 - a*x])/(4*a*c^3) - Log[1 + a*x]/(4*a*c^3)}
{E^(2*ArcCoth[a*x])/(c - c/(a^2*x^2))^4, x, 5, x/c^4 - 1/(32*a*c^4*(1 - a*x)^4) + 13/(48*a*c^4*(1 - a*x)^3) - 35/(32*a*c^4*(1 - a*x)^2) + 99/(32*a*c^4*(1 - a*x)) + 1/(64*a*c^4*(1 + a*x)^2) - 11/(64*a*c^4*(1 + a*x)) + (303*Log[1 - a*x])/(128*a*c^4) - (47*Log[1 + a*x])/(128*a*c^4)}


{E^(3*ArcCoth[a*x])*(c - c/(a^2*x^2))^4, x, 14, -((63*c^4*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])/(16*a)) - (37*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2))/(16*a) - (61*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(5/2))/(40*a) - (303*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(7/2))/(280*a) - (57*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(9/2))/(70*a) + (15*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(11/2))/(14*a) + (8*c^4*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(11/2))/(7*a) + c^4*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(11/2)*x + (15*c^4*ArcCsc[a*x])/(16*a) + (3*c^4*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/a}
{E^(3*ArcCoth[a*x])*(c - c/(a^2*x^2))^3, x, 12, -((27*c^3*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])/(8*a)) - (17*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2))/(8*a) - (29*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(5/2))/(20*a) - (21*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(7/2))/(20*a) + (6*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(9/2))/(5*a) + c^3*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(9/2)*x + (3*c^3*ArcCsc[a*x])/(8*a) + (3*c^3*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/a}
{E^(3*ArcCoth[a*x])*(c - c/(a^2*x^2))^2, x, 10, -((5*c^2*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])/(2*a)) - (11*c^2*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2))/(6*a) - (4*c^2*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(5/2))/(3*a) + c^2*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(7/2)*x - (c^2*ArcCsc[a*x])/(2*a) + (3*c^2*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/a}
{E^(3*ArcCoth[a*x])*(c - c/(a^2*x^2)), x, 8, c*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2)*x - (3*c*ArcCsc[a*x])/a + (3*c*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/a}
{E^(3*ArcCoth[a*x])/(c - c/(a^2*x^2)), x, 7, -((5*Sqrt[1 + 1/(a*x)])/(3*a*c*(1 - 1/(a*x))^(3/2))) - (14*Sqrt[1 + 1/(a*x)])/(3*a*c*Sqrt[1 - 1/(a*x)]) + (Sqrt[1 + 1/(a*x)]*x)/(c*(1 - 1/(a*x))^(3/2)) + (3*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/(a*c)}
{E^(3*ArcCoth[a*x])/(c - c/(a^2*x^2))^2, x, 9, -((6*Sqrt[1 + 1/(a*x)])/(5*a*c^2*(1 - 1/(a*x))^(5/2))) - (9*Sqrt[1 + 1/(a*x)])/(5*a*c^2*(1 - 1/(a*x))^(3/2)) - (24*Sqrt[1 + 1/(a*x)])/(5*a*c^2*Sqrt[1 - 1/(a*x)]) + (Sqrt[1 + 1/(a*x)]*x)/(c^2*(1 - 1/(a*x))^(5/2)) + (3*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/(a*c^2)}
{E^(3*ArcCoth[a*x])/(c - c/(a^2*x^2))^3, x, 10, -(8/(7*a*c^3*(1 - 1/(a*x))^(7/2)*Sqrt[1 + 1/(a*x)])) - 53/(35*a*c^3*(1 - 1/(a*x))^(5/2)*Sqrt[1 + 1/(a*x)]) - 88/(35*a*c^3*(1 - 1/(a*x))^(3/2)*Sqrt[1 + 1/(a*x)]) - 281/(35*a*c^3*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]) + (176*Sqrt[1 - 1/(a*x)])/(35*a*c^3*Sqrt[1 + 1/(a*x)]) + x/(c^3*(1 - 1/(a*x))^(7/2)*Sqrt[1 + 1/(a*x)]) + (3*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/(a*c^3)}
{E^(3*ArcCoth[a*x])/(c - c/(a^2*x^2))^4, x, 12, -(10/(9*a*c^4*(1 - 1/(a*x))^(9/2)*(1 + 1/(a*x))^(3/2))) - 29/(21*a*c^4*(1 - 1/(a*x))^(7/2)*(1 + 1/(a*x))^(3/2)) - 208/(105*a*c^4*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(3/2)) - 1147/(315*a*c^4*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(3/2)) - 1462/(105*a*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2)) + (2609*Sqrt[1 - 1/(a*x)])/(315*a*c^4*(1 + 1/(a*x))^(3/2)) + (1664*Sqrt[1 - 1/(a*x)])/(315*a*c^4*Sqrt[1 + 1/(a*x)]) + x/(c^4*(1 - 1/(a*x))^(9/2)*(1 + 1/(a*x))^(3/2)) + (3*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/(a*c^4)}


{E^(4*ArcCoth[a*x])*(c - c/(a^2*x^2))^5, x, 5, c^5/(9*a^10*x^9) + c^5/(2*a^9*x^8) + (3*c^5)/(7*a^8*x^7) - (4*c^5)/(3*a^7*x^6) - (14*c^5)/(5*a^6*x^5) + (14*c^5)/(3*a^4*x^3) + (4*c^5)/(a^3*x^2) - (3*c^5)/(a^2*x) + c^5*x + (4*c^5*Log[x])/a}
{E^(4*ArcCoth[a*x])*(c - c/(a^2*x^2))^4, x, 5, -(c^4/(7*a^8*x^7)) - (2*c^4)/(3*a^7*x^6) - (4*c^4)/(5*a^6*x^5) + c^4/(a^5*x^4) + (10*c^4)/(3*a^4*x^3) + (2*c^4)/(a^3*x^2) - (4*c^4)/(a^2*x) + c^4*x + (4*c^4*Log[x])/a}
{E^(4*ArcCoth[a*x])*(c - c/(a^2*x^2))^3, x, 5, c^3/(5*a^6*x^5) + c^3/(a^5*x^4) + (5*c^3)/(3*a^4*x^3) - (5*c^3)/(a^2*x) + c^3*x + (4*c^3*Log[x])/a}
{E^(4*ArcCoth[a*x])*(c - c/(a^2*x^2))^2, x, 5, -(c^2/(3*a^4*x^3)) - (2*c^2)/(a^3*x^2) - (6*c^2)/(a^2*x) + c^2*x + (4*c^2*Log[x])/a}
{E^(4*ArcCoth[a*x])*(c - c/(a^2*x^2)), x, 5, c/(a^2*x) + c*x - (4*c*Log[x])/a + (8*c*Log[1 - a*x])/a}
{E^(4*ArcCoth[a*x])/(c - c/(a^2*x^2)), x, 5, x/c - 1/(a*c*(1 - a*x)^2) + 5/(a*c*(1 - a*x)) + (4*Log[1 - a*x])/(a*c)}
{E^(4*ArcCoth[a*x])/(c - c/(a^2*x^2))^2, x, 5, x/c^2 + 1/(3*a*c^2*(1 - a*x)^3) - 2/(a*c^2*(1 - a*x)^2) + 6/(a*c^2*(1 - a*x)) + (4*Log[1 - a*x])/(a*c^2)}
{E^(4*ArcCoth[a*x])/(c - c/(a^2*x^2))^3, x, 5, x/c^3 - 1/(8*a*c^3*(1 - a*x)^4) + 11/(12*a*c^3*(1 - a*x)^3) - 49/(16*a*c^3*(1 - a*x)^2) + 111/(16*a*c^3*(1 - a*x)) + (129*Log[1 - a*x])/(32*a*c^3) - Log[1 + a*x]/(32*a*c^3)}
{E^(4*ArcCoth[a*x])/(c - c/(a^2*x^2))^4, x, 5, x/c^4 + 1/(20*a*c^4*(1 - a*x)^5) - 7/(16*a*c^4*(1 - a*x)^4) + 83/(48*a*c^4*(1 - a*x)^3) - 67/(16*a*c^4*(1 - a*x)^2) + 501/(64*a*c^4*(1 - a*x)) - 1/(64*a*c^4*(1 + a*x)) + (261*Log[1 - a*x])/(64*a*c^4) - (5*Log[1 + a*x])/(64*a*c^4)}


(* ::Subsubsection::Closed:: *)
(*n<0*)


{(c - c/(a^2*x^2))^4/E^ArcCoth[a*x], x, 14, -((19*c^4*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])/(16*a)) - (c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2))/(16*a) + (7*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(5/2))/(40*a) + (19*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(7/2))/(40*a) + (29*c^4*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(7/2))/(30*a) + (7*c^4*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(7/2))/(6*a) + (8*c^4*(1 - 1/(a*x))^(7/2)*(1 + 1/(a*x))^(7/2))/(7*a) + c^4*(1 - 1/(a*x))^(9/2)*(1 + 1/(a*x))^(7/2)*x + (35*c^4*ArcCsc[a*x])/(16*a) - (c^4*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/a}
{(c - c/(a^2*x^2))^3/E^ArcCoth[a*x], x, 12, -((7*c^3*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])/(8*a)) + (c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2))/(24*a) + (11*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(5/2))/(12*a) + (5*c^3*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(5/2))/(4*a) + (6*c^3*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(5/2))/(5*a) + c^3*(1 - 1/(a*x))^(7/2)*(1 + 1/(a*x))^(5/2)*x + (15*c^3*ArcCsc[a*x])/(8*a) - (c^3*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/a}
{(c - c/(a^2*x^2))^2/E^ArcCoth[a*x], x, 10, -((c^2*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])/(2*a)) + (3*c^2*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2))/(2*a) + (4*c^2*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(3/2))/(3*a) + c^2*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(3/2)*x + (3*c^2*ArcCsc[a*x])/(2*a) - (c^2*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/a}
{(c - c/(a^2*x^2))/E^ArcCoth[a*x], x, 9, (2*c*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])/a + c*(1 - 1/(a*x))^(3/2)*Sqrt[1 + 1/(a*x)]*x + (c*ArcCsc[a*x])/a - (c*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/a}
{1/(E^ArcCoth[a*x]*(c - c/(a^2*x^2))), x, 6, (2*Sqrt[1 - 1/(a*x)])/(a*c*Sqrt[1 + 1/(a*x)]) + (Sqrt[1 - 1/(a*x)]*x)/(c*Sqrt[1 + 1/(a*x)]) - ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]]/(a*c)}
{1/(E^ArcCoth[a*x]*(c - c/(a^2*x^2))^2), x, 8, -(2/(a*c^2*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2))) + (5*Sqrt[1 - 1/(a*x)])/(3*a*c^2*(1 + 1/(a*x))^(3/2)) + (8*Sqrt[1 - 1/(a*x)])/(3*a*c^2*Sqrt[1 + 1/(a*x)]) + x/(c^2*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2)) - ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]]/(a*c^2)}
{1/(E^ArcCoth[a*x]*(c - c/(a^2*x^2))^3), x, 10, -(4/(3*a*c^3*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(5/2))) - 13/(3*a*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(5/2)) + (14*Sqrt[1 - 1/(a*x)])/(5*a*c^3*(1 + 1/(a*x))^(5/2)) + (11*Sqrt[1 - 1/(a*x)])/(5*a*c^3*(1 + 1/(a*x))^(3/2)) + (16*Sqrt[1 - 1/(a*x)])/(5*a*c^3*Sqrt[1 + 1/(a*x)]) + x/(c^3*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(5/2)) - ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]]/(a*c^3)}
{1/(E^ArcCoth[a*x]*(c - c/(a^2*x^2))^4), x, 12, -(6/(5*a*c^4*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(7/2))) - 31/(15*a*c^4*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(7/2)) - 28/(3*a*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(7/2)) + (115*Sqrt[1 - 1/(a*x)])/(21*a*c^4*(1 + 1/(a*x))^(7/2)) + (122*Sqrt[1 - 1/(a*x)])/(35*a*c^4*(1 + 1/(a*x))^(5/2)) + (93*Sqrt[1 - 1/(a*x)])/(35*a*c^4*(1 + 1/(a*x))^(3/2)) + (128*Sqrt[1 - 1/(a*x)])/(35*a*c^4*Sqrt[1 + 1/(a*x)]) + x/(c^4*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(7/2)) - ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]]/(a*c^4)}


{(c - c/(a^2*x^2))^4/E^(2*ArcCoth[a*x]), x, 5, c^4/(7*a^8*x^7) - c^4/(3*a^7*x^6) - (2*c^4)/(5*a^6*x^5) + (3*c^4)/(2*a^5*x^4) - (3*c^4)/(a^3*x^2) + (2*c^4)/(a^2*x) + c^4*x - (2*c^4*Log[x])/a}
{(c - c/(a^2*x^2))^3/E^(2*ArcCoth[a*x]), x, 5, -(c^3/(5*a^6*x^5)) + c^3/(2*a^5*x^4) + c^3/(3*a^4*x^3) - (2*c^3)/(a^3*x^2) + c^3/(a^2*x) + c^3*x - (2*c^3*Log[x])/a}
{(c - c/(a^2*x^2))^2/E^(2*ArcCoth[a*x]), x, 5, c^2/(3*a^4*x^3) - c^2/(a^3*x^2) + c^2*x - (2*c^2*Log[x])/a}
{(c - c/(a^2*x^2))/E^(2*ArcCoth[a*x]), x, 5, -(c/(a^2*x)) + c*x - (2*c*Log[x])/a}
{1/(E^(2*ArcCoth[a*x])*(c - c/(a^2*x^2))), x, 5, x/c - 1/(a*c*(1 + a*x)) - (2*Log[1 + a*x])/(a*c)}
{1/(E^(2*ArcCoth[a*x])*(c - c/(a^2*x^2))^2), x, 5, x/c^2 + 1/(4*a*c^2*(1 + a*x)^2) - 7/(4*a*c^2*(1 + a*x)) + Log[1 - a*x]/(8*a*c^2) - (17*Log[1 + a*x])/(8*a*c^2)}
{1/(E^(2*ArcCoth[a*x])*(c - c/(a^2*x^2))^3), x, 5, x/c^3 + 1/(16*a*c^3*(1 - a*x)) - 1/(12*a*c^3*(1 + a*x)^3) + 5/(8*a*c^3*(1 + a*x)^2) - 39/(16*a*c^3*(1 + a*x)) + Log[1 - a*x]/(4*a*c^3) - (9*Log[1 + a*x])/(4*a*c^3)}
{1/(E^(2*ArcCoth[a*x])*(c - c/(a^2*x^2))^4), x, 5, x/c^4 - 1/(64*a*c^4*(1 - a*x)^2) + 11/(64*a*c^4*(1 - a*x)) + 1/(32*a*c^4*(1 + a*x)^4) - 13/(48*a*c^4*(1 + a*x)^3) + 35/(32*a*c^4*(1 + a*x)^2) - 99/(32*a*c^4*(1 + a*x)) + (47*Log[1 - a*x])/(128*a*c^4) - (303*Log[1 + a*x])/(128*a*c^4)}


{(c - c/(a^2*x^2))^4/E^(3*ArcCoth[a*x]), x, 14, (33*c^4*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])/(16*a) + (27*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2))/(16*a) - (3*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(5/2))/(8*a) + (5*c^4*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(5/2))/(8*a) + (11*c^4*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(5/2))/(10*a) + (17*c^4*(1 - 1/(a*x))^(7/2)*(1 + 1/(a*x))^(5/2))/(14*a) + (8*c^4*(1 - 1/(a*x))^(9/2)*(1 + 1/(a*x))^(5/2))/(7*a) + c^4*(1 - 1/(a*x))^(11/2)*(1 + 1/(a*x))^(5/2)*x + (15*c^4*ArcCsc[a*x])/(16*a) - (3*c^4*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/a}
{(c - c/(a^2*x^2))^3/E^(3*ArcCoth[a*x]), x, 12, (21*c^3*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])/(8*a) + (3*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(3/2))/(8*a) + (5*c^3*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(3/2))/(4*a) + (27*c^3*(1 - 1/(a*x))^(5/2)*(1 + 1/(a*x))^(3/2))/(20*a) + (6*c^3*(1 - 1/(a*x))^(7/2)*(1 + 1/(a*x))^(3/2))/(5*a) + c^3*(1 - 1/(a*x))^(9/2)*(1 + 1/(a*x))^(3/2)*x + (3*c^3*ArcCsc[a*x])/(8*a) - (3*c^3*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/a}
{(c - c/(a^2*x^2))^2/E^(3*ArcCoth[a*x]), x, 10, (5*c^2*Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)])/(2*a) + (11*c^2*(1 - 1/(a*x))^(3/2)*Sqrt[1 + 1/(a*x)])/(6*a) + (4*c^2*(1 - 1/(a*x))^(5/2)*Sqrt[1 + 1/(a*x)])/(3*a) + c^2*(1 - 1/(a*x))^(7/2)*Sqrt[1 + 1/(a*x)]*x - (c^2*ArcCsc[a*x])/(2*a) - (3*c^2*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/a}
{(c - c/(a^2*x^2))/E^(3*ArcCoth[a*x]), x, 8, c*(1 - 1/(a*x))^(3/2)*Sqrt[1 + 1/(a*x)]*x - (3*c*ArcCsc[a*x])/a - (3*c*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/a}
{1/(E^(3*ArcCoth[a*x])*(c - c/(a^2*x^2))), x, 7, (5*Sqrt[1 - 1/(a*x)])/(3*a*c*(1 + 1/(a*x))^(3/2)) + (14*Sqrt[1 - 1/(a*x)])/(3*a*c*Sqrt[1 + 1/(a*x)]) + (Sqrt[1 - 1/(a*x)]*x)/(c*(1 + 1/(a*x))^(3/2)) - (3*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/(a*c)}
{1/(E^(3*ArcCoth[a*x])*(c - c/(a^2*x^2))^2), x, 9, (6*Sqrt[1 - 1/(a*x)])/(5*a*c^2*(1 + 1/(a*x))^(5/2)) + (9*Sqrt[1 - 1/(a*x)])/(5*a*c^2*(1 + 1/(a*x))^(3/2)) + (24*Sqrt[1 - 1/(a*x)])/(5*a*c^2*Sqrt[1 + 1/(a*x)]) + (Sqrt[1 - 1/(a*x)]*x)/(c^2*(1 + 1/(a*x))^(5/2)) - (3*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/(a*c^2)}
{1/(E^(3*ArcCoth[a*x])*(c - c/(a^2*x^2))^3), x, 10, -(2/(a*c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(7/2))) + (11*Sqrt[1 - 1/(a*x)])/(7*a*c^3*(1 + 1/(a*x))^(7/2)) + (54*Sqrt[1 - 1/(a*x)])/(35*a*c^3*(1 + 1/(a*x))^(5/2)) + (71*Sqrt[1 - 1/(a*x)])/(35*a*c^3*(1 + 1/(a*x))^(3/2)) + (176*Sqrt[1 - 1/(a*x)])/(35*a*c^3*Sqrt[1 + 1/(a*x)]) + x/(c^3*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(7/2)) - (3*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/(a*c^3)}
{1/(E^(3*ArcCoth[a*x])*(c - c/(a^2*x^2))^4), x, 12, -(4/(3*a*c^4*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(9/2))) - 5/(a*c^4*Sqrt[1 - 1/(a*x)]*(1 + 1/(a*x))^(9/2)) + (28*Sqrt[1 - 1/(a*x)])/(9*a*c^4*(1 + 1/(a*x))^(9/2)) + (139*Sqrt[1 - 1/(a*x)])/(63*a*c^4*(1 + 1/(a*x))^(7/2)) + (202*Sqrt[1 - 1/(a*x)])/(105*a*c^4*(1 + 1/(a*x))^(5/2)) + (719*Sqrt[1 - 1/(a*x)])/(315*a*c^4*(1 + 1/(a*x))^(3/2)) + (1664*Sqrt[1 - 1/(a*x)])/(315*a*c^4*Sqrt[1 + 1/(a*x)]) + x/(c^4*(1 - 1/(a*x))^(3/2)*(1 + 1/(a*x))^(9/2)) - (3*ArcTanh[Sqrt[1 - 1/(a*x)]*Sqrt[1 + 1/(a*x)]])/(a*c^4)}


(* ::Subsection::Closed:: *)
(*Integrands of the form E^(n ArcCoth[a x]) (c-c/(a^2 x^2))^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{E^ArcCoth[a*x]*(c - c/(a^2*x^2))^(7/2), x, 4, (c^3*Sqrt[c - c/(a^2*x^2)])/(6*a^7*Sqrt[1 - 1/(a^2*x^2)]*x^6) + (c^3*Sqrt[c - c/(a^2*x^2)])/(5*a^6*Sqrt[1 - 1/(a^2*x^2)]*x^5) - (3*c^3*Sqrt[c - c/(a^2*x^2)])/(4*a^5*Sqrt[1 - 1/(a^2*x^2)]*x^4) - (c^3*Sqrt[c - c/(a^2*x^2)])/(a^4*Sqrt[1 - 1/(a^2*x^2)]*x^3) + (3*c^3*Sqrt[c - c/(a^2*x^2)])/(2*a^3*Sqrt[1 - 1/(a^2*x^2)]*x^2) + (3*c^3*Sqrt[c - c/(a^2*x^2)])/(a^2*Sqrt[1 - 1/(a^2*x^2)]*x) + (c^3*Sqrt[c - c/(a^2*x^2)]*x)/Sqrt[1 - 1/(a^2*x^2)] + (c^3*Sqrt[c - c/(a^2*x^2)]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)])}
{E^ArcCoth[a*x]*(c - c/(a^2*x^2))^(5/2), x, 4, -((c^2*Sqrt[c - c/(a^2*x^2)])/(4*a^5*Sqrt[1 - 1/(a^2*x^2)]*x^4)) - (c^2*Sqrt[c - c/(a^2*x^2)])/(3*a^4*Sqrt[1 - 1/(a^2*x^2)]*x^3) + (c^2*Sqrt[c - c/(a^2*x^2)])/(a^3*Sqrt[1 - 1/(a^2*x^2)]*x^2) + (2*c^2*Sqrt[c - c/(a^2*x^2)])/(a^2*Sqrt[1 - 1/(a^2*x^2)]*x) + (c^2*Sqrt[c - c/(a^2*x^2)]*x)/Sqrt[1 - 1/(a^2*x^2)] + (c^2*Sqrt[c - c/(a^2*x^2)]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)])}
{E^ArcCoth[a*x]*(c - c/(a^2*x^2))^(3/2), x, 4, (c*Sqrt[c - c/(a^2*x^2)])/(2*a^3*Sqrt[1 - 1/(a^2*x^2)]*x^2) + (c*Sqrt[c - c/(a^2*x^2)])/(a^2*Sqrt[1 - 1/(a^2*x^2)]*x) + (c*Sqrt[c - c/(a^2*x^2)]*x)/Sqrt[1 - 1/(a^2*x^2)] + (c*Sqrt[c - c/(a^2*x^2)]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)])}
{E^ArcCoth[a*x]*Sqrt[c - c/(a^2*x^2)], x, 4, (Sqrt[c - c/(a^2*x^2)]*x)/Sqrt[1 - 1/(a^2*x^2)] + (Sqrt[c - c/(a^2*x^2)]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)])}
{E^ArcCoth[a*x]/Sqrt[c - c/(a^2*x^2)], x, 4, (Sqrt[1 - 1/(a^2*x^2)]*x)/Sqrt[c - c/(a^2*x^2)] + (Sqrt[1 - 1/(a^2*x^2)]*Log[1 - a*x])/(a*Sqrt[c - c/(a^2*x^2)])}
{E^ArcCoth[a*x]/(c - c/(a^2*x^2))^(3/2), x, 4, (Sqrt[1 - 1/(a^2*x^2)]*x)/(c*Sqrt[c - c/(a^2*x^2)]) + Sqrt[1 - 1/(a^2*x^2)]/(2*a*c*Sqrt[c - c/(a^2*x^2)]*(1 - a*x)) + (5*Sqrt[1 - 1/(a^2*x^2)]*Log[1 - a*x])/(4*a*c*Sqrt[c - c/(a^2*x^2)]) - (Sqrt[1 - 1/(a^2*x^2)]*Log[1 + a*x])/(4*a*c*Sqrt[c - c/(a^2*x^2)])}
{E^ArcCoth[a*x]/(c - c/(a^2*x^2))^(5/2), x, 4, (Sqrt[1 - 1/(a^2*x^2)]*x)/(c^2*Sqrt[c - c/(a^2*x^2)]) - Sqrt[1 - 1/(a^2*x^2)]/(8*a*c^2*Sqrt[c - c/(a^2*x^2)]*(1 - a*x)^2) + Sqrt[1 - 1/(a^2*x^2)]/(a*c^2*Sqrt[c - c/(a^2*x^2)]*(1 - a*x)) - Sqrt[1 - 1/(a^2*x^2)]/(8*a*c^2*Sqrt[c - c/(a^2*x^2)]*(1 + a*x)) + (23*Sqrt[1 - 1/(a^2*x^2)]*Log[1 - a*x])/(16*a*c^2*Sqrt[c - c/(a^2*x^2)]) - (7*Sqrt[1 - 1/(a^2*x^2)]*Log[1 + a*x])/(16*a*c^2*Sqrt[c - c/(a^2*x^2)])}
{E^ArcCoth[a*x]/(c - c/(a^2*x^2))^(7/2), x, 4, (Sqrt[1 - 1/(a^2*x^2)]*x)/(c^3*Sqrt[c - c/(a^2*x^2)]) + Sqrt[1 - 1/(a^2*x^2)]/(24*a*c^3*Sqrt[c - c/(a^2*x^2)]*(1 - a*x)^3) - (11*Sqrt[1 - 1/(a^2*x^2)])/(32*a*c^3*Sqrt[c - c/(a^2*x^2)]*(1 - a*x)^2) + (3*Sqrt[1 - 1/(a^2*x^2)])/(2*a*c^3*Sqrt[c - c/(a^2*x^2)]*(1 - a*x)) + Sqrt[1 - 1/(a^2*x^2)]/(32*a*c^3*Sqrt[c - c/(a^2*x^2)]*(1 + a*x)^2) - (5*Sqrt[1 - 1/(a^2*x^2)])/(16*a*c^3*Sqrt[c - c/(a^2*x^2)]*(1 + a*x)) + (51*Sqrt[1 - 1/(a^2*x^2)]*Log[1 - a*x])/(32*a*c^3*Sqrt[c - c/(a^2*x^2)]) - (19*Sqrt[1 - 1/(a^2*x^2)]*Log[1 + a*x])/(32*a*c^3*Sqrt[c - c/(a^2*x^2)])}


{E^(2*ArcCoth[a*x])*(c - c/(a^2*x^2))^(7/2), x, 15, (11*a^3*(c - c/(a^2*x^2))^(7/2)*x^4)/(30*(1 - a*x)^3) - (57*a^6*(c - c/(a^2*x^2))^(7/2)*x^7)/(16*(1 - a*x)^3*(1 + a*x)^3) + (41*a^5*(c - c/(a^2*x^2))^(7/2)*x^6)/(24*(1 - a*x)^3*(1 + a*x)^2) + (57*a^4*(c - c/(a^2*x^2))^(7/2)*x^5)/(80*(1 - a*x)^3*(1 + a*x)) - (13*a^2*(c - c/(a^2*x^2))^(7/2)*x^3*(1 + a*x))/(40*(1 - a*x)^3) + (a*(c - c/(a^2*x^2))^(7/2)*x^2*(1 + a*x))/(15*(1 - a*x)^2) + ((c - c/(a^2*x^2))^(7/2)*x*(1 + a*x))/(6*(1 - a*x)) + (2*a^6*(c - c/(a^2*x^2))^(7/2)*x^7*ArcSin[a*x])/((1 - a*x)^(7/2)*(1 + a*x)^(7/2)) + (25*a^6*(c - c/(a^2*x^2))^(7/2)*x^7*ArcTanh[Sqrt[1 - a*x]*Sqrt[1 + a*x]])/(16*(1 - a*x)^(7/2)*(1 + a*x)^(7/2))}
{E^(2*ArcCoth[a*x])*(c - c/(a^2*x^2))^(5/2), x, 13, -((5*a^2*(c - c/(a^2*x^2))^(5/2)*x^3)/(8*(1 - a*x)^2)) + (25*a^4*(c - c/(a^2*x^2))^(5/2)*x^5)/(8*(1 - a*x)^2*(1 + a*x)^2) - (17*a^3*(c - c/(a^2*x^2))^(5/2)*x^4)/(12*(1 - a*x)^2*(1 + a*x)) + (a*(c - c/(a^2*x^2))^(5/2)*x^2*(1 + a*x))/(6*(1 - a*x)^2) + ((c - c/(a^2*x^2))^(5/2)*x*(1 + a*x))/(4*(1 - a*x)) - (2*a^4*(c - c/(a^2*x^2))^(5/2)*x^5*ArcSin[a*x])/((1 - a*x)^(5/2)*(1 + a*x)^(5/2)) - (9*a^4*(c - c/(a^2*x^2))^(5/2)*x^5*ArcTanh[Sqrt[1 - a*x]*Sqrt[1 + a*x]])/(8*(1 - a*x)^(5/2)*(1 + a*x)^(5/2))}
{E^(2*ArcCoth[a*x])*(c - c/(a^2*x^2))^(3/2), x, 11, (a*(c - c/(a^2*x^2))^(3/2)*x^2)/(1 - a*x) - (5*a^2*(c - c/(a^2*x^2))^(3/2)*x^3)/(2*(1 - a*x)*(1 + a*x)) + ((c - c/(a^2*x^2))^(3/2)*x*(1 + a*x))/(2*(1 - a*x)) + (2*a^2*(c - c/(a^2*x^2))^(3/2)*x^3*ArcSin[a*x])/((1 - a*x)^(3/2)*(1 + a*x)^(3/2)) + (a^2*(c - c/(a^2*x^2))^(3/2)*x^3*ArcTanh[Sqrt[1 - a*x]*Sqrt[1 + a*x]])/(2*(1 - a*x)^(3/2)*(1 + a*x)^(3/2))}
{E^(2*ArcCoth[a*x])*Sqrt[c - c/(a^2*x^2)], x, 9, Sqrt[c - c/(a^2*x^2)]*x - (2*Sqrt[c - c/(a^2*x^2)]*x*ArcSin[a*x])/(Sqrt[1 - a*x]*Sqrt[1 + a*x]) + (Sqrt[c - c/(a^2*x^2)]*x*ArcTanh[Sqrt[1 - a*x]*Sqrt[1 + a*x]])/(Sqrt[1 - a*x]*Sqrt[1 + a*x])}
{E^(2*ArcCoth[a*x])/Sqrt[c - c/(a^2*x^2)], x, 7, -((2*(1 - a*x)*(1 + a*x))/(a^2*Sqrt[c - c/(a^2*x^2)]*x)) - (1 + a*x)^2/(a^2*Sqrt[c - c/(a^2*x^2)]*x) + (2*Sqrt[1 - a*x]*Sqrt[1 + a*x]*ArcSin[a*x])/(a^2*Sqrt[c - c/(a^2*x^2)]*x)}
{E^(2*ArcCoth[a*x])/(c - c/(a^2*x^2))^(3/2), x, 7, -((1 + a*x)^2/(3*a^2*(c - c/(a^2*x^2))^(3/2)*x)) + (2*(5 - 2*a*x)*(1 - a*x)*(1 + a*x)^2)/(3*a^4*(c - c/(a^2*x^2))^(3/2)*x^3) - (2*(1 - a*x)^(3/2)*(1 + a*x)^(3/2)*ArcSin[a*x])/(a^4*(c - c/(a^2*x^2))^(3/2)*x^3)}
{E^(2*ArcCoth[a*x])/(c - c/(a^2*x^2))^(5/2), x, 9, -((1 + a*x)^2/(5*a^2*(c - c/(a^2*x^2))^(5/2)*x)) + (2*(1 - a*x)*(1 + a*x)^2)/(3*a^3*(c - c/(a^2*x^2))^(5/2)*x^2) - (58*(1 - a*x)^2*(1 + a*x)^2)/(15*a^4*(c - c/(a^2*x^2))^(5/2)*x^3) - (2*(1 - a*x)^3*(1 + a*x)^2*(28 + 43*a*x))/(15*a^6*(c - c/(a^2*x^2))^(5/2)*x^5) + (2*(1 - a*x)^(5/2)*(1 + a*x)^(5/2)*ArcSin[a*x])/(a^6*(c - c/(a^2*x^2))^(5/2)*x^5)}
{E^(2*ArcCoth[a*x])/(c - c/(a^2*x^2))^(7/2), x, 11, -((1 + a*x)^2/(7*a^2*(c - c/(a^2*x^2))^(7/2)*x)) + (2*(1 - a*x)*(1 + a*x)^2)/(5*a^3*(c - c/(a^2*x^2))^(7/2)*x^2) - (124*(1 - a*x)^2*(1 + a*x)^2)/(105*a^4*(c - c/(a^2*x^2))^(7/2)*x^3) + (782*(1 - a*x)^3*(1 + a*x)^2)/(105*a^5*(c - c/(a^2*x^2))^(7/2)*x^4) + (142*(1 - a*x)^4*(1 + a*x)^2)/(35*a^6*(c - c/(a^2*x^2))^(7/2)*x^5) + (2*(1 - a*x)^4*(1 + a*x)^3*(72 + 107*a*x))/(35*a^8*(c - c/(a^2*x^2))^(7/2)*x^7) - (2*(1 - a*x)^(7/2)*(1 + a*x)^(7/2)*ArcSin[a*x])/(a^8*(c - c/(a^2*x^2))^(7/2)*x^7)}


{E^(3*ArcCoth[a*x])*(c - c/(a^2*x^2))^(9/2), x, 4, (c^4*Sqrt[c - c/(a^2*x^2)])/(8*a^9*Sqrt[1 - 1/(a^2*x^2)]*x^8) + (3*c^4*Sqrt[c - c/(a^2*x^2)])/(7*a^8*Sqrt[1 - 1/(a^2*x^2)]*x^7) - (8*c^4*Sqrt[c - c/(a^2*x^2)])/(5*a^6*Sqrt[1 - 1/(a^2*x^2)]*x^5) - (3*c^4*Sqrt[c - c/(a^2*x^2)])/(2*a^5*Sqrt[1 - 1/(a^2*x^2)]*x^4) + (2*c^4*Sqrt[c - c/(a^2*x^2)])/(a^4*Sqrt[1 - 1/(a^2*x^2)]*x^3) + (4*c^4*Sqrt[c - c/(a^2*x^2)])/(a^3*Sqrt[1 - 1/(a^2*x^2)]*x^2) + (c^4*Sqrt[c - c/(a^2*x^2)]*x)/Sqrt[1 - 1/(a^2*x^2)] + (3*c^4*Sqrt[c - c/(a^2*x^2)]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)])}
{E^(3*ArcCoth[a*x])*(c - c/(a^2*x^2))^(7/2), x, 4, -((c^3*Sqrt[c - c/(a^2*x^2)])/(6*a^7*Sqrt[1 - 1/(a^2*x^2)]*x^6)) - (3*c^3*Sqrt[c - c/(a^2*x^2)])/(5*a^6*Sqrt[1 - 1/(a^2*x^2)]*x^5) - (c^3*Sqrt[c - c/(a^2*x^2)])/(4*a^5*Sqrt[1 - 1/(a^2*x^2)]*x^4) + (5*c^3*Sqrt[c - c/(a^2*x^2)])/(3*a^4*Sqrt[1 - 1/(a^2*x^2)]*x^3) + (5*c^3*Sqrt[c - c/(a^2*x^2)])/(2*a^3*Sqrt[1 - 1/(a^2*x^2)]*x^2) - (c^3*Sqrt[c - c/(a^2*x^2)])/(a^2*Sqrt[1 - 1/(a^2*x^2)]*x) + (c^3*Sqrt[c - c/(a^2*x^2)]*x)/Sqrt[1 - 1/(a^2*x^2)] + (3*c^3*Sqrt[c - c/(a^2*x^2)]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)])}
{E^(3*ArcCoth[a*x])*(c - c/(a^2*x^2))^(5/2), x, 4, (c^2*Sqrt[c - c/(a^2*x^2)])/(4*a^5*Sqrt[1 - 1/(a^2*x^2)]*x^4) + (c^2*Sqrt[c - c/(a^2*x^2)])/(a^4*Sqrt[1 - 1/(a^2*x^2)]*x^3) + (c^2*Sqrt[c - c/(a^2*x^2)])/(a^3*Sqrt[1 - 1/(a^2*x^2)]*x^2) - (2*c^2*Sqrt[c - c/(a^2*x^2)])/(a^2*Sqrt[1 - 1/(a^2*x^2)]*x) + (c^2*Sqrt[c - c/(a^2*x^2)]*x)/Sqrt[1 - 1/(a^2*x^2)] + (3*c^2*Sqrt[c - c/(a^2*x^2)]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)])}
{E^(3*ArcCoth[a*x])*(c - c/(a^2*x^2))^(3/2), x, 4, -((c*Sqrt[c - c/(a^2*x^2)])/(2*a^3*Sqrt[1 - 1/(a^2*x^2)]*x^2)) - (3*c*Sqrt[c - c/(a^2*x^2)])/(a^2*Sqrt[1 - 1/(a^2*x^2)]*x) + (c*Sqrt[c - c/(a^2*x^2)]*x)/Sqrt[1 - 1/(a^2*x^2)] + (3*c*Sqrt[c - c/(a^2*x^2)]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)])}
{E^(3*ArcCoth[a*x])*Sqrt[c - c/(a^2*x^2)], x, 4, (Sqrt[c - c/(a^2*x^2)]*x)/Sqrt[1 - 1/(a^2*x^2)] - (Sqrt[c - c/(a^2*x^2)]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)]) + (4*Sqrt[c - c/(a^2*x^2)]*Log[1 - a*x])/(a*Sqrt[1 - 1/(a^2*x^2)])}
{E^(3*ArcCoth[a*x])/Sqrt[c - c/(a^2*x^2)], x, 4, (Sqrt[1 - 1/(a^2*x^2)]*x)/Sqrt[c - c/(a^2*x^2)] + (2*Sqrt[1 - 1/(a^2*x^2)])/(a*Sqrt[c - c/(a^2*x^2)]*(1 - a*x)) + (3*Sqrt[1 - 1/(a^2*x^2)]*Log[1 - a*x])/(a*Sqrt[c - c/(a^2*x^2)])}
{E^(3*ArcCoth[a*x])/(c - c/(a^2*x^2))^(3/2), x, 4, (Sqrt[1 - 1/(a^2*x^2)]*x)/(c*Sqrt[c - c/(a^2*x^2)]) - Sqrt[1 - 1/(a^2*x^2)]/(2*a*c*Sqrt[c - c/(a^2*x^2)]*(1 - a*x)^2) + (3*Sqrt[1 - 1/(a^2*x^2)])/(a*c*Sqrt[c - c/(a^2*x^2)]*(1 - a*x)) + (3*Sqrt[1 - 1/(a^2*x^2)]*Log[1 - a*x])/(a*c*Sqrt[c - c/(a^2*x^2)])}
{E^(3*ArcCoth[a*x])/(c - c/(a^2*x^2))^(5/2), x, 4, (Sqrt[1 - 1/(a^2*x^2)]*x)/(c^2*Sqrt[c - c/(a^2*x^2)]) + Sqrt[1 - 1/(a^2*x^2)]/(6*a*c^2*Sqrt[c - c/(a^2*x^2)]*(1 - a*x)^3) - (9*Sqrt[1 - 1/(a^2*x^2)])/(8*a*c^2*Sqrt[c - c/(a^2*x^2)]*(1 - a*x)^2) + (31*Sqrt[1 - 1/(a^2*x^2)])/(8*a*c^2*Sqrt[c - c/(a^2*x^2)]*(1 - a*x)) + (49*Sqrt[1 - 1/(a^2*x^2)]*Log[1 - a*x])/(16*a*c^2*Sqrt[c - c/(a^2*x^2)]) - (Sqrt[1 - 1/(a^2*x^2)]*Log[1 + a*x])/(16*a*c^2*Sqrt[c - c/(a^2*x^2)])}
{E^(3*ArcCoth[a*x])/(c - c/(a^2*x^2))^(7/2), x, 4, (Sqrt[1 - 1/(a^2*x^2)]*x)/(c^3*Sqrt[c - c/(a^2*x^2)]) - Sqrt[1 - 1/(a^2*x^2)]/(16*a*c^3*Sqrt[c - c/(a^2*x^2)]*(1 - a*x)^4) + Sqrt[1 - 1/(a^2*x^2)]/(2*a*c^3*Sqrt[c - c/(a^2*x^2)]*(1 - a*x)^3) - (59*Sqrt[1 - 1/(a^2*x^2)])/(32*a*c^3*Sqrt[c - c/(a^2*x^2)]*(1 - a*x)^2) + (75*Sqrt[1 - 1/(a^2*x^2)])/(16*a*c^3*Sqrt[c - c/(a^2*x^2)]*(1 - a*x)) - Sqrt[1 - 1/(a^2*x^2)]/(32*a*c^3*Sqrt[c - c/(a^2*x^2)]*(1 + a*x)) + (201*Sqrt[1 - 1/(a^2*x^2)]*Log[1 - a*x])/(64*a*c^3*Sqrt[c - c/(a^2*x^2)]) - (9*Sqrt[1 - 1/(a^2*x^2)]*Log[1 + a*x])/(64*a*c^3*Sqrt[c - c/(a^2*x^2)])}


(* ::Subsubsection::Closed:: *)
(*n<0*)


{(c - c/(a^2*x^2))^(7/2)/E^ArcCoth[a*x], x, 4, -((c^3*Sqrt[c - c/(a^2*x^2)])/(6*a^7*Sqrt[1 - 1/(a^2*x^2)]*x^6)) + (c^3*Sqrt[c - c/(a^2*x^2)])/(5*a^6*Sqrt[1 - 1/(a^2*x^2)]*x^5) + (3*c^3*Sqrt[c - c/(a^2*x^2)])/(4*a^5*Sqrt[1 - 1/(a^2*x^2)]*x^4) - (c^3*Sqrt[c - c/(a^2*x^2)])/(a^4*Sqrt[1 - 1/(a^2*x^2)]*x^3) - (3*c^3*Sqrt[c - c/(a^2*x^2)])/(2*a^3*Sqrt[1 - 1/(a^2*x^2)]*x^2) + (3*c^3*Sqrt[c - c/(a^2*x^2)])/(a^2*Sqrt[1 - 1/(a^2*x^2)]*x) + (c^3*Sqrt[c - c/(a^2*x^2)]*x)/Sqrt[1 - 1/(a^2*x^2)] - (c^3*Sqrt[c - c/(a^2*x^2)]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)])}
{(c - c/(a^2*x^2))^(5/2)/E^ArcCoth[a*x], x, 4, (c^2*Sqrt[c - c/(a^2*x^2)])/(4*a^5*Sqrt[1 - 1/(a^2*x^2)]*x^4) - (c^2*Sqrt[c - c/(a^2*x^2)])/(3*a^4*Sqrt[1 - 1/(a^2*x^2)]*x^3) - (c^2*Sqrt[c - c/(a^2*x^2)])/(a^3*Sqrt[1 - 1/(a^2*x^2)]*x^2) + (2*c^2*Sqrt[c - c/(a^2*x^2)])/(a^2*Sqrt[1 - 1/(a^2*x^2)]*x) + (c^2*Sqrt[c - c/(a^2*x^2)]*x)/Sqrt[1 - 1/(a^2*x^2)] - (c^2*Sqrt[c - c/(a^2*x^2)]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)])}
{(c - c/(a^2*x^2))^(3/2)/E^ArcCoth[a*x], x, 4, -((c*Sqrt[c - c/(a^2*x^2)])/(2*a^3*Sqrt[1 - 1/(a^2*x^2)]*x^2)) + (c*Sqrt[c - c/(a^2*x^2)])/(a^2*Sqrt[1 - 1/(a^2*x^2)]*x) + (c*Sqrt[c - c/(a^2*x^2)]*x)/Sqrt[1 - 1/(a^2*x^2)] - (c*Sqrt[c - c/(a^2*x^2)]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)])}
{Sqrt[c - c/(a^2*x^2)]/E^ArcCoth[a*x], x, 4, (Sqrt[c - c/(a^2*x^2)]*x)/Sqrt[1 - 1/(a^2*x^2)] - (Sqrt[c - c/(a^2*x^2)]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)])}
{1/(E^ArcCoth[a*x]*Sqrt[c - c/(a^2*x^2)]), x, 4, (Sqrt[1 - 1/(a^2*x^2)]*x)/Sqrt[c - c/(a^2*x^2)] - (Sqrt[1 - 1/(a^2*x^2)]*Log[1 + a*x])/(a*Sqrt[c - c/(a^2*x^2)])}
{1/(E^ArcCoth[a*x]*(c - c/(a^2*x^2))^(3/2)), x, 4, (Sqrt[1 - 1/(a^2*x^2)]*x)/(c*Sqrt[c - c/(a^2*x^2)]) - Sqrt[1 - 1/(a^2*x^2)]/(2*a*c*Sqrt[c - c/(a^2*x^2)]*(1 + a*x)) + (Sqrt[1 - 1/(a^2*x^2)]*Log[1 - a*x])/(4*a*c*Sqrt[c - c/(a^2*x^2)]) - (5*Sqrt[1 - 1/(a^2*x^2)]*Log[1 + a*x])/(4*a*c*Sqrt[c - c/(a^2*x^2)])}
{1/(E^ArcCoth[a*x]*(c - c/(a^2*x^2))^(5/2)), x, 4, (Sqrt[1 - 1/(a^2*x^2)]*x)/(c^2*Sqrt[c - c/(a^2*x^2)]) + Sqrt[1 - 1/(a^2*x^2)]/(8*a*c^2*Sqrt[c - c/(a^2*x^2)]*(1 - a*x)) + Sqrt[1 - 1/(a^2*x^2)]/(8*a*c^2*Sqrt[c - c/(a^2*x^2)]*(1 + a*x)^2) - Sqrt[1 - 1/(a^2*x^2)]/(a*c^2*Sqrt[c - c/(a^2*x^2)]*(1 + a*x)) + (7*Sqrt[1 - 1/(a^2*x^2)]*Log[1 - a*x])/(16*a*c^2*Sqrt[c - c/(a^2*x^2)]) - (23*Sqrt[1 - 1/(a^2*x^2)]*Log[1 + a*x])/(16*a*c^2*Sqrt[c - c/(a^2*x^2)])}
{1/(E^ArcCoth[a*x]*(c - c/(a^2*x^2))^(7/2)), x, 4, (Sqrt[1 - 1/(a^2*x^2)]*x)/(c^3*Sqrt[c - c/(a^2*x^2)]) - Sqrt[1 - 1/(a^2*x^2)]/(32*a*c^3*Sqrt[c - c/(a^2*x^2)]*(1 - a*x)^2) + (5*Sqrt[1 - 1/(a^2*x^2)])/(16*a*c^3*Sqrt[c - c/(a^2*x^2)]*(1 - a*x)) - Sqrt[1 - 1/(a^2*x^2)]/(24*a*c^3*Sqrt[c - c/(a^2*x^2)]*(1 + a*x)^3) + (11*Sqrt[1 - 1/(a^2*x^2)])/(32*a*c^3*Sqrt[c - c/(a^2*x^2)]*(1 + a*x)^2) - (3*Sqrt[1 - 1/(a^2*x^2)])/(2*a*c^3*Sqrt[c - c/(a^2*x^2)]*(1 + a*x)) + (19*Sqrt[1 - 1/(a^2*x^2)]*Log[1 - a*x])/(32*a*c^3*Sqrt[c - c/(a^2*x^2)]) - (51*Sqrt[1 - 1/(a^2*x^2)]*Log[1 + a*x])/(32*a*c^3*Sqrt[c - c/(a^2*x^2)])}


{(c - c/(a^2*x^2))^(7/2)/E^(2*ArcCoth[a*x]), x, 15, (7*a^6*(c - c/(a^2*x^2))^(7/2)*x^7)/(16*(1 - a*x)^3*(1 + a*x)^3) + (3*a^5*(c - c/(a^2*x^2))^(7/2)*x^6)/(8*(1 - a*x)^3*(1 + a*x)^2) - (a*(c - c/(a^2*x^2))^(7/2)*x^2)/(15*(1 + a*x)) - (19*a^4*(c - c/(a^2*x^2))^(7/2)*x^5)/(16*(1 - a*x)^3*(1 + a*x)) + (2*a^3*(c - c/(a^2*x^2))^(7/2)*x^4)/(3*(1 - a*x)^2*(1 + a*x)) - (23*a^2*(c - c/(a^2*x^2))^(7/2)*x^3)/(120*(1 - a*x)*(1 + a*x)) + ((c - c/(a^2*x^2))^(7/2)*x*(1 - a*x))/(6*(1 + a*x)) - (2*a^6*(c - c/(a^2*x^2))^(7/2)*x^7*ArcSin[a*x])/((1 - a*x)^(7/2)*(1 + a*x)^(7/2)) + (25*a^6*(c - c/(a^2*x^2))^(7/2)*x^7*ArcTanh[Sqrt[1 - a*x]*Sqrt[1 + a*x]])/(16*(1 - a*x)^(7/2)*(1 + a*x)^(7/2))}
{(c - c/(a^2*x^2))^(5/2)/E^(2*ArcCoth[a*x]), x, 13, -((7*a^4*(c - c/(a^2*x^2))^(5/2)*x^5)/(8*(1 - a*x)^2*(1 + a*x)^2)) - (a*(c - c/(a^2*x^2))^(5/2)*x^2)/(6*(1 + a*x)) + (2*a^3*(c - c/(a^2*x^2))^(5/2)*x^4)/((1 - a*x)^2*(1 + a*x)) - (7*a^2*(c - c/(a^2*x^2))^(5/2)*x^3)/(24*(1 - a*x)*(1 + a*x)) + ((c - c/(a^2*x^2))^(5/2)*x*(1 - a*x))/(4*(1 + a*x)) + (2*a^4*(c - c/(a^2*x^2))^(5/2)*x^5*ArcSin[a*x])/((1 - a*x)^(5/2)*(1 + a*x)^(5/2)) - (9*a^4*(c - c/(a^2*x^2))^(5/2)*x^5*ArcTanh[Sqrt[1 - a*x]*Sqrt[1 + a*x]])/(8*(1 - a*x)^(5/2)*(1 + a*x)^(5/2))}
{(c - c/(a^2*x^2))^(3/2)/E^(2*ArcCoth[a*x]), x, 11, -((a*(c - c/(a^2*x^2))^(3/2)*x^2)/(1 + a*x)) - (5*a^2*(c - c/(a^2*x^2))^(3/2)*x^3)/(2*(1 - a*x)*(1 + a*x)) + ((c - c/(a^2*x^2))^(3/2)*x*(1 - a*x))/(2*(1 + a*x)) - (2*a^2*(c - c/(a^2*x^2))^(3/2)*x^3*ArcSin[a*x])/((1 - a*x)^(3/2)*(1 + a*x)^(3/2)) + (a^2*(c - c/(a^2*x^2))^(3/2)*x^3*ArcTanh[Sqrt[1 - a*x]*Sqrt[1 + a*x]])/(2*(1 - a*x)^(3/2)*(1 + a*x)^(3/2))}
{Sqrt[c - c/(a^2*x^2)]/E^(2*ArcCoth[a*x]), x, 9, Sqrt[c - c/(a^2*x^2)]*x + (2*Sqrt[c - c/(a^2*x^2)]*x*ArcSin[a*x])/(Sqrt[1 - a*x]*Sqrt[1 + a*x]) + (Sqrt[c - c/(a^2*x^2)]*x*ArcTanh[Sqrt[1 - a*x]*Sqrt[1 + a*x]])/(Sqrt[1 - a*x]*Sqrt[1 + a*x])}
{1/(E^(2*ArcCoth[a*x])*Sqrt[c - c/(a^2*x^2)]), x, 7, -((1 - a*x)^2/(a^2*Sqrt[c - c/(a^2*x^2)]*x)) - (2*(1 - a*x)*(1 + a*x))/(a^2*Sqrt[c - c/(a^2*x^2)]*x) - (2*Sqrt[1 - a*x]*Sqrt[1 + a*x]*ArcSin[a*x])/(a^2*Sqrt[c - c/(a^2*x^2)]*x)}
{1/(E^(2*ArcCoth[a*x])*(c - c/(a^2*x^2))^(3/2)), x, 7, -((1 - a*x)^2/(3*a^2*(c - c/(a^2*x^2))^(3/2)*x)) + (2*(1 - a*x)^2*(1 + a*x)*(5 + 2*a*x))/(3*a^4*(c - c/(a^2*x^2))^(3/2)*x^3) + (2*(1 - a*x)^(3/2)*(1 + a*x)^(3/2)*ArcSin[a*x])/(a^4*(c - c/(a^2*x^2))^(3/2)*x^3)}
{1/(E^(2*ArcCoth[a*x])*(c - c/(a^2*x^2))^(5/2)), x, 9, -((1 - a*x)^2/(a^2*(c - c/(a^2*x^2))^(5/2)*x)) - (2*(1 - a*x)^3)/(5*a^3*(c - c/(a^2*x^2))^(5/2)*x^2) + (2*(1 - a*x)^3*(1 + a*x))/(15*a^4*(c - c/(a^2*x^2))^(5/2)*x^3) - (2*(1 - a*x)^3*(1 + a*x)^2*(28 + 13*a*x))/(15*a^6*(c - c/(a^2*x^2))^(5/2)*x^5) - (2*(1 - a*x)^(5/2)*(1 + a*x)^(5/2)*ArcSin[a*x])/(a^6*(c - c/(a^2*x^2))^(5/2)*x^5)}
{1/(E^(2*ArcCoth[a*x])*(c - c/(a^2*x^2))^(7/2)), x, 11, -((1 - a*x)^2/(3*a^2*(c - c/(a^2*x^2))^(7/2)*x)) + (10*(1 - a*x)^3)/(3*a^3*(c - c/(a^2*x^2))^(7/2)*x^2) + (12*(1 - a*x)^4)/(7*a^4*(c - c/(a^2*x^2))^(7/2)*x^3) + (82*(1 - a*x)^4*(1 + a*x))/(105*a^5*(c - c/(a^2*x^2))^(7/2)*x^4) + (2*(1 - a*x)^4*(1 + a*x)^2)/(35*a^6*(c - c/(a^2*x^2))^(7/2)*x^5) + (2*(1 - a*x)^4*(1 + a*x)^3*(72 + 37*a*x))/(35*a^8*(c - c/(a^2*x^2))^(7/2)*x^7) + (2*(1 - a*x)^(7/2)*(1 + a*x)^(7/2)*ArcSin[a*x])/(a^8*(c - c/(a^2*x^2))^(7/2)*x^7)}


{(c - c/(a^2*x^2))^(9/2)/E^(3*ArcCoth[a*x]), x, 4, -((c^4*Sqrt[c - c/(a^2*x^2)])/(8*a^9*Sqrt[1 - 1/(a^2*x^2)]*x^8)) + (3*c^4*Sqrt[c - c/(a^2*x^2)])/(7*a^8*Sqrt[1 - 1/(a^2*x^2)]*x^7) - (8*c^4*Sqrt[c - c/(a^2*x^2)])/(5*a^6*Sqrt[1 - 1/(a^2*x^2)]*x^5) + (3*c^4*Sqrt[c - c/(a^2*x^2)])/(2*a^5*Sqrt[1 - 1/(a^2*x^2)]*x^4) + (2*c^4*Sqrt[c - c/(a^2*x^2)])/(a^4*Sqrt[1 - 1/(a^2*x^2)]*x^3) - (4*c^4*Sqrt[c - c/(a^2*x^2)])/(a^3*Sqrt[1 - 1/(a^2*x^2)]*x^2) + (c^4*Sqrt[c - c/(a^2*x^2)]*x)/Sqrt[1 - 1/(a^2*x^2)] - (3*c^4*Sqrt[c - c/(a^2*x^2)]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)])}
{(c - c/(a^2*x^2))^(7/2)/E^(3*ArcCoth[a*x]), x, 4, (c^3*Sqrt[c - c/(a^2*x^2)])/(6*a^7*Sqrt[1 - 1/(a^2*x^2)]*x^6) - (3*c^3*Sqrt[c - c/(a^2*x^2)])/(5*a^6*Sqrt[1 - 1/(a^2*x^2)]*x^5) + (c^3*Sqrt[c - c/(a^2*x^2)])/(4*a^5*Sqrt[1 - 1/(a^2*x^2)]*x^4) + (5*c^3*Sqrt[c - c/(a^2*x^2)])/(3*a^4*Sqrt[1 - 1/(a^2*x^2)]*x^3) - (5*c^3*Sqrt[c - c/(a^2*x^2)])/(2*a^3*Sqrt[1 - 1/(a^2*x^2)]*x^2) - (c^3*Sqrt[c - c/(a^2*x^2)])/(a^2*Sqrt[1 - 1/(a^2*x^2)]*x) + (c^3*Sqrt[c - c/(a^2*x^2)]*x)/Sqrt[1 - 1/(a^2*x^2)] - (3*c^3*Sqrt[c - c/(a^2*x^2)]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)])}
{(c - c/(a^2*x^2))^(5/2)/E^(3*ArcCoth[a*x]), x, 4, -((c^2*Sqrt[c - c/(a^2*x^2)])/(4*a^5*Sqrt[1 - 1/(a^2*x^2)]*x^4)) + (c^2*Sqrt[c - c/(a^2*x^2)])/(a^4*Sqrt[1 - 1/(a^2*x^2)]*x^3) - (c^2*Sqrt[c - c/(a^2*x^2)])/(a^3*Sqrt[1 - 1/(a^2*x^2)]*x^2) - (2*c^2*Sqrt[c - c/(a^2*x^2)])/(a^2*Sqrt[1 - 1/(a^2*x^2)]*x) + (c^2*Sqrt[c - c/(a^2*x^2)]*x)/Sqrt[1 - 1/(a^2*x^2)] - (3*c^2*Sqrt[c - c/(a^2*x^2)]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)])}
{(c - c/(a^2*x^2))^(3/2)/E^(3*ArcCoth[a*x]), x, 4, (c*Sqrt[c - c/(a^2*x^2)])/(2*a^3*Sqrt[1 - 1/(a^2*x^2)]*x^2) - (3*c*Sqrt[c - c/(a^2*x^2)])/(a^2*Sqrt[1 - 1/(a^2*x^2)]*x) + (c*Sqrt[c - c/(a^2*x^2)]*x)/Sqrt[1 - 1/(a^2*x^2)] - (3*c*Sqrt[c - c/(a^2*x^2)]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)])}
{Sqrt[c - c/(a^2*x^2)]/E^(3*ArcCoth[a*x]), x, 4, (Sqrt[c - c/(a^2*x^2)]*x)/Sqrt[1 - 1/(a^2*x^2)] + (Sqrt[c - c/(a^2*x^2)]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)]) - (4*Sqrt[c - c/(a^2*x^2)]*Log[1 + a*x])/(a*Sqrt[1 - 1/(a^2*x^2)])}
{1/(E^(3*ArcCoth[a*x])*Sqrt[c - c/(a^2*x^2)]), x, 4, (Sqrt[1 - 1/(a^2*x^2)]*x)/Sqrt[c - c/(a^2*x^2)] - (2*Sqrt[1 - 1/(a^2*x^2)])/(a*Sqrt[c - c/(a^2*x^2)]*(1 + a*x)) - (3*Sqrt[1 - 1/(a^2*x^2)]*Log[1 + a*x])/(a*Sqrt[c - c/(a^2*x^2)])}
{1/(E^(3*ArcCoth[a*x])*(c - c/(a^2*x^2))^(3/2)), x, 4, (Sqrt[1 - 1/(a^2*x^2)]*x)/(c*Sqrt[c - c/(a^2*x^2)]) + Sqrt[1 - 1/(a^2*x^2)]/(2*a*c*Sqrt[c - c/(a^2*x^2)]*(1 + a*x)^2) - (3*Sqrt[1 - 1/(a^2*x^2)])/(a*c*Sqrt[c - c/(a^2*x^2)]*(1 + a*x)) - (3*Sqrt[1 - 1/(a^2*x^2)]*Log[1 + a*x])/(a*c*Sqrt[c - c/(a^2*x^2)])}
{1/(E^(3*ArcCoth[a*x])*(c - c/(a^2*x^2))^(5/2)), x, 4, (Sqrt[1 - 1/(a^2*x^2)]*x)/(c^2*Sqrt[c - c/(a^2*x^2)]) - Sqrt[1 - 1/(a^2*x^2)]/(6*a*c^2*Sqrt[c - c/(a^2*x^2)]*(1 + a*x)^3) + (9*Sqrt[1 - 1/(a^2*x^2)])/(8*a*c^2*Sqrt[c - c/(a^2*x^2)]*(1 + a*x)^2) - (31*Sqrt[1 - 1/(a^2*x^2)])/(8*a*c^2*Sqrt[c - c/(a^2*x^2)]*(1 + a*x)) + (Sqrt[1 - 1/(a^2*x^2)]*Log[1 - a*x])/(16*a*c^2*Sqrt[c - c/(a^2*x^2)]) - (49*Sqrt[1 - 1/(a^2*x^2)]*Log[1 + a*x])/(16*a*c^2*Sqrt[c - c/(a^2*x^2)])}
{1/(E^(3*ArcCoth[a*x])*(c - c/(a^2*x^2))^(7/2)), x, 4, (Sqrt[1 - 1/(a^2*x^2)]*x)/(c^3*Sqrt[c - c/(a^2*x^2)]) + Sqrt[1 - 1/(a^2*x^2)]/(32*a*c^3*Sqrt[c - c/(a^2*x^2)]*(1 - a*x)) + Sqrt[1 - 1/(a^2*x^2)]/(16*a*c^3*Sqrt[c - c/(a^2*x^2)]*(1 + a*x)^4) - Sqrt[1 - 1/(a^2*x^2)]/(2*a*c^3*Sqrt[c - c/(a^2*x^2)]*(1 + a*x)^3) + (59*Sqrt[1 - 1/(a^2*x^2)])/(32*a*c^3*Sqrt[c - c/(a^2*x^2)]*(1 + a*x)^2) - (75*Sqrt[1 - 1/(a^2*x^2)])/(16*a*c^3*Sqrt[c - c/(a^2*x^2)]*(1 + a*x)) + (9*Sqrt[1 - 1/(a^2*x^2)]*Log[1 - a*x])/(64*a*c^3*Sqrt[c - c/(a^2*x^2)]) - (201*Sqrt[1 - 1/(a^2*x^2)]*Log[1 + a*x])/(64*a*c^3*Sqrt[c - c/(a^2*x^2)])}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m E^(n ArcCoth[a x]) (c-c/(a^2 x^2))^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{E^ArcCoth[a*x]*Sqrt[c - c/(a^2*x^2)]*x^m, x, 4, (Sqrt[c - c/(a^2*x^2)]*x^m)/(a*m*Sqrt[1 - 1/(a^2*x^2)]) + (Sqrt[c - c/(a^2*x^2)]*x^(1 + m))/((1 + m)*Sqrt[1 - 1/(a^2*x^2)])}

{E^ArcCoth[a*x]*Sqrt[c - c/(a^2*x^2)]*x^2, x, 4, (Sqrt[c - c/(a^2*x^2)]*x^2)/(2*a*Sqrt[1 - 1/(a^2*x^2)]) + (Sqrt[c - c/(a^2*x^2)]*x^3)/(3*Sqrt[1 - 1/(a^2*x^2)])}
{E^ArcCoth[a*x]*Sqrt[c - c/(a^2*x^2)]*x, x, 3, (Sqrt[c - c/(a^2*x^2)]*x)/(a*Sqrt[1 - 1/(a^2*x^2)]) + (Sqrt[c - c/(a^2*x^2)]*x^2)/(2*Sqrt[1 - 1/(a^2*x^2)])}
{E^ArcCoth[a*x]*Sqrt[c - c/(a^2*x^2)], x, 4, (Sqrt[c - c/(a^2*x^2)]*x)/Sqrt[1 - 1/(a^2*x^2)] + (Sqrt[c - c/(a^2*x^2)]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)])}
{(E^ArcCoth[a*x]*Sqrt[c - c/(a^2*x^2)])/x, x, 4, -(Sqrt[c - c/(a^2*x^2)]/(a*Sqrt[1 - 1/(a^2*x^2)]*x)) + (Sqrt[c - c/(a^2*x^2)]*Log[x])/Sqrt[1 - 1/(a^2*x^2)]}
{(E^ArcCoth[a*x]*Sqrt[c - c/(a^2*x^2)])/x^2, x, 3, -((Sqrt[c - c/(a^2*x^2)]*(1 + a*x)^2)/(2*a*Sqrt[1 - 1/(a^2*x^2)]*x^2))}


{E^(2*ArcCoth[a*x])*Sqrt[c - c/(a^2*x^2)]*x^3, x, 9, (7*Sqrt[c - c/(a^2*x^2)]*x)/(8*a^3) + (7*Sqrt[c - c/(a^2*x^2)]*x*(1 + a*x))/(24*a^3) + (Sqrt[c - c/(a^2*x^2)]*x*(1 + a*x)^2)/(6*a^3) + (Sqrt[c - c/(a^2*x^2)]*x^2*(1 + a*x)^2)/(4*a^2) - (7*Sqrt[c - c/(a^2*x^2)]*x*ArcSin[a*x])/(8*a^3*Sqrt[1 - a*x]*Sqrt[1 + a*x])}
{E^(2*ArcCoth[a*x])*Sqrt[c - c/(a^2*x^2)]*x^2, x, 8, (Sqrt[c - c/(a^2*x^2)]*x)/a^2 + (Sqrt[c - c/(a^2*x^2)]*x*(1 + a*x))/(3*a^2) + (Sqrt[c - c/(a^2*x^2)]*x*(1 + a*x)^2)/(3*a^2) - (Sqrt[c - c/(a^2*x^2)]*x*ArcSin[a*x])/(a^2*Sqrt[1 - a*x]*Sqrt[1 + a*x])}
{E^(2*ArcCoth[a*x])*Sqrt[c - c/(a^2*x^2)]*x, x, 7, (3*Sqrt[c - c/(a^2*x^2)]*x)/(2*a) + (Sqrt[c - c/(a^2*x^2)]*x*(1 + a*x))/(2*a) - (3*Sqrt[c - c/(a^2*x^2)]*x*ArcSin[a*x])/(2*a*Sqrt[1 - a*x]*Sqrt[1 + a*x])}
{E^(2*ArcCoth[a*x])*Sqrt[c - c/(a^2*x^2)], x, 9, Sqrt[c - c/(a^2*x^2)]*x - (2*Sqrt[c - c/(a^2*x^2)]*x*ArcSin[a*x])/(Sqrt[1 - a*x]*Sqrt[1 + a*x]) + (Sqrt[c - c/(a^2*x^2)]*x*ArcTanh[Sqrt[1 - a*x]*Sqrt[1 + a*x]])/(Sqrt[1 - a*x]*Sqrt[1 + a*x])}
{(E^(2*ArcCoth[a*x])*Sqrt[c - c/(a^2*x^2)])/x, x, 9, Sqrt[c - c/(a^2*x^2)] - (a*Sqrt[c - c/(a^2*x^2)]*x*ArcSin[a*x])/(Sqrt[1 - a*x]*Sqrt[1 + a*x]) + (2*a*Sqrt[c - c/(a^2*x^2)]*x*ArcTanh[Sqrt[1 - a*x]*Sqrt[1 + a*x]])/(Sqrt[1 - a*x]*Sqrt[1 + a*x])}
{(E^(2*ArcCoth[a*x])*Sqrt[c - c/(a^2*x^2)])/x^2, x, 7, (3/2)*a*Sqrt[c - c/(a^2*x^2)] + (Sqrt[c - c/(a^2*x^2)]*(1 + a*x))/(2*x) + (3*a^2*Sqrt[c - c/(a^2*x^2)]*x*ArcTanh[Sqrt[1 - a*x]*Sqrt[1 + a*x]])/(2*Sqrt[1 - a*x]*Sqrt[1 + a*x])}
{(E^(2*ArcCoth[a*x])*Sqrt[c - c/(a^2*x^2)])/x^3, x, 8, a^2*Sqrt[c - c/(a^2*x^2)] + (a*Sqrt[c - c/(a^2*x^2)]*(1 + a*x))/(3*x) + (Sqrt[c - c/(a^2*x^2)]*(1 + a*x)^2)/(3*x^2) + (a^3*Sqrt[c - c/(a^2*x^2)]*x*ArcTanh[Sqrt[1 - a*x]*Sqrt[1 + a*x]])/(Sqrt[1 - a*x]*Sqrt[1 + a*x])}
{(E^(2*ArcCoth[a*x])*Sqrt[c - c/(a^2*x^2)])/x^4, x, 10, (4/3)*a^3*Sqrt[c - c/(a^2*x^2)] + Sqrt[c - c/(a^2*x^2)]/(4*x^3) + (2*a*Sqrt[c - c/(a^2*x^2)])/(3*x^2) + (7*a^2*Sqrt[c - c/(a^2*x^2)])/(8*x) + (7*a^4*Sqrt[c - c/(a^2*x^2)]*x*ArcTanh[Sqrt[1 - a*x]*Sqrt[1 + a*x]])/(8*Sqrt[1 - a*x]*Sqrt[1 + a*x])}
{(E^(2*ArcCoth[a*x])*Sqrt[c - c/(a^2*x^2)])/x^5, x, 11, (6/5)*a^4*Sqrt[c - c/(a^2*x^2)] + Sqrt[c - c/(a^2*x^2)]/(5*x^4) + (a*Sqrt[c - c/(a^2*x^2)])/(2*x^3) + (3*a^2*Sqrt[c - c/(a^2*x^2)])/(5*x^2) + (3*a^3*Sqrt[c - c/(a^2*x^2)])/(4*x) + (3*a^5*Sqrt[c - c/(a^2*x^2)]*x*ArcTanh[Sqrt[1 - a*x]*Sqrt[1 + a*x]])/(4*Sqrt[1 - a*x]*Sqrt[1 + a*x])}


{E^(3*ArcCoth[a*x])*Sqrt[c - c/(a^2*x^2)]*x^3, x, 4, (4*Sqrt[c - c/(a^2*x^2)]*x)/(a^3*Sqrt[1 - 1/(a^2*x^2)]) + (2*Sqrt[c - c/(a^2*x^2)]*x^2)/(a^2*Sqrt[1 - 1/(a^2*x^2)]) + (Sqrt[c - c/(a^2*x^2)]*x^3)/(a*Sqrt[1 - 1/(a^2*x^2)]) + (Sqrt[c - c/(a^2*x^2)]*x^4)/(4*Sqrt[1 - 1/(a^2*x^2)]) + (4*Sqrt[c - c/(a^2*x^2)]*Log[1 - a*x])/(a^4*Sqrt[1 - 1/(a^2*x^2)])}
{E^(3*ArcCoth[a*x])*Sqrt[c - c/(a^2*x^2)]*x^2, x, 4, (4*Sqrt[c - c/(a^2*x^2)]*x)/(a^2*Sqrt[1 - 1/(a^2*x^2)]) + (3*Sqrt[c - c/(a^2*x^2)]*x^2)/(2*a*Sqrt[1 - 1/(a^2*x^2)]) + (Sqrt[c - c/(a^2*x^2)]*x^3)/(3*Sqrt[1 - 1/(a^2*x^2)]) + (4*Sqrt[c - c/(a^2*x^2)]*Log[1 - a*x])/(a^3*Sqrt[1 - 1/(a^2*x^2)])}
{E^(3*ArcCoth[a*x])*Sqrt[c - c/(a^2*x^2)]*x, x, 4, (3*Sqrt[c - c/(a^2*x^2)]*x)/(a*Sqrt[1 - 1/(a^2*x^2)]) + (Sqrt[c - c/(a^2*x^2)]*x^2)/(2*Sqrt[1 - 1/(a^2*x^2)]) + (4*Sqrt[c - c/(a^2*x^2)]*Log[1 - a*x])/(a^2*Sqrt[1 - 1/(a^2*x^2)])}
{E^(3*ArcCoth[a*x])*Sqrt[c - c/(a^2*x^2)], x, 4, (Sqrt[c - c/(a^2*x^2)]*x)/Sqrt[1 - 1/(a^2*x^2)] - (Sqrt[c - c/(a^2*x^2)]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)]) + (4*Sqrt[c - c/(a^2*x^2)]*Log[1 - a*x])/(a*Sqrt[1 - 1/(a^2*x^2)])}
{(E^(3*ArcCoth[a*x])*Sqrt[c - c/(a^2*x^2)])/x, x, 4, Sqrt[c - c/(a^2*x^2)]/(a*Sqrt[1 - 1/(a^2*x^2)]*x) - (3*Sqrt[c - c/(a^2*x^2)]*Log[x])/Sqrt[1 - 1/(a^2*x^2)] + (4*Sqrt[c - c/(a^2*x^2)]*Log[1 - a*x])/Sqrt[1 - 1/(a^2*x^2)]}
{(E^(3*ArcCoth[a*x])*Sqrt[c - c/(a^2*x^2)])/x^2, x, 4, Sqrt[c - c/(a^2*x^2)]/(2*a*Sqrt[1 - 1/(a^2*x^2)]*x^2) + (3*Sqrt[c - c/(a^2*x^2)])/(Sqrt[1 - 1/(a^2*x^2)]*x) - (4*a*Sqrt[c - c/(a^2*x^2)]*Log[x])/Sqrt[1 - 1/(a^2*x^2)] + (4*a*Sqrt[c - c/(a^2*x^2)]*Log[1 - a*x])/Sqrt[1 - 1/(a^2*x^2)]}
{(E^(3*ArcCoth[a*x])*Sqrt[c - c/(a^2*x^2)])/x^3, x, 4, Sqrt[c - c/(a^2*x^2)]/(3*a*Sqrt[1 - 1/(a^2*x^2)]*x^3) + (3*Sqrt[c - c/(a^2*x^2)])/(2*Sqrt[1 - 1/(a^2*x^2)]*x^2) + (4*a*Sqrt[c - c/(a^2*x^2)])/(Sqrt[1 - 1/(a^2*x^2)]*x) - (4*a^2*Sqrt[c - c/(a^2*x^2)]*Log[x])/Sqrt[1 - 1/(a^2*x^2)] + (4*a^2*Sqrt[c - c/(a^2*x^2)]*Log[1 - a*x])/Sqrt[1 - 1/(a^2*x^2)]}
{(E^(3*ArcCoth[a*x])*Sqrt[c - c/(a^2*x^2)])/x^4, x, 4, Sqrt[c - c/(a^2*x^2)]/(4*a*Sqrt[1 - 1/(a^2*x^2)]*x^4) + Sqrt[c - c/(a^2*x^2)]/(Sqrt[1 - 1/(a^2*x^2)]*x^3) + (2*a*Sqrt[c - c/(a^2*x^2)])/(Sqrt[1 - 1/(a^2*x^2)]*x^2) + (4*a^2*Sqrt[c - c/(a^2*x^2)])/(Sqrt[1 - 1/(a^2*x^2)]*x) - (4*a^3*Sqrt[c - c/(a^2*x^2)]*Log[x])/Sqrt[1 - 1/(a^2*x^2)] + (4*a^3*Sqrt[c - c/(a^2*x^2)]*Log[1 - a*x])/Sqrt[1 - 1/(a^2*x^2)]}
{(E^(3*ArcCoth[a*x])*Sqrt[c - c/(a^2*x^2)])/x^5, x, 4, Sqrt[c - c/(a^2*x^2)]/(5*a*Sqrt[1 - 1/(a^2*x^2)]*x^5) + (3*Sqrt[c - c/(a^2*x^2)])/(4*Sqrt[1 - 1/(a^2*x^2)]*x^4) + (4*a*Sqrt[c - c/(a^2*x^2)])/(3*Sqrt[1 - 1/(a^2*x^2)]*x^3) + (2*a^2*Sqrt[c - c/(a^2*x^2)])/(Sqrt[1 - 1/(a^2*x^2)]*x^2) + (4*a^3*Sqrt[c - c/(a^2*x^2)])/(Sqrt[1 - 1/(a^2*x^2)]*x) - (4*a^4*Sqrt[c - c/(a^2*x^2)]*Log[x])/Sqrt[1 - 1/(a^2*x^2)] + (4*a^4*Sqrt[c - c/(a^2*x^2)]*Log[1 - a*x])/Sqrt[1 - 1/(a^2*x^2)]}


(* ::Subsubsection::Closed:: *)
(*n<0*)


{(Sqrt[c - c/(a^2*x^2)]*x^m)/E^ArcCoth[a*x], x, 4, -((Sqrt[c - c/(a^2*x^2)]*x^m)/(a*m*Sqrt[1 - 1/(a^2*x^2)])) + (Sqrt[c - c/(a^2*x^2)]*x^(1 + m))/((1 + m)*Sqrt[1 - 1/(a^2*x^2)])}
{(Sqrt[c - c/(a^2*x^2)]*x^2)/E^ArcCoth[a*x], x, 4, -(Sqrt[c - c/(a^2*x^2)]*x^2)/(2*a*Sqrt[1 - 1/(a^2*x^2)]) + (Sqrt[c - c/(a^2*x^2)]*x^3)/(3*Sqrt[1 - 1/(a^2*x^2)])}
{(Sqrt[c - c/(a^2*x^2)]*x)/E^ArcCoth[a*x], x, 3, -((Sqrt[c - c/(a^2*x^2)]*x)/(a*Sqrt[1 - 1/(a^2*x^2)])) + (Sqrt[c - c/(a^2*x^2)]*x^2)/(2*Sqrt[1 - 1/(a^2*x^2)])}
{Sqrt[c - c/(a^2*x^2)]/E^ArcCoth[a*x], x, 4, (Sqrt[c - c/(a^2*x^2)]*x)/Sqrt[1 - 1/(a^2*x^2)] - (Sqrt[c - c/(a^2*x^2)]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)])}
{Sqrt[c - c/(a^2*x^2)]/(E^ArcCoth[a*x]*x), x, 4, Sqrt[c - c/(a^2*x^2)]/(a*Sqrt[1 - 1/(a^2*x^2)]*x) + (Sqrt[c - c/(a^2*x^2)]*Log[x])/Sqrt[1 - 1/(a^2*x^2)]}
{Sqrt[c - c/(a^2*x^2)]/(E^ArcCoth[a*x]*x^2), x, 3, (Sqrt[c - c/(a^2*x^2)]*(1 - a*x)^2)/(2*a*Sqrt[1 - 1/(a^2*x^2)]*x^2)}


{(Sqrt[c - c/(a^2*x^2)]*x^3)/E^(2*ArcCoth[a*x]), x, 9, -((7*Sqrt[c - c/(a^2*x^2)]*x)/(8*a^3)) - (7*Sqrt[c - c/(a^2*x^2)]*x*(1 - a*x))/(24*a^3) - (Sqrt[c - c/(a^2*x^2)]*x*(1 - a*x)^2)/(6*a^3) + (Sqrt[c - c/(a^2*x^2)]*x^2*(1 - a*x)^2)/(4*a^2) - (7*Sqrt[c - c/(a^2*x^2)]*x*ArcSin[a*x])/(8*a^3*Sqrt[1 - a*x]*Sqrt[1 + a*x])}
{(Sqrt[c - c/(a^2*x^2)]*x^2)/E^(2*ArcCoth[a*x]), x, 8, (Sqrt[c - c/(a^2*x^2)]*x)/a^2 + (Sqrt[c - c/(a^2*x^2)]*x*(1 - a*x))/(3*a^2) + (Sqrt[c - c/(a^2*x^2)]*x*(1 - a*x)^2)/(3*a^2) + (Sqrt[c - c/(a^2*x^2)]*x*ArcSin[a*x])/(a^2*Sqrt[1 - a*x]*Sqrt[1 + a*x])}
{(Sqrt[c - c/(a^2*x^2)]*x)/E^(2*ArcCoth[a*x]), x, 7, -((3*Sqrt[c - c/(a^2*x^2)]*x)/(2*a)) - (Sqrt[c - c/(a^2*x^2)]*x*(1 - a*x))/(2*a) - (3*Sqrt[c - c/(a^2*x^2)]*x*ArcSin[a*x])/(2*a*Sqrt[1 - a*x]*Sqrt[1 + a*x])}
{Sqrt[c - c/(a^2*x^2)]/E^(2*ArcCoth[a*x]), x, 9, Sqrt[c - c/(a^2*x^2)]*x + (2*Sqrt[c - c/(a^2*x^2)]*x*ArcSin[a*x])/(Sqrt[1 - a*x]*Sqrt[1 + a*x]) + (Sqrt[c - c/(a^2*x^2)]*x*ArcTanh[Sqrt[1 - a*x]*Sqrt[1 + a*x]])/(Sqrt[1 - a*x]*Sqrt[1 + a*x])}
{Sqrt[c - c/(a^2*x^2)]/(E^(2*ArcCoth[a*x])*x), x, 9, Sqrt[c - c/(a^2*x^2)] - (a*Sqrt[c - c/(a^2*x^2)]*x*ArcSin[a*x])/(Sqrt[1 - a*x]*Sqrt[1 + a*x]) - (2*a*Sqrt[c - c/(a^2*x^2)]*x*ArcTanh[Sqrt[1 - a*x]*Sqrt[1 + a*x]])/(Sqrt[1 - a*x]*Sqrt[1 + a*x])}
{Sqrt[c - c/(a^2*x^2)]/(E^(2*ArcCoth[a*x])*x^2), x, 7, (-(3/2))*a*Sqrt[c - c/(a^2*x^2)] + (Sqrt[c - c/(a^2*x^2)]*(1 - a*x))/(2*x) + (3*a^2*Sqrt[c - c/(a^2*x^2)]*x*ArcTanh[Sqrt[1 - a*x]*Sqrt[1 + a*x]])/(2*Sqrt[1 - a*x]*Sqrt[1 + a*x])}
{Sqrt[c - c/(a^2*x^2)]/(E^(2*ArcCoth[a*x])*x^3), x, 8, a^2*Sqrt[c - c/(a^2*x^2)] - (a*Sqrt[c - c/(a^2*x^2)]*(1 - a*x))/(3*x) + (Sqrt[c - c/(a^2*x^2)]*(1 - a*x)^2)/(3*x^2) - (a^3*Sqrt[c - c/(a^2*x^2)]*x*ArcTanh[Sqrt[1 - a*x]*Sqrt[1 + a*x]])/(Sqrt[1 - a*x]*Sqrt[1 + a*x])}
{Sqrt[c - c/(a^2*x^2)]/(E^(2*ArcCoth[a*x])*x^4), x, 10, (-(4/3))*a^3*Sqrt[c - c/(a^2*x^2)] + Sqrt[c - c/(a^2*x^2)]/(4*x^3) - (2*a*Sqrt[c - c/(a^2*x^2)])/(3*x^2) + (7*a^2*Sqrt[c - c/(a^2*x^2)])/(8*x) + (7*a^4*Sqrt[c - c/(a^2*x^2)]*x*ArcTanh[Sqrt[1 - a*x]*Sqrt[1 + a*x]])/(8*Sqrt[1 - a*x]*Sqrt[1 + a*x])}
{Sqrt[c - c/(a^2*x^2)]/(E^(2*ArcCoth[a*x])*x^5), x, 11, (6/5)*a^4*Sqrt[c - c/(a^2*x^2)] + Sqrt[c - c/(a^2*x^2)]/(5*x^4) - (a*Sqrt[c - c/(a^2*x^2)])/(2*x^3) + (3*a^2*Sqrt[c - c/(a^2*x^2)])/(5*x^2) - (3*a^3*Sqrt[c - c/(a^2*x^2)])/(4*x) - (3*a^5*Sqrt[c - c/(a^2*x^2)]*x*ArcTanh[Sqrt[1 - a*x]*Sqrt[1 + a*x]])/(4*Sqrt[1 - a*x]*Sqrt[1 + a*x])}


{(Sqrt[c - c/(a^2*x^2)]*x^3)/E^(3*ArcCoth[a*x]), x, 4, (-4*Sqrt[c - c/(a^2*x^2)]*x)/(a^3*Sqrt[1 - 1/(a^2*x^2)]) + (2*Sqrt[c - c/(a^2*x^2)]*x^2)/(a^2*Sqrt[1 - 1/(a^2*x^2)]) - (Sqrt[c - c/(a^2*x^2)]*x^3)/(a*Sqrt[1 - 1/(a^2*x^2)]) + (Sqrt[c - c/(a^2*x^2)]*x^4)/(4*Sqrt[1 - 1/(a^2*x^2)]) + (4*Sqrt[c - c/(a^2*x^2)]*Log[1 + a*x])/(a^4*Sqrt[1 - 1/(a^2*x^2)])}
{(Sqrt[c - c/(a^2*x^2)]*x^2)/E^(3*ArcCoth[a*x]), x, 4, (4*Sqrt[c - c/(a^2*x^2)]*x)/(a^2*Sqrt[1 - 1/(a^2*x^2)]) - (3*Sqrt[c - c/(a^2*x^2)]*x^2)/(2*a*Sqrt[1 - 1/(a^2*x^2)]) + (Sqrt[c - c/(a^2*x^2)]*x^3)/(3*Sqrt[1 - 1/(a^2*x^2)]) - (4*Sqrt[c - c/(a^2*x^2)]*Log[1 + a*x])/(a^3*Sqrt[1 - 1/(a^2*x^2)])}
{(Sqrt[c - c/(a^2*x^2)]*x)/E^(3*ArcCoth[a*x]), x, 4, -((3*Sqrt[c - c/(a^2*x^2)]*x)/(a*Sqrt[1 - 1/(a^2*x^2)])) + (Sqrt[c - c/(a^2*x^2)]*x^2)/(2*Sqrt[1 - 1/(a^2*x^2)]) + (4*Sqrt[c - c/(a^2*x^2)]*Log[1 + a*x])/(a^2*Sqrt[1 - 1/(a^2*x^2)])}
{Sqrt[c - c/(a^2*x^2)]/E^(3*ArcCoth[a*x]), x, 4, (Sqrt[c - c/(a^2*x^2)]*x)/Sqrt[1 - 1/(a^2*x^2)] + (Sqrt[c - c/(a^2*x^2)]*Log[x])/(a*Sqrt[1 - 1/(a^2*x^2)]) - (4*Sqrt[c - c/(a^2*x^2)]*Log[1 + a*x])/(a*Sqrt[1 - 1/(a^2*x^2)])}
{Sqrt[c - c/(a^2*x^2)]/(E^(3*ArcCoth[a*x])*x), x, 4, -(Sqrt[c - c/(a^2*x^2)]/(a*Sqrt[1 - 1/(a^2*x^2)]*x)) - (3*Sqrt[c - c/(a^2*x^2)]*Log[x])/Sqrt[1 - 1/(a^2*x^2)] + (4*Sqrt[c - c/(a^2*x^2)]*Log[1 + a*x])/Sqrt[1 - 1/(a^2*x^2)]}
{Sqrt[c - c/(a^2*x^2)]/(E^(3*ArcCoth[a*x])*x^2), x, 4, -(Sqrt[c - c/(a^2*x^2)]/(2*a*Sqrt[1 - 1/(a^2*x^2)]*x^2)) + (3*Sqrt[c - c/(a^2*x^2)])/(Sqrt[1 - 1/(a^2*x^2)]*x) + (4*a*Sqrt[c - c/(a^2*x^2)]*Log[x])/Sqrt[1 - 1/(a^2*x^2)] - (4*a*Sqrt[c - c/(a^2*x^2)]*Log[1 + a*x])/Sqrt[1 - 1/(a^2*x^2)]}
{Sqrt[c - c/(a^2*x^2)]/(E^(3*ArcCoth[a*x])*x^3), x, 4, -(Sqrt[c - c/(a^2*x^2)]/(3*a*Sqrt[1 - 1/(a^2*x^2)]*x^3)) + (3*Sqrt[c - c/(a^2*x^2)])/(2*Sqrt[1 - 1/(a^2*x^2)]*x^2) - (4*a*Sqrt[c - c/(a^2*x^2)])/(Sqrt[1 - 1/(a^2*x^2)]*x) - (4*a^2*Sqrt[c - c/(a^2*x^2)]*Log[x])/Sqrt[1 - 1/(a^2*x^2)] + (4*a^2*Sqrt[c - c/(a^2*x^2)]*Log[1 + a*x])/Sqrt[1 - 1/(a^2*x^2)]}
{Sqrt[c - c/(a^2*x^2)]/(E^(3*ArcCoth[a*x])*x^4), x, 4, -(Sqrt[c - c/(a^2*x^2)]/(4*a*Sqrt[1 - 1/(a^2*x^2)]*x^4)) + Sqrt[c - c/(a^2*x^2)]/(Sqrt[1 - 1/(a^2*x^2)]*x^3) - (2*a*Sqrt[c - c/(a^2*x^2)])/(Sqrt[1 - 1/(a^2*x^2)]*x^2) + (4*a^2*Sqrt[c - c/(a^2*x^2)])/(Sqrt[1 - 1/(a^2*x^2)]*x) + (4*a^3*Sqrt[c - c/(a^2*x^2)]*Log[x])/Sqrt[1 - 1/(a^2*x^2)] - (4*a^3*Sqrt[c - c/(a^2*x^2)]*Log[1 + a*x])/Sqrt[1 - 1/(a^2*x^2)]}
{Sqrt[c - c/(a^2*x^2)]/(E^(3*ArcCoth[a*x])*x^5), x, 4, -(Sqrt[c - c/(a^2*x^2)]/(5*a*Sqrt[1 - 1/(a^2*x^2)]*x^5)) + (3*Sqrt[c - c/(a^2*x^2)])/(4*Sqrt[1 - 1/(a^2*x^2)]*x^4) - (4*a*Sqrt[c - c/(a^2*x^2)])/(3*Sqrt[1 - 1/(a^2*x^2)]*x^3) + (2*a^2*Sqrt[c - c/(a^2*x^2)])/(Sqrt[1 - 1/(a^2*x^2)]*x^2) - (4*a^3*Sqrt[c - c/(a^2*x^2)])/(Sqrt[1 - 1/(a^2*x^2)]*x) - (4*a^4*Sqrt[c - c/(a^2*x^2)]*Log[x])/Sqrt[1 - 1/(a^2*x^2)] + (4*a^4*Sqrt[c - c/(a^2*x^2)]*Log[1 + a*x])/Sqrt[1 - 1/(a^2*x^2)]}


(* ::Subsection::Closed:: *)
(*Integrands of the form E^(n ArcCoth[a x]) (c-c/(a^2 x^2))^p with n symbolic*)


{E^(n*ArcCoth[a*x])*(c - c/(a^2*x^2)), x, 4, (4*c*(1 - 1/(a*x))^(1 - n/2)*(1 + 1/(a*x))^((1/2)*(-2 + n))*Hypergeometric2F1[2, 1 - n/2, 2 - n/2, (a - 1/x)/(a + 1/x)])/(a*(2 - n)) - (2^(1 + n/2)*c*(1 - 1/(a*x))^(1 - n/2)*Hypergeometric2F1[1 - n/2, -(n/2), 2 - n/2, (a - 1/x)/(2*a)])/(a*(2 - n))}
{E^(n*ArcCoth[a*x])/(c - c/(a^2*x^2)), x, 5, -(((1 + n)*(1 + 1/(a*x))^(n/2))/((1 - 1/(a*x))^(n/2)*(a*c*n))) + ((1 + 1/(a*x))^(n/2)*x)/((1 - 1/(a*x))^(n/2)*c) + (2*(1 + 1/(a*x))^(n/2)*Hypergeometric2F1[1, n/2, (2 + n)/2, (a + 1/x)/(a - 1/x)])/((1 - 1/(a*x))^(n/2)*(a*c))}
{E^(n*ArcCoth[a*x])/(c - c/(a^2*x^2))^2, x, 7, If[$VersionNumber>=8, -(((3 + n)*(1 - 1/(a*x))^(-1 - n/2)*(1 + 1/(a*x))^((1/2)*(-2 + n)))/(a*c^2*(2 + n))) + ((6 + 4*n - n^2 - n^3)*(1 - 1/(a*x))^(1 - n/2)*(1 + 1/(a*x))^((1/2)*(-2 + n)))/(a*c^2*(2 - n)*n*(2 + n)) - ((6 + 4*n + n^2)*(1 + 1/(a*x))^((1/2)*(-2 + n)))/((1 - 1/(a*x))^(n/2)*(a*c^2*n*(2 + n))) + ((1 - 1/(a*x))^(-1 - n/2)*(1 + 1/(a*x))^((1/2)*(-2 + n))*x)/c^2 + (2*(1 + 1/(a*x))^(n/2)*Hypergeometric2F1[1, n/2, (2 + n)/2, (a + 1/x)/(a - 1/x)])/((1 - 1/(a*x))^(n/2)*(a*c^2)), -(((3 + n)*(1 - 1/(a*x))^(-1 - n/2)*(1 + 1/(a*x))^((1/2)*(-2 + n)))/(a*c^2*(2 + n))) + ((6 + 4*n - n^2 - n^3)*(1 - 1/(a*x))^(1 - n/2)*(1 + 1/(a*x))^((1/2)*(-2 + n)))/(a*c^2*n*(4 - n^2)) - ((6 + 4*n + n^2)*(1 + 1/(a*x))^((1/2)*(-2 + n)))/((1 - 1/(a*x))^(n/2)*(a*c^2*n*(2 + n))) + ((1 - 1/(a*x))^(-1 - n/2)*(1 + 1/(a*x))^((1/2)*(-2 + n))*x)/c^2 + (2*(1 + 1/(a*x))^(n/2)*Hypergeometric2F1[1, n/2, (2 + n)/2, (a + 1/x)/(a - 1/x)])/((1 - 1/(a*x))^(n/2)*(a*c^2))]}


{E^(n*ArcCoth[a*x])*Sqrt[c - c/(a^2*x^2)], x, 6, (Sqrt[c - c/(a^2*x^2)]*(1 - 1/(a*x))^((1 - n)/2)*(1 + 1/(a*x))^((1 + n)/2)*x)/Sqrt[1 - 1/(a^2*x^2)] + (2*n*Sqrt[c - c/(a^2*x^2)]*(1 - 1/(a*x))^((1 - n)/2)*(1 + 1/(a*x))^((1/2)*(-1 + n))*Hypergeometric2F1[1, (1 - n)/2, (3 - n)/2, (a - 1/x)/(a + 1/x)])/(a*(1 - n)*Sqrt[1 - 1/(a^2*x^2)]) - (2^((1 + n)/2)*Sqrt[c - c/(a^2*x^2)]*(1 - 1/(a*x))^((1 - n)/2)*Hypergeometric2F1[(1 - n)/2, (1 - n)/2, (3 - n)/2, (a - 1/x)/(2*a)])/(a*(1 - n)*Sqrt[1 - 1/(a^2*x^2)])}
{E^(n*ArcCoth[a*x])/Sqrt[c - c/(a^2*x^2)], x, 4, (Sqrt[1 - 1/(a^2*x^2)]*(1 - 1/(a*x))^((1 - n)/2)*(1 + 1/(a*x))^((1 + n)/2)*x)/Sqrt[c - c/(a^2*x^2)] + (2*n*Sqrt[1 - 1/(a^2*x^2)]*(1 - 1/(a*x))^((1 - n)/2)*(1 + 1/(a*x))^((1/2)*(-1 + n))*Hypergeometric2F1[1, (1 - n)/2, (3 - n)/2, (a - 1/x)/(a + 1/x)])/(a*(1 - n)*Sqrt[c - c/(a^2*x^2)])}


(* ::Subsection::Closed:: *)
(*Integrands of the form E^(n ArcCoth[a x]) (c-c/(a^2 x^2))^p with p symbolic*)


{E^(n*ArcCoth[a*x])*(c - c/(a^2*x^2))^p, x, 3, -((2^(1 - n/2 + p)*(c - c/(a^2*x^2))^p*(1 + 1/(a*x))^(1 + n/2 + p)*AppellF1[1 + n/2 + p, (1/2)*(n - 2*p), 2, 2 + n/2 + p, (a + 1/x)/(2*a), 1 + 1/(a*x)])/((1 - 1/(a^2*x^2))^p*(a*(2 + n + 2*p))))}


{(c - c/(a^2*x^2))^p/E^(2*p*ArcCoth[a*x]), x, 3, ((c - c/(a^2*x^2))^p*(1 - 1/(a*x))^(1 + 2*p)*Hypergeometric2F1[2, 1 + 2*p, 2*(1 + p), 1 - 1/(a*x)])/((1 - 1/(a^2*x^2))^p*(a*(1 + 2*p)))}
{E^(2*p*ArcCoth[a*x])*(c - c/(a^2*x^2))^p, x, 3, -(((c - c/(a^2*x^2))^p*(1 + 1/(a*x))^(1 + 2*p)*Hypergeometric2F1[2, 1 + 2*p, 2*(1 + p), 1 + 1/(a*x)])/((1 - 1/(a^2*x^2))^p*(a*(1 + 2*p))))}
